/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.module;

import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.class_151;
import net.thomilist.dimensionalinventories.DimensionalInventories;
import net.thomilist.dimensionalinventories.exception.ModuleNotRegisteredException;
import net.thomilist.dimensionalinventories.module.ModuleGroup;
import net.thomilist.dimensionalinventories.module.base.Module;
import net.thomilist.dimensionalinventories.module.version.StorageVersion;

public final class ModuleRegistry<T extends Module> {
    private final HashMap<StorageVersion, SortedSet<T>> modules = new HashMap();
    private final Class<T> moduleType;

    public ModuleRegistry(Class<T> moduleType) {
        this.moduleType = moduleType;
    }

    public static boolean isValidId(String groupId) {
        return groupId.matches("^[a-z]+[a-z0-9_-]*[a-z0-9]*$");
    }

    private void register(T module) {
        for (StorageVersion storageVersion : module.storageVersions()) {
            this.modules.putIfAbsent(storageVersion, new TreeSet());
            if (this.modules.get((Object)storageVersion).removeIf(existingModule -> existingModule.getClass().getCanonicalName().equals(module.getClass().getCanonicalName()))) {
                DimensionalInventories.LOGGER.warn("Module {} replaces already-registered module of the same type ({})", (Object)module.toFormatted(), module.getClass());
            }
            if (!this.modules.get((Object)storageVersion).add(module)) {
                DimensionalInventories.LOGGER.warn("Failed to register module: {} has already been registered", (Object)module.toFormatted());
                continue;
            }
            if (module.latestStorageVersion() == StorageVersion.latest()) {
                module.registerCommands();
            }
            DimensionalInventories.LOGGER.info("Registered {}", (Object)module.toFormatted());
        }
    }

    public void register(ModuleGroup moduleGroup) throws class_151 {
        if (!ModuleRegistry.isValidId(moduleGroup.groupId())) {
            throw new class_151("'%s' is not a valid module group ID".formatted(moduleGroup.groupId()));
        }
        for (Module module : moduleGroup.modules) {
            if (!this.moduleType.isInstance(module)) continue;
            this.register((Module)this.moduleType.cast(module));
        }
    }

    public boolean has(StorageVersion storageVersion) {
        return this.modules.containsKey((Object)storageVersion);
    }

    public SortedSet<T> get(StorageVersion storageVersion) {
        return this.modules.getOrDefault((Object)storageVersion, new TreeSet());
    }

    public <M extends T> M get(Class<M> moduleType) throws ModuleNotRegisteredException {
        for (SortedSet<T> moduleSet : this.modules.values()) {
            for (Module module : moduleSet) {
                if (!moduleType.isInstance(module)) continue;
                return (M)((Module)moduleType.cast(module));
            }
        }
        throw new ModuleNotRegisteredException(moduleType);
    }
}

