/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.module.base;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.thomilist.dimensionalinventories.exception.ModuleConstructionException;
import net.thomilist.dimensionalinventories.module.base.Module;
import net.thomilist.dimensionalinventories.module.version.StorageVersion;

public abstract class ModuleBase
implements Module {
    private final String groupId;
    private final String moduleId;
    private final String description;
    private final SortedSet<StorageVersion> storageVersions = new TreeSet<StorageVersion>();

    protected ModuleBase(StorageVersion[] storageVersions, String groupId, String moduleId, String description) {
        this.groupId = groupId;
        this.moduleId = moduleId;
        this.description = description;
        this.storageVersions.addAll(List.of(storageVersions));
    }

    public static <T extends Module> T createDerived(Class<T> moduleType, String groupId) throws ModuleConstructionException {
        try {
            return (T)((Module)moduleType.getConstructor(String.class).newInstance(groupId));
        }
        catch (Exception e) {
            throw new ModuleConstructionException(moduleType, groupId, e);
        }
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public SortedSet<StorageVersion> storageVersions() {
        return this.storageVersions;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String moduleId() {
        return this.moduleId;
    }
}

