/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.module.builtin.pool;

import com.google.gson.Gson;
import net.thomilist.dimensionalinventories.command.Commands;
import net.thomilist.dimensionalinventories.module.base.JsonModule;
import net.thomilist.dimensionalinventories.module.base.ModuleBase;
import net.thomilist.dimensionalinventories.module.base.config.JsonConfigModule;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPoolConfigModuleState;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPoolMapSerializerPair;
import net.thomilist.dimensionalinventories.module.version.StorageVersion;

public final class DimensionPoolConfigModule
extends ModuleBase
implements JsonConfigModule<DimensionPoolConfigModuleState> {
    private static final String MODULE_ID = "dimension-pools";
    private static final String DESCRIPTION = "Configuration of dimension pools, including assigned dimensions, game modes & more.";
    private static final StorageVersion[] STORAGE_VERSIONS = new StorageVersion[]{StorageVersion.V2};
    private static final Gson GSON = JsonModule.GSON_BUILDER.registerTypeAdapter(DimensionPoolMapSerializerPair.TYPE, (Object)new DimensionPoolMapSerializerPair()).create();
    private final DimensionPoolConfigModuleState state = new DimensionPoolConfigModuleState();
    private final Commands commands = new Commands();

    public DimensionPoolConfigModule(String groupId) {
        super(STORAGE_VERSIONS, groupId, MODULE_ID, DESCRIPTION);
    }

    @Override
    public DimensionPoolConfigModuleState newInstance() {
        return new DimensionPoolConfigModuleState();
    }

    @Override
    public DimensionPoolConfigModuleState state() {
        return this.state;
    }

    @Override
    public DimensionPoolConfigModuleState defaultState() {
        return DimensionPoolConfigModuleState.createDefault();
    }

    @Override
    public Gson gson() {
        return GSON;
    }

    @Override
    public void loadFromOther(DimensionPoolConfigModuleState other) {
        this.state().dimensionPools.clear();
        this.state().dimensionPools.putAll(other.dimensionPools);
    }

    @Override
    public void registerCommands() {
        this.commands.register(this);
    }
}

