/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.module.version;

import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.thomilist.dimensionalinventories.compatibility.Compat;

public enum StorageVersion {
    V1(1),
    V2(2);

    private static final SortedSet<StorageVersion> ALL;
    public final int version;

    private StorageVersion(int version) {
        this.version = version;
    }

    public static StorageVersion latest() {
        return StorageVersion.all().last();
    }

    public static SortedSet<StorageVersion> all() {
        return ALL;
    }

    public static SortedSet<StorageVersion> reversed() {
        return Compat.SORTED_SET.reversed(StorageVersion.all());
    }

    public static int compareSets(SortedSet<StorageVersion> a, SortedSet<StorageVersion> b) {
        if (a.equals(b)) {
            return 0;
        }
        if (a.isEmpty() && b.isEmpty()) {
            return 0;
        }
        if (a.isEmpty()) {
            return 1;
        }
        if (b.isEmpty()) {
            return -1;
        }
        TreeSet combined = new TreeSet(Collections.reverseOrder());
        combined.addAll(a);
        combined.addAll(b);
        for (StorageVersion version : combined) {
            if (a.contains((Object)version) && b.contains((Object)version)) continue;
            if (a.contains((Object)version)) {
                return -1;
            }
            if (!b.contains((Object)version)) continue;
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "v" + this.version;
    }

    static {
        ALL = new TreeSet<StorageVersion>(List.of(V1, V2));
    }
}

