/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.util;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.thomilist.dimensionalinventories.exception.PropertyReadException;
import net.thomilist.dimensionalinventories.util.StringHelper;

public class ModProperties {
    private final String id;
    private final List<String> authors = new ArrayList<String>();
    private String namePretty = "<unknown mod name>";
    private String namePascal = "<unknown mod name>";
    private String version = "<unknown mod version>";
    private String description = "<unknown mod description>";

    public ModProperties(String modId) {
        this.id = modId;
        try {
            Optional fabricModJsonPath = ((ModContainer)FabricLoader.getInstance().getModContainer(this.id).orElseThrow()).findPath("fabric.mod.json");
            if (fabricModJsonPath.isEmpty()) {
                throw new PropertyReadException();
            }
            try (InputStream stream = Files.newInputStream((Path)fabricModJsonPath.get(), new OpenOption[0]);){
                InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                try (JsonReader jsonReader = new JsonReader((Reader)reader);){
                    jsonReader.beginObject();
                    block24: while (jsonReader.hasNext()) {
                        String name;
                        switch (name = jsonReader.nextName()) {
                            case "version": {
                                this.version = jsonReader.nextString();
                                continue block24;
                            }
                            case "name": {
                                this.namePretty = jsonReader.nextString();
                                this.namePascal = StringHelper.toPascalCase(this.namePretty);
                                continue block24;
                            }
                            case "description": {
                                this.description = jsonReader.nextString();
                                continue block24;
                            }
                            case "authors": {
                                jsonReader.beginArray();
                                while (jsonReader.hasNext()) {
                                    this.authors.add(jsonReader.nextString());
                                }
                                jsonReader.endArray();
                                continue block24;
                            }
                        }
                        jsonReader.skipValue();
                    }
                    jsonReader.endObject();
                }
            }
        }
        catch (IOException e) {
            throw new PropertyReadException();
        }
    }

    public String version() {
        return this.version;
    }

    public String id() {
        return this.id;
    }

    public String namePretty() {
        return this.namePretty;
    }

    public String namePascal() {
        return this.namePascal;
    }

    public String description() {
        return this.description;
    }

    public List<String> authors() {
        return this.authors;
    }

    public String authorsPretty() {
        if (this.authors.isEmpty()) {
            return "<no authors found>";
        }
        return StringHelper.joinLastDifferent(", ", " & ", this.authors);
    }
}

