/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.util;

import java.nio.file.Path;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.thomilist.dimensionalinventories.module.base.Module;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPool;
import net.thomilist.dimensionalinventories.module.version.StorageVersion;

public final class SavePaths {
    private static final String BASE_SAVE_DIRECTORY_NAME = "dimensional-inventories";
    private static final String DATA_DIRECTORY_NAME = "data";
    private static final String CONFIG_DIRECTORY_NAME = "config";
    private static final String LOST_AND_FOUND_DIRECTORY_NAME = "lost+found";
    private static final String DELETED_DIRECTORY_NAME = "deleted";
    private static Path baseSaveDirectory;

    private SavePaths() {
    }

    public static void onServerStarted(MinecraftServer server) {
        baseSaveDirectory = server.method_27050(class_5218.field_24188).resolve(BASE_SAVE_DIRECTORY_NAME);
    }

    public static Path saveDirectory() {
        return baseSaveDirectory;
    }

    public static Path saveDirectory(StorageVersion storageVersion) {
        return SavePaths.saveDirectory().resolve(storageVersion.toString());
    }

    public static Path saveDirectory(StorageVersion storageVersion, DimensionPool dimensionPool) {
        return switch (storageVersion) {
            default -> throw new MatchException(null, null);
            case StorageVersion.V1 -> SavePaths.saveDirectory(storageVersion).resolve(dimensionPool.getId());
            case StorageVersion.V2 -> SavePaths.saveDirectory(storageVersion).resolve(DATA_DIRECTORY_NAME).resolve(dimensionPool.getId());
        };
    }

    public static Path saveDirectory(StorageVersion storageVersion, DimensionPool dimensionPool, class_3222 player) {
        return switch (storageVersion) {
            default -> throw new MatchException(null, null);
            case StorageVersion.V1 -> SavePaths.saveDirectory(storageVersion, dimensionPool);
            case StorageVersion.V2 -> SavePaths.saveDirectory(storageVersion, dimensionPool).resolve(player.method_5845());
        };
    }

    public static Path saveDirectory(StorageVersion storageVersion, DimensionPool dimensionPool, class_3222 player, String namespace) {
        return switch (storageVersion) {
            default -> throw new MatchException(null, null);
            case StorageVersion.V1 -> SavePaths.saveDirectory(storageVersion, dimensionPool);
            case StorageVersion.V2 -> SavePaths.saveDirectory(storageVersion, dimensionPool, player).resolve(namespace);
        };
    }

    public static Path configDirectory(StorageVersion storageVersion) {
        return switch (storageVersion) {
            default -> throw new MatchException(null, null);
            case StorageVersion.V1 -> SavePaths.saveDirectory(storageVersion);
            case StorageVersion.V2 -> SavePaths.saveDirectory(storageVersion).resolve(CONFIG_DIRECTORY_NAME);
        };
    }

    public static Path configDirectory(StorageVersion storageVersion, String namespace) {
        return switch (storageVersion) {
            default -> throw new MatchException(null, null);
            case StorageVersion.V1 -> SavePaths.saveDirectory(storageVersion);
            case StorageVersion.V2 -> SavePaths.configDirectory(storageVersion).resolve(namespace);
        };
    }

    public static Path lostAndFoundDirectory(StorageVersion storageVersion) {
        return SavePaths.saveDirectory(storageVersion).resolve(LOST_AND_FOUND_DIRECTORY_NAME);
    }

    public static Path lostAndFoundDirectory(StorageVersion storageVersion, DimensionPool dimensionPool) {
        return SavePaths.saveDirectory(storageVersion, dimensionPool).resolve(LOST_AND_FOUND_DIRECTORY_NAME);
    }

    public static Path lostAndFoundDirectory(StorageVersion storageVersion, DimensionPool dimensionPool, class_3222 player) {
        return SavePaths.saveDirectory(storageVersion, dimensionPool, player).resolve(LOST_AND_FOUND_DIRECTORY_NAME);
    }

    public static Path lostAndFoundDirectory(StorageVersion storageVersion, DimensionPool dimensionPool, class_3222 player, Module module) {
        return SavePaths.saveDirectory(storageVersion, dimensionPool, player, module.groupId()).resolve(LOST_AND_FOUND_DIRECTORY_NAME);
    }
}

