/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.util;

import java.util.Collection;
import java.util.List;
import net.thomilist.dimensionalinventories.compatibility.Compat;

public final class StringHelper {
    public static final String SCOPE_DELIMITER = " :: ";

    private StringHelper() {
    }

    public static String joinScopes(String ... scopes) {
        return String.join((CharSequence)SCOPE_DELIMITER, scopes);
    }

    public static String joinScopes(Collection<String> scopes) {
        return StringHelper.joinScopes((String[])scopes.toArray(String[]::new));
    }

    public static String joinAndWrapScopes(String ... scopes) {
        return String.join((CharSequence)" ", "[", StringHelper.joinScopes(scopes), "]");
    }

    public static String joinAndWrapScopes(Collection<String> scopes) {
        return StringHelper.joinAndWrapScopes((String[])scopes.toArray(String[]::new));
    }

    public static String toPascalCase(String text) {
        char[] characters = text.toLowerCase().toCharArray();
        StringBuilder builder = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : characters) {
            if (!Character.isLetterOrDigit(c)) {
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                builder.append(Character.toTitleCase(c));
                capitalizeNext = false;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String joinLastDifferent(String mainDelimiter, String lastDelimiter, String ... strings) {
        return StringHelper.joinLastDifferent(mainDelimiter, lastDelimiter, List.of(strings));
    }

    public static String joinLastDifferent(String mainDelimiter, String lastDelimiter, List<String> strings) {
        return switch (strings.size()) {
            case 0 -> "";
            case 1 -> Compat.LIST.getFirst(strings);
            default -> String.join((CharSequence)lastDelimiter, String.join((CharSequence)mainDelimiter, strings.subList(0, strings.size() - 1)), Compat.LIST.getLast(strings));
        };
    }
}

