/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.util.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFound;
import net.thomilist.dimensionalinventories.util.gson.SerializerPair;

public class OptionalSerializerPair<T>
implements SerializerPair<Optional<T>> {
    @Override
    public Optional<T> fromJson(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonArray()) {
            LostAndFound.log("Unexpected JSON structure for Optional<T> (expected an array)", json.toString());
            return Optional.empty();
        }
        JsonArray asJsonArray = json.getAsJsonArray();
        JsonElement jsonElement = asJsonArray.get(0);
        Object value = context.deserialize(jsonElement, ((ParameterizedType)typeOfT).getActualTypeArguments()[0]);
        return Optional.ofNullable(value);
    }

    @Override
    public JsonElement toJson(Optional<T> src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement element = context.serialize(src.orElse(null));
        JsonArray result = new JsonArray();
        result.add(element);
        return result;
    }
}

