package net.thomilist.dimensionalinventories.module.builtin.inventory;

import com.google.gson.*;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFound;
import net.thomilist.dimensionalinventories.util.gson.SerializerPair;

import java.lang.reflect.Type;
import java.util.Objects;

public class ItemStackListSerializerPair
    implements SerializerPair<class_2371<class_1799>>
{
    public static final Type TYPE = new ItemStackListSerializerPair().type();

    @Override
    public class_2371<class_1799> fromJson( final JsonElement json,
                                              final Type typeOfT,
                                              final JsonDeserializationContext context )
        throws JsonParseException
    {
        if ( !json.isJsonArray() )
        {
            LostAndFound.log(
                "Unexpected JSON structure for list of item stacks (expected an array)",
                json.getAsString()
            );

            return class_2371.method_37434( 0 );
        }

        final JsonArray jsonArray = json.getAsJsonArray();
        final class_2371<class_1799> items = class_2371.method_10213( jsonArray.size(), class_1799.field_8037 );

        for ( int i = 0; i < jsonArray.size(); i++ )
        {
            items.set(
                i,
                Objects.requireNonNullElse(
                    context.deserialize( jsonArray.get( i ), class_1799.class ),
                    class_1799.field_8037
                )
            );
        }

        return items;
    }

    @Override
    public JsonElement toJson( final class_2371<class_1799> src,
                               final Type typeOfSrc,
                               final JsonSerializationContext context )
    {
        final JsonArray json = new JsonArray();

        for ( final class_1799 itemStack : src )
        {
            json.add( context.serialize( itemStack, class_1799.class ) );
        }

        return json;
    }
}
