package net.thomilist.dimensionalinventories.module.builtin.inventory;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.thomilist.dimensionalinventories.compatibility.Compat;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFound;
import net.thomilist.dimensionalinventories.util.gson.SerializerPair;

import java.lang.reflect.Type;

public class ItemStackSerializerPair
    implements SerializerPair<class_1799>
{
    @Override
    public class_1799 fromJson( final JsonElement json, final Type typeOfT, final JsonDeserializationContext context )
        throws JsonParseException
    {
        final class_2487 nbt = context.deserialize( json, class_2487.class );

        if ( (nbt == null) || nbt.method_33133() )
        {
            return null;
        }

        final class_1799 itemStack = Compat.NBT.toItemStack( nbt );

        if ( itemStack == null )
        {
            LostAndFound.log( "Invalid NBT compound for item stack", nbt.toString() );
            return null;
        }

        return itemStack;
    }

    @Override
    public JsonElement toJson( final class_1799 src, final Type typeOfSrc, final JsonSerializationContext context )
    {
        if ( src.method_7960() )
        {
            return null;
        }

        return context.serialize( Compat.NBT.fromItemStack( src ), class_2487.class );
    }
}
