package net.thomilist.dimensionalinventories.module.builtin.shoulderentity;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.thomilist.dimensionalinventories.module.base.JsonModule;
import net.thomilist.dimensionalinventories.module.base.ModuleBase;
import net.thomilist.dimensionalinventories.module.base.player.JsonPlayerModule;
import net.thomilist.dimensionalinventories.module.version.StorageVersion;
import net.thomilist.dimensionalinventories.module.version.VersionedJsonData;
import net.thomilist.dimensionalinventories.util.NbtUtils;

public final class ShoulderEntityModule
    extends ModuleBase
    implements JsonPlayerModule<ShoulderEntityModuleState>
{
    private static final String MODULE_ID = "shoulder-entity";
    private static final String DESCRIPTION = "Shoulder entities - just parrots, at least for now.";

    private static final StorageVersion[] STORAGE_VERSIONS = {
        StorageVersion.V2
    };

    private static final Gson GSON = JsonModule.GSON_BUILDER.create();

    private final ShoulderEntityModuleState state = new ShoulderEntityModuleState();

    public ShoulderEntityModule( final String groupId )
    {
        super(
            ShoulderEntityModule.STORAGE_VERSIONS,
            groupId,
            ShoulderEntityModule.MODULE_ID,
            ShoulderEntityModule.DESCRIPTION
        );
    }

    private static void preprocessOldShoulderEntityNbt( final class_2487 nbtCompound )
    {
        if ( NbtUtils.isEffectivelyEmpty( nbtCompound ) || nbtCompound.method_10545( "id" ) )
        {
            return;
        }

        nbtCompound.method_10582( "id", "minecraft:parrot" );
    }

    @Override
    public Gson gson()
    {
        return ShoulderEntityModule.GSON;
    }

    @Override
    public ShoulderEntityModuleState loadVersionedData( final VersionedJsonData versionedData )
        throws JsonParseException
    {
        final ShoulderEntityModuleState loadedState = JsonPlayerModule.super.loadVersionedData( versionedData );

        ShoulderEntityModule.preprocessOldShoulderEntityNbt( loadedState.leftShoulderEntity );
        ShoulderEntityModule.preprocessOldShoulderEntityNbt( loadedState.rightShoulderEntity );

        return loadedState;
    }

    @Override
    public ShoulderEntityModuleState newInstance( final class_3222 player )
    {
        return new ShoulderEntityModuleState( player );
    }

    @Override
    public ShoulderEntityModuleState state()
    {
        return this.state;
    }

    @Override
    public ShoulderEntityModuleState defaultState()
    {
        return new ShoulderEntityModuleState();
    }
}
