package net.thomilist.dimensionalinventories.module.builtin.status;

import com.google.gson.*;
import net.minecraft.class_1293;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFound;
import net.thomilist.dimensionalinventories.util.gson.SerializerPair;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;

public class StatusEffectCollectionSerializerPair
    implements SerializerPair<Collection<class_1293>>
{
    public static final Type TYPE = new StatusEffectCollectionSerializerPair().type();

    @Override
    public Collection<class_1293> fromJson( final JsonElement json,
                                                      final Type typeOfT,
                                                      final JsonDeserializationContext context )
        throws JsonParseException
    {
        if ( !json.isJsonArray() )
        {
            LostAndFound.log(
                "Unexpected JSON structure for collection of status effects (expected an array)",
                json.getAsString()
            );

            return new ArrayList<>();
        }

        final ArrayList<class_1293> effects = new ArrayList<>();
        final JsonArray jsonArray = json.getAsJsonArray();

        for ( int i = 0; i < jsonArray.size(); i++ )
        {
            final class_1293 effect = context.deserialize( jsonArray.get( i ), class_1293.class );

            if ( effect == null )
            {
                continue;
            }

            effects.add( effect );
        }

        return effects;
    }

    @Override
    public JsonElement toJson( final Collection<class_1293> src,
                               final Type typeOfSrc,
                               final JsonSerializationContext context )
    {
        final JsonArray json = new JsonArray();

        for ( final class_1293 statusEffect : src )
        {
            json.add( context.serialize( statusEffect, class_1293.class ) );
        }

        return json;
    }
}
