package net.thomilist.dimensionalinventories.module.builtin.status;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import net.minecraft.class_1293;
import net.minecraft.class_2487;
import net.thomilist.dimensionalinventories.compatibility.Compat;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFound;
import net.thomilist.dimensionalinventories.util.gson.SerializerPair;

import java.lang.reflect.Type;

public class StatusEffectSerializerPair
    implements SerializerPair<class_1293>
{
    @Override
    public class_1293 fromJson( final JsonElement json,
                                          final Type typeOfT,
                                          final JsonDeserializationContext context )
        throws JsonParseException
    {
        final class_2487 nbt = context.deserialize( json, class_2487.class );

        if ( nbt == null )
        {
            return null;
        }

        final class_1293 effect = Compat.NBT.toStatusEffectInstance( nbt );

        if ( effect == null )
        {
            LostAndFound.log( "Invalid NBT compound for status effect instance", nbt.toString() );
            return null;
        }

        return effect;
    }

    @Override
    public JsonElement toJson( final class_1293 src,
                               final Type typeOfSrc,
                               final JsonSerializationContext context )
    {
        return context.serialize( Compat.NBT.fromStatusEffectInstance( src ), class_2487.class );
    }
}
