package net.thomilist.dimensionalinventories.util;

import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.HashSet;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;

public final class NbtUtils
{
    private NbtUtils()
    { }

    public static boolean isEffectivelyEmpty( final @Nullable class_2520 nbtElement )
    {
        return switch ( nbtElement )
        {
            case final class_2483 nbtList -> nbtList.isEmpty();
            case final class_2487 nbtCompound ->
                nbtCompound.method_33133() || nbtCompound.method_68567().stream().allMatch( NbtUtils::isEffectivelyEmpty );
            case null -> true;
            default -> false;
        };
    }

    public static boolean areEffectivelyEqual( final @Nullable class_2520 left, final @Nullable class_2520 right )
    {
        if ( class_2512.method_10687( left, right, true ) )
        {
            return true;
        }

        if ( NbtUtils.isEffectivelyEmpty( left ) && NbtUtils.isEffectivelyEmpty( right ) )
        {
            return true;
        }

        if ( (left instanceof final class_2487 leftCompound) && (right instanceof final class_2487 rightCompound) )
        {
            final Collection<String> combinedKeys = new HashSet<>();
            combinedKeys.addAll( leftCompound.method_10541() );
            combinedKeys.addAll( rightCompound.method_10541() );

            for ( final String key : combinedKeys )
            {
                final class_2520 leftElement = leftCompound.method_10580( key );
                final class_2520 rightElement = rightCompound.method_10580( key );

                if ( !NbtUtils.areEffectivelyEqual( leftElement, rightElement ) )
                {
                    return false;
                }
            }
        }

        return true;
    }
}
