package net.thomilist.dimensionalinventories.util.gson;

import com.google.gson.*;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFound;

import java.lang.reflect.Type;

public class NbtCompoundSerializerPair
    implements SerializerPair<class_2487>
{
    @Override
    public class_2487 fromJson( final JsonElement json, final Type typeOfT, final JsonDeserializationContext context )
        throws JsonParseException
    {
        if ( !json.isJsonPrimitive() )
        {
            LostAndFound.log( "Unexpected JSON structure for NBT compound (expected a string)", json.toString() );
            return null;
        }

        final String nbtString = json.getAsJsonPrimitive().getAsString();

        try
        {
            return class_2512.method_32260( nbtString );
        }
        catch ( final CommandSyntaxException e )
        {
            LostAndFound.log( "Invalid NBT string", nbtString, e );
            return null;
        }
    }

    @Override
    public JsonElement toJson( final class_2487 src, final Type typeOfSrc, final JsonSerializationContext context )
    {
        if ( src == null )
        {
            return null;
        }

        return new JsonPrimitive( class_2512.method_32271( src ) );
    }
}
