/*
 * Decompiled with CFR 0.152.
 */
package net.trinketina.frogpetting.config;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import net.trinketina.frogpetting.config.PettingConfigProvider;
import net.trinketina.frogpetting.config.SimpleConfig;

public class PettingConfig {
    public static int COOLDOWN;
    public static float SLIME_SQUISHINESS;
    public static boolean ENABLE_RIDEABLE_PETTING;
    public static boolean ENABLE_ALLAY_UNIQUE;
    public static boolean ENABLE_BEE_UNIQUE;
    public static boolean ENABLE_CAMEL_UNIQUE;
    public static boolean ENABLE_CAT_UNIQUE;
    public static boolean ENABLE_CHICKEN_UNIQUE;
    public static boolean ENABLE_FROG_UNIQUE;
    public static boolean ENABLE_GOAT_UNIQUE;
    public static boolean ENABLE_PARROT_UNIQUE;
    public static boolean ENABLE_RABBIT_UNIQUE;
    public static boolean ENABLE_SLIME_UNIQUE;
    public static boolean ENABLE_SNIFFER_UNIQUE;
    public static boolean ENABLE_WOLF_UNIQUE;
    public static List<String> IGNORED_MOBS;
    public static SimpleConfig CONFIG;
    private static PettingConfigProvider configs;

    private String provider(String filename) {
        return "#Pet more Than Frogs Config\n#cooldown time in ticks:";
    }

    public static void registerConfigs() {
        configs = new PettingConfigProvider();
        PettingConfig.createConfigs();
        CONFIG = SimpleConfig.of("frog_petting-config").provider(configs).request();
        PettingConfig.assignConfigs();
    }

    private static void createConfigs() {
        configs.addKeyValuePair(new Pair((Object)"cooldown", (Object)10), "petting cooldown in ticks");
        configs.addLine();
        configs.addComment("how squishy is the slime when pet");
        configs.addKeyValuePair(new Pair((Object)"slime-squishiness", (Object)Float.valueOf(-0.8f)), "recommended range: -2 to 2");
        configs.addLine();
        configs.addKeyValuePair(new Pair((Object)"rideable-shift-petting", (Object)true), "enable/disable rideable mob petting");
        configs.addLine();
        configs.addSeparator();
        configs.addComment("Enable or Disable entity-specific unique interactions");
        configs.addSeparator();
        configs.addKeyValuePair(new Pair((Object)"allay-unique", (Object)true), "allay twirl");
        configs.addKeyValuePair(new Pair((Object)"bee-unique", (Object)true), "bee spin");
        configs.addKeyValuePair(new Pair((Object)"camel-unique", (Object)true), "camel ear wiggle");
        configs.addKeyValuePair(new Pair((Object)"cat-unique", (Object)true), "cat nod");
        configs.addKeyValuePair(new Pair((Object)"chicken-unique", (Object)true), "chicken wing flap");
        configs.addKeyValuePair(new Pair((Object)"frog-unique", (Object)true), "frog croak");
        configs.addKeyValuePair(new Pair((Object)"goat-unique", (Object)true), "goat nod");
        configs.addKeyValuePair(new Pair((Object)"parrot-unique", (Object)true), "parrot wing flap");
        configs.addKeyValuePair(new Pair((Object)"rabbit-unique", (Object)true), "rabbit kick");
        configs.addKeyValuePair(new Pair((Object)"slime-unique", (Object)true), "slime squish");
        configs.addKeyValuePair(new Pair((Object)"sniffer-unique", (Object)true), "sniffer sniff");
        configs.addKeyValuePair(new Pair((Object)"wolf-unique", (Object)true), "wolf shake");
        configs.addSeparator();
        configs.addComment("Disable interactions for some mobs");
        configs.addSeparator();
        configs.addKeyValuePair(new Pair((Object)"ignored-mobs", (Object)"\"\""), "ignored mobs separated by commas (ex: \"entity.minecraft.wolf, entity.minecraft.parrot\")");
    }

    private static void assignConfigs() {
        COOLDOWN = CONFIG.getOrDefault("cooldown", 5);
        SLIME_SQUISHINESS = CONFIG.getOrDefault("slime-squishiness", -0.8f);
        ENABLE_RIDEABLE_PETTING = CONFIG.getOrDefault("rideable-shift-petting", true);
        ENABLE_ALLAY_UNIQUE = CONFIG.getOrDefault("allay-unique", true);
        ENABLE_BEE_UNIQUE = CONFIG.getOrDefault("bee-unique", true);
        ENABLE_CAMEL_UNIQUE = CONFIG.getOrDefault("camel-unique", true);
        ENABLE_CAT_UNIQUE = CONFIG.getOrDefault("cat-unique", true);
        ENABLE_CHICKEN_UNIQUE = CONFIG.getOrDefault("chicken-unique", true);
        ENABLE_FROG_UNIQUE = CONFIG.getOrDefault("frog-unique", true);
        ENABLE_PARROT_UNIQUE = CONFIG.getOrDefault("parrot-unique", true);
        ENABLE_GOAT_UNIQUE = CONFIG.getOrDefault("goat-unique", true);
        ENABLE_RABBIT_UNIQUE = CONFIG.getOrDefault("rabbit-unique", true);
        ENABLE_SLIME_UNIQUE = CONFIG.getOrDefault("slime-unique", true);
        ENABLE_SNIFFER_UNIQUE = CONFIG.getOrDefault("sniffer-unique", true);
        ENABLE_WOLF_UNIQUE = CONFIG.getOrDefault("wolf-unique", true);
        IGNORED_MOBS = Arrays.asList(CONFIG.getOrDefault("ignored-mobs", "\"\"").split("\\s*,\\s*"));
    }
}

