/*
 * Decompiled with CFR 0.152.
 */
package net.trinketina.frogpetting.resourcegen;

import com.nimbusds.jose.shaded.gson.JsonElement;
import com.nimbusds.jose.shaded.gson.JsonObject;
import com.nimbusds.jose.shaded.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_7179;
import net.minecraft.class_7184;
import net.minecraft.class_7186;
import net.minecraft.class_7187;
import net.trinketina.frogpetting.PettingClient;
import net.trinketina.frogpetting.resourcegen.jsondata.AnimationBoneData;
import net.trinketina.frogpetting.resourcegen.jsondata.AnimationData;
import net.trinketina.frogpetting.resourcegen.jsondata.BoneTransformationData;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class AnimationDataReader {
    public static AnimationData readAnimation(BufferedReader reader, String animation_name) throws IOException {
        JsonElement animation_json = JsonParser.parseReader((Reader)reader);
        JsonObject root = animation_json.getAsJsonObject();
        JsonObject animations = root.getAsJsonObject("animations");
        JsonObject petting_animation = animations.getAsJsonObject(animation_name);
        JsonObject bones = petting_animation.getAsJsonObject("bones");
        AnimationData animation_data = new AnimationData();
        animation_data.animation_length = petting_animation.get("animation_length").getAsFloat();
        animation_data.bone_animations = AnimationDataReader.readBones(bones);
        return animation_data;
    }

    static List<AnimationBoneData> readBones(JsonObject bones) {
        ArrayList<AnimationBoneData> bone_animations = new ArrayList<AnimationBoneData>();
        for (Map.Entry bone_entry : bones.entrySet()) {
            AnimationBoneData bone_animation = new AnimationBoneData();
            bone_animation.bone_name = (String)bone_entry.getKey();
            bone_animation.transformation_animations = AnimationDataReader.readTransformations((JsonElement)bone_entry.getValue());
            bone_animations.add(bone_animation);
        }
        return bone_animations;
    }

    static List<BoneTransformationData> readTransformations(JsonElement bone_data) {
        ArrayList<BoneTransformationData> transformations = new ArrayList<BoneTransformationData>();
        block10: for (Map.Entry transformationEntry : bone_data.getAsJsonObject().entrySet()) {
            class_7179.class_7182 transformation_target;
            String transformation_target_type;
            switch (transformation_target_type = (String)transformationEntry.getKey()) {
                case "position": {
                    transformation_target = class_7179.class_7183.field_37886;
                    break;
                }
                case "rotation": {
                    transformation_target = class_7179.class_7183.field_37887;
                    break;
                }
                case "scale": {
                    transformation_target = class_7179.class_7183.field_37888;
                    break;
                }
                default: {
                    continue block10;
                }
            }
            class_7186[] keyframes = AnimationDataReader.readKeyframes((JsonElement)transformationEntry.getValue(), transformation_target_type).toArray(new class_7186[0]);
            BoneTransformationData transformation_data = new BoneTransformationData(transformation_target, keyframes);
            transformations.add(transformation_data);
        }
        return transformations;
    }

    static List<class_7186> readKeyframes(JsonElement keyframe_data, String transformation_target_type) {
        ArrayList<class_7186> keyframes = new ArrayList<class_7186>();
        block12: for (Map.Entry keyframeEntry : keyframe_data.getAsJsonObject().entrySet()) {
            try {
                class_7186 keyframe;
                float keyframe_position = Float.parseFloat((String)keyframeEntry.getKey());
                String vector_string = ((JsonElement)keyframeEntry.getValue()).toString();
                String[] vector_values = vector_string.substring(vector_string.indexOf("[") + 1, vector_string.indexOf("]")).split(",");
                float x = Float.parseFloat(vector_values[0]);
                float y = Float.parseFloat(vector_values[1]);
                float z = Float.parseFloat(vector_values[2]);
                Vector3f keyframe_vector = new Vector3f(x, y, z);
                switch (transformation_target_type) {
                    case "position": {
                        keyframe_vector = class_7187.method_41823((float)x, (float)y, (float)z);
                        keyframe = new class_7186(keyframe_position, keyframe_vector, class_7179.class_7181.field_37884);
                        break;
                    }
                    case "rotation": {
                        keyframe_vector = class_7187.method_41829((float)x, (float)y, (float)z);
                        keyframe = new class_7186(keyframe_position, keyframe_vector, class_7179.class_7181.field_37884);
                        break;
                    }
                    case "scale": {
                        keyframe_vector = class_7187.method_41822((double)x, (double)y, (double)z);
                        keyframe = new class_7186(keyframe_position, keyframe_vector, class_7179.class_7181.field_37884);
                        break;
                    }
                    default: {
                        continue block12;
                    }
                }
                keyframes.add(keyframe);
            }
            catch (Exception e) {
                PettingClient.LOGGER.error("error reading keyframe: " + e.getMessage());
            }
        }
        return keyframes;
    }

    public static class_7184 buildAnimation(AnimationData animation_data) {
        float animation_length = animation_data.animation_length;
        class_7184.class_7185 animation_builder = class_7184.class_7185.method_41818((float)animation_length);
        for (AnimationBoneData bone_animation : animation_data.bone_animations) {
            for (BoneTransformationData animation_element : bone_animation.transformation_animations) {
                animation_builder = animation_builder.method_41820(bone_animation.bone_name, new class_7179(animation_element.transformation_target, animation_element.keyframes));
            }
        }
        return animation_builder.method_41821();
    }
}

