/*
 * Decompiled with CFR 0.152.
 */
package net.trinketina.frogpetting.resourcegen;

import com.nimbusds.jose.shaded.gson.Gson;
import com.nimbusds.jose.shaded.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.trinketina.frogpetting.PettingClient;
import net.trinketina.frogpetting.PettingData;
import net.trinketina.frogpetting.resourcegen.AnimationDataReader;
import net.trinketina.frogpetting.resourcegen.jsondata.AnimationData;
import net.trinketina.frogpetting.resourcegen.jsondata.PettingOffsetData;

@Environment(value=EnvType.CLIENT)
public class PettingResourceLoader
implements SimpleSynchronousResourceReloadListener {
    public static String animation_name = "animation.petting";

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"frog-petting", (String)"offsets");
    }

    public void method_14491(class_3300 manager) {
        PettingClient.LOGGER.info(this.getFabricId().toString());
        this.loadOffsets(manager);
        this.loadAnimations(manager);
    }

    private String getEntityType(class_2960 id) {
        int index_last_slash;
        int index_first_slash = id.method_12832().indexOf("/");
        if (index_first_slash == (index_last_slash = id.method_12832().lastIndexOf("/"))) {
            return null;
        }
        String entity_namespace = id.method_12832().substring(index_first_slash + 1, index_last_slash);
        if (entity_namespace.isEmpty()) {
            return null;
        }
        return "entity." + entity_namespace + "." + id.method_12832().substring(index_last_slash + 1, id.method_12832().lastIndexOf(".json"));
    }

    private void loadOffsets(class_3300 manager) {
        PettingData.OFFSETS.clear();
        for (class_2960 id : manager.method_14488("offsets", path -> path.toString().endsWith(".json")).keySet()) {
            try {
                BufferedReader reader = ((class_3298)manager.method_14486(id).get()).method_43039();
                try {
                    String entity = this.getEntityType(id);
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    PettingOffsetData offset_json = (PettingOffsetData)gson.fromJson((Reader)reader, PettingOffsetData.class);
                    PettingData.OFFSETS.put(entity, offset_json);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                PettingClient.LOGGER.error("Error occurred while loading resource json" + id.toString(), (Throwable)e);
            }
        }
    }

    private void loadAnimations(class_3300 manager) {
        PettingData.PETTING_ANIMATIONS.clear();
        for (class_2960 id : manager.method_14488("animations", path -> path.toString().endsWith(".json")).keySet()) {
            try {
                BufferedReader reader = ((class_3298)manager.method_14486(id).get()).method_43039();
                try {
                    String entity_id = this.getEntityType(id);
                    AnimationData animation_data = AnimationDataReader.readAnimation(reader, animation_name);
                    PettingData.PETTING_ANIMATIONS.put(entity_id, AnimationDataReader.buildAnimation(animation_data));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                PettingClient.LOGGER.error("Error occurred while loading resource json" + id.toString(), (Throwable)e);
            }
        }
    }
}

