/*
 * Decompiled with CFR 0.152.
 */
package com.sylsatra.hologram.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sylsatra.hologram.client.ClientActivationRegistry;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fifthlight.blazerod.animation.AnimationItem;
import top.fifthlight.blazerod.animation.AnimationLoader;
import top.fifthlight.blazerod.model.Model;
import top.fifthlight.blazerod.model.ModelFileLoader;
import top.fifthlight.blazerod.model.ModelFileLoaders;
import top.fifthlight.blazerod.model.ModelInstance;
import top.fifthlight.blazerod.model.NodeTransform;
import top.fifthlight.blazerod.model.RenderScene;
import top.fifthlight.blazerod.model.TransformId;
import top.fifthlight.blazerod.model.animation.Animation;
import top.fifthlight.blazerod.model.data.LocalMatricesBuffer;
import top.fifthlight.blazerod.model.load.ModelLoader;
import top.fifthlight.blazerod.model.node.RenderNode;
import top.fifthlight.blazerod.model.node.component.Primitive;
import top.fifthlight.blazerod.model.renderer.CpuTransformRenderer;
import top.fifthlight.blazerod.model.renderer.Renderer;
import top.fifthlight.blazerod.model.resource.RenderPrimitive;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002MNB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u0003J\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u001b\u0010\u001cJ{\u0010+\u001a\u0018\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020*\u0018\u00010)2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020#2\b\b\u0002\u0010%\u001a\u00020#2\b\b\u0002\u0010&\u001a\u00020#2\b\b\u0002\u0010'\u001a\u00020#2\b\b\u0002\u0010(\u001a\u00020#\u00a2\u0006\u0004\b+\u0010,J-\u0010/\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020#\u00a2\u0006\u0004\b/\u00100J\u001f\u00103\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u00020*H\u0002\u00a2\u0006\u0004\b3\u00104J'\u00108\u001a\u00020\f2\u0006\u00106\u001a\u0002052\u0006\u0010-\u001a\u00020\f2\u0006\u00107\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b8\u00109R\u0014\u0010;\u001a\u00020:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u001c\u0010?\u001a\n >*\u0004\u0018\u00010=0=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@R \u0010B\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002050A8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010CR,\u0010D\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001d0)\u0012\u0004\u0012\u00020*0A8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010CR,\u0010E\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001d0)\u0012\u0004\u0012\u00020#0A8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010CR,\u0010F\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001d0)\u0012\u0004\u0012\u00020\f0A8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010CR \u0010G\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010HR\u001a\u0010K\u001a\b\u0012\u0004\u0012\u00020J0I8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bK\u0010L\u00a8\u0006O"}, d2={"Lcom/sylsatra/hologram/client/HologramModelManager;", "", "<init>", "()V", "Ltop/fifthlight/blazerod/model/renderer/Renderer;", "getRenderer", "()Ltop/fifthlight/blazerod/model/renderer/Renderer;", "", "rotateRenderer", "", "isIrisShaderPackActive", "()Z", "", "code", "Ljava/nio/file/Path;", "resolveFolderForCode", "(I)Ljava/nio/file/Path;", "dir", "Lcom/sylsatra/hologram/client/HologramModelManager$Manifest;", "readManifest", "(Ljava/nio/file/Path;)Lcom/sylsatra/hologram/client/HologramModelManager$Manifest;", "manifest", "pickModelFile", "(Ljava/nio/file/Path;Lcom/sylsatra/hologram/client/HologramModelManager$Manifest;)Ljava/nio/file/Path;", "ensureLoaded", "(I)V", "Ltop/fifthlight/blazerod/model/RenderScene;", "getScene", "(I)Ltop/fifthlight/blazerod/model/RenderScene;", "Lcom/sylsatra/hologram/client/ClientActivationRegistry$Id;", "id", "", "centerX", "centerY", "centerZ", "", "scale", "paramScale", "paramOffX", "paramOffY", "paramOffZ", "Lkotlin/Pair;", "Ltop/fifthlight/blazerod/model/ModelInstance;", "getRendererAndInstance", "(ILcom/sylsatra/hologram/client/ClientActivationRegistry$Id;DDDFFFFF)Lkotlin/Pair;", "animCode", "dtSec", "applyAnimation", "(ILcom/sylsatra/hologram/client/ClientActivationRegistry$Id;IF)V", "scene", "instance", "resetInstancePose", "(Ltop/fifthlight/blazerod/model/RenderScene;Ltop/fifthlight/blazerod/model/ModelInstance;)V", "Lcom/sylsatra/hologram/client/HologramModelManager$ModelCache;", "cache", "count", "selectAnimationIndex", "(Lcom/sylsatra/hologram/client/HologramModelManager$ModelCache;II)I", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Ljava/util/concurrent/ConcurrentHashMap;", "models", "Ljava/util/concurrent/ConcurrentHashMap;", "instances", "animTimes", "animIndices", "renderer", "Ltop/fifthlight/blazerod/model/renderer/Renderer;", "", "", "exts", "Ljava/util/List;", "ModelCache", "Manifest", "hologram_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nHologramModelManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HologramModelManager.kt\ncom/sylsatra/hologram/client/HologramModelManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n1563#2:353\n1634#2,3:354\n1761#2,3:358\n1563#2:361\n1634#2,3:362\n1869#2,2:365\n1869#2,2:367\n1#3:357\n*S KotlinDebug\n*F\n+ 1 HologramModelManager.kt\ncom/sylsatra/hologram/client/HologramModelManager\n*L\n98#1:353\n98#1:354,3\n116#1:358,3\n160#1:361\n160#1:362,3\n172#1:365,2\n228#1:367,2\n*E\n"})
public final class HologramModelManager {
    @NotNull
    public static final HologramModelManager INSTANCE = new HologramModelManager();
    @NotNull
    private static final Gson gson = new Gson();
    private static final Logger logger = LoggerFactory.getLogger((String)"hologram");
    @NotNull
    private static final ConcurrentHashMap<Integer, ModelCache> models = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<Pair<Integer, ClientActivationRegistry.Id>, ModelInstance> instances = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<Pair<Integer, ClientActivationRegistry.Id>, Float> animTimes = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<Pair<Integer, ClientActivationRegistry.Id>, Integer> animIndices = new ConcurrentHashMap();
    @Nullable
    private static volatile Renderer<?, ?> renderer;
    @NotNull
    private static final List<String> exts;

    private HologramModelManager() {
    }

    private final Renderer<?, ?> getRenderer() {
        Renderer r = renderer;
        if (r == null) {
            logger.info("Using CpuTransformRenderer for holograms (temporary global default)");
            renderer = r = (Renderer)CpuTransformRenderer.Type.create();
        }
        return r;
    }

    public final void rotateRenderer() {
        try {
            Renderer<?, ?> renderer = HologramModelManager.renderer;
            if (renderer != null) {
                renderer.rotate();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final boolean isIrisShaderPackActive() {
        boolean bl;
        try {
            Class<?> apiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Method getInstance = apiClass.getMethod("getInstance", new Class[0]);
            Object api = getInstance.invoke(null, new Object[0]);
            Object isInUse = apiClass.getMethod("isShaderPackInUse", new Class[0]).invoke(api, new Object[0]);
            bl = Intrinsics.areEqual((Object)(isInUse instanceof Boolean ? (Boolean)isInUse : null), (Object)true);
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private final Path resolveFolderForCode(int code) {
        Path runDir = class_310.method_1551().field_1697.toPath();
        String string = "%03d";
        Object[] objectArray = new Object[]{RangesKt.coerceIn((int)code, (int)0, (int)255)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String nnn = string2;
        Path path = runDir.resolve("hologram").resolve("models").resolve(nnn);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Manifest readManifest(Path dir) {
        Manifest manifest;
        Path file = dir.resolve("manifest.json");
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return null;
        }
        Closeable closeable = Files.newBufferedReader(file);
        Throwable throwable = null;
        try {
            List list;
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            JsonElement jsonElement = json.get("file");
            String string = jsonElement != null ? jsonElement.getAsString() : null;
            JsonElement jsonElement2 = json.get("scale");
            Float f = jsonElement2 != null ? Float.valueOf(jsonElement2.getAsFloat()) : null;
            JsonElement jsonElement3 = json.get("offset");
            if (jsonElement3 != null && (jsonElement3 = jsonElement3.getAsJsonArray()) != null) {
                Collection<Float> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = (Iterable)jsonElement3;
                Float f2 = f;
                String string2 = string;
                boolean $i$f$map = false;
                void var12_14 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonElement jsonElement4 = (JsonElement)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(Float.valueOf(it.getAsFloat()));
                }
                collection = (List)destination$iv$iv;
                string = string2;
                f = f2;
                list = collection;
            } else {
                list = null;
            }
            JsonElement jsonElement5 = json.get("defaultAnimation");
            Integer n = jsonElement5 != null ? Integer.valueOf(jsonElement5.getAsInt()) : null;
            List list2 = list;
            Float f3 = f;
            String string3 = string;
            manifest = new Manifest(string3, f3, list2, n);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path pickModelFile(Path dir, Manifest manifest) {
        Object object = manifest;
        if (object != null && (object = ((Manifest)object).getFile()) != null) {
            Object f = object;
            boolean bl = false;
            Path p = dir.resolve((String)f);
            if (Files.isRegularFile(p, new LinkOption[0])) {
                return p;
            }
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return null;
        }
        AutoCloseable autoCloseable = Files.list(dir);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            Path path = stream.filter(arg_0 -> HologramModelManager.pickModelFile$lambda$1$1(HologramModelManager::pickModelFile$lambda$1$0, arg_0)).findFirst().orElse(null);
            return path;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void ensureLoaded(int code) {
        float scaleMul;
        if (models.containsKey(code)) {
            return;
        }
        Path dir = this.resolveFolderForCode(code);
        Manifest manifest = this.readManifest(dir);
        Path path = this.pickModelFile(dir, manifest);
        if (path == null) {
            HologramModelManager $this$ensureLoaded_u24lambda_u240 = this;
            boolean bl = false;
            logger.warn("No model file found for code=" + code + " in " + dir.toAbsolutePath() + " (expected one of " + exts + ")");
            return;
        }
        Path modelPath = path;
        logger.info("Loading model for code=" + code + " from " + modelPath.toAbsolutePath());
        ModelFileLoader.LoadResult loadResult = ModelFileLoaders.probeAndLoad$default((ModelFileLoaders)ModelFileLoaders.INSTANCE, (Path)modelPath, null, (int)2, null);
        if (loadResult == null) {
            HologramModelManager $this$ensureLoaded_u24lambda_u241 = this;
            boolean bl = false;
            logger.warn("No loader available for file " + modelPath.getFileName() + " (code=" + code + ")");
            return;
        }
        ModelFileLoader.LoadResult result = loadResult;
        Model model = result.getModel();
        if (model == null) {
            HologramModelManager $this$ensureLoaded_u24lambda_u242 = this;
            boolean bl = false;
            logger.warn("Loader failed to provide model for file " + modelPath.getFileName() + " (code=" + code + ")");
            return;
        }
        Model model2 = model;
        CompletableFuture future = ModelLoader.loadModelAsFuture((Model)model2);
        Object object = manifest;
        float f = scaleMul = object != null && (object = ((Manifest)object).getScale()) != null ? ((Float)object).floatValue() : 1.0f;
        Object object2 = manifest;
        if (object2 == null || (object2 = ((Manifest)object2).getOffset()) == null) {
            object2 = CollectionsKt.emptyList();
        }
        Object off = object2;
        Float f2 = (Float)CollectionsKt.getOrNull((List)off, (int)0);
        float ox = f2 != null ? f2.floatValue() : 0.0f;
        Float f3 = (Float)CollectionsKt.getOrNull((List)off, (int)1);
        float oy = f3 != null ? f3.floatValue() : 0.0f;
        Float f4 = (Float)CollectionsKt.getOrNull((List)off, (int)2);
        float oz = f4 != null ? f4.floatValue() : 0.0f;
        Manifest manifest2 = manifest;
        ModelCache cache = new ModelCache(future, null, null, scaleMul, ox, oy, oz, manifest2 != null ? manifest2.getDefaultAnimation() : null, 6, null);
        ((Map)models).put(code, cache);
        future.thenAccept(arg_0 -> HologramModelManager.ensureLoaded$lambda$4(arg_0 -> HologramModelManager.ensureLoaded$lambda$3(cache, code, result, dir, arg_0), arg_0));
    }

    @Nullable
    public final RenderScene getScene(int code) {
        ModelCache modelCache = models.get(code);
        return modelCache != null ? modelCache.getScene() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Pair<Renderer<?, ?>, ModelInstance> getRendererAndInstance(int code, @NotNull ClientActivationRegistry.Id id, double centerX, double centerY, double centerZ, float scale, float paramScale, float paramOffX, float paramOffY, float paramOffZ) {
        ModelInstance modelInstance;
        RenderScene scene;
        ModelCache cache;
        block16: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            ModelCache modelCache = models.get(code);
            if (modelCache == null) {
                HologramModelManager $this$getRendererAndInstance_u24lambda_u240 = this;
                boolean bl = false;
                $this$getRendererAndInstance_u24lambda_u240.ensureLoaded(code);
                return null;
            }
            cache = modelCache;
            RenderScene renderScene = cache.getScene();
            if (renderScene == null) {
                HologramModelManager $this$getRendererAndInstance_u24lambda_u241 = this;
                boolean bl = false;
                $this$getRendererAndInstance_u24lambda_u241.ensureLoaded(code);
                return null;
            }
            scene = renderScene;
            if (scene.getPrimitiveComponents().isEmpty()) {
                return null;
            }
            if (cache.getAnimations().isEmpty()) {
                try {
                    Path dir = this.resolveFolderForCode(code);
                    if (!Files.isDirectory(dir, new LinkOption[0])) break block16;
                    List collected = new ArrayList();
                    AutoCloseable $this$getRendererAndInstance_u24lambda_u241 = Files.list(dir);
                    Throwable throwable = null;
                    try {
                        Stream s = (Stream)$this$getRendererAndInstance_u24lambda_u241;
                        boolean bl = false;
                        s.forEach(arg_0 -> HologramModelManager.getRendererAndInstance$lambda$2$1(arg_0 -> HologramModelManager.getRendererAndInstance$lambda$2$0(collected, scene, arg_0), arg_0));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable bl) {
                        throwable = bl;
                        throw bl;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)$this$getRendererAndInstance_u24lambda_u241, (Throwable)throwable);
                    }
                    if (!((Collection)collected).isEmpty()) {
                        cache.setAnimations(collected);
                        logger.info("Loaded external animations on demand for code=" + code + ": count=" + collected.size());
                    }
                }
                catch (Throwable dir) {
                    // empty catch block
                }
            }
        }
        Pair key = TuplesKt.to((Object)code, (Object)id);
        ModelInstance modelInstance2 = instances.get(key);
        if (modelInstance2 != null) {
            ModelInstance existing = modelInstance2;
            boolean bl = false;
            int lmSize = ((LocalMatricesBuffer)existing.getModelData().getLocalMatricesBuffer().getContent()).getPrimitiveNodesSize();
            if (lmSize == 0 && !((Collection)scene.getPrimitiveComponents()).isEmpty()) {
                existing.decreaseReferenceCount();
                ModelInstance rebuilt = new ModelInstance(scene);
                rebuilt.increaseReferenceCount();
                ((Map)instances).put(key, rebuilt);
                modelInstance = rebuilt;
            } else {
                modelInstance = existing;
            }
        } else {
            HologramModelManager $this$getRendererAndInstance_u24lambda_u244 = this;
            boolean bl = false;
            ModelInstance inst = new ModelInstance(scene);
            inst.increaseReferenceCount();
            ((Map)instances).put(key, inst);
            modelInstance = inst;
        }
        ModelInstance instance = modelInstance;
        int rootIndex = scene.getRootNode().getNodeIndex();
        instance.setTransformDecomposed(rootIndex, TransformId.ABSOLUTE, arg_0 -> HologramModelManager.getRendererAndInstance$lambda$5(scale, cache, paramScale, paramOffX, paramOffY, paramOffZ, arg_0));
        instance.updateRenderData();
        return TuplesKt.to(this.getRenderer(), (Object)instance);
    }

    public static /* synthetic */ Pair getRendererAndInstance$default(HologramModelManager hologramModelManager, int n, ClientActivationRegistry.Id id, double d, double d2, double d3, float f, float f2, float f3, float f4, float f5, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            f2 = 1.0f;
        }
        if ((n2 & 0x80) != 0) {
            f3 = 0.0f;
        }
        if ((n2 & 0x100) != 0) {
            f4 = 0.0f;
        }
        if ((n2 & 0x200) != 0) {
            f5 = 0.0f;
        }
        return hologramModelManager.getRendererAndInstance(n, id, d, d2, d3, f, f2, f3, f4, f5);
    }

    public final void applyAnimation(int code, @NotNull ClientActivationRegistry.Id id, int animCode, float dtSec) {
        int idx;
        ModelInstance instance;
        Pair key;
        List<AnimationItem> anims;
        block12: {
            RenderScene scene;
            block11: {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                ModelCache modelCache = models.get(code);
                if (modelCache == null) {
                    return;
                }
                ModelCache cache = modelCache;
                RenderScene renderScene = cache.getScene();
                if (renderScene == null) {
                    return;
                }
                scene = renderScene;
                anims = cache.getAnimations();
                if (anims.isEmpty()) {
                    return;
                }
                key = TuplesKt.to((Object)code, (Object)id);
                ModelInstance modelInstance = instances.get(key);
                if (modelInstance == null) {
                    return;
                }
                instance = modelInstance;
                idx = this.selectAnimationIndex(cache, animCode, anims.size());
                Integer prevIdx = animIndices.get(key);
                if (prevIdx == null) break block11;
                int n = idx;
                if (prevIdx == n) break block12;
            }
            ((Map)animIndices).put(key, idx);
            ((Map)animTimes).put(key, Float.valueOf(0.0f));
            this.resetInstancePose(scene, instance);
            instance.updateRenderData();
        }
        if (idx < 0) {
            return;
        }
        float duration = anims.get(idx).getDuration();
        if (duration <= 0.0f) {
            return;
        }
        Float f = animTimes.get(key);
        float t0 = f != null ? f.floatValue() : 0.0f;
        Float f2 = Float.valueOf(t0 + dtSec);
        float it = ((Number)f2).floatValue();
        boolean bl = false;
        float t = (Math.abs(it) <= Float.MAX_VALUE ? it : 0.0f) % duration;
        ((Map)animTimes).put(key, Float.valueOf(t));
        try {
            anims.get(idx).apply(instance, t);
            instance.updateRenderData();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final void resetInstancePose(RenderScene scene, ModelInstance instance) {
        for (RenderNode node : scene.getNodes()) {
            int index = node.getNodeIndex();
            instance.setTransformDecomposed(index, TransformId.RELATIVE_ANIMATION, HologramModelManager::resetInstancePose$lambda$0);
        }
        block3: for (Primitive comp : scene.getPrimitiveComponents()) {
            int groupCount;
            int n;
            RenderPrimitive prim = comp.getPrimitive();
            if (prim.getTargets() != null) {
                RenderPrimitive.Targets t;
                boolean bl = false;
                n = Math.min(t.getPosition().getTargetsCount(), Math.min(t.getColor().getTargetsCount(), t.getTexCoord().getTargetsCount()));
            } else {
                n = prim.getTargetGroups().size();
            }
            if ((groupCount = n) <= 0) continue;
            int primIndex = comp.getPrimitiveIndex();
            for (int gi = 0; gi < groupCount; ++gi) {
                try {
                    instance.setGroupWeight(primIndex, gi, 0.0f);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue block3;
                }
            }
        }
    }

    private final int selectAnimationIndex(ModelCache cache, int animCode, int count) {
        if (count <= 0) {
            return -1;
        }
        if (animCode > 0) {
            int idx = (animCode - 1) % count;
            return idx >= 0 ? idx : idx + count;
        }
        return -1;
    }

    private static final boolean pickModelFile$lambda$1$0(Path p) {
        boolean bl;
        block3: {
            String string = ((Object)p.getFileName()).toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String name = string;
            Iterable $this$any$iv = exts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String ext = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)name, (String)("." + ext), (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean pickModelFile$lambda$1$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit ensureLoaded$lambda$3(ModelCache $cache, int $code, ModelFileLoader.LoadResult $result, Path $dir, RenderScene scene) {
        $cache.setScene(scene);
        RenderScene renderScene = scene;
        if (renderScene != null) {
            List collected;
            List builtIn;
            RenderScene it;
            block14: {
                List list;
                Iterable iterable;
                Object $this$map$iv;
                it = renderScene;
                boolean bl = false;
                it.increaseReferenceCount();
                try {
                    List list2;
                    List list3 = $result.getAnimations();
                    if (list3 != null) {
                        void $this$mapTo$iv$iv;
                        $this$map$iv = list3;
                        boolean $i$f$map = false;
                        iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void a;
                            Animation animation = (Animation)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(AnimationLoader.INSTANCE.load(it, (Animation)a));
                        }
                        list2 = (List)destination$iv$iv;
                    } else {
                        list2 = CollectionsKt.emptyList();
                    }
                    list = list2;
                }
                catch (Throwable throwable) {
                    list = CollectionsKt.emptyList();
                }
                builtIn = list;
                try {
                    collected = new ArrayList();
                    if (!Files.isDirectory($dir, new LinkOption[0])) break block14;
                    $this$map$iv = Files.list($dir);
                    Throwable throwable = null;
                    try {
                        Stream s = (Stream)$this$map$iv;
                        boolean bl3 = false;
                        s.forEach(arg_0 -> HologramModelManager.ensureLoaded$lambda$3$0$1$1(arg_0 -> HologramModelManager.ensureLoaded$lambda$3$0$1$0(collected, it, arg_0), arg_0));
                        iterable = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)$this$map$iv, (Throwable)throwable);
                    }
                }
                catch (Throwable throwable) {
                    collected = CollectionsKt.emptyList();
                }
            }
            List external = collected;
            List all = CollectionsKt.plus((Collection)builtIn, (Iterable)external);
            $cache.setAnimations(all);
            logger.info("Loaded scene for code=" + $code + ": primitives=" + it.getPrimitiveComponents().size() + ", nodes=" + it.getNodes().size() + ", animations=" + all.size());
        } else {
            logger.warn("Model load returned null scene (code=" + $code + ")");
        }
        return Unit.INSTANCE;
    }

    private static final Unit ensureLoaded$lambda$3$0$1$0(List $collected, RenderScene $it, Path p) {
        String string = ((Object)p.getFileName()).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String name = string;
        if (StringsKt.endsWith$default((String)name, (String)".vmd", (boolean)false, (int)2, null)) {
            try {
                Intrinsics.checkNotNull((Object)p);
                ModelFileLoader.LoadResult lr = ModelFileLoaders.probeAndLoad$default((ModelFileLoaders)ModelFileLoaders.INSTANCE, (Path)p, null, (int)2, null);
                Object object = lr;
                if (object != null && (object = object.getAnimations()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Animation a = (Animation)element$iv;
                        boolean bl = false;
                        $collected.add(AnimationLoader.INSTANCE.load($it, a));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Unit.INSTANCE;
    }

    private static final void ensureLoaded$lambda$3$0$1$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void ensureLoaded$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit getRendererAndInstance$lambda$2$0(List $collected, RenderScene $scene, Path p) {
        String string = ((Object)p.getFileName()).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String name = string;
        if (StringsKt.endsWith$default((String)name, (String)".vmd", (boolean)false, (int)2, null)) {
            try {
                Intrinsics.checkNotNull((Object)p);
                ModelFileLoader.LoadResult lr = ModelFileLoaders.probeAndLoad$default((ModelFileLoaders)ModelFileLoaders.INSTANCE, (Path)p, null, (int)2, null);
                Object object = lr;
                if (object != null && (object = object.getAnimations()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Animation a = (Animation)element$iv;
                        boolean bl = false;
                        $collected.add(AnimationLoader.INSTANCE.load($scene, a));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Unit.INSTANCE;
    }

    private static final void getRendererAndInstance$lambda$2$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void getRendererAndInstance$lambda$5(float $scale, ModelCache $cache, float $paramScale, float $paramOffX, float $paramOffY, float $paramOffZ, NodeTransform.Decomposed decomposed) {
        Intrinsics.checkNotNullParameter((Object)decomposed, (String)"decomposed");
        decomposed.getScale().set($scale * $cache.getScaleMultiplier() * $paramScale);
        decomposed.getTranslation().set($cache.getOffsetX() + $paramOffX, $cache.getOffsetY() + $paramOffY, $cache.getOffsetZ() + $paramOffZ);
    }

    private static final void resetInstancePose$lambda$0(NodeTransform.Decomposed decomposed) {
        Intrinsics.checkNotNullParameter((Object)decomposed, (String)"decomposed");
        decomposed.getTranslation().set(0.0f, 0.0f, 0.0f);
        decomposed.getRotation().identity();
        decomposed.getScale().set(1.0f, 1.0f, 1.0f);
    }

    static {
        Object[] objectArray = new String[]{"vrm", "glb", "gltf", "pmx", "pmd"};
        exts = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0082\b\u0018\u00002\u00020\u0001B;\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013JF\u0010\u0014\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0018\u001a\u00020\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\rR\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\rR\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010\u000fR\u001f\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010!\u001a\u0004\b\"\u0010\u0011R\u0019\u0010\t\u001a\u0004\u0018\u00010\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010#\u001a\u0004\b$\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/sylsatra/hologram/client/HologramModelManager$Manifest;", "", "", "file", "", "scale", "", "offset", "", "defaultAnimation", "<init>", "(Ljava/lang/String;Ljava/lang/Float;Ljava/util/List;Ljava/lang/Integer;)V", "component1", "()Ljava/lang/String;", "component2", "()Ljava/lang/Float;", "component3", "()Ljava/util/List;", "component4", "()Ljava/lang/Integer;", "copy", "(Ljava/lang/String;Ljava/lang/Float;Ljava/util/List;Ljava/lang/Integer;)Lcom/sylsatra/hologram/client/HologramModelManager$Manifest;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "Ljava/lang/String;", "getFile", "Ljava/lang/Float;", "getScale", "Ljava/util/List;", "getOffset", "Ljava/lang/Integer;", "getDefaultAnimation", "hologram_client"})
    @Environment(value=EnvType.CLIENT)
    private static final class Manifest {
        @Nullable
        private final String file;
        @Nullable
        private final Float scale;
        @Nullable
        private final List<Float> offset;
        @Nullable
        private final Integer defaultAnimation;

        public Manifest(@Nullable String file, @Nullable Float scale, @Nullable List<Float> offset, @Nullable Integer defaultAnimation) {
            this.file = file;
            this.scale = scale;
            this.offset = offset;
            this.defaultAnimation = defaultAnimation;
        }

        public /* synthetic */ Manifest(String string, Float f, List list, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                f = null;
            }
            if ((n2 & 4) != 0) {
                list = null;
            }
            if ((n2 & 8) != 0) {
                n = null;
            }
            this(string, f, list, n);
        }

        @Nullable
        public final String getFile() {
            return this.file;
        }

        @Nullable
        public final Float getScale() {
            return this.scale;
        }

        @Nullable
        public final List<Float> getOffset() {
            return this.offset;
        }

        @Nullable
        public final Integer getDefaultAnimation() {
            return this.defaultAnimation;
        }

        @Nullable
        public final String component1() {
            return this.file;
        }

        @Nullable
        public final Float component2() {
            return this.scale;
        }

        @Nullable
        public final List<Float> component3() {
            return this.offset;
        }

        @Nullable
        public final Integer component4() {
            return this.defaultAnimation;
        }

        @NotNull
        public final Manifest copy(@Nullable String file, @Nullable Float scale, @Nullable List<Float> offset, @Nullable Integer defaultAnimation) {
            return new Manifest(file, scale, offset, defaultAnimation);
        }

        public static /* synthetic */ Manifest copy$default(Manifest manifest, String string, Float f, List list, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = manifest.file;
            }
            if ((n2 & 2) != 0) {
                f = manifest.scale;
            }
            if ((n2 & 4) != 0) {
                list = manifest.offset;
            }
            if ((n2 & 8) != 0) {
                n = manifest.defaultAnimation;
            }
            return manifest.copy(string, f, list, n);
        }

        @NotNull
        public String toString() {
            return "Manifest(file=" + this.file + ", scale=" + this.scale + ", offset=" + this.offset + ", defaultAnimation=" + this.defaultAnimation + ")";
        }

        public int hashCode() {
            int result = this.file == null ? 0 : this.file.hashCode();
            result = result * 31 + (this.scale == null ? 0 : ((Object)this.scale).hashCode());
            result = result * 31 + (this.offset == null ? 0 : ((Object)this.offset).hashCode());
            result = result * 31 + (this.defaultAnimation == null ? 0 : ((Object)this.defaultAnimation).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Manifest)) {
                return false;
            }
            Manifest manifest = (Manifest)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)manifest.file)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.scale, (Object)manifest.scale)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.offset, manifest.offset)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.defaultAnimation, (Object)manifest.defaultAnimation);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0014\b\u0082\b\u0018\u00002\u00020\u0001Bg\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u0012\b\b\u0002\u0010\r\u001a\u00020\t\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u0019J\u0010\u0010\u001c\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u0019J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eJr\u0010\u001f\u001a\u00020\u00002\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\t2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u00c6\u0001\u00a2\u0006\u0004\b\u001f\u0010 J\u001a\u0010#\u001a\u00020\"2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b#\u0010$J\u0010\u0010%\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010(\u001a\u00020'H\u00d6\u0001\u00a2\u0006\u0004\b(\u0010)R\u001f\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010*\u001a\u0004\b+\u0010\u0013R$\u0010\u0005\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010,\u001a\u0004\b-\u0010\u0015\"\u0004\b.\u0010/R(\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u00100\u001a\u0004\b1\u0010\u0017\"\u0004\b2\u00103R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u00104\u001a\u0004\b5\u0010\u0019R\u0017\u0010\u000b\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u00104\u001a\u0004\b6\u0010\u0019R\u0017\u0010\f\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\f\u00104\u001a\u0004\b7\u0010\u0019R\u0017\u0010\r\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\r\u00104\u001a\u0004\b8\u0010\u0019R\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u00109\u001a\u0004\b:\u0010\u001e\u00a8\u0006;"}, d2={"Lcom/sylsatra/hologram/client/HologramModelManager$ModelCache;", "", "Ljava/util/concurrent/CompletableFuture;", "Ltop/fifthlight/blazerod/model/RenderScene;", "future", "scene", "", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "animations", "", "scaleMultiplier", "offsetX", "offsetY", "offsetZ", "", "defaultAnimation", "<init>", "(Ljava/util/concurrent/CompletableFuture;Ltop/fifthlight/blazerod/model/RenderScene;Ljava/util/List;FFFFLjava/lang/Integer;)V", "component1", "()Ljava/util/concurrent/CompletableFuture;", "component2", "()Ltop/fifthlight/blazerod/model/RenderScene;", "component3", "()Ljava/util/List;", "component4", "()F", "component5", "component6", "component7", "component8", "()Ljava/lang/Integer;", "copy", "(Ljava/util/concurrent/CompletableFuture;Ltop/fifthlight/blazerod/model/RenderScene;Ljava/util/List;FFFFLjava/lang/Integer;)Lcom/sylsatra/hologram/client/HologramModelManager$ModelCache;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/concurrent/CompletableFuture;", "getFuture", "Ltop/fifthlight/blazerod/model/RenderScene;", "getScene", "setScene", "(Ltop/fifthlight/blazerod/model/RenderScene;)V", "Ljava/util/List;", "getAnimations", "setAnimations", "(Ljava/util/List;)V", "F", "getScaleMultiplier", "getOffsetX", "getOffsetY", "getOffsetZ", "Ljava/lang/Integer;", "getDefaultAnimation", "hologram_client"})
    @Environment(value=EnvType.CLIENT)
    private static final class ModelCache {
        @NotNull
        private final CompletableFuture<RenderScene> future;
        @Nullable
        private volatile RenderScene scene;
        @NotNull
        private volatile List<AnimationItem> animations;
        private final float scaleMultiplier;
        private final float offsetX;
        private final float offsetY;
        private final float offsetZ;
        @Nullable
        private final Integer defaultAnimation;

        public ModelCache(@NotNull CompletableFuture<RenderScene> future, @Nullable RenderScene scene, @NotNull List<AnimationItem> animations, float scaleMultiplier, float offsetX, float offsetY, float offsetZ, @Nullable Integer defaultAnimation) {
            Intrinsics.checkNotNullParameter(future, (String)"future");
            Intrinsics.checkNotNullParameter(animations, (String)"animations");
            this.future = future;
            this.scene = scene;
            this.animations = animations;
            this.scaleMultiplier = scaleMultiplier;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.defaultAnimation = defaultAnimation;
        }

        public /* synthetic */ ModelCache(CompletableFuture completableFuture, RenderScene renderScene, List list, float f, float f2, float f3, float f4, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                renderScene = null;
            }
            if ((n2 & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n2 & 8) != 0) {
                f = 1.0f;
            }
            if ((n2 & 0x10) != 0) {
                f2 = 0.0f;
            }
            if ((n2 & 0x20) != 0) {
                f3 = 0.0f;
            }
            if ((n2 & 0x40) != 0) {
                f4 = 0.0f;
            }
            if ((n2 & 0x80) != 0) {
                n = null;
            }
            this(completableFuture, renderScene, list, f, f2, f3, f4, n);
        }

        @NotNull
        public final CompletableFuture<RenderScene> getFuture() {
            return this.future;
        }

        @Nullable
        public final RenderScene getScene() {
            return this.scene;
        }

        public final void setScene(@Nullable RenderScene renderScene) {
            this.scene = renderScene;
        }

        @NotNull
        public final List<AnimationItem> getAnimations() {
            return this.animations;
        }

        public final void setAnimations(@NotNull List<AnimationItem> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.animations = list;
        }

        public final float getScaleMultiplier() {
            return this.scaleMultiplier;
        }

        public final float getOffsetX() {
            return this.offsetX;
        }

        public final float getOffsetY() {
            return this.offsetY;
        }

        public final float getOffsetZ() {
            return this.offsetZ;
        }

        @Nullable
        public final Integer getDefaultAnimation() {
            return this.defaultAnimation;
        }

        @NotNull
        public final CompletableFuture<RenderScene> component1() {
            return this.future;
        }

        @Nullable
        public final RenderScene component2() {
            return this.scene;
        }

        @NotNull
        public final List<AnimationItem> component3() {
            return this.animations;
        }

        public final float component4() {
            return this.scaleMultiplier;
        }

        public final float component5() {
            return this.offsetX;
        }

        public final float component6() {
            return this.offsetY;
        }

        public final float component7() {
            return this.offsetZ;
        }

        @Nullable
        public final Integer component8() {
            return this.defaultAnimation;
        }

        @NotNull
        public final ModelCache copy(@NotNull CompletableFuture<RenderScene> future, @Nullable RenderScene scene, @NotNull List<AnimationItem> animations, float scaleMultiplier, float offsetX, float offsetY, float offsetZ, @Nullable Integer defaultAnimation) {
            Intrinsics.checkNotNullParameter(future, (String)"future");
            Intrinsics.checkNotNullParameter(animations, (String)"animations");
            return new ModelCache(future, scene, animations, scaleMultiplier, offsetX, offsetY, offsetZ, defaultAnimation);
        }

        public static /* synthetic */ ModelCache copy$default(ModelCache modelCache, CompletableFuture completableFuture, RenderScene renderScene, List list, float f, float f2, float f3, float f4, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                completableFuture = modelCache.future;
            }
            if ((n2 & 2) != 0) {
                renderScene = modelCache.scene;
            }
            if ((n2 & 4) != 0) {
                list = modelCache.animations;
            }
            if ((n2 & 8) != 0) {
                f = modelCache.scaleMultiplier;
            }
            if ((n2 & 0x10) != 0) {
                f2 = modelCache.offsetX;
            }
            if ((n2 & 0x20) != 0) {
                f3 = modelCache.offsetY;
            }
            if ((n2 & 0x40) != 0) {
                f4 = modelCache.offsetZ;
            }
            if ((n2 & 0x80) != 0) {
                n = modelCache.defaultAnimation;
            }
            return modelCache.copy(completableFuture, renderScene, list, f, f2, f3, f4, n);
        }

        @NotNull
        public String toString() {
            return "ModelCache(future=" + this.future + ", scene=" + this.scene + ", animations=" + this.animations + ", scaleMultiplier=" + this.scaleMultiplier + ", offsetX=" + this.offsetX + ", offsetY=" + this.offsetY + ", offsetZ=" + this.offsetZ + ", defaultAnimation=" + this.defaultAnimation + ")";
        }

        public int hashCode() {
            int result = this.future.hashCode();
            result = result * 31 + (this.scene == null ? 0 : this.scene.hashCode());
            result = result * 31 + ((Object)this.animations).hashCode();
            result = result * 31 + Float.hashCode(this.scaleMultiplier);
            result = result * 31 + Float.hashCode(this.offsetX);
            result = result * 31 + Float.hashCode(this.offsetY);
            result = result * 31 + Float.hashCode(this.offsetZ);
            result = result * 31 + (this.defaultAnimation == null ? 0 : ((Object)this.defaultAnimation).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModelCache)) {
                return false;
            }
            ModelCache modelCache = (ModelCache)other;
            if (!Intrinsics.areEqual(this.future, modelCache.future)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.scene, (Object)modelCache.scene)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.animations, modelCache.animations)) {
                return false;
            }
            if (Float.compare(this.scaleMultiplier, modelCache.scaleMultiplier) != 0) {
                return false;
            }
            if (Float.compare(this.offsetX, modelCache.offsetX) != 0) {
                return false;
            }
            if (Float.compare(this.offsetY, modelCache.offsetY) != 0) {
                return false;
            }
            if (Float.compare(this.offsetZ, modelCache.offsetZ) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.defaultAnimation, (Object)modelCache.defaultAnimation);
        }
    }
}

