/*
 * Decompiled with CFR 0.152.
 */
package com.sylsatra.hologram.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.sylsatra.hologram.client.ClientActivationRegistry;
import com.sylsatra.hologram.client.HologramModelManager;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_761;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fifthlight.blazerod.model.ModelInstance;
import top.fifthlight.blazerod.model.RenderScene;
import top.fifthlight.blazerod.model.RenderTask;
import top.fifthlight.blazerod.model.data.LocalMatricesBuffer;
import top.fifthlight.blazerod.model.renderer.CpuTransformRenderer;
import top.fifthlight.blazerod.model.renderer.Renderer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003R\u001c\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u001b\u0010\u000f\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR&\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R&\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/sylsatra/hologram/client/HologramWorldRenderer;", "", "<init>", "()V", "", "register", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Ltop/fifthlight/blazerod/model/renderer/CpuTransformRenderer;", "cpuRenderer$delegate", "Lkotlin/Lazy;", "getCpuRenderer", "()Ltop/fifthlight/blazerod/model/renderer/CpuTransformRenderer;", "cpuRenderer", "", "Lkotlin/Pair;", "", "Lcom/sylsatra/hologram/client/ClientActivationRegistry$Id;", "gpuFallback", "Ljava/util/Set;", "fallbackWarned", "", "lastFrameNs", "J", "hologram_client"})
@Environment(value=EnvType.CLIENT)
public final class HologramWorldRenderer {
    @NotNull
    public static final HologramWorldRenderer INSTANCE = new HologramWorldRenderer();
    private static final Logger logger = LoggerFactory.getLogger((String)"hologram");
    @NotNull
    private static final Lazy cpuRenderer$delegate = LazyKt.lazy(HologramWorldRenderer::cpuRenderer_delegate$lambda$0);
    @NotNull
    private static final Set<Pair<Integer, ClientActivationRegistry.Id>> gpuFallback;
    @NotNull
    private static final Set<Pair<Integer, ClientActivationRegistry.Id>> fallbackWarned;
    private static long lastFrameNs;

    private HologramWorldRenderer() {
    }

    private final CpuTransformRenderer getCpuRenderer() {
        Lazy lazy = cpuRenderer$delegate;
        return (CpuTransformRenderer)lazy.getValue();
    }

    public final void register() {
        WorldRenderEvents.AFTER_ENTITIES.register(HologramWorldRenderer::register$lambda$0);
    }

    private static final CpuTransformRenderer cpuRenderer_delegate$lambda$0() {
        return CpuTransformRenderer.Type.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void register$lambda$0(WorldRenderContext context) {
        GpuTextureView gpuTextureView;
        class_310 client = class_310.method_1551();
        class_638 class_6382 = client.field_1687;
        if (class_6382 == null) {
            return;
        }
        class_638 world = class_6382;
        class_2960 dimId = world.method_27983().method_29177();
        long now = System.nanoTime();
        float dtSec = (float)RangesKt.coerceAtLeast((long)(now - lastFrameNs), (long)0L) / 1.0E9f;
        lastFrameNs = now;
        Map<ClientActivationRegistry.Id, ClientActivationRegistry.Codes> entries = ClientActivationRegistry.INSTANCE.getAll();
        if (entries.isEmpty()) {
            return;
        }
        class_4587 class_45872 = context.matrixStack();
        if (class_45872 == null) {
            return;
        }
        class_4587 matrices = class_45872;
        class_276 frameBuffer = client.method_1522();
        GpuTextureView gpuTextureView2 = RenderSystem.outputColorTextureOverride;
        if (gpuTextureView2 == null && (gpuTextureView2 = frameBuffer.method_71639()) == null) {
            return;
        }
        GpuTextureView colorView = gpuTextureView2;
        if (frameBuffer.field_1478) {
            gpuTextureView = RenderSystem.outputDepthTextureOverride;
            if (gpuTextureView == null) {
                gpuTextureView = frameBuffer.method_71640();
            }
        } else {
            gpuTextureView = null;
        }
        GpuTextureView depthViewBase = gpuTextureView;
        for (Map.Entry<ClientActivationRegistry.Id, ClientActivationRegistry.Codes> entry : entries.entrySet()) {
            boolean noCull;
            Pair<Renderer<?, ?>, ModelInstance> pair;
            float pOffZ;
            float pOffY;
            float pOffX;
            ClientActivationRegistry.Id id = entry.getKey();
            ClientActivationRegistry.Codes codes = entry.getValue();
            if (!Intrinsics.areEqual((Object)id.getDim(), (Object)dimId)) continue;
            class_2338 minPos = id.getMin();
            class_2338 maxPos = id.getMax();
            int sizeX = maxPos.method_10263() - minPos.method_10263() + 1;
            int sizeY = maxPos.method_10264() - minPos.method_10264() + 1;
            int sizeZ = maxPos.method_10260() - minPos.method_10260() + 1;
            if (codes.getModel() <= 0) continue;
            int nnnCode = RangesKt.coerceIn((int)codes.getModel(), (int)0, (int)255);
            double centerX = (double)(minPos.method_10263() + maxPos.method_10263() + 1) / 2.0;
            double centerY = (double)(minPos.method_10264() + maxPos.method_10264() + 1) / 2.0;
            double centerZ = (double)(minPos.method_10260() + maxPos.method_10260() + 1) / 2.0;
            int fit = Math.min(Math.min(sizeX, sizeY), sizeZ);
            float scale = RangesKt.coerceAtLeast((float)((float)fit * 0.9f), (float)0.1f);
            boolean anyParam = codes.getScaleQ() != 0 || codes.getOffXQ() != 0 || codes.getOffYQ() != 0 || codes.getOffZQ() != 0;
            float pScale = codes.getScaleQ() > 0 ? 0.25f + (float)RangesKt.coerceIn((int)codes.getScaleQ(), (int)1, (int)15) / 15.0f * 1.75f : 1.0f;
            if (HologramModelManager.INSTANCE.getRendererAndInstance(nnnCode, id, centerX, centerY, centerZ, scale, pScale, pOffX = HologramWorldRenderer.register$lambda$0$offFromQ(codes.getOffXQ()), pOffY = HologramWorldRenderer.register$lambda$0$offFromQ(codes.getOffYQ()), pOffZ = HologramWorldRenderer.register$lambda$0$offFromQ(codes.getOffZQ())) == null) continue;
            Renderer renderer = (Renderer)pair.component1();
            ModelInstance instance = (ModelInstance)pair.component2();
            RenderScene scene = instance.getScene();
            if (scene.getPrimitiveComponents().isEmpty()) continue;
            class_243 camPos = context.camera().method_19326();
            matrices.method_22903();
            matrices.method_22904(centerX - camPos.field_1352, centerY - camPos.field_1351, centerZ - camPos.field_1350);
            logger.debug("Render hologram code=" + nnnCode + " at center=(" + centerX + "," + centerY + "," + centerZ + ") scale=" + scale + " params=" + (String)(anyParam ? "(" + pScale + ", " + pOffX + ", " + pOffY + ", " + pOffZ + ")" : "(manifest)") + " primitives=" + scene.getPrimitiveComponents().size());
            HologramModelManager.INSTANCE.applyAnimation(nnnCode, id, codes.getAnim(), dtSec);
            boolean ctrl3 = (codes.getCtrl() & 3) == 3;
            int light = ctrl3 ? class_761.method_23794((class_1920)((class_1920)world), (class_2338)class_2338.method_49637((double)centerX, (double)centerY, (double)centerZ)) : 0xF000F0;
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"getPositionMatrix(...)");
            RenderTask task = ModelInstance.createRenderTask$default((ModelInstance)instance, (Matrix4fc)((Matrix4fc)matrix4f), (int)light, (int)0, (int)4, null);
            boolean ignoreDepth = (codes.getCtrl() & 1) == 1 && !ctrl3;
            GpuTextureView depthView = ignoreDepth ? null : depthViewBase;
            int lmSize = ((LocalMatricesBuffer)task.getLocalMatricesBuffer().getContent()).getPrimitiveNodesSize();
            if (lmSize <= 0) {
                logger.warn("Skipping scene render (code=" + nnnCode + ", dim=" + dimId + ", id=" + id + "): localMatrices primitiveNodesSize == 0");
                matrices.method_22909();
                continue;
            }
            boolean bl = noCull = (codes.getCtrl() & 4) != 0;
            if (noCull) {
                GL11C.glDisable((int)2884);
            }
            try {
                renderer.render(colorView, depthView, task, scene);
            }
            finally {
                if (noCull) {
                    GL11C.glEnable((int)2884);
                }
                try {
                    task.release();
                }
                catch (Throwable throwable) {}
                matrices.method_22909();
            }
        }
        HologramModelManager.INSTANCE.rotateRenderer();
    }

    private static final float register$lambda$0$offFromQ(int q) {
        return q > 0 ? (float)(RangesKt.coerceIn((int)q, (int)1, (int)15) - 8) / 8.0f : 0.0f;
    }

    static {
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        gpuFallback = set;
        fallbackWarned = new LinkedHashSet();
        lastFrameNs = System.nanoTime();
    }
}

