/*
 * Decompiled with CFR 0.152.
 */
package com.sylsatra.hologram.state;

import com.sylsatra.hologram.net.BusUpdatePayload;
import com.sylsatra.hologram.structure.GlassCuboid;
import com.sylsatra.hologram.structure.ProjectorIndex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003MNOB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u001f\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ1\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J)\u0010%\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b%\u0010&J1\u0010)\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b)\u0010*J1\u0010+\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b+\u0010*J\u001f\u0010,\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010/\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b/\u00100J\u001d\u00101\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b1\u0010-J1\u00102\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b2\u0010 J3\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e072\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b8\u00109J\u001d\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000f0:2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b;\u0010<J\u001f\u0010=\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\u0004\b=\u0010\u0013J1\u0010>\u001a\u0016\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\u0004\b>\u0010?J5\u0010C\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020\u001e\u00a2\u0006\u0004\bC\u0010DR\u001c\u0010G\u001a\n F*\u0004\u0018\u00010E0E8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bG\u0010HR \u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020J0I8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bK\u0010L\u00a8\u0006P"}, d2={"Lcom/sylsatra/hologram/state/HoloActivationRegistry;", "", "<init>", "()V", "Lnet/minecraft/class_3218;", "world", "", "worldKey", "(Lnet/minecraft/class_3218;)Ljava/lang/String;", "Lcom/sylsatra/hologram/structure/GlassCuboid;", "cuboid", "keyOf", "(Lcom/sylsatra/hologram/structure/GlassCuboid;)Ljava/lang/String;", "", "init", "Lnet/minecraft/class_2338;", "seed", "Lcom/sylsatra/hologram/state/HoloActivationRegistry$WatchedEntry;", "watch", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)Lcom/sylsatra/hologram/state/HoloActivationRegistry$WatchedEntry;", "pos", "", "unwatch", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)Z", "tickWorld", "(Lnet/minecraft/class_3218;)V", "Lcom/sylsatra/hologram/state/HoloActivationRegistry$QuadrupleInt;", "computeParams", "(Lnet/minecraft/class_3218;Lcom/sylsatra/hologram/structure/GlassCuboid;)Lcom/sylsatra/hologram/state/HoloActivationRegistry$QuadrupleInt;", "Lkotlin/Triple;", "", "computeCodesFaceBus", "(Lnet/minecraft/class_3218;Lcom/sylsatra/hologram/structure/GlassCuboid;)Lkotlin/Triple;", "Lnet/minecraft/class_3222;", "player", "", "distance", "findTargetTintedGlass", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_3222;D)Lnet/minecraft/class_2338;", "radiusXZ", "radiusY", "findPoweredTintedGlassNear", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_3222;II)Lnet/minecraft/class_2338;", "findAnyTintedGlassNear", "samplePower", "(Lnet/minecraft/class_3218;Lcom/sylsatra/hologram/structure/GlassCuboid;)I", "size", "strideFor", "(I)I", "currentPower", "computeCodes", "", "strengths", "start", "maxBits", "Lkotlin/Pair;", "readBus", "([III)Lkotlin/Pair;", "", "enumerateEdgePorts", "(Lcom/sylsatra/hologram/structure/GlassCuboid;)Ljava/util/List;", "getWatchedEntry", "getCodes", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)Lkotlin/Triple;", "model", "anim", "ctrl", "setCodes", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;III)Z", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "", "Lcom/sylsatra/hologram/state/HoloActivationRegistry$WorldState;", "worlds", "Ljava/util/Map;", "WatchedEntry", "WorldState", "QuadrupleInt", "hologram"})
@SourceDebugExtension(value={"SMAP\nHoloActivationRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoloActivationRegistry.kt\ncom/sylsatra/hologram/state/HoloActivationRegistry\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,525:1\n382#2,7:526\n382#2,7:533\n1#3:540\n774#4:541\n865#4,2:542\n295#4,2:544\n295#4,2:546\n*S KotlinDebug\n*F\n+ 1 HoloActivationRegistry.kt\ncom/sylsatra/hologram/state/HoloActivationRegistry\n*L\n57#1:526,7\n60#1:533,7\n482#1:541\n482#1:542,2\n489#1:544,2\n500#1:546,2\n*E\n"})
public final class HoloActivationRegistry {
    @NotNull
    public static final HoloActivationRegistry INSTANCE = new HoloActivationRegistry();
    private static final Logger logger = LoggerFactory.getLogger((String)"hologram");
    @NotNull
    private static final Map<String, WorldState> worlds = new LinkedHashMap();

    private HoloActivationRegistry() {
    }

    private final String worldKey(class_3218 world) {
        String string = world.method_27983().method_29177().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String keyOf(GlassCuboid cuboid) {
        return cuboid.getMin().method_10263() + "," + cuboid.getMin().method_10264() + "," + cuboid.getMin().method_10260() + "|" + cuboid.getMax().method_10263() + "," + cuboid.getMax().method_10264() + "," + cuboid.getMax().method_10260();
    }

    public final void init() {
        ServerTickEvents.END_WORLD_TICK.register(HoloActivationRegistry::init$lambda$0);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final WatchedEntry watch(@NotNull class_3218 world, @NotNull class_2338 seed) {
        Object object;
        void $this$getOrPut$iv;
        Object object2;
        void $this$getOrPut$iv2;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        GlassCuboid glassCuboid = ProjectorIndex.INSTANCE.getOrDetect(world, seed);
        if (glassCuboid == null) {
            return null;
        }
        GlassCuboid cuboid = glassCuboid;
        String wk = this.worldKey(world);
        Map<String, WorldState> map = worlds;
        String key$iv = wk;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv2.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            WorldState answer$iv = new WorldState(null, 0L, 3, null);
            $this$getOrPut$iv2.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        WorldState ws = (WorldState)object2;
        String key = this.keyOf(cuboid);
        boolean existed = ws.getWatched().containsKey(key);
        value$iv = ws.getWatched();
        String key$iv2 = key;
        boolean $i$f$getOrPut2 = false;
        Object value$iv2 = $this$getOrPut$iv.get(key$iv2);
        if (value$iv2 == null) {
            boolean bl = false;
            WatchedEntry answer$iv = new WatchedEntry(cuboid, 0, 0, 0, 0, 0, 0, 0, 0, 510, null);
            $this$getOrPut$iv.put(key$iv2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv2;
        }
        WatchedEntry entry = (WatchedEntry)object;
        if (existed) {
            return entry;
        }
        entry.setPower(this.samplePower(world, cuboid));
        Triple<Integer, Integer, Integer> triple = this.computeCodes(world, cuboid);
        int m = ((Number)triple.component1()).intValue();
        int a = ((Number)triple.component2()).intValue();
        int c = ((Number)triple.component3()).intValue();
        if (m == 0 && a == 0 && c == 0 && entry.getPower() > 0) {
            m = 3;
            a = 0;
            c = 2;
        }
        entry.setModelCode(m);
        entry.setAnimCode(a);
        entry.setCtrlCode(c);
        QuadrupleInt quadrupleInt = this.computeParams(world, cuboid);
        int sQ = quadrupleInt.component1();
        int xQ = quadrupleInt.component2();
        int yQ = quadrupleInt.component3();
        int zQ = quadrupleInt.component4();
        entry.setScaleQ(sQ);
        entry.setOffXQ(xQ);
        entry.setOffYQ(yQ);
        entry.setOffZQ(zQ);
        long l = ws.getTickCounter();
        ws.setTickCounter(l + 1L);
        class_2960 class_29602 = world.method_27983().method_29177();
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"getValue(...)");
        BusUpdatePayload payload = new BusUpdatePayload(class_29602, entry.getCuboid().getMin(), entry.getCuboid().getMax(), m, a, c, sQ, xQ, yQ, zQ, ws.getTickCounter());
        for (class_3222 player : world.method_18456()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
        logger.debug("Auto-watch: min=" + entry.getCuboid().getMin() + " max=" + entry.getCuboid().getMax() + " size=" + entry.getCuboid().getSizeX() + "x" + entry.getCuboid().getSizeY() + "x" + entry.getCuboid().getSizeZ() + " initialCodes=m:" + m + " a:" + a + " c:" + c + " params=" + sQ + "," + xQ + "," + yQ + "," + zQ);
        return entry;
    }

    public final boolean unwatch(@NotNull class_3218 world, @NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        String wk = this.worldKey(world);
        WorldState worldState = worlds.get(wk);
        if (worldState == null) {
            return false;
        }
        WorldState ws = worldState;
        Iterator<Map.Entry<String, WatchedEntry>> iter = ws.getWatched().entrySet().iterator();
        boolean removed = false;
        while (iter.hasNext()) {
            Map.Entry<String, WatchedEntry> e = iter.next();
            if (!e.getValue().getCuboid().contains(pos)) continue;
            iter.remove();
            removed = true;
        }
        return removed;
    }

    public final void tickWorld(@NotNull class_3218 world) {
        WatchedEntry entry;
        class_2338 seed;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        String wk = this.worldKey(world);
        WorldState worldState = worlds.get(wk);
        if (worldState == null) {
            return;
        }
        WorldState ws = worldState;
        long l = ws.getTickCounter();
        ws.setTickCounter(l + 1L);
        if (ws.getTickCounter() % 10L == 0L) {
            for (class_3222 player : world.method_18456()) {
                Intrinsics.checkNotNull((Object)player);
                seed = this.findTargetTintedGlass(world, player, 20.0);
                if (seed == null || this.getWatchedEntry(world, seed) != null) continue;
                this.watch(world, seed);
            }
        }
        if (ws.getTickCounter() % 20L == 5L) {
            for (class_3222 player : world.method_18456()) {
                Intrinsics.checkNotNull((Object)player);
                seed = this.findPoweredTintedGlassNear(world, player, 8, 4);
                if (seed == null || this.getWatchedEntry(world, seed) != null) continue;
                this.watch(world, seed);
            }
        }
        if (ws.getTickCounter() % 40L == 15L) {
            for (class_3222 player : world.method_18456()) {
                Intrinsics.checkNotNull((Object)player);
                seed = this.findAnyTintedGlassNear(world, player, 8, 4);
                if (seed == null || this.getWatchedEntry(world, seed) != null) continue;
                this.watch(world, seed);
            }
        }
        if (ws.getTickCounter() % 20L == 10L) {
            Iterator<Map.Entry<String, WatchedEntry>> iterator = ws.getWatched().entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next().getValue();
                class_2338 seed2 = entry.getCuboid().getMin();
                ProjectorIndex.INSTANCE.invalidateAt(world, seed2);
                GlassCuboid fresh = ProjectorIndex.INSTANCE.getOrDetect(world, seed2);
                if (fresh == null || Intrinsics.areEqual((Object)fresh.getMin(), (Object)entry.getCuboid().getMin()) && Intrinsics.areEqual((Object)fresh.getMax(), (Object)entry.getCuboid().getMax())) continue;
                entry.setCuboid(fresh);
                entry.setModelCode(-1);
            }
        }
        Iterator<Map.Entry<String, WatchedEntry>> iterator = ws.getWatched().entrySet().iterator();
        while (iterator.hasNext()) {
            Triple<Integer, Integer, Integer> fallback;
            entry = iterator.next().getValue();
            entry.setPower(this.samplePower(world, entry.getCuboid()));
            Triple<Integer, Integer, Integer> triple = this.computeCodes(world, entry.getCuboid());
            int m = ((Number)triple.component1()).intValue();
            int a = ((Number)triple.component2()).intValue();
            int c = ((Number)triple.component3()).intValue();
            if (m == 0 && a == 0 && c == 0 && entry.getPower() > 0 && (((Number)(fallback = this.computeCodesFaceBus(world, entry.getCuboid())).getFirst()).intValue() != 0 || ((Number)fallback.getSecond()).intValue() != 0 || ((Number)fallback.getThird()).intValue() != 0)) {
                m = ((Number)fallback.getFirst()).intValue();
                a = ((Number)fallback.getSecond()).intValue();
                c = ((Number)fallback.getThird()).intValue();
            }
            QuadrupleInt quadrupleInt = this.computeParams(world, entry.getCuboid());
            int sQ = quadrupleInt.component1();
            int xQ = quadrupleInt.component2();
            int yQ = quadrupleInt.component3();
            int zQ = quadrupleInt.component4();
            if (m == entry.getModelCode() && a == entry.getAnimCode() && c == entry.getCtrlCode() && sQ == entry.getScaleQ() && xQ == entry.getOffXQ() && yQ == entry.getOffYQ() && zQ == entry.getOffZQ()) continue;
            entry.setModelCode(m);
            entry.setAnimCode(a);
            entry.setCtrlCode(c);
            entry.setScaleQ(sQ);
            entry.setOffXQ(xQ);
            entry.setOffYQ(yQ);
            entry.setOffZQ(zQ);
            class_2960 class_29602 = world.method_27983().method_29177();
            Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"getValue(...)");
            BusUpdatePayload payload = new BusUpdatePayload(class_29602, entry.getCuboid().getMin(), entry.getCuboid().getMax(), m, a, c, sQ, xQ, yQ, zQ, ws.getTickCounter());
            for (class_3222 player : world.method_18456()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
            }
        }
    }

    private final QuadrupleInt computeParams(class_3218 world, GlassCuboid cuboid) {
        class_2338 min = cuboid.getMin();
        class_2338 max = cuboid.getMax();
        int midY = (min.method_10264() + max.method_10264()) / 2;
        int cx = (min.method_10263() + max.method_10263()) / 2;
        int cz = (min.method_10260() + max.method_10260()) / 2;
        int scaleQ = HoloActivationRegistry.computeParams$q(world, new class_2338(cx, midY, min.method_10260()));
        int offXQ = HoloActivationRegistry.computeParams$q(world, new class_2338(max.method_10263(), midY, cz));
        int offYQ = HoloActivationRegistry.computeParams$q(world, new class_2338(cx, midY, max.method_10260()));
        int offZQ = HoloActivationRegistry.computeParams$q(world, new class_2338(min.method_10263(), midY, cz));
        return new QuadrupleInt(scaleQ, offXQ, offYQ, offZQ);
    }

    private final Triple<Integer, Integer, Integer> computeCodesFaceBus(class_3218 world, GlassCuboid cuboid) {
        int n;
        int n2;
        int[] nArray;
        class_2338 min = cuboid.getMin();
        class_2338 max = cuboid.getMax();
        int midY = (min.method_10264() + max.method_10264()) / 2;
        int cx = (min.method_10263() + max.method_10263()) / 2;
        int cz = (min.method_10260() + max.method_10260()) / 2;
        int[] nArray2 = new int[]{HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(min.method_10263(), min.method_10264(), min.method_10260())), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(cx, min.method_10264(), min.method_10260())), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(max.method_10263(), min.method_10264(), min.method_10260())), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(min.method_10263(), min.method_10264(), cz)), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(max.method_10263(), min.method_10264(), cz)), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(min.method_10263(), min.method_10264(), max.method_10260())), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(cx, min.method_10264(), max.method_10260())), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(max.method_10263(), min.method_10264(), max.method_10260()))};
        int[] modelBits = nArray2;
        int model = 0;
        for (int i = 0; i < 8; ++i) {
            int n3;
            int n4 = model;
            nArray = modelBits;
            boolean bl = 0 <= i ? i < nArray.length : false;
            if (bl) {
                n3 = nArray[i];
            } else {
                int n5 = i;
                n2 = n4;
                boolean bl2 = false;
                n = 0;
                n4 = n2;
                n3 = n;
            }
            model = n4 | n3 << i;
        }
        nArray = new int[]{HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(min.method_10263(), max.method_10264(), min.method_10260())), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(cx, max.method_10264(), min.method_10260())), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(max.method_10263(), max.method_10264(), min.method_10260())), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(min.method_10263(), max.method_10264(), cz)), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(max.method_10263(), max.method_10264(), cz)), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(min.method_10263(), max.method_10264(), max.method_10260())), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(cx, max.method_10264(), max.method_10260())), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(max.method_10263(), max.method_10264(), max.method_10260()))};
        int[] animBits = nArray;
        int anim = 0;
        for (int i = 0; i < 8; ++i) {
            int n6;
            int n7 = anim;
            int[] bl2 = animBits;
            boolean bl = 0 <= i ? i < bl2.length : false;
            if (bl) {
                n6 = bl2[i];
            } else {
                int n8 = i;
                n2 = n7;
                boolean bl3 = false;
                n = 0;
                n7 = n2;
                n6 = n;
            }
            anim = n7 | n6 << i;
        }
        int[] bl2 = new int[]{HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(min.method_10263(), midY, min.method_10260())), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(max.method_10263(), midY, min.method_10260())), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(min.method_10263(), midY, max.method_10260())), HoloActivationRegistry.computeCodesFaceBus$bit(world, new class_2338(max.method_10263(), midY, max.method_10260()))};
        int[] ctrlBits = bl2;
        int ctrl = 0;
        for (int i = 0; i < 4; ++i) {
            int n9;
            int n10 = ctrl;
            int[] nArray3 = ctrlBits;
            boolean bl = 0 <= i ? i < nArray3.length : false;
            if (bl) {
                n9 = nArray3[i];
            } else {
                int n11 = i;
                n2 = n10;
                boolean bl4 = false;
                n = 0;
                n10 = n2;
                n9 = n;
            }
            ctrl = n10 | n9 << i;
        }
        return new Triple((Object)model, (Object)anim, (Object)ctrl);
    }

    private final class_2338 findTargetTintedGlass(class_3218 world, class_3222 player, double distance) {
        class_243 class_2432 = player.method_5836(1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"getCameraPosVec(...)");
        class_243 eyePos = class_2432;
        class_243 class_2433 = player.method_5828(1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"getRotationVec(...)");
        class_243 look = class_2433;
        class_243 end = eyePos.method_1031(look.field_1352 * distance, look.field_1351 * distance, look.field_1350 * distance);
        class_3959 ctx = new class_3959(eyePos, end, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player);
        class_3965 hit = world.method_17742(ctx);
        if (hit.method_17783() != class_239.class_240.field_1332) {
            return null;
        }
        Intrinsics.checkNotNull((Object)hit, (String)"null cannot be cast to non-null type net.minecraft.util.hit.BlockHitResult");
        class_2338 pos = hit.method_17777();
        class_2680 state = world.method_8320(pos);
        return state.method_27852(class_2246.field_27115) ? pos : null;
    }

    private final class_2338 findPoweredTintedGlassNear(class_3218 world, class_3222 player, int radiusXZ, int radiusY) {
        class_2338 center = player.method_24515();
        int minX = center.method_10263() - radiusXZ;
        int maxX = center.method_10263() + radiusXZ;
        int minY = center.method_10264() - radiusY;
        int maxY = center.method_10264() + radiusY;
        int minZ = center.method_10260() - radiusXZ;
        int maxZ = center.method_10260() + radiusXZ;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int power;
                    class_2338 pos = new class_2338(x, y, z);
                    class_2680 state = world.method_8320(pos);
                    if (!state.method_27852(class_2246.field_27115) || (power = world.method_49804(pos)) < 1) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    private final class_2338 findAnyTintedGlassNear(class_3218 world, class_3222 player, int radiusXZ, int radiusY) {
        class_2338 center = player.method_24515();
        int minX = center.method_10263() - radiusXZ;
        int maxX = center.method_10263() + radiusXZ;
        int minY = center.method_10264() - radiusY;
        int maxY = center.method_10264() + radiusY;
        int minZ = center.method_10260() - radiusXZ;
        int maxZ = center.method_10260() + radiusXZ;
        for (int y = minY; y <= maxY; y += 2) {
            for (int x = minX; x <= maxX; x += 2) {
                for (int z = minZ; z <= maxZ; z += 2) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2680 state = world.method_8320(pos);
                    if (!state.method_27852(class_2246.field_27115)) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    private final int samplePower(class_3218 world, GlassCuboid cuboid) {
        int strideX = this.strideFor(cuboid.getSizeX());
        int strideY = this.strideFor(cuboid.getSizeY());
        int strideZ = this.strideFor(cuboid.getSizeZ());
        int maxPower = 0;
        int xMin = cuboid.getMin().method_10263();
        int xMax = cuboid.getMax().method_10263();
        int yMin = cuboid.getMin().method_10264();
        int yMax = cuboid.getMax().method_10264();
        int zMin = cuboid.getMin().method_10260();
        int zMax = cuboid.getMax().method_10260();
        for (int y = yMin; y <= yMax; y += strideY) {
            for (int z = zMin; z <= zMax; z += strideZ) {
                if ((maxPower = Math.max(maxPower, world.method_49804(new class_2338(xMin, y, z)))) == 15) {
                    return 15;
                }
                if ((maxPower = Math.max(maxPower, world.method_49804(new class_2338(xMax, y, z)))) != 15) continue;
                return 15;
            }
        }
        for (int x = xMin; x <= xMax; x += strideX) {
            for (int z2 = zMin; z2 <= zMax; z2 += strideZ) {
                if ((maxPower = Math.max(maxPower, world.method_49804(new class_2338(x, yMin, z2)))) == 15) {
                    return 15;
                }
                if ((maxPower = Math.max(maxPower, world.method_49804(new class_2338(x, yMax, z2)))) != 15) continue;
                return 15;
            }
        }
        for (int y2 = yMin; y2 <= yMax; y2 += strideY) {
            for (int x2 = xMin; x2 <= xMax; x2 += strideX) {
                if ((maxPower = Math.max(maxPower, world.method_49804(new class_2338(x2, y2, zMin)))) == 15) {
                    return 15;
                }
                if ((maxPower = Math.max(maxPower, world.method_49804(new class_2338(x2, y2, zMax)))) != 15) continue;
                return 15;
            }
        }
        return maxPower;
    }

    private final int strideFor(int size) {
        int target = 32;
        return size <= target ? 1 : (size + target - 1) / target;
    }

    public final int currentPower(@NotNull class_3218 world, @NotNull GlassCuboid cuboid) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)cuboid, (String)"cuboid");
        String wk = this.worldKey(world);
        WorldState worldState = worlds.get(wk);
        if (worldState == null) {
            return 0;
        }
        WorldState ws = worldState;
        String key = this.keyOf(cuboid);
        WatchedEntry watchedEntry = ws.getWatched().get(key);
        return watchedEntry != null ? watchedEntry.getPower() : 0;
    }

    private final Triple<Integer, Integer, Integer> computeCodes(class_3218 world, GlassCuboid cuboid) {
        int idxAfterAnim;
        int idxAfterModel;
        List<class_2338> ports = this.enumerateEdgePorts(cuboid);
        int n = 0;
        int n2 = ports.size();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = world.method_49804(ports.get(n3));
        }
        int[] strengths = nArray;
        int index = 0;
        Pair<Integer, Integer> pair = this.readBus(strengths, index, 8);
        int model = ((Number)pair.component1()).intValue();
        index = idxAfterModel = ((Number)pair.component2()).intValue();
        Pair<Integer, Integer> pair2 = this.readBus(strengths, index, 8);
        int anim = ((Number)pair2.component1()).intValue();
        index = idxAfterAnim = ((Number)pair2.component2()).intValue();
        int ctrl = ((Number)this.readBus(strengths, index, 4).component1()).intValue();
        return new Triple((Object)model, (Object)anim, (Object)ctrl);
    }

    private final Pair<Integer, Integer> readBus(int[] strengths, int start, int maxBits) {
        int remaining = strengths.length - start;
        if (remaining <= 0) {
            return TuplesKt.to((Object)0, (Object)start);
        }
        if (remaining == 1) {
            int v = RangesKt.coerceIn((int)strengths[start], (int)0, (int)15);
            return TuplesKt.to((Object)v, (Object)(start + 1));
        }
        int bits = Math.min(maxBits, remaining);
        int value = 0;
        for (int i = 0; i < bits; ++i) {
            int bit = strengths[start + i] >= 1 ? 1 : 0;
            value |= bit << i;
        }
        return TuplesKt.to((Object)value, (Object)(start + bits));
    }

    /*
     * Unable to fully structure code
     */
    private final List<class_2338> enumerateEdgePorts(GlassCuboid cuboid) {
        set = new LinkedHashSet<class_2338>();
        min = cuboid.getMin();
        max = cuboid.getMax();
        HoloActivationRegistry.enumerateEdgePorts$addLineX(min, max, set, min.method_10264(), min.method_10260());
        HoloActivationRegistry.enumerateEdgePorts$addLineX(min, max, set, min.method_10264(), max.method_10260());
        HoloActivationRegistry.enumerateEdgePorts$addLineZ(min, max, set, min.method_10264(), min.method_10263());
        HoloActivationRegistry.enumerateEdgePorts$addLineZ(min, max, set, min.method_10264(), max.method_10263());
        HoloActivationRegistry.enumerateEdgePorts$addLineX(min, max, set, max.method_10264(), min.method_10260());
        HoloActivationRegistry.enumerateEdgePorts$addLineX(min, max, set, max.method_10264(), max.method_10260());
        HoloActivationRegistry.enumerateEdgePorts$addLineZ(min, max, set, max.method_10264(), min.method_10263());
        HoloActivationRegistry.enumerateEdgePorts$addLineZ(min, max, set, max.method_10264(), max.method_10263());
        HoloActivationRegistry.enumerateEdgePorts$addLineY(max, min, set, min.method_10263(), min.method_10260());
        HoloActivationRegistry.enumerateEdgePorts$addLineY(max, min, set, max.method_10263(), min.method_10260());
        HoloActivationRegistry.enumerateEdgePorts$addLineY(max, min, set, min.method_10263(), max.method_10260());
        HoloActivationRegistry.enumerateEdgePorts$addLineY(max, min, set, max.method_10263(), max.method_10260());
        $this$filter$iv = set;
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            pos = (class_2338)element$iv$iv;
            $i$a$-filter-HoloActivationRegistry$enumerateEdgePorts$1 = false;
            var14_14 = min.method_10263();
            var15_15 = max.method_10263();
            var16_16 = pos.method_10263();
            v0 = var14_14 <= var16_16 ? var16_16 <= var15_15 : false;
            if (!v0) ** GOTO lbl-1000
            var14_14 = min.method_10264();
            var15_15 = max.method_10264();
            var16_16 = pos.method_10264();
            v1 = var14_14 <= var16_16 ? var16_16 <= var15_15 : false;
            if (!v1) ** GOTO lbl-1000
            var14_14 = min.method_10260();
            var15_15 = max.method_10260();
            var16_16 = pos.method_10260();
            v2 = var14_14 <= var16_16 ? var16_16 <= var15_15 : false;
            if (v2) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final WatchedEntry getWatchedEntry(@NotNull class_3218 world, @NotNull class_2338 pos) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            String wk = this.worldKey(world);
            WorldState worldState = worlds.get(wk);
            if (worldState == null) {
                return null;
            }
            WorldState ws = worldState;
            Iterable $this$firstOrNull$iv = ws.getWatched().values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WatchedEntry it = (WatchedEntry)element$iv;
                boolean bl = false;
                if (!it.getCuboid().contains(pos)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public final Triple<Integer, Integer, Integer> getCodes(@NotNull class_3218 world, @NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        WatchedEntry watchedEntry = this.getWatchedEntry(world, pos);
        if (watchedEntry == null) {
            return null;
        }
        WatchedEntry entry = watchedEntry;
        return new Triple((Object)entry.getModelCode(), (Object)entry.getAnimCode(), (Object)entry.getCtrlCode());
    }

    public final boolean setCodes(@NotNull class_3218 world, @NotNull class_2338 pos, int model, int anim, int ctrl) {
        Object v1;
        WorldState ws;
        block4: {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            String wk = this.worldKey(world);
            WorldState worldState = worlds.get(wk);
            if (worldState == null) {
                return false;
            }
            ws = worldState;
            Iterable $this$firstOrNull$iv = ws.getWatched().values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WatchedEntry it = (WatchedEntry)element$iv;
                boolean bl = false;
                if (!it.getCuboid().contains(pos)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        WatchedEntry watchedEntry = v1;
        if (watchedEntry == null) {
            return false;
        }
        WatchedEntry entry = watchedEntry;
        entry.setModelCode(RangesKt.coerceIn((int)model, (int)0, (int)255));
        entry.setAnimCode(RangesKt.coerceIn((int)anim, (int)0, (int)255));
        entry.setCtrlCode(RangesKt.coerceIn((int)ctrl, (int)0, (int)15));
        long l = ws.getTickCounter();
        ws.setTickCounter(l + 1L);
        class_2960 class_29602 = world.method_27983().method_29177();
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"getValue(...)");
        BusUpdatePayload payload = new BusUpdatePayload(class_29602, entry.getCuboid().getMin(), entry.getCuboid().getMax(), entry.getModelCode(), entry.getAnimCode(), entry.getCtrlCode(), entry.getScaleQ(), entry.getOffXQ(), entry.getOffYQ(), entry.getOffZQ(), ws.getTickCounter());
        for (class_3222 player : world.method_18456()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
        return true;
    }

    private static final void init$lambda$0(class_3218 world) {
        if (world != null) {
            INSTANCE.tickWorld(world);
        }
    }

    private static final int computeParams$q(class_3218 $world, class_2338 pos) {
        return RangesKt.coerceIn((int)$world.method_49804(pos), (int)0, (int)15);
    }

    private static final int computeCodesFaceBus$bit(class_3218 $world, class_2338 pos) {
        return $world.method_49804(pos) >= 1 ? 1 : 0;
    }

    private static final void enumerateEdgePorts$addLineX(class_2338 min, class_2338 max, LinkedHashSet<class_2338> set, int y, int z) {
        int n;
        int x = min.method_10263();
        if (x <= (n = max.method_10263())) {
            while (true) {
                set.add(new class_2338(x, y, z));
                if (x == n) break;
                ++x;
            }
        }
    }

    private static final void enumerateEdgePorts$addLineZ(class_2338 min, class_2338 max, LinkedHashSet<class_2338> set, int y, int x) {
        int n;
        int z = min.method_10260();
        if (z <= (n = max.method_10260())) {
            while (true) {
                set.add(new class_2338(x, y, z));
                if (z == n) break;
                ++z;
            }
        }
    }

    private static final void enumerateEdgePorts$addLineY(class_2338 max, class_2338 min, LinkedHashSet<class_2338> set, int x, int z) {
        int n;
        int y;
        if (max.method_10264() - min.method_10264() >= 2 && (y = min.method_10264() + 1) <= (n = max.method_10264() - 1)) {
            while (true) {
                set.add(new class_2338(x, y, z));
                if (y == n) break;
                ++y;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\nJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\nJ8\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\nR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u001a\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u001b\u0010\nR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u001c\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/sylsatra/hologram/state/HoloActivationRegistry$QuadrupleInt;", "", "", "a", "b", "c", "d", "<init>", "(IIII)V", "component1", "()I", "component2", "component3", "component4", "copy", "(IIII)Lcom/sylsatra/hologram/state/HoloActivationRegistry$QuadrupleInt;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getA", "getB", "getC", "getD", "hologram"})
    private static final class QuadrupleInt {
        private final int a;
        private final int b;
        private final int c;
        private final int d;

        public QuadrupleInt(int a, int b, int c, int d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        public final int getA() {
            return this.a;
        }

        public final int getB() {
            return this.b;
        }

        public final int getC() {
            return this.c;
        }

        public final int getD() {
            return this.d;
        }

        public final int component1() {
            return this.a;
        }

        public final int component2() {
            return this.b;
        }

        public final int component3() {
            return this.c;
        }

        public final int component4() {
            return this.d;
        }

        @NotNull
        public final QuadrupleInt copy(int a, int b, int c, int d) {
            return new QuadrupleInt(a, b, c, d);
        }

        public static /* synthetic */ QuadrupleInt copy$default(QuadrupleInt quadrupleInt, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = quadrupleInt.a;
            }
            if ((n5 & 2) != 0) {
                n2 = quadrupleInt.b;
            }
            if ((n5 & 4) != 0) {
                n3 = quadrupleInt.c;
            }
            if ((n5 & 8) != 0) {
                n4 = quadrupleInt.d;
            }
            return quadrupleInt.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "QuadrupleInt(a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.a);
            result = result * 31 + Integer.hashCode(this.b);
            result = result * 31 + Integer.hashCode(this.c);
            result = result * 31 + Integer.hashCode(this.d);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QuadrupleInt)) {
                return false;
            }
            QuadrupleInt quadrupleInt = (QuadrupleInt)other;
            if (this.a != quadrupleInt.a) {
                return false;
            }
            if (this.b != quadrupleInt.b) {
                return false;
            }
            if (this.c != quadrupleInt.c) {
                return false;
            }
            return this.d == quadrupleInt.d;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0019\b\u0086\b\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u0012\b\b\u0002\u0010\n\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u0010\u0010\u0015\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0012J\u0010\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0012J\u0010\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0012J\u0010\u0010\u0018\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0012J\u0010\u0010\u0019\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u0012Jj\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001a\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010 \u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b \u0010\u0012J\u0010\u0010\"\u001a\u00020!H\u00d6\u0001\u00a2\u0006\u0004\b\"\u0010#R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010\u0010\"\u0004\b&\u0010'R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010(\u001a\u0004\b)\u0010\u0012\"\u0004\b*\u0010+R\"\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010(\u001a\u0004\b,\u0010\u0012\"\u0004\b-\u0010+R\"\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010(\u001a\u0004\b.\u0010\u0012\"\u0004\b/\u0010+R\"\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010(\u001a\u0004\b0\u0010\u0012\"\u0004\b1\u0010+R\"\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010(\u001a\u0004\b2\u0010\u0012\"\u0004\b3\u0010+R\"\u0010\n\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010(\u001a\u0004\b4\u0010\u0012\"\u0004\b5\u0010+R\"\u0010\u000b\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010(\u001a\u0004\b6\u0010\u0012\"\u0004\b7\u0010+R\"\u0010\f\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010(\u001a\u0004\b8\u0010\u0012\"\u0004\b9\u0010+\u00a8\u0006:"}, d2={"Lcom/sylsatra/hologram/state/HoloActivationRegistry$WatchedEntry;", "", "Lcom/sylsatra/hologram/structure/GlassCuboid;", "cuboid", "", "power", "modelCode", "animCode", "ctrlCode", "scaleQ", "offXQ", "offYQ", "offZQ", "<init>", "(Lcom/sylsatra/hologram/structure/GlassCuboid;IIIIIIII)V", "component1", "()Lcom/sylsatra/hologram/structure/GlassCuboid;", "component2", "()I", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Lcom/sylsatra/hologram/structure/GlassCuboid;IIIIIIII)Lcom/sylsatra/hologram/state/HoloActivationRegistry$WatchedEntry;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lcom/sylsatra/hologram/structure/GlassCuboid;", "getCuboid", "setCuboid", "(Lcom/sylsatra/hologram/structure/GlassCuboid;)V", "I", "getPower", "setPower", "(I)V", "getModelCode", "setModelCode", "getAnimCode", "setAnimCode", "getCtrlCode", "setCtrlCode", "getScaleQ", "setScaleQ", "getOffXQ", "setOffXQ", "getOffYQ", "setOffYQ", "getOffZQ", "setOffZQ", "hologram"})
    public static final class WatchedEntry {
        @NotNull
        private GlassCuboid cuboid;
        private int power;
        private int modelCode;
        private int animCode;
        private int ctrlCode;
        private int scaleQ;
        private int offXQ;
        private int offYQ;
        private int offZQ;

        public WatchedEntry(@NotNull GlassCuboid cuboid, int power, int modelCode, int animCode, int ctrlCode, int scaleQ, int offXQ, int offYQ, int offZQ) {
            Intrinsics.checkNotNullParameter((Object)cuboid, (String)"cuboid");
            this.cuboid = cuboid;
            this.power = power;
            this.modelCode = modelCode;
            this.animCode = animCode;
            this.ctrlCode = ctrlCode;
            this.scaleQ = scaleQ;
            this.offXQ = offXQ;
            this.offYQ = offYQ;
            this.offZQ = offZQ;
        }

        public /* synthetic */ WatchedEntry(GlassCuboid glassCuboid, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n9 & 2) != 0) {
                n = 0;
            }
            if ((n9 & 4) != 0) {
                n2 = 0;
            }
            if ((n9 & 8) != 0) {
                n3 = 0;
            }
            if ((n9 & 0x10) != 0) {
                n4 = 0;
            }
            if ((n9 & 0x20) != 0) {
                n5 = 0;
            }
            if ((n9 & 0x40) != 0) {
                n6 = 0;
            }
            if ((n9 & 0x80) != 0) {
                n7 = 0;
            }
            if ((n9 & 0x100) != 0) {
                n8 = 0;
            }
            this(glassCuboid, n, n2, n3, n4, n5, n6, n7, n8);
        }

        @NotNull
        public final GlassCuboid getCuboid() {
            return this.cuboid;
        }

        public final void setCuboid(@NotNull GlassCuboid glassCuboid) {
            Intrinsics.checkNotNullParameter((Object)glassCuboid, (String)"<set-?>");
            this.cuboid = glassCuboid;
        }

        public final int getPower() {
            return this.power;
        }

        public final void setPower(int n) {
            this.power = n;
        }

        public final int getModelCode() {
            return this.modelCode;
        }

        public final void setModelCode(int n) {
            this.modelCode = n;
        }

        public final int getAnimCode() {
            return this.animCode;
        }

        public final void setAnimCode(int n) {
            this.animCode = n;
        }

        public final int getCtrlCode() {
            return this.ctrlCode;
        }

        public final void setCtrlCode(int n) {
            this.ctrlCode = n;
        }

        public final int getScaleQ() {
            return this.scaleQ;
        }

        public final void setScaleQ(int n) {
            this.scaleQ = n;
        }

        public final int getOffXQ() {
            return this.offXQ;
        }

        public final void setOffXQ(int n) {
            this.offXQ = n;
        }

        public final int getOffYQ() {
            return this.offYQ;
        }

        public final void setOffYQ(int n) {
            this.offYQ = n;
        }

        public final int getOffZQ() {
            return this.offZQ;
        }

        public final void setOffZQ(int n) {
            this.offZQ = n;
        }

        @NotNull
        public final GlassCuboid component1() {
            return this.cuboid;
        }

        public final int component2() {
            return this.power;
        }

        public final int component3() {
            return this.modelCode;
        }

        public final int component4() {
            return this.animCode;
        }

        public final int component5() {
            return this.ctrlCode;
        }

        public final int component6() {
            return this.scaleQ;
        }

        public final int component7() {
            return this.offXQ;
        }

        public final int component8() {
            return this.offYQ;
        }

        public final int component9() {
            return this.offZQ;
        }

        @NotNull
        public final WatchedEntry copy(@NotNull GlassCuboid cuboid, int power, int modelCode, int animCode, int ctrlCode, int scaleQ, int offXQ, int offYQ, int offZQ) {
            Intrinsics.checkNotNullParameter((Object)cuboid, (String)"cuboid");
            return new WatchedEntry(cuboid, power, modelCode, animCode, ctrlCode, scaleQ, offXQ, offYQ, offZQ);
        }

        public static /* synthetic */ WatchedEntry copy$default(WatchedEntry watchedEntry, GlassCuboid glassCuboid, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object) {
            if ((n9 & 1) != 0) {
                glassCuboid = watchedEntry.cuboid;
            }
            if ((n9 & 2) != 0) {
                n = watchedEntry.power;
            }
            if ((n9 & 4) != 0) {
                n2 = watchedEntry.modelCode;
            }
            if ((n9 & 8) != 0) {
                n3 = watchedEntry.animCode;
            }
            if ((n9 & 0x10) != 0) {
                n4 = watchedEntry.ctrlCode;
            }
            if ((n9 & 0x20) != 0) {
                n5 = watchedEntry.scaleQ;
            }
            if ((n9 & 0x40) != 0) {
                n6 = watchedEntry.offXQ;
            }
            if ((n9 & 0x80) != 0) {
                n7 = watchedEntry.offYQ;
            }
            if ((n9 & 0x100) != 0) {
                n8 = watchedEntry.offZQ;
            }
            return watchedEntry.copy(glassCuboid, n, n2, n3, n4, n5, n6, n7, n8);
        }

        @NotNull
        public String toString() {
            return "WatchedEntry(cuboid=" + this.cuboid + ", power=" + this.power + ", modelCode=" + this.modelCode + ", animCode=" + this.animCode + ", ctrlCode=" + this.ctrlCode + ", scaleQ=" + this.scaleQ + ", offXQ=" + this.offXQ + ", offYQ=" + this.offYQ + ", offZQ=" + this.offZQ + ")";
        }

        public int hashCode() {
            int result = this.cuboid.hashCode();
            result = result * 31 + Integer.hashCode(this.power);
            result = result * 31 + Integer.hashCode(this.modelCode);
            result = result * 31 + Integer.hashCode(this.animCode);
            result = result * 31 + Integer.hashCode(this.ctrlCode);
            result = result * 31 + Integer.hashCode(this.scaleQ);
            result = result * 31 + Integer.hashCode(this.offXQ);
            result = result * 31 + Integer.hashCode(this.offYQ);
            result = result * 31 + Integer.hashCode(this.offZQ);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WatchedEntry)) {
                return false;
            }
            WatchedEntry watchedEntry = (WatchedEntry)other;
            if (!Intrinsics.areEqual((Object)this.cuboid, (Object)watchedEntry.cuboid)) {
                return false;
            }
            if (this.power != watchedEntry.power) {
                return false;
            }
            if (this.modelCode != watchedEntry.modelCode) {
                return false;
            }
            if (this.animCode != watchedEntry.animCode) {
                return false;
            }
            if (this.ctrlCode != watchedEntry.ctrlCode) {
                return false;
            }
            if (this.scaleQ != watchedEntry.scaleQ) {
                return false;
            }
            if (this.offXQ != watchedEntry.offXQ) {
                return false;
            }
            if (this.offYQ != watchedEntry.offYQ) {
                return false;
            }
            return this.offZQ == watchedEntry.offZQ;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ0\u0010\u000e\u001a\u00020\u00002\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R#\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u000bR\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\u001b\u001a\u0004\b\u001c\u0010\r\"\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/sylsatra/hologram/state/HoloActivationRegistry$WorldState;", "", "", "", "Lcom/sylsatra/hologram/state/HoloActivationRegistry$WatchedEntry;", "watched", "", "tickCounter", "<init>", "(Ljava/util/Map;J)V", "component1", "()Ljava/util/Map;", "component2", "()J", "copy", "(Ljava/util/Map;J)Lcom/sylsatra/hologram/state/HoloActivationRegistry$WorldState;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Ljava/util/Map;", "getWatched", "J", "getTickCounter", "setTickCounter", "(J)V", "hologram"})
    private static final class WorldState {
        @NotNull
        private final Map<String, WatchedEntry> watched;
        private long tickCounter;

        public WorldState(@NotNull Map<String, WatchedEntry> watched, long tickCounter) {
            Intrinsics.checkNotNullParameter(watched, (String)"watched");
            this.watched = watched;
            this.tickCounter = tickCounter;
        }

        public /* synthetic */ WorldState(Map map, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new LinkedHashMap();
            }
            if ((n & 2) != 0) {
                l = 0L;
            }
            this(map, l);
        }

        @NotNull
        public final Map<String, WatchedEntry> getWatched() {
            return this.watched;
        }

        public final long getTickCounter() {
            return this.tickCounter;
        }

        public final void setTickCounter(long l) {
            this.tickCounter = l;
        }

        @NotNull
        public final Map<String, WatchedEntry> component1() {
            return this.watched;
        }

        public final long component2() {
            return this.tickCounter;
        }

        @NotNull
        public final WorldState copy(@NotNull Map<String, WatchedEntry> watched, long tickCounter) {
            Intrinsics.checkNotNullParameter(watched, (String)"watched");
            return new WorldState(watched, tickCounter);
        }

        public static /* synthetic */ WorldState copy$default(WorldState worldState, Map map, long l, int n, Object object) {
            if ((n & 1) != 0) {
                map = worldState.watched;
            }
            if ((n & 2) != 0) {
                l = worldState.tickCounter;
            }
            return worldState.copy(map, l);
        }

        @NotNull
        public String toString() {
            return "WorldState(watched=" + this.watched + ", tickCounter=" + this.tickCounter + ")";
        }

        public int hashCode() {
            int result = ((Object)this.watched).hashCode();
            result = result * 31 + Long.hashCode(this.tickCounter);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WorldState)) {
                return false;
            }
            WorldState worldState = (WorldState)other;
            if (!Intrinsics.areEqual(this.watched, worldState.watched)) {
                return false;
            }
            return this.tickCounter == worldState.tickCounter;
        }

        public WorldState() {
            this(null, 0L, 3, null);
        }
    }
}

