/*
 * Decompiled with CFR 0.152.
 */
package com.sylsatra.hologram.structure;

import com.sylsatra.hologram.structure.GlassCuboid;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JG\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ)\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/sylsatra/hologram/structure/GlassCuboidDetector;", "", "<init>", "()V", "Lnet/minecraft/class_3218;", "world", "", "minX", "minY", "minZ", "maxX", "maxY", "maxZ", "", "facesFilled", "(Lnet/minecraft/class_3218;IIIIII)Z", "Lnet/minecraft/class_2338;", "seed", "maxSizePerAxis", "Lcom/sylsatra/hologram/structure/GlassCuboid;", "detectFromSeed", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;I)Lcom/sylsatra/hologram/structure/GlassCuboid;", "", "NEIGHBORS", "[Lnet/minecraft/class_2338;", "hologram"})
public final class GlassCuboidDetector {
    @NotNull
    public static final GlassCuboidDetector INSTANCE = new GlassCuboidDetector();
    @NotNull
    private static final class_2338[] NEIGHBORS;

    private GlassCuboidDetector() {
    }

    private final boolean facesFilled(class_3218 world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (!world.method_8320(new class_2338(x, minY, z)).method_27852(class_2246.field_27115)) {
                    return false;
                }
                if (world.method_8320(new class_2338(x, maxY, z)).method_27852(class_2246.field_27115)) continue;
                return false;
            }
        }
        for (int y = minY; y <= maxY; ++y) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                if (!world.method_8320(new class_2338(minX, y, z2)).method_27852(class_2246.field_27115)) {
                    return false;
                }
                if (world.method_8320(new class_2338(maxX, y, z2)).method_27852(class_2246.field_27115)) continue;
                return false;
            }
        }
        for (int y2 = minY; y2 <= maxY; ++y2) {
            for (int x2 = minX; x2 <= maxX; ++x2) {
                if (!world.method_8320(new class_2338(x2, y2, minZ)).method_27852(class_2246.field_27115)) {
                    return false;
                }
                if (world.method_8320(new class_2338(x2, y2, maxZ)).method_27852(class_2246.field_27115)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public final GlassCuboid detectFromSeed(@NotNull class_3218 world, @NotNull class_2338 seed, int maxSizePerAxis) {
        boolean isShell;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        if (!world.method_8320(seed).method_27852(class_2246.field_27115)) {
            return null;
        }
        HashSet<class_2338> visited = new HashSet<class_2338>(1024);
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        queue.add(seed);
        visited.add(seed);
        int minX = seed.method_10263();
        int minY = seed.method_10264();
        int minZ = seed.method_10260();
        int maxX = seed.method_10263();
        int maxY = seed.method_10264();
        int maxZ = seed.method_10260();
        int maxVolume = maxSizePerAxis * maxSizePerAxis * maxSizePerAxis;
        while (!((Collection)queue).isEmpty()) {
            class_2338 cur = (class_2338)queue.removeFirst();
            if (cur.method_10263() < minX) {
                minX = cur.method_10263();
            }
            if (cur.method_10264() < minY) {
                minY = cur.method_10264();
            }
            if (cur.method_10260() < minZ) {
                minZ = cur.method_10260();
            }
            if (cur.method_10263() > maxX) {
                maxX = cur.method_10263();
            }
            if (cur.method_10264() > maxY) {
                maxY = cur.method_10264();
            }
            if (cur.method_10260() > maxZ) {
                maxZ = cur.method_10260();
            }
            int sizeX = maxX - minX + 1;
            int sizeY = maxY - minY + 1;
            int sizeZ = maxZ - minZ + 1;
            if (sizeX > maxSizePerAxis || sizeY > maxSizePerAxis || sizeZ > maxSizePerAxis) {
                return null;
            }
            for (class_2338 d : NEIGHBORS) {
                class_2680 state;
                class_2338 next = cur.method_10069(d.method_10263(), d.method_10264(), d.method_10260());
                if (visited.contains(next) || !(state = world.method_8320(next)).method_27852(class_2246.field_27115)) continue;
                visited.add(next);
                if (visited.size() > maxVolume) {
                    return null;
                }
                queue.add(next);
            }
        }
        int sizeX = maxX - minX + 1;
        int sizeY = maxY - minY + 1;
        int sizeZ = maxZ - minZ + 1;
        int volume = sizeX * sizeY * sizeZ;
        boolean isFilled = visited.size() == volume;
        boolean bl = isShell = !isFilled ? this.facesFilled(world, minX, minY, minZ, maxX, maxY, maxZ) : false;
        if (!isFilled && !isShell) {
            return null;
        }
        class_2338 min = new class_2338(minX, minY, minZ);
        class_2338 max = new class_2338(maxX, maxY, maxZ);
        class_5321 class_53212 = world.method_27983();
        Intrinsics.checkNotNullExpressionValue((Object)class_53212, (String)"getRegistryKey(...)");
        return new GlassCuboid((class_5321<class_1937>)class_53212, min, max);
    }

    public static /* synthetic */ GlassCuboid detectFromSeed$default(GlassCuboidDetector glassCuboidDetector, class_3218 class_32182, class_2338 class_23382, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 64;
        }
        return glassCuboidDetector.detectFromSeed(class_32182, class_23382, n);
    }

    static {
        class_2338[] class_2338Array = new class_2338[]{new class_2338(1, 0, 0), new class_2338(-1, 0, 0), new class_2338(0, 1, 0), new class_2338(0, -1, 0), new class_2338(0, 0, 1), new class_2338(0, 0, -1)};
        NEIGHBORS = class_2338Array;
    }
}

