/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.culler;

import com.imeetake.culler.CullerClient;
import com.imeetake.tlib.client.render.TClientRenderUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1511;
import net.minecraft.class_1531;
import net.minecraft.class_1533;
import net.minecraft.class_1534;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2573;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2589;
import net.minecraft.class_2595;
import net.minecraft.class_2597;
import net.minecraft.class_2601;
import net.minecraft.class_2605;
import net.minecraft.class_2608;
import net.minecraft.class_2614;
import net.minecraft.class_2619;
import net.minecraft.class_2625;
import net.minecraft.class_2627;
import net.minecraft.class_310;
import net.minecraft.class_3720;
import net.minecraft.class_3721;
import net.minecraft.class_3722;
import net.minecraft.class_3723;
import net.minecraft.class_3866;
import net.minecraft.class_3924;
import net.minecraft.class_5704;
import net.minecraft.class_7133;

@Environment(value=EnvType.CLIENT)
public class CullManager {
    private static double cachedFovThreshold = -2.0;
    private static int lastPlayerFov = -1;
    private static int lastBufferValue = -1;

    public static void initialize() {
    }

    public static boolean shouldRenderBlockEntity(class_2586 blockEntity, class_2338 pos) {
        if (!CullerClient.CONFIG.enableCulling()) {
            return true;
        }
        if (blockEntity instanceof class_2625) {
            class_2625 signEntity = (class_2625)blockEntity;
            if (CullerClient.CONFIG.cullSigns()) {
                return CullManager.shouldRenderSign(signEntity, pos);
            }
        }
        if (blockEntity instanceof class_2573 && CullerClient.CONFIG.cullBanners()) {
            return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.bannerDistance());
        }
        if (blockEntity instanceof class_2595 && CullerClient.CONFIG.cullChests()) {
            return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.chestDistance());
        }
        if (blockEntity instanceof class_2580 && CullerClient.CONFIG.cullBeacons()) {
            return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.beaconDistance());
        }
        if (blockEntity instanceof class_3722 && CullerClient.CONFIG.cullLecterns()) {
            return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.lecternDistance());
        }
        if (blockEntity instanceof class_3924 && CullerClient.CONFIG.cullCampfires()) {
            return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.campfireDistance());
        }
        if (blockEntity instanceof class_2627 && CullerClient.CONFIG.cullShulkerBoxes()) {
            return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.shulkerBoxDistance());
        }
        if (blockEntity instanceof class_2605 && CullerClient.CONFIG.cullEnchantingTables()) {
            return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.enchantingTableDistance());
        }
        if (blockEntity instanceof class_2589 && CullerClient.CONFIG.cullBrewingStands()) {
            return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.brewingStandDistance());
        }
        if ((blockEntity instanceof class_3866 || blockEntity instanceof class_3723 || blockEntity instanceof class_3720) && CullerClient.CONFIG.cullFurnaces()) {
            return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.furnaceDistance());
        }
        if (blockEntity instanceof class_2614 && CullerClient.CONFIG.cullHoppers()) {
            return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.hopperDistance());
        }
        if ((blockEntity instanceof class_2601 || blockEntity instanceof class_2608) && CullerClient.CONFIG.cullDispensers()) {
            return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.dispenserDistance());
        }
        if (blockEntity instanceof class_2619 && CullerClient.CONFIG.cullJukeboxes()) {
            return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.jukeboxDistance());
        }
        if (blockEntity instanceof class_3721 && CullerClient.CONFIG.cullBells()) {
            return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.bellDistance());
        }
        if (blockEntity instanceof class_2597 && CullerClient.CONFIG.cullConduits()) {
            return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.conduitDistance());
        }
        if ((blockEntity instanceof class_7133 || blockEntity instanceof class_5704) && CullerClient.CONFIG.cullSculkBlocks()) {
            return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.sculkDistance());
        }
        return true;
    }

    public static boolean shouldRenderSign(class_2625 signEntity, class_2338 pos) {
        if (!CullerClient.CONFIG.enableCulling() || !CullerClient.CONFIG.cullSigns()) {
            return true;
        }
        if (CullerClient.CONFIG.cullEmptySigns() && CullManager.isSignEmpty(signEntity)) {
            return CullManager.shouldRenderWithDistance(pos, (double)CullerClient.CONFIG.signDistance() * 0.5);
        }
        return CullManager.shouldRenderWithDistance(pos, CullerClient.CONFIG.signDistance());
    }

    public static boolean shouldRenderPainting(class_1534 painting) {
        if (!CullerClient.CONFIG.enableCulling() || !CullerClient.CONFIG.cullPaintings()) {
            return true;
        }
        return CullManager.shouldRenderEntity((class_1297)painting, CullerClient.CONFIG.paintingDistance());
    }

    public static boolean shouldRenderItemFrame(class_1533 itemFrame) {
        if (!CullerClient.CONFIG.enableCulling() || !CullerClient.CONFIG.cullItemFrames()) {
            return true;
        }
        double distance = CullerClient.CONFIG.itemFrameDistance();
        if (CullerClient.CONFIG.cullSmallItemFrames() && itemFrame.method_5864().toString().contains("glow")) {
            distance *= 0.75;
        }
        return CullManager.shouldRenderEntity((class_1297)itemFrame, distance);
    }

    public static boolean shouldRenderArmorStand(class_1531 armorStand) {
        if (!CullerClient.CONFIG.enableCulling() || !CullerClient.CONFIG.cullArmorStands()) {
            return true;
        }
        return CullManager.shouldRenderEntity((class_1297)armorStand, CullerClient.CONFIG.armorStandDistance());
    }

    public static boolean shouldRenderEndCrystal(class_1511 endCrystal) {
        if (!CullerClient.CONFIG.enableCulling() || !CullerClient.CONFIG.cullEndCrystals()) {
            return true;
        }
        return CullManager.shouldRenderEntity((class_1297)endCrystal, CullerClient.CONFIG.endCrystalDistance());
    }

    public static boolean shouldRenderDroppedItem(class_1542 itemEntity) {
        if (!CullerClient.CONFIG.enableCulling() || !CullerClient.CONFIG.cullDroppedItems()) {
            return true;
        }
        return CullManager.shouldRenderEntity((class_1297)itemEntity, CullerClient.CONFIG.droppedItemDistance());
    }

    public static boolean shouldRenderExperienceOrb(class_1303 experienceOrb) {
        if (!CullerClient.CONFIG.enableCulling() || !CullerClient.CONFIG.cullExperienceOrbs()) {
            return true;
        }
        return CullManager.shouldRenderEntity((class_1297)experienceOrb, CullerClient.CONFIG.experienceOrbDistance());
    }

    public static boolean shouldRenderBoat(class_1690 boat) {
        if (!CullerClient.CONFIG.enableCulling() || !CullerClient.CONFIG.cullBoats()) {
            return true;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && boat.method_5626((class_1297)client.field_1724)) {
            return true;
        }
        double distance = CullerClient.CONFIG.boatDistance();
        if (CullerClient.CONFIG.cullEmptyBoats() && boat.method_31483() == null) {
            distance *= 0.75;
        }
        return CullManager.shouldRenderEntity((class_1297)boat, distance);
    }

    public static boolean shouldRenderMinecart(class_1695 minecart) {
        if (!CullerClient.CONFIG.enableCulling() || !CullerClient.CONFIG.cullMinecarts()) {
            return true;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && minecart.method_5626((class_1297)client.field_1724)) {
            return true;
        }
        double distance = CullerClient.CONFIG.minecartDistance();
        if (CullerClient.CONFIG.cullEmptyMinecarts() && !minecart.method_5782()) {
            distance *= 0.8;
        }
        return CullManager.shouldRenderEntity((class_1297)minecart, distance);
    }

    public static boolean shouldRenderTnt(class_1541 tnt) {
        if (!CullerClient.CONFIG.enableCulling() || !CullerClient.CONFIG.cullTnt()) {
            return true;
        }
        return CullManager.shouldRenderEntity((class_1297)tnt, CullerClient.CONFIG.tntDistance());
    }

    public static boolean shouldRenderArrow(class_1297 arrow) {
        if (!CullerClient.CONFIG.enableCulling() || !CullerClient.CONFIG.cullArrows()) {
            return true;
        }
        return CullManager.shouldRenderEntity(arrow, CullerClient.CONFIG.arrowDistance());
    }

    public static boolean shouldRenderItemDisplay(class_1297 itemDisplay) {
        if (!CullerClient.CONFIG.enableCulling() || !CullerClient.CONFIG.cullItemDisplays()) {
            return true;
        }
        return CullManager.shouldRenderEntity(itemDisplay, CullerClient.CONFIG.itemDisplayDistance());
    }

    public static boolean shouldRenderBlockDisplay(class_1297 blockDisplay) {
        if (!CullerClient.CONFIG.enableCulling() || !CullerClient.CONFIG.cullBlockDisplays()) {
            return true;
        }
        return CullManager.shouldRenderEntity(blockDisplay, CullerClient.CONFIG.blockDisplayDistance());
    }

    public static boolean shouldRenderTextDisplay(class_1297 textDisplay) {
        if (!CullerClient.CONFIG.enableCulling() || !CullerClient.CONFIG.cullTextDisplays()) {
            return true;
        }
        return CullManager.shouldRenderEntity(textDisplay, CullerClient.CONFIG.textDisplayDistance());
    }

    private static boolean shouldRenderWithDistance(class_2338 pos, double maxDistance) {
        try {
            class_243 cameraPos = CullManager.getCameraPosition();
            class_243 blockPos = class_243.method_24954((class_2382)pos).method_1031(0.5, 0.5, 0.5);
            double effectiveLimit = maxDistance / CullerClient.CONFIG.distanceMultiplier();
            if (cameraPos.method_1025(blockPos) > effectiveLimit * effectiveLimit) {
                return false;
            }
            return !CullerClient.CONFIG.enableFovCulling() || CullManager.isInFOV(cameraPos, blockPos);
        }
        catch (Exception e) {
            return true;
        }
    }

    private static boolean shouldRenderEntity(class_1297 entity, double maxDistance) {
        try {
            if (entity.method_5851()) {
                return true;
            }
            if ((entity instanceof class_1695 || entity instanceof class_1690 || entity instanceof class_1541) && entity.method_18798().method_1027() > 0.2) {
                return true;
            }
            class_243 cameraPos = CullManager.getCameraPosition();
            class_243 entityPos = entity.method_19538();
            double effectiveLimit = maxDistance / CullerClient.CONFIG.distanceMultiplier();
            if (cameraPos.method_1025(entityPos) > effectiveLimit * effectiveLimit) {
                return false;
            }
            return !CullerClient.CONFIG.enableFovCulling() || CullManager.isInFOV(cameraPos, entityPos);
        }
        catch (Exception e) {
            return true;
        }
    }

    private static boolean isSignEmpty(class_2625 signEntity) {
        for (int i = 0; i < 4; ++i) {
            class_2561 text = signEntity.method_49843(true).method_49859(i, false);
            if (text == null || text.getString().trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static class_243 getCameraPosition() {
        return TClientRenderUtils.getCameraPosition();
    }

    private static class_243 getCameraLookVector() {
        return TClientRenderUtils.getCameraLookVector();
    }

    private static boolean isInFOV(class_243 cameraPos, class_243 targetPos) {
        class_243 toTarget;
        class_243 lookVector;
        double dotProduct;
        int currentFov = (Integer)class_310.method_1551().field_1690.method_41808().method_41753();
        int currentBuffer = CullerClient.CONFIG.fovBuffer();
        if (currentFov != lastPlayerFov || currentBuffer != lastBufferValue) {
            lastPlayerFov = currentFov;
            lastBufferValue = currentBuffer;
            double totalFov = currentFov + currentBuffer;
            cachedFovThreshold = Math.cos(Math.toRadians(totalFov / 2.0));
        }
        return (dotProduct = (lookVector = CullManager.getCameraLookVector()).method_1026(toTarget = targetPos.method_1020(cameraPos).method_1029())) >= cachedFovThreshold;
    }
}

