/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.essentials999;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerHomes {
    private final UUID playerUUID;
    private final Map<String, Location> homes = new HashMap<String, Location>();
    private final int maxHomes;

    public PlayerHomes(UUID playerUUID, int maxHomes) {
        this.playerUUID = playerUUID;
        this.maxHomes = maxHomes;
    }

    public boolean setHome(String name, Location loc) {
        if (this.homes.size() >= this.maxHomes && !this.homes.containsKey(name.toLowerCase())) {
            return false;
        }
        this.homes.put(name.toLowerCase(), loc);
        return true;
    }

    public boolean deleteHome(String name) {
        return this.homes.remove(name.toLowerCase()) != null;
    }

    public Location getHome(String name) {
        return this.homes.get(name.toLowerCase());
    }

    public Set<String> getHomeNames() {
        return new HashSet<String>(this.homes.keySet());
    }

    public void loadFromConfig(YamlConfiguration config) {
        String path = "players." + this.playerUUID.toString() + ".homes";
        if (!config.contains(path)) {
            return;
        }
        ConfigurationSection sec = config.getConfigurationSection(path);
        if (sec == null) {
            return;
        }
        for (String homeName : sec.getKeys(false)) {
            Location loc = sec.getLocation(homeName);
            if (loc == null) continue;
            this.homes.put(homeName.toLowerCase(), loc);
        }
    }

    public void saveToConfig(YamlConfiguration config) {
        String path = "players." + this.playerUUID.toString() + ".homes";
        config.set(path, null);
        for (Map.Entry<String, Location> entry : this.homes.entrySet()) {
            config.set(path + "." + entry.getKey(), (Object)entry.getValue());
        }
    }
}

