/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.essentials999;

import com.yourname.essentials999.Essentials999;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WarpsManager {
    private final Map<String, Location> warps = new HashMap<String, Location>();
    private File warpsFile;
    private YamlConfiguration warpsConfig;
    private final Essentials999 plugin;

    public WarpsManager(Essentials999 plugin) {
        this.plugin = plugin;
        this.setup();
    }

    private void setup() {
        this.warpsFile = new File(this.plugin.getDataFolder(), "warps.yml");
        if (!this.warpsFile.exists()) {
            try {
                this.warpsFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to create warps.yml: " + e.getMessage());
            }
        }
        this.warpsConfig = YamlConfiguration.loadConfiguration((File)this.warpsFile);
    }

    public void loadWarps() {
        this.warps.clear();
        if (!this.warpsConfig.contains("warps")) {
            return;
        }
        ConfigurationSection sec = this.warpsConfig.getConfigurationSection("warps");
        if (sec == null) {
            return;
        }
        for (String warpName : sec.getKeys(false)) {
            Location loc = sec.getLocation(warpName);
            if (loc == null) continue;
            this.warps.put(warpName.toLowerCase(), loc);
        }
    }

    public void saveWarpsAsync() {
        new BukkitRunnable(){

            public void run() {
                WarpsManager.this.saveWarps();
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private synchronized void saveWarps() {
        this.warpsConfig.set("warps", null);
        for (Map.Entry<String, Location> entry : this.warps.entrySet()) {
            this.warpsConfig.set("warps." + entry.getKey(), (Object)entry.getValue());
        }
        try {
            this.warpsConfig.save(this.warpsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save warps.yml: " + e.getMessage());
        }
    }

    public void setWarp(String name, Location loc) {
        this.warps.put(name.toLowerCase(), loc);
        this.saveWarpsAsync();
    }

    public boolean deleteWarp(String name) {
        if (this.warps.remove(name.toLowerCase()) != null) {
            this.saveWarpsAsync();
            return true;
        }
        return false;
    }

    public Location getWarp(String name) {
        return this.warps.get(name.toLowerCase());
    }

    public Set<String> getWarpNames() {
        return new HashSet<String>(this.warps.keySet());
    }
}

