/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.essentials999;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Essentials999
extends JavaPlugin {
    private final Map<UUID, PlayerHomes> playerHomes = new ConcurrentHashMap<UUID, PlayerHomes>();
    private final Map<UUID, Location> lastLocations = new ConcurrentHashMap<UUID, Location>();
    private final Map<UUID, Long> warpCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, UUID> tpRequests = new ConcurrentHashMap<UUID, UUID>();
    private final Map<UUID, UUID> tpDenied = new ConcurrentHashMap<UUID, UUID>();
    private File homesFile;
    private YamlConfiguration homesConfig;
    private WarpsManager warpsManager;
    private int maxHomes;
    private boolean teleportSafety;
    private int warpCooldownSeconds;
    private final Map<String, Location> spawnPoints = new ConcurrentHashMap<String, Location>();

    public void onEnable() {
        this.setupConfigs();
        this.loadConfigValues();
        this.loadHomes();
        this.warpsManager = new WarpsManager(this);
        this.warpsManager.loadWarps();
        this.registerCommands();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEventListener(this), (Plugin)this);
        this.getLogger().info(String.valueOf(ChatColor.GREEN) + "Essentials999 v1.0.4 enabled!");
    }

    public void onDisable() {
        this.saveHomesAsync();
        this.warpsManager.saveWarpsAsync();
        this.getLogger().info(String.valueOf(ChatColor.RED) + "Essentials999 v1.0.4 disabled!");
    }

    private void setupConfigs() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.saveDefaultConfig();
        this.homesFile = new File(this.getDataFolder(), "homes.yml");
        if (!this.homesFile.exists()) {
            try {
                this.homesFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to create homes.yml: " + e.getMessage());
            }
        }
        this.homesConfig = YamlConfiguration.loadConfiguration((File)this.homesFile);
    }

    private void loadConfigValues() {
        this.maxHomes = this.getConfig().getInt("max-homes", 5);
        this.teleportSafety = this.getConfig().getBoolean("safe-teleport", true);
        this.warpCooldownSeconds = this.getConfig().getInt("warp-cooldown", 10);
        if (this.getConfig().isConfigurationSection("spawn")) {
            for (String worldName : this.getConfig().getConfigurationSection("spawn").getKeys(false)) {
                Location loc = this.getConfig().getLocation("spawn." + worldName);
                if (loc == null) continue;
                this.spawnPoints.put(worldName.toLowerCase(), loc);
            }
        }
    }

    private void loadHomes() {
        if (!this.homesConfig.contains("players")) {
            return;
        }
        for (String uuidStr : this.homesConfig.getConfigurationSection("players").getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(uuidStr);
                PlayerHomes homes = new PlayerHomes(uuid);
                homes.loadFromConfig(this.homesConfig);
                this.playerHomes.put(uuid, homes);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid UUID in homes.yml: " + uuidStr);
            }
        }
    }

    public void saveHomesAsync() {
        new BukkitRunnable(){

            public void run() {
                Essentials999.this.saveHomes();
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private synchronized void saveHomes() {
        this.homesConfig.set("players", null);
        this.playerHomes.forEach((uuid, homes) -> homes.saveToConfig(this.homesConfig));
        try {
            this.homesConfig.save(this.homesFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save homes.yml: " + e.getMessage());
        }
    }

    public Location getSpawnForWorld(String worldName) {
        return this.spawnPoints.get(worldName.toLowerCase());
    }

    public void setSpawnForWorld(String worldName, Location location) {
        this.spawnPoints.put(worldName.toLowerCase(), location);
        this.getConfig().set("spawn." + worldName.toLowerCase(), (Object)location);
        this.saveConfig();
    }

    private void registerCommands() {
        HomeCommandExecutor executor = new HomeCommandExecutor(this);
        this.registerCommand("sethome", executor);
        this.registerCommand("rtp", executor);
        this.registerCommand("delhome", executor);
        this.registerCommand("home", executor);
        this.registerCommand("homes", executor);
        this.registerCommand("back", executor);
        this.registerCommand("setspawn", executor);
        this.registerCommand("spawn", executor);
        this.registerCommand("setwarp", executor);
        this.registerCommand("delwarp", executor);
        this.registerCommand("warp", executor);
        this.registerCommand("warps", executor);
        this.registerCommand("tpask", executor);
        this.registerCommand("tpahere", executor);
        this.registerCommand("tpaccept", executor);
        this.registerCommand("tpdeny", executor);
    }

    private void registerCommand(String name, HomeCommandExecutor executor) {
        Objects.requireNonNull(this.getCommand(name)).setExecutor((CommandExecutor)executor);
        Objects.requireNonNull(this.getCommand(name)).setTabCompleter((TabCompleter)executor);
    }

    public static class WarpsManager {
        private final Essentials999 plugin;
        private final Map<String, Location> warps = new ConcurrentHashMap<String, Location>();
        private File warpsFile;
        private YamlConfiguration warpsConfig;

        public WarpsManager(Essentials999 plugin) {
            this.plugin = plugin;
            this.warpsFile = new File(plugin.getDataFolder(), "warps.yml");
            if (!this.warpsFile.exists()) {
                try {
                    this.warpsFile.createNewFile();
                }
                catch (IOException e) {
                    plugin.getLogger().severe("Failed to create warps.yml: " + e.getMessage());
                }
            }
            this.warpsConfig = YamlConfiguration.loadConfiguration((File)this.warpsFile);
        }

        public void loadWarps() {
            if (!this.warpsConfig.contains("warps")) {
                return;
            }
            for (String warpName : this.warpsConfig.getConfigurationSection("warps").getKeys(false)) {
                Location loc = this.warpsConfig.getLocation("warps." + warpName);
                if (loc == null) continue;
                this.warps.put(warpName.toLowerCase(), loc);
            }
        }

        public void saveWarpsAsync() {
            new BukkitRunnable(){

                public void run() {
                    this.saveWarps();
                }
            }.runTaskAsynchronously((Plugin)this.plugin);
        }

        private synchronized void saveWarps() {
            this.warpsConfig.set("warps", null);
            this.warps.forEach((name, loc) -> this.warpsConfig.set("warps." + name, loc));
            try {
                this.warpsConfig.save(this.warpsFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to save warps.yml: " + e.getMessage());
            }
        }

        public boolean setWarp(String name, Location location) {
            this.warps.put(name.toLowerCase(), location);
            this.saveWarpsAsync();
            return true;
        }

        public boolean deleteWarp(String name) {
            if (this.warps.remove(name.toLowerCase()) != null) {
                this.saveWarpsAsync();
                return true;
            }
            return false;
        }

        public Location getWarp(String name) {
            return this.warps.get(name.toLowerCase());
        }

        public Set<String> getWarpNames() {
            return this.warps.keySet();
        }
    }

    public static class PlayerEventListener
    implements Listener {
        private final Essentials999 plugin;
        private final Map<String, RTPConfigData> rtpWorldConfigs = new HashMap<String, RTPConfigData>();
        private final Set<Material> rtpUnsafeBlocks = new HashSet<Material>();
        private final Set<Material> rtpSolidBlocks = new HashSet<Material>();
        private final Map<UUID, Long> rtpCooldowns = new ConcurrentHashMap<UUID, Long>();
        private Set<String> rtpDisabledWorlds = new HashSet<String>();
        private RTPConfigData globalRtpDefaults = new RTPConfigData();

        public PlayerEventListener(Essentials999 plugin) {
            this.plugin = plugin;
        }

        @EventHandler
        public void onPlayerTeleport(PlayerTeleportEvent event) {
            this.plugin.lastLocations.put(event.getPlayer().getUniqueId(), event.getFrom());
        }

        @EventHandler
        public void onPlayerDeath(PlayerDeathEvent event) {
            this.plugin.lastLocations.put(event.getEntity().getUniqueId(), event.getEntity().getLocation());
        }

        public void loadRTPConfig() {
            FileConfiguration config = this.plugin.getConfig();
            this.globalRtpDefaults.range = config.getInt("range", 1000);
            this.globalRtpDefaults.maxAttempts = config.getInt("max-attempts", 15);
            this.globalRtpDefaults.cooldownSeconds = config.getInt("cooldown-seconds", 60);
            this.globalRtpDefaults.minYLevel = config.getInt("min-y-level", 80);
            this.globalRtpDefaults.checkCaves = config.getBoolean("check-caves", true);
            this.globalRtpDefaults.allowNether = config.getBoolean("allow-nether", false);
            this.globalRtpDefaults.allowEnd = config.getBoolean("allow-end", false);
            this.rtpDisabledWorlds = new HashSet<String>(config.getStringList("disabled-worlds"));
            this.rtpWorldConfigs.clear();
            ConfigurationSection worldsSec = config.getConfigurationSection("worlds");
            if (worldsSec != null) {
                for (String worldName : worldsSec.getKeys(false)) {
                    ConfigurationSection w = worldsSec.getConfigurationSection(worldName);
                    if (w == null) continue;
                    RTPConfigData data = new RTPConfigData();
                    data.enabled = w.getBoolean("enabled", true);
                    data.range = w.getInt("range", this.globalRtpDefaults.range);
                    data.maxAttempts = w.getInt("max-attempts", this.globalRtpDefaults.maxAttempts);
                    data.cooldownSeconds = w.getInt("cooldown-seconds", this.globalRtpDefaults.cooldownSeconds);
                    data.minYLevel = w.getInt("min-y-level", this.globalRtpDefaults.minYLevel);
                    data.checkCaves = w.getBoolean("check-caves", this.globalRtpDefaults.checkCaves);
                    data.allowNether = w.getBoolean("allow-nether", this.globalRtpDefaults.allowNether);
                    data.allowEnd = w.getBoolean("allow-end", this.globalRtpDefaults.allowEnd);
                    this.rtpWorldConfigs.put(worldName, data);
                }
            }
            this.rtpUnsafeBlocks.clear();
            Collections.addAll(this.rtpUnsafeBlocks, Material.LAVA, Material.CACTUS, Material.FIRE, Material.SOUL_FIRE, Material.MAGMA_BLOCK, Material.SWEET_BERRY_BUSH, Material.COBWEB, Material.POWDER_SNOW, Material.WATER, Material.WHITE_CARPET, Material.OAK_LEAVES, Material.SPRUCE_LEAVES, Material.BIRCH_LEAVES, Material.JUNGLE_LEAVES, Material.ACACIA_LEAVES, Material.DARK_OAK_LEAVES);
            this.rtpSolidBlocks.clear();
            Collections.addAll(this.rtpSolidBlocks, Material.GRASS_BLOCK, Material.DIRT, Material.STONE, Material.SAND, Material.GRAVEL, Material.COBBLESTONE, Material.OAK_PLANKS, Material.BEDROCK, Material.NETHERRACK, Material.END_STONE, Material.TERRACOTTA, Material.CLAY, Material.DEEPSLATE, Material.SANDSTONE, Material.MYCELIUM, Material.PODZOL, Material.SOUL_SAND, Material.SOUL_SOIL, Material.BASALT, Material.BLACKSTONE, Material.POLISHED_BLACKSTONE, Material.QUARTZ_BLOCK, Material.OBSIDIAN, Material.COPPER_BLOCK, Material.ENCHANTING_TABLE, Material.BOOKSHELF);
        }

        public Location findSafeLocation(Location origin, World world, RTPConfigData config) {
            int attempts = 0;
            while (attempts < config.maxAttempts) {
                int y;
                ++attempts;
                double angle = ThreadLocalRandom.current().nextDouble(0.0, Math.PI * 2);
                int radius = ThreadLocalRandom.current().nextInt(config.range + 1);
                int x = origin.getBlockX() + (int)(Math.cos(angle) * (double)radius);
                int z = origin.getBlockZ() + (int)(Math.sin(angle) * (double)radius);
                if (world.getEnvironment() == World.Environment.NETHER) {
                    y = -1;
                    boolean foundSafe = false;
                    for (int scanY = 120; scanY >= config.minYLevel; --scanY) {
                        Block groundBlock = world.getBlockAt(x, scanY - 1, z);
                        if (!this.isSolidSafeGround(groundBlock)) continue;
                        Block feetBlock = world.getBlockAt(x, scanY, z);
                        Block headBlock = world.getBlockAt(x, scanY + 1, z);
                        if (!this.isSafeBlock(feetBlock.getType()) || !this.isSafeBlock(headBlock.getType())) continue;
                        y = scanY;
                        foundSafe = true;
                        break;
                    }
                    if (!foundSafe) {
                        continue;
                    }
                } else {
                    Block ground;
                    for (y = world.getHighestBlockYAt(x, z); y > config.minYLevel && !this.isSolidSafeGround(ground = world.getBlockAt(x, y - 1, z)); --y) {
                    }
                    if (y < config.minYLevel) continue;
                    Block feet = world.getBlockAt(x, y, z);
                    Block head = world.getBlockAt(x, y + 1, z);
                    if (!this.isSafeBlock(feet.getType()) || !this.isSafeBlock(head.getType())) continue;
                }
                Location loc = new Location(world, (double)x + 0.5, (double)y + 0.1, (double)z + 0.5);
                if (config.checkCaves && this.isCave(loc, world)) continue;
                return loc;
            }
            return null;
        }

        private boolean isSafeBlock(Material mat) {
            return mat == Material.AIR || !mat.isSolid() && !this.rtpUnsafeBlocks.contains(mat);
        }

        private boolean isSolidSafeGround(Block block) {
            Material mat = block.getType();
            return this.rtpSolidBlocks.contains(mat) || mat.isSolid() && !this.rtpUnsafeBlocks.contains(mat);
        }

        private boolean isCave(Location loc, World world) {
            int x = loc.getBlockX();
            int y = loc.getBlockY();
            int z = loc.getBlockZ();
            boolean hasCeiling = false;
            boolean hasFloor = false;
            for (int up = y + 1; up <= y + 10 && up < world.getMaxHeight(); ++up) {
                if (!world.getBlockAt(x, up, z).getType().isSolid()) continue;
                hasCeiling = true;
                break;
            }
            for (int down = y - 1; down >= 0; --down) {
                if (!world.getBlockAt(x, down, z).getType().isSolid()) continue;
                hasFloor = true;
                break;
            }
            return hasCeiling && hasFloor;
        }

        private static class RTPConfigData {
            boolean enabled = true;
            int range = 1000;
            int maxAttempts = 15;
            int cooldownSeconds = 60;
            int minYLevel = 80;
            boolean checkCaves = true;
            boolean allowNether = false;
            boolean allowEnd = false;

            private RTPConfigData() {
            }
        }
    }

    public class PlayerHomes {
        private final Map<String, Location> homes = new ConcurrentHashMap<String, Location>();
        private final UUID playerId;

        public PlayerHomes(UUID playerId) {
            this.playerId = playerId;
        }

        public boolean setHome(String name, Location location) {
            if (this.homes.size() >= Essentials999.this.maxHomes && !this.homes.containsKey(name.toLowerCase())) {
                return false;
            }
            this.homes.put(name.toLowerCase(), location);
            return true;
        }

        public Location getHome(String name) {
            return this.homes.get(name.toLowerCase());
        }

        public boolean deleteHome(String name) {
            return this.homes.remove(name.toLowerCase()) != null;
        }

        public Set<String> getHomeNames() {
            return this.homes.keySet();
        }

        public void loadFromConfig(YamlConfiguration config) {
            String path = "players." + String.valueOf(this.playerId);
            if (config.isConfigurationSection(path)) {
                for (String homeName : config.getConfigurationSection(path).getKeys(false)) {
                    Location loc = config.getLocation(path + "." + homeName);
                    if (loc == null) continue;
                    this.homes.put(homeName.toLowerCase(), loc);
                }
            }
        }

        public void saveToConfig(YamlConfiguration config) {
            String path = "players." + String.valueOf(this.playerId);
            this.homes.forEach((name, loc) -> config.set(path + "." + name, loc));
        }
    }

    private class HomeCommandExecutor
    implements CommandExecutor,
    TabCompleter {
        private final Essentials999 plugin;

        public HomeCommandExecutor(Essentials999 plugin) {
            this.plugin = plugin;
        }

        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            String cmdName;
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
                return true;
            }
            Player player = (Player)sender;
            switch (cmdName = cmd.getName().toLowerCase()) {
                case "sethome": {
                    return this.setHomeCommand(player, args);
                }
                case "delhome": {
                    return this.deleteHomeCommand(player, args);
                }
                case "home": {
                    return this.homeCommand(player, args);
                }
                case "homes": {
                    return this.listHomesCommand(player);
                }
                case "back": {
                    return this.backCommand(player);
                }
                case "setspawn": {
                    return this.setSpawnCommand(player);
                }
                case "spawn": {
                    return this.spawnCommand(player);
                }
                case "setwarp": {
                    return this.setWarpCommand(player, args);
                }
                case "delwarp": {
                    return this.deleteWarpCommand(player, args);
                }
                case "warp": {
                    return this.warpCommand(player, args);
                }
                case "warps": {
                    return this.listWarpsCommand(player);
                }
                case "tpask": {
                    return this.tpAskCommand(player, args);
                }
                case "tpahere": {
                    return this.tpHereCommand(player, args);
                }
                case "tpaccept": {
                    return this.tpAcceptCommand(player);
                }
                case "tpdeny": {
                    return this.tpDenyCommand(player);
                }
            }
            return false;
        }

        public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
            String cmdName;
            if (!(sender instanceof Player)) {
                return Collections.emptyList();
            }
            Player player = (Player)sender;
            switch (cmdName = cmd.getName().toLowerCase()) {
                case "home": 
                case "delhome": {
                    PlayerHomes homes;
                    if (args.length != 1 || (homes = this.plugin.playerHomes.get(player.getUniqueId())) == null) break;
                    return this.filterStartingWith(homes.getHomeNames(), args[0]);
                }
                case "warp": 
                case "delwarp": {
                    if (args.length != 1) break;
                    return this.filterStartingWith(this.plugin.warpsManager.getWarpNames(), args[0]);
                }
                case "tpask": 
                case "tpahere": {
                    if (args.length != 1) break;
                    ArrayList<String> onlineNames = new ArrayList<String>();
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        if (p.equals((Object)player)) continue;
                        onlineNames.add(p.getName());
                    }
                    return this.filterStartingWith(onlineNames, args[0]);
                }
            }
            return Collections.emptyList();
        }

        private List<String> filterStartingWith(Collection<String> options, String prefix) {
            ArrayList<String> result = new ArrayList<String>();
            String lowerPrefix = prefix.toLowerCase();
            for (String option : options) {
                if (!option.toLowerCase().startsWith(lowerPrefix)) continue;
                result.add(option);
            }
            return result;
        }

        private boolean setHomeCommand(Player player, String[] args) {
            if (!player.hasPermission("essentials999.sethome")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            if (args.length < 1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /sethome <name>");
                return true;
            }
            String homeName = args[0];
            PlayerHomes homes = this.plugin.playerHomes.computeIfAbsent(player.getUniqueId(), k -> new PlayerHomes(player.getUniqueId()));
            if (!homes.setHome(homeName, player.getLocation())) {
                player.sendMessage(String.valueOf(ChatColor.RED) + String.format("You've reached your home limit (%d). Delete another home first.", this.plugin.maxHomes));
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Home '" + homeName + "' set successfully!");
            this.plugin.saveHomesAsync();
            return true;
        }

        private boolean deleteHomeCommand(Player player, String[] args) {
            if (!player.hasPermission("essentials999.delhome")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            if (args.length < 1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /delhome <name>");
                return true;
            }
            String homeName = args[0];
            PlayerHomes homes = this.plugin.playerHomes.get(player.getUniqueId());
            if (homes == null || !homes.deleteHome(homeName)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Home '" + homeName + "' doesn't exist.");
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Home '" + homeName + "' deleted successfully!");
            this.plugin.saveHomesAsync();
            return true;
        }

        private boolean homeCommand(Player player, String[] args) {
            Location homeLoc;
            if (!player.hasPermission("essentials999.home")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            if (args.length < 1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /home <name>");
                return true;
            }
            String homeName = args[0];
            PlayerHomes homes = this.plugin.playerHomes.get(player.getUniqueId());
            Location location = homeLoc = homes != null ? homes.getHome(homeName) : null;
            if (homeLoc == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Home '" + homeName + "' doesn't exist.");
                return true;
            }
            this.teleportPlayerSafe(player, homeLoc, "home '" + homeName + "'");
            return true;
        }

        private boolean listHomesCommand(Player player) {
            if (!player.hasPermission("essentials999.homes")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            PlayerHomes homes = this.plugin.playerHomes.get(player.getUniqueId());
            if (homes == null || homes.getHomeNames().isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have any homes.");
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your homes: " + String.join((CharSequence)", ", homes.getHomeNames()));
            return true;
        }

        private boolean backCommand(Player player) {
            if (!player.hasPermission("essentials999.back")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            Location lastLocation = this.plugin.lastLocations.get(player.getUniqueId());
            if (lastLocation == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "No previous location found.");
                return true;
            }
            this.teleportPlayerSafe(player, lastLocation, "last location");
            return true;
        }

        private boolean setSpawnCommand(Player player) {
            if (!player.hasPermission("essentials999.setspawn")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            Location loc = player.getLocation();
            String worldName = loc.getWorld().getName().toLowerCase();
            this.plugin.setSpawnForWorld(worldName, loc);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Spawn point set for world '" + worldName + "' successfully!");
            return true;
        }

        private boolean spawnCommand(Player player) {
            if (!player.hasPermission("essentials999.spawn")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            String worldName = player.getWorld().getName().toLowerCase();
            Location spawnLoc = this.plugin.getSpawnForWorld(worldName);
            if (spawnLoc == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Spawn point has not been set for this world.");
                return true;
            }
            this.teleportPlayerSafe(player, spawnLoc, "spawn");
            return true;
        }

        private boolean setWarpCommand(Player player, String[] args) {
            if (!player.hasPermission("essentials999.setwarp")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            if (args.length < 1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /setwarp <name>");
                return true;
            }
            String warpName = args[0];
            Location loc = player.getLocation();
            this.plugin.warpsManager.setWarp(warpName, loc);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Warp '" + warpName + "' set successfully!");
            return true;
        }

        private boolean deleteWarpCommand(Player player, String[] args) {
            if (!player.hasPermission("essentials999.delwarp")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            if (args.length < 1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /delwarp <name>");
                return true;
            }
            String warpName = args[0];
            if (!this.plugin.warpsManager.deleteWarp(warpName)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Warp '" + warpName + "' doesn't exist.");
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Warp '" + warpName + "' deleted successfully!");
            return true;
        }

        private boolean warpCommand(Player player, String[] args) {
            long cooldownMillis;
            if (!player.hasPermission("essentials999.warp")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            if (args.length < 1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /warp <name>");
                return true;
            }
            String warpName = args[0];
            Location warpLoc = this.plugin.warpsManager.getWarp(warpName);
            if (warpLoc == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Warp '" + warpName + "' doesn't exist.");
                return true;
            }
            long lastWarpTime = Essentials999.this.warpCooldowns.getOrDefault(player.getUniqueId(), 0L);
            long now = System.currentTimeMillis();
            long elapsed = now - lastWarpTime;
            if (elapsed < (cooldownMillis = (long)this.plugin.warpCooldownSeconds * 1000L)) {
                long timeLeft = (cooldownMillis - elapsed) / 1000L;
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait " + timeLeft + " seconds before warping again.");
                return true;
            }
            Essentials999.this.warpCooldowns.put(player.getUniqueId(), now);
            this.teleportPlayerSafe(player, warpLoc, "warp '" + warpName + "'");
            return true;
        }

        private boolean listWarpsCommand(Player player) {
            if (!player.hasPermission("essentials999.warps")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            Set<String> warps = this.plugin.warpsManager.getWarpNames();
            if (warps.isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "No warps have been set.");
                return true;
            }
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Available warps: " + String.join((CharSequence)", ", warps));
            return true;
        }

        private boolean tpAskCommand(Player player, String[] args) {
            if (!player.hasPermission("essentials999.tpask")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            if (args.length < 1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /tpask <playername>");
                return true;
            }
            Player target = Bukkit.getPlayerExact((String)args[0]);
            if (target == null || !target.isOnline()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                return true;
            }
            if (target.equals((Object)player)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot send a teleport request to yourself.");
                return true;
            }
            Essentials999.this.tpRequests.put(target.getUniqueId(), player.getUniqueId());
            Essentials999.this.tpDenied.remove(target.getUniqueId());
            target.sendMessage(String.valueOf(ChatColor.YELLOW) + player.getName() + " has requested to teleport to you. Use /tpaccept to accept or /tpdeny to deny.");
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleport request sent to " + target.getName() + ".");
            return true;
        }

        private boolean tpHereCommand(Player player, String[] args) {
            if (!player.hasPermission("essentials999.tpahere")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            if (args.length < 1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /tpahere <playername>");
                return true;
            }
            Player target = Bukkit.getPlayerExact((String)args[0]);
            if (target == null || !target.isOnline()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                return true;
            }
            if (target.equals((Object)player)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot send a teleport request to yourself.");
                return true;
            }
            Essentials999.this.tpRequests.put(target.getUniqueId(), player.getUniqueId());
            Essentials999.this.tpDenied.remove(target.getUniqueId());
            target.sendMessage(String.valueOf(ChatColor.YELLOW) + player.getName() + " has requested you to teleport to them. Use /tpaccept to accept or /tpdeny to deny.");
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleport request sent to " + target.getName() + ".");
            return true;
        }

        private boolean tpAcceptCommand(Player player) {
            if (!player.hasPermission("essentials999.tpaccept")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            UUID requesterId = Essentials999.this.tpRequests.remove(player.getUniqueId());
            if (requesterId == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You have no pending teleport requests.");
                return true;
            }
            if (Essentials999.this.tpDenied.containsKey(player.getUniqueId()) && Essentials999.this.tpDenied.get(player.getUniqueId()).equals(requesterId)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You have denied this teleport request.");
                Essentials999.this.tpDenied.remove(player.getUniqueId());
                return true;
            }
            Player requester = Bukkit.getPlayer((UUID)requesterId);
            if (requester != null && requester.isOnline()) {
                requester.teleport(player.getLocation());
                requester.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been teleported to " + player.getName() + "!");
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have accepted the teleport request from " + requester.getName() + "!");
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "The player who requested to teleport is no longer online.");
            }
            return true;
        }

        private boolean tpDenyCommand(Player player) {
            if (!player.hasPermission("essentials999.tpdeny")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            UUID requesterId = Essentials999.this.tpRequests.remove(player.getUniqueId());
            if (requesterId == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You have no pending teleport requests.");
                return true;
            }
            Essentials999.this.tpDenied.put(player.getUniqueId(), requesterId);
            Player requester = Bukkit.getPlayer((UUID)requesterId);
            if (requester != null && requester.isOnline()) {
                requester.sendMessage(String.valueOf(ChatColor.RED) + player.getName() + " has denied your teleport request.");
            }
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleport request denied.");
            return true;
        }

        private void teleportPlayerSafe(final Player player, final Location targetLoc, final String destinationName) {
            new BukkitRunnable(){

                public void run() {
                    int chunkZ;
                    World world = targetLoc.getWorld();
                    if (world == null) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid world for teleport.");
                        return;
                    }
                    int chunkX = targetLoc.getBlockX() >> 4;
                    if (!world.isChunkLoaded(chunkX, chunkZ = targetLoc.getBlockZ() >> 4)) {
                        world.loadChunk(chunkX, chunkZ);
                    }
                    Location safeLoc = targetLoc.clone().add(0.5, 0.0, 0.5);
                    if (Essentials999.this.teleportSafety && !HomeCommandExecutor.this.isSafeLocation(safeLoc)) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Cannot teleport to " + destinationName + " because the location is unsafe.");
                        return;
                    }
                    HomeCommandExecutor.this.plugin.lastLocations.put(player.getUniqueId(), player.getLocation());
                    player.teleport(safeLoc);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleported to " + destinationName + "!");
                }
            }.runTask((Plugin)this.plugin);
        }

        private boolean isSafeLocation(Location loc) {
            if (loc == null) {
                return false;
            }
            World world = loc.getWorld();
            if (world == null) {
                return false;
            }
            Location feet = loc.clone();
            Location head = loc.clone().add(0.0, 1.0, 0.0);
            return !feet.getBlock().getType().isSolid() && !head.getBlock().getType().isSolid();
        }
    }
}

