/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.essentials999;

import com.yourname.essentials999.EssentialsCommands;
import com.yourname.essentials999.Kit;
import com.yourname.essentials999.KitManager;
import com.yourname.essentials999.PlayerHomes;
import com.yourname.essentials999.WarpsManager;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Essentials999
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private final Map<UUID, PlayerHomes> playerHomes = new ConcurrentHashMap<UUID, PlayerHomes>();
    private final Map<UUID, Location> lastLocations = new ConcurrentHashMap<UUID, Location>();
    private final Map<UUID, Long> warpCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, UUID> tpRequests = new ConcurrentHashMap<UUID, UUID>();
    private final Map<UUID, Boolean> tpHereRequests = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, UUID> tpDenied = new ConcurrentHashMap<UUID, UUID>();
    private final Map<String, Location> spawnPoints = new ConcurrentHashMap<String, Location>();
    private File homesFile;
    private YamlConfiguration homesConfig;
    private WarpsManager warpsManager;
    private KitManager kitManager;
    private EssentialsCommands essentialsCommands;
    int maxHomes;
    private boolean teleportSafety;
    private int warpCooldownSeconds;
    private int teleportCountdownSeconds;
    private final Map<UUID, BukkitTask> teleportCountdownTasks = new ConcurrentHashMap<UUID, BukkitTask>();
    private final Map<String, Map<String, Object>> rtpWorldConfigs = new HashMap<String, Map<String, Object>>();
    private boolean globalRtpEnabled;
    private int globalRtpRange;
    private int globalRtpMaxAttempts;
    private int globalRtpCooldownSeconds;
    private int globalRtpMinYLevel;
    private boolean globalRtpCheckCaves;
    private boolean globalRtpAllowNether;
    private boolean globalRtpAllowEnd;
    private String globalRtpBiome;
    private boolean globalRtpCheckWorldBorder;
    private final Set<Material> rtpUnsafeBlocks = new HashSet<Material>();
    private final Set<Material> rtpSolidBlocks = new HashSet<Material>();
    private final Map<UUID, Long> rtpCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, String> pendingDeleteHome = new HashMap<UUID, String>();
    private final Map<UUID, String> pendingDeleteWarp = new HashMap<UUID, String>();
    private final Map<UUID, BukkitTask> teleportRequestExpireTasks = new HashMap<UUID, BukkitTask>();
    private final Set<UUID> tpGuiEnabledPlayers = new HashSet<UUID>();
    private final Map<UUID, Integer> homesGuiPage = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Integer> warpsGuiPage = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Integer> kitsGuiPage = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Location> jailedPlayers = new ConcurrentHashMap<UUID, Location>();
    private final Map<UUID, BukkitTask> jailTasks = new ConcurrentHashMap<UUID, BukkitTask>();
    private final Map<UUID, Map<String, Long>> kitCooldowns = new ConcurrentHashMap<UUID, Map<String, Long>>();
    private final Set<UUID> flyingPlayers = ConcurrentHashMap.newKeySet();
    private final Set<UUID> godPlayers = ConcurrentHashMap.newKeySet();
    private final Set<UUID> vanishedPlayers = ConcurrentHashMap.newKeySet();
    private final Map<UUID, String> nicknames = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Long> mutedPlayers = new ConcurrentHashMap<UUID, Long>();

    public WarpsManager getWarpsManager() {
        return this.warpsManager;
    }

    public KitManager getKitManager() {
        return this.kitManager;
    }

    public void onEnable() {
        this.setupConfigs();
        this.loadConfigValues();
        this.loadHomes();
        this.warpsManager = new WarpsManager(this);
        this.warpsManager.loadWarps();
        this.kitManager = new KitManager(this);
        this.loadRTPConfig();
        this.essentialsCommands = new EssentialsCommands(this, this.flyingPlayers, this.godPlayers, this.vanishedPlayers, this.tpRequests, this.tpHereRequests, this.tpDenied, this.nicknames, this.mutedPlayers);
        this.registerCommands();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.essentialsCommands, (Plugin)this);
        this.getLogger().info(String.valueOf(ChatColor.GREEN) + "Essentials999 v1.0.5 enabled!");
    }

    public void onDisable() {
        this.saveHomesAsync();
        this.warpsManager.saveWarpsAsync();
        this.getLogger().info(String.valueOf(ChatColor.RED) + "Essentials999 v1.0.4 disabled!");
    }

    private void setupConfigs() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.saveDefaultConfig();
        this.homesFile = new File(this.getDataFolder(), "homes.yml");
        if (!this.homesFile.exists()) {
            try {
                this.homesFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to create homes.yml: " + e.getMessage());
            }
        }
        this.homesConfig = YamlConfiguration.loadConfiguration((File)this.homesFile);
    }

    private void loadConfigValues() {
        this.maxHomes = this.getConfig().getInt("max-homes", 5);
        this.teleportSafety = this.getConfig().getBoolean("safe-teleport", true);
        this.warpCooldownSeconds = this.getConfig().getInt("warp-cooldown", 10);
        this.teleportCountdownSeconds = this.getConfig().getInt("teleport-countdown-seconds", 5);
        if (this.getConfig().isConfigurationSection("spawn")) {
            for (String worldName : this.getConfig().getConfigurationSection("spawn").getKeys(false)) {
                Location loc = this.getConfig().getLocation("spawn." + worldName);
                if (loc == null) continue;
                this.spawnPoints.put(worldName.toLowerCase(), loc);
            }
        }
    }

    private void loadHomes() {
        if (!this.homesConfig.contains("players")) {
            return;
        }
        for (String uuidStr : this.homesConfig.getConfigurationSection("players").getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(uuidStr);
                PlayerHomes homes = new PlayerHomes(uuid, this.maxHomes);
                homes.loadFromConfig(this.homesConfig);
                this.playerHomes.put(uuid, homes);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid UUID in homes.yml: " + uuidStr);
            }
        }
    }

    public void saveHomesAsync() {
        new BukkitRunnable(){

            public void run() {
                Essentials999.this.saveHomes();
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private synchronized void saveHomes() {
        this.homesConfig.set("players", null);
        this.playerHomes.forEach((uuid, homes) -> homes.saveToConfig(this.homesConfig));
        try {
            this.homesConfig.save(this.homesFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save homes.yml: " + e.getMessage());
        }
    }

    private void loadRTPConfig() {
        FileConfiguration config = this.getConfig();
        this.globalRtpEnabled = config.getBoolean("rtp.enabled", true);
        this.globalRtpRange = config.getInt("rtp.range", 1000);
        this.globalRtpMaxAttempts = config.getInt("rtp.max-attempts", 15);
        this.globalRtpCooldownSeconds = config.getInt("rtp.cooldown-seconds", 60);
        this.globalRtpMinYLevel = config.getInt("rtp.min-y-level", 80);
        this.globalRtpCheckCaves = config.getBoolean("rtp.check-caves", true);
        this.globalRtpAllowNether = config.getBoolean("rtp.allow-nether", false);
        this.globalRtpAllowEnd = config.getBoolean("rtp.allow-end", false);
        this.globalRtpBiome = config.getString("rtp.biome", "");
        this.globalRtpCheckWorldBorder = config.getBoolean("rtp.check-world-border", true);
        this.rtpWorldConfigs.clear();
        ConfigurationSection worldsSec = config.getConfigurationSection("rtp.worlds");
        if (worldsSec != null) {
            for (String worldName : worldsSec.getKeys(false)) {
                ConfigurationSection w = worldsSec.getConfigurationSection(worldName);
                if (w == null) continue;
                HashMap<String, Object> worldConfig = new HashMap<String, Object>();
                worldConfig.put("enabled", w.getBoolean("enabled", true));
                worldConfig.put("range", w.getInt("range", this.globalRtpRange));
                worldConfig.put("max-attempts", w.getInt("max-attempts", this.globalRtpMaxAttempts));
                worldConfig.put("cooldown-seconds", w.getInt("cooldown-seconds", this.globalRtpCooldownSeconds));
                worldConfig.put("min-y-level", w.getInt("min-y-level", this.globalRtpMinYLevel));
                worldConfig.put("check-caves", w.getBoolean("check-caves", this.globalRtpCheckCaves));
                worldConfig.put("allow-nether", w.getBoolean("allow-nether", this.globalRtpAllowNether));
                worldConfig.put("allow-end", w.getBoolean("allow-end", this.globalRtpAllowEnd));
                worldConfig.put("biome", w.getString("biome", this.globalRtpBiome));
                worldConfig.put("check-world-border", w.getBoolean("check-world-border", this.globalRtpCheckWorldBorder));
                this.rtpWorldConfigs.put(worldName, worldConfig);
            }
        }
        this.rtpUnsafeBlocks.clear();
        Collections.addAll(this.rtpUnsafeBlocks, Material.LAVA, Material.CACTUS, Material.FIRE, Material.SOUL_FIRE, Material.MAGMA_BLOCK, Material.SWEET_BERRY_BUSH, Material.COBWEB, Material.POWDER_SNOW, Material.WATER, Material.WHITE_CARPET, Material.OAK_LEAVES, Material.SPRUCE_LEAVES, Material.BIRCH_LEAVES, Material.JUNGLE_LEAVES, Material.ACACIA_LEAVES, Material.DARK_OAK_LEAVES);
        this.rtpSolidBlocks.clear();
        Collections.addAll(this.rtpSolidBlocks, Material.GRASS_BLOCK, Material.DIRT, Material.STONE, Material.SAND, Material.GRAVEL, Material.COBBLESTONE, Material.OAK_PLANKS, Material.BEDROCK, Material.NETHERRACK, Material.END_STONE, Material.TERRACOTTA, Material.CLAY, Material.DEEPSLATE, Material.SANDSTONE, Material.MYCELIUM, Material.PODZOL, Material.SOUL_SAND, Material.SOUL_SOIL, Material.BASALT, Material.BLACKSTONE, Material.POLISHED_BLACKSTONE, Material.QUARTZ_BLOCK, Material.OBSIDIAN, Material.COPPER_BLOCK, Material.ENCHANTING_TABLE, Material.BOOKSHELF);
    }

    private void registerCommands() {
        String[] commands;
        for (String cmd : commands = new String[]{"sethome", "rtp", "delhome", "home", "homes", "back", "setspawn", "spawn", "setwarp", "delwarp", "warp", "warps", "tpask", "tpahere", "tpaccept", "tpdeny", "tpgui", "essentials999", "seen", "whois", "heal", "feed", "jail", "kit", "kits", "fly", "god", "vanish", "tpaall", "broadcast", "day", "night", "weather", "nick", "mute", "unmute"}) {
            Objects.requireNonNull(this.getCommand(cmd)).setExecutor((CommandExecutor)this);
            Objects.requireNonNull(this.getCommand(cmd)).setTabCompleter((TabCompleter)this);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String cmdName;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        switch (cmdName = cmd.getName().toLowerCase()) {
            case "sethome": {
                return this.setHomeCommand(player, args);
            }
            case "delhome": {
                return this.deleteHomeCommand(player, args);
            }
            case "home": {
                return this.homeCommand(player, args);
            }
            case "homes": {
                return this.openHomesGUI(player, 0);
            }
            case "back": {
                return this.backCommand(player);
            }
            case "setspawn": {
                return this.setSpawnCommand(player);
            }
            case "spawn": {
                return this.spawnCommand(player);
            }
            case "setwarp": {
                return this.setWarpCommand(player, args);
            }
            case "delwarp": {
                return this.deleteWarpCommand(player, args);
            }
            case "warp": {
                return this.warpCommand(player, args);
            }
            case "warps": {
                return this.openWarpsGUI(player, 0);
            }
            case "tpask": {
                return this.tpAskCommand(player, args);
            }
            case "tpahere": {
                return this.tpHereCommand(player, args);
            }
            case "tpaccept": {
                return this.tpAcceptCommand(player);
            }
            case "tpdeny": {
                return this.tpDenyCommand(player);
            }
            case "tpgui": {
                return this.toggleTpGui(player, args);
            }
            case "essentials999": {
                if (args.length > 0 && args[0].equalsIgnoreCase("help")) {
                    return this.openHelpGUI(player);
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown command. Use /essentials999 help for a list of commands.");
                return true;
            }
            case "rtp": {
                return this.rtpCommand(player, args);
            }
            case "seen": {
                return this.seenCommand(player, args);
            }
            case "whois": {
                return this.whoisCommand(player, args);
            }
            case "heal": {
                return this.healCommand(player, args);
            }
            case "feed": {
                return this.feedCommand(player, args);
            }
            case "jail": {
                return this.jailCommand(player, args);
            }
            case "kit": {
                return this.kitCommand(player, args);
            }
            case "kits": {
                return this.kitsCommand(player, args);
            }
            case "fly": {
                return this.essentialsCommands.flyCommand(player, args);
            }
            case "god": {
                return this.essentialsCommands.godCommand(player, args);
            }
            case "vanish": {
                return this.essentialsCommands.vanishCommand(player, args);
            }
            case "tpaall": {
                return this.essentialsCommands.tpaallCommand(player);
            }
            case "broadcast": {
                return this.essentialsCommands.broadcastCommand(player, args);
            }
            case "day": {
                return this.essentialsCommands.timeCommand(player, "day");
            }
            case "night": {
                return this.essentialsCommands.timeCommand(player, "night");
            }
            case "weather": {
                return this.essentialsCommands.weatherCommand(player, args);
            }
            case "nick": {
                return this.essentialsCommands.nickCommand(player, args);
            }
            case "mute": {
                return this.essentialsCommands.muteCommand(player, args);
            }
            case "unmute": {
                return this.essentialsCommands.unmuteCommand(player, args);
            }
        }
        player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown command. Use /essentials999 help for a list of commands.");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        String cmdName;
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        switch (cmdName = cmd.getName().toLowerCase()) {
            case "home": 
            case "delhome": {
                PlayerHomes homes;
                if (args.length != 1 || (homes = this.playerHomes.get(player.getUniqueId())) == null) break;
                return this.filterStartingWith(homes.getHomeNames(), args[0]);
            }
            case "warp": 
            case "delwarp": {
                if (args.length != 1) break;
                return this.filterStartingWith(this.warpsManager.getWarpNames(), args[0]);
            }
            case "tpask": 
            case "tpahere": {
                if (args.length != 1) break;
                ArrayList<String> onlineNames = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (p.equals((Object)player)) continue;
                    onlineNames.add(p.getName());
                }
                return this.filterStartingWith(onlineNames, args[0]);
            }
            case "tpgui": {
                if (args.length != 1) break;
                return this.filterStartingWith(Collections.singletonList("toggle"), args[0]);
            }
        }
        return Collections.emptyList();
    }

    private List<String> filterStartingWith(Collection<String> options, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        String lowerPrefix = prefix.toLowerCase();
        for (String option : options) {
            if (!option.toLowerCase().startsWith(lowerPrefix)) continue;
            result.add(option);
        }
        return result;
    }

    private boolean setHomeCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.sethome")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /sethome <name>");
            return true;
        }
        String homeName = args[0];
        PlayerHomes homes = this.playerHomes.computeIfAbsent(player.getUniqueId(), k -> new PlayerHomes(player.getUniqueId(), this.maxHomes));
        if (!homes.setHome(homeName, player.getLocation())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You've reached your home limit (" + this.maxHomes + "). Delete another home first.");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Home '" + homeName + "' set successfully!");
        this.saveHomesAsync();
        return true;
    }

    private boolean deleteHomeCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.delhome")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /delhome <name>");
            return true;
        }
        String homeName = args[0];
        PlayerHomes homes = this.playerHomes.get(player.getUniqueId());
        if (homes == null || !homes.deleteHome(homeName)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Home '" + homeName + "' doesn't exist.");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Home '" + homeName + "' deleted successfully!");
        this.saveHomesAsync();
        return true;
    }

    private boolean homeCommand(Player player, String[] args) {
        int chunkZ;
        Location homeLoc;
        if (!player.hasPermission("essentials999.home")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /home <name>");
            return true;
        }
        String homeName = args[0];
        PlayerHomes homes = this.playerHomes.get(player.getUniqueId());
        Location location = homeLoc = homes != null ? homes.getHome(homeName) : null;
        if (homeLoc == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Home '" + homeName + "' doesn't exist.");
            return true;
        }
        World world = homeLoc.getWorld();
        if (world == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid world for teleport.");
            return true;
        }
        int chunkX = homeLoc.getBlockX() >> 4;
        if (!world.isChunkLoaded(chunkX, chunkZ = homeLoc.getBlockZ() >> 4)) {
            world.loadChunk(chunkX, chunkZ);
        }
        Location safeLoc = homeLoc.clone().add(0.5, 0.0, 0.5);
        if (this.teleportSafety && !this.isSafeLocation(safeLoc)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Cannot teleport to home '" + homeName + "' because the location is unsafe.");
            return true;
        }
        this.startTeleportCountdown(player, safeLoc, "home '" + homeName + "'");
        return true;
    }

    private boolean backCommand(Player player) {
        int chunkZ;
        if (!player.hasPermission("essentials999.back")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        Location lastLocation = this.lastLocations.get(player.getUniqueId());
        if (lastLocation == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No previous location found.");
            return true;
        }
        World world = lastLocation.getWorld();
        if (world == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid world for teleport.");
            return true;
        }
        int chunkX = lastLocation.getBlockX() >> 4;
        if (!world.isChunkLoaded(chunkX, chunkZ = lastLocation.getBlockZ() >> 4)) {
            world.loadChunk(chunkX, chunkZ);
        }
        Location safeLoc = lastLocation.clone().add(0.5, 0.0, 0.5);
        if (this.teleportSafety && !this.isSafeLocation(safeLoc)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Cannot teleport to last location because the location is unsafe.");
            return true;
        }
        this.startTeleportCountdown(player, safeLoc, "last location");
        return true;
    }

    private boolean setSpawnCommand(Player player) {
        if (!player.hasPermission("essentials999.setspawn")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        Location loc = player.getLocation();
        String worldName = loc.getWorld().getName().toLowerCase();
        this.spawnPoints.put(worldName, loc);
        this.getConfig().set("spawn." + worldName, (Object)loc);
        this.saveConfig();
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Spawn point set for world '" + worldName + "' successfully!");
        return true;
    }

    private boolean spawnCommand(Player player) {
        int chunkZ;
        if (!player.hasPermission("essentials999.spawn")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        String worldName = player.getWorld().getName().toLowerCase();
        Location spawnLoc = this.spawnPoints.get(worldName);
        if (spawnLoc == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Spawn point has not been set for this world.");
            return true;
        }
        World world = spawnLoc.getWorld();
        if (world == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid world for teleport.");
            return true;
        }
        int chunkX = spawnLoc.getBlockX() >> 4;
        if (!world.isChunkLoaded(chunkX, chunkZ = spawnLoc.getBlockZ() >> 4)) {
            world.loadChunk(chunkX, chunkZ);
        }
        Location safeLoc = spawnLoc.clone().add(0.5, 0.0, 0.5);
        if (this.teleportSafety && !this.isSafeLocation(safeLoc)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Cannot teleport to spawn because the location is unsafe.");
            return true;
        }
        this.startTeleportCountdown(player, safeLoc, "spawn");
        return true;
    }

    private boolean setWarpCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.setwarp")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /setwarp <name>");
            return true;
        }
        String warpName = args[0];
        this.warpsManager.setWarp(warpName, player.getLocation());
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Warp '" + warpName + "' set successfully!");
        return true;
    }

    private boolean deleteWarpCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.delwarp")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /delwarp <name>");
            return true;
        }
        String warpName = args[0];
        if (!this.warpsManager.deleteWarp(warpName)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Warp '" + warpName + "' doesn't exist.");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Warp '" + warpName + "' deleted successfully!");
        return true;
    }

    private boolean warpCommand(Player player, String[] args) {
        int chunkZ;
        long cooldownMillis;
        if (!player.hasPermission("essentials999.warp")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /warp <name>");
            return true;
        }
        String warpName = args[0];
        Location warpLoc = this.warpsManager.getWarp(warpName);
        if (warpLoc == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Warp '" + warpName + "' doesn't exist.");
            return true;
        }
        long lastWarpTime = this.warpCooldowns.getOrDefault(player.getUniqueId(), 0L);
        long now = System.currentTimeMillis();
        long elapsed = now - lastWarpTime;
        if (elapsed < (cooldownMillis = (long)this.warpCooldownSeconds * 1000L)) {
            long timeLeft = (cooldownMillis - elapsed) / 1000L;
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait " + timeLeft + " seconds before warping again.");
            return true;
        }
        World world = warpLoc.getWorld();
        if (world == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid world for teleport.");
            return true;
        }
        int chunkX = warpLoc.getBlockX() >> 4;
        if (!world.isChunkLoaded(chunkX, chunkZ = warpLoc.getBlockZ() >> 4)) {
            world.loadChunk(chunkX, chunkZ);
        }
        Location safeLoc = warpLoc.clone().add(0.5, 0.0, 0.5);
        if (this.teleportSafety && !this.isSafeLocation(safeLoc)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Cannot teleport to warp '" + warpName + "' because the location is unsafe.");
            return true;
        }
        this.warpCooldowns.put(player.getUniqueId(), now);
        this.startTeleportCountdown(player, safeLoc, "warp '" + warpName + "'");
        return true;
    }

    private boolean openWarpsGUI(Player player, int page) {
        if (!player.hasPermission("essentials999.warps")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        Set<String> warps = this.warpsManager.getWarpNames();
        if (warps.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No warps have been set.");
            return true;
        }
        ArrayList<String> warpNames = new ArrayList<String>(warps);
        int itemsPerPage = 45;
        int startIndex = page * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, warpNames.size());
        int totalPages = (int)Math.ceil((double)warpNames.size() / (double)itemsPerPage);
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.DARK_AQUA) + "Warps (Page " + (page + 1) + "/" + totalPages + ")"));
        long now = System.currentTimeMillis();
        long cooldownMillis = (long)this.warpCooldownSeconds * 1000L;
        long lastWarpTime = this.warpCooldowns.getOrDefault(player.getUniqueId(), 0L);
        long elapsed = now - lastWarpTime;
        long timeLeft = Math.max(0L, (cooldownMillis - elapsed) / 1000L);
        for (int i = startIndex; i < endIndex; ++i) {
            String warpName = (String)warpNames.get(i);
            Location loc = this.warpsManager.getWarp(warpName);
            if (loc == null) continue;
            ItemStack item = new ItemStack(Material.COMPASS);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + warpName);
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            if (timeLeft > 0L) {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "Cooldown: " + timeLeft + " seconds")));
            } else {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Left-click to warp")));
            }
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "Right-click to delete")));
            meta.setLore(lore);
            item.setItemMeta(meta);
            inv.addItem(new ItemStack[]{item});
        }
        if (page > 0) {
            ItemStack prev = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prev.getItemMeta();
            prevMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Previous Page");
            prev.setItemMeta(prevMeta);
            inv.setItem(45, prev);
        }
        if (page < totalPages - 1) {
            ItemStack next = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = next.getItemMeta();
            nextMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Next Page");
            next.setItemMeta(nextMeta);
            inv.setItem(53, next);
        }
        this.warpsGuiPage.put(player.getUniqueId(), page);
        player.openInventory(inv);
        return true;
    }

    private boolean tpAskCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.tpask")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /tpask <playername>");
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null || !target.isOnline()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        if (target.equals((Object)player)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot send a teleport request to yourself.");
            return true;
        }
        this.tpRequests.put(target.getUniqueId(), player.getUniqueId());
        this.tpHereRequests.put(target.getUniqueId(), false);
        this.tpDenied.remove(target.getUniqueId());
        target.sendMessage(String.valueOf(ChatColor.YELLOW) + player.getName() + " has requested to teleport to you. Use /tpaccept to accept or /tpdeny to deny.");
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleport request sent to " + target.getName() + ".");
        return true;
    }

    private boolean tpHereCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.tpahere")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /tpahere <playername>");
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null || !target.isOnline()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        if (target.equals((Object)player)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot send a teleport request to yourself.");
            return true;
        }
        this.tpRequests.put(target.getUniqueId(), player.getUniqueId());
        this.tpHereRequests.put(target.getUniqueId(), true);
        this.tpDenied.remove(target.getUniqueId());
        target.sendMessage(String.valueOf(ChatColor.YELLOW) + player.getName() + " has requested you to teleport to them. Use /tpaccept to accept or /tpdeny to deny.");
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleport request sent to " + target.getName() + ".");
        return true;
    }

    private boolean tpAcceptCommand(Player player) {
        if (!player.hasPermission("essentials999.tpaccept")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        UUID requesterId = this.tpRequests.remove(player.getUniqueId());
        Boolean isTpHere = this.tpHereRequests.remove(player.getUniqueId());
        if (requesterId == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You have no pending teleport requests.");
            return true;
        }
        if (this.tpDenied.containsKey(player.getUniqueId()) && this.tpDenied.get(player.getUniqueId()).equals(requesterId)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You have denied this teleport request.");
            this.tpDenied.remove(player.getUniqueId());
            return true;
        }
        Player requester = Bukkit.getPlayer((UUID)requesterId);
        if (requester != null && requester.isOnline()) {
            if (isTpHere != null && isTpHere.booleanValue()) {
                player.teleport(requester.getLocation());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been teleported to " + requester.getName() + "!");
                requester.sendMessage(String.valueOf(ChatColor.GREEN) + player.getName() + " has accepted your teleport request!");
            } else {
                requester.teleport(player.getLocation());
                requester.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been teleported to " + player.getName() + "!");
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have accepted the teleport request from " + requester.getName() + "!");
            }
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "The player who requested to teleport is no longer online.");
        }
        return true;
    }

    private boolean tpDenyCommand(Player player) {
        if (!player.hasPermission("essentials999.tpdeny")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        UUID requesterId = this.tpRequests.remove(player.getUniqueId());
        this.tpHereRequests.remove(player.getUniqueId());
        if (requesterId == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You have no pending teleport requests.");
            return true;
        }
        this.tpDenied.put(player.getUniqueId(), requesterId);
        Player requester = Bukkit.getPlayer((UUID)requesterId);
        if (requester != null && requester.isOnline()) {
            requester.sendMessage(String.valueOf(ChatColor.RED) + player.getName() + " has denied your teleport request.");
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleport request denied.");
        return true;
    }

    private void startTeleportCountdown(final Player player, final Location location, final String destinationName) {
        if (this.teleportCountdownSeconds <= 0) {
            this.teleportPlayer(player, location, destinationName);
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleporting to " + destinationName + " in " + this.teleportCountdownSeconds + " seconds. Don't move!");
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                Essentials999.this.teleportPlayer(player, location, destinationName);
                Essentials999.this.teleportCountdownTasks.remove(player.getUniqueId());
            }
        }.runTaskLater((Plugin)this, (long)this.teleportCountdownSeconds * 20L);
        this.teleportCountdownTasks.put(player.getUniqueId(), task);
    }

    private void teleportPlayer(Player player, Location targetLoc, String destinationName) {
        this.lastLocations.put(player.getUniqueId(), player.getLocation());
        player.teleport(targetLoc);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleported to " + destinationName + "!");
    }

    private boolean isSafeLocation(Location loc) {
        if (loc == null) {
            return false;
        }
        World world = loc.getWorld();
        if (world == null) {
            return false;
        }
        Location feet = loc.clone();
        Location head = loc.clone().add(0.0, 1.0, 0.0);
        return !feet.getBlock().getType().isSolid() && !head.getBlock().getType().isSolid();
    }

    private boolean openHomesGUI(Player player, int page) {
        if (!player.hasPermission("essentials999.homes")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        PlayerHomes homes = this.playerHomes.get(player.getUniqueId());
        if (homes == null || homes.getHomeNames().isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have any homes.");
            return true;
        }
        ArrayList<String> homeNames = new ArrayList<String>(homes.getHomeNames());
        int itemsPerPage = 45;
        int startIndex = page * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, homeNames.size());
        int totalPages = (int)Math.ceil((double)homeNames.size() / (double)itemsPerPage);
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.DARK_GREEN) + "Your Homes (Page " + (page + 1) + "/" + totalPages + ")"));
        for (int i = startIndex; i < endIndex; ++i) {
            String homeName = (String)homeNames.get(i);
            Location loc = homes.getHome(homeName);
            if (loc == null) continue;
            ItemStack item = new ItemStack(Material.RED_BED);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + homeName);
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Left-click to teleport")));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "Right-click to delete")));
            meta.setLore(lore);
            item.setItemMeta(meta);
            inv.addItem(new ItemStack[]{item});
        }
        if (page > 0) {
            ItemStack prev = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prev.getItemMeta();
            prevMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Previous Page");
            prev.setItemMeta(prevMeta);
            inv.setItem(45, prev);
        }
        if (page < totalPages - 1) {
            ItemStack next = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = next.getItemMeta();
            nextMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Next Page");
            next.setItemMeta(nextMeta);
            inv.setItem(53, next);
        }
        this.homesGuiPage.put(player.getUniqueId(), page);
        player.openInventory(inv);
        return true;
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && this.godPlayers.contains((player = (Player)event.getEntity()).getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.teleportCountdownTasks.containsKey(event.getPlayer().getUniqueId()) && (event.getFrom().getBlockX() != event.getTo().getBlockX() || event.getFrom().getBlockZ() != event.getTo().getBlockZ())) {
            this.teleportCountdownTasks.get(event.getPlayer().getUniqueId()).cancel();
            this.teleportCountdownTasks.remove(event.getPlayer().getUniqueId());
            event.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "Teleportation cancelled because you moved.");
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.jailTasks.containsKey(player.getUniqueId())) {
            this.jailTasks.get(player.getUniqueId()).cancel();
            this.jailTasks.remove(player.getUniqueId());
        }
        this.vanishedPlayers.remove(player.getUniqueId());
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            onlinePlayer.showPlayer((Plugin)this, player);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.jailedPlayers.containsKey(player.getUniqueId())) {
            Location jailLoc = player.getLocation().clone();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    for (int y = -1; y <= 2; ++y) {
                        if (x == 0 && z == 0 && y >= 0 && y <= 1) continue;
                        jailLoc.clone().add((double)x, (double)y, (double)z).getBlock().setType(Material.BEDROCK);
                    }
                }
            }
            player.teleport(jailLoc.clone().add(0.5, 0.0, 0.5));
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are still jailed!");
        }
        for (UUID vanishedId : this.vanishedPlayers) {
            Player vanishedPlayer = Bukkit.getPlayer((UUID)vanishedId);
            if (vanishedPlayer == null || player.hasPermission("essentials999.vanish.see")) continue;
            player.hidePlayer((Plugin)this, vanishedPlayer);
        }
        if (this.vanishedPlayers.contains(player.getUniqueId())) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (onlinePlayer.hasPermission("essentials999.vanish.see")) continue;
                onlinePlayer.hidePlayer((Plugin)this, player);
            }
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (this.jailedPlayers.containsKey(event.getPlayer().getUniqueId()) && event.getCause() != PlayerTeleportEvent.TeleportCause.PLUGIN) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "You cannot teleport while jailed.");
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inv = event.getInventory();
        String title = event.getView().getTitle();
        if (title.startsWith(String.valueOf(ChatColor.DARK_GREEN) + "Your Homes")) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            if (event.getCurrentItem().getType() == Material.ARROW) {
                int currentPage = this.homesGuiPage.getOrDefault(player.getUniqueId(), 0);
                if (event.getCurrentItem().getItemMeta().getDisplayName().contains("Next")) {
                    this.openHomesGUI(player, currentPage + 1);
                } else if (event.getCurrentItem().getItemMeta().getDisplayName().contains("Previous")) {
                    this.openHomesGUI(player, currentPage - 1);
                }
                return;
            }
            if (event.getClick().isLeftClick()) {
                String homeName = ChatColor.stripColor((String)event.getCurrentItem().getItemMeta().getDisplayName());
                PlayerHomes homes = this.playerHomes.get(player.getUniqueId());
                if (homes == null) {
                    return;
                }
                Location loc = homes.getHome(homeName);
                if (loc == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Home '" + homeName + "' no longer exists.");
                    player.closeInventory();
                    return;
                }
                player.closeInventory();
                this.teleportPlayer(player, loc, "home '" + homeName + "'");
            } else if (event.getClick().isRightClick()) {
                String homeName = ChatColor.stripColor((String)event.getCurrentItem().getItemMeta().getDisplayName());
                player.closeInventory();
                this.openDeleteConfirmGUI(player, homeName);
            }
        } else if (title.startsWith(String.valueOf(ChatColor.RED) + "Delete home")) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            String homeName = this.pendingDeleteHome.get(player.getUniqueId());
            if (homeName == null) {
                player.closeInventory();
                return;
            }
            Material clicked = event.getCurrentItem().getType();
            if (clicked == Material.GREEN_STAINED_GLASS_PANE) {
                PlayerHomes homes = this.playerHomes.get(player.getUniqueId());
                if (homes != null && homes.deleteHome(homeName)) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Home '" + homeName + "' deleted successfully!");
                    this.saveHomesAsync();
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Home '" + homeName + "' no longer exists.");
                }
                this.pendingDeleteHome.remove(player.getUniqueId());
                player.closeInventory();
            } else if (clicked == Material.RED_STAINED_GLASS_PANE) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Home deletion cancelled.");
                this.pendingDeleteHome.remove(player.getUniqueId());
                player.closeInventory();
            }
        } else if (title.startsWith(String.valueOf(ChatColor.RED) + "Delete warp")) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            String warpName = this.pendingDeleteWarp.get(player.getUniqueId());
            if (warpName == null) {
                player.closeInventory();
                return;
            }
            Material clicked = event.getCurrentItem().getType();
            if (clicked == Material.GREEN_STAINED_GLASS_PANE) {
                if (this.warpsManager.deleteWarp(warpName)) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Warp '" + warpName + "' deleted successfully!");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Warp '" + warpName + "' no longer exists.");
                }
                this.pendingDeleteWarp.remove(player.getUniqueId());
                player.closeInventory();
            } else if (clicked == Material.RED_STAINED_GLASS_PANE) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Warp deletion cancelled.");
                this.pendingDeleteWarp.remove(player.getUniqueId());
                player.closeInventory();
            }
        } else if (title.startsWith(String.valueOf(ChatColor.DARK_AQUA) + "Warps")) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            if (event.getCurrentItem().getType() == Material.ARROW) {
                int currentPage = this.warpsGuiPage.getOrDefault(player.getUniqueId(), 0);
                if (event.getCurrentItem().getItemMeta().getDisplayName().contains("Next")) {
                    this.openWarpsGUI(player, currentPage + 1);
                } else if (event.getCurrentItem().getItemMeta().getDisplayName().contains("Previous")) {
                    this.openWarpsGUI(player, currentPage - 1);
                }
                return;
            }
            if (event.getClick().isLeftClick()) {
                String warpName = ChatColor.stripColor((String)event.getCurrentItem().getItemMeta().getDisplayName());
                player.closeInventory();
                this.warpCommand(player, new String[]{warpName});
            } else if (event.getClick().isRightClick()) {
                String warpName = ChatColor.stripColor((String)event.getCurrentItem().getItemMeta().getDisplayName());
                player.closeInventory();
                this.openDeleteWarpConfirmGUI(player, warpName);
            }
        }
    }

    private void openDeleteConfirmGUI(Player player, String homeName) {
        Inventory inv = Bukkit.createInventory(null, (int)9, (String)(String.valueOf(ChatColor.RED) + "Delete home '" + homeName + "'?"));
        ItemStack yes = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta yesMeta = yes.getItemMeta();
        yesMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Yes");
        yes.setItemMeta(yesMeta);
        ItemStack no = new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta noMeta = no.getItemMeta();
        noMeta.setDisplayName(String.valueOf(ChatColor.RED) + "No");
        no.setItemMeta(noMeta);
        ItemStack filler = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(" ");
        filler.setItemMeta(fillerMeta);
        for (int i = 0; i < 9; ++i) {
            if (i == 3 || i == 5) continue;
            inv.setItem(i, filler);
        }
        inv.setItem(3, no);
        inv.setItem(5, yes);
        this.pendingDeleteHome.put(player.getUniqueId(), homeName);
        player.openInventory(inv);
    }

    private void openDeleteWarpConfirmGUI(Player player, String warpName) {
        Inventory inv = Bukkit.createInventory(null, (int)9, (String)(String.valueOf(ChatColor.RED) + "Delete warp '" + warpName + "'?"));
        ItemStack yes = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta yesMeta = yes.getItemMeta();
        yesMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Yes");
        yes.setItemMeta(yesMeta);
        ItemStack no = new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta noMeta = no.getItemMeta();
        noMeta.setDisplayName(String.valueOf(ChatColor.RED) + "No");
        no.setItemMeta(noMeta);
        ItemStack filler = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(" ");
        filler.setItemMeta(fillerMeta);
        for (int i = 0; i < 9; ++i) {
            if (i == 3 || i == 5) continue;
            inv.setItem(i, filler);
        }
        inv.setItem(3, no);
        inv.setItem(5, yes);
        this.pendingDeleteWarp.put(player.getUniqueId(), warpName);
        player.openInventory(inv);
    }

    private boolean openHelpGUI(Player player) {
        if (!player.hasPermission("essentials999.help")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        int size = 27;
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)(String.valueOf(ChatColor.BLUE) + "Essentials999 Help"));
        ItemStack homesCat = new ItemStack(Material.RED_BED);
        ItemMeta homesMeta = homesCat.getItemMeta();
        homesMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Homes Commands");
        homesMeta.setLore(Arrays.asList(String.valueOf(ChatColor.YELLOW) + "/sethome <name> - Set a home", String.valueOf(ChatColor.YELLOW) + "/home <name> - Teleport home", String.valueOf(ChatColor.YELLOW) + "/delhome <name> - Delete home", String.valueOf(ChatColor.YELLOW) + "/homes - List homes (GUI)"));
        homesCat.setItemMeta(homesMeta);
        inv.setItem(10, homesCat);
        ItemStack warpsCat = new ItemStack(Material.COMPASS);
        ItemMeta warpsMeta = warpsCat.getItemMeta();
        warpsMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Warps Commands");
        warpsMeta.setLore(Arrays.asList(String.valueOf(ChatColor.YELLOW) + "/warp <name> - Warp to location", String.valueOf(ChatColor.YELLOW) + "/warps - List warps (GUI)"));
        warpsCat.setItemMeta(warpsMeta);
        inv.setItem(12, warpsCat);
        ItemStack tpCat = new ItemStack(Material.ENDER_PEARL);
        ItemMeta tpMeta = tpCat.getItemMeta();
        tpMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Teleport Commands");
        tpMeta.setLore(Arrays.asList(String.valueOf(ChatColor.YELLOW) + "/tpask <player> - Request teleport", String.valueOf(ChatColor.YELLOW) + "/tpahere <player> - Request player teleport", String.valueOf(ChatColor.YELLOW) + "/tpaccept - Accept teleport", String.valueOf(ChatColor.YELLOW) + "/tpdeny - Deny teleport", String.valueOf(ChatColor.YELLOW) + "/back - Return to last location", String.valueOf(ChatColor.YELLOW) + "/spawn - Teleport to spawn", String.valueOf(ChatColor.YELLOW) + "/setspawn - Set spawn"));
        tpCat.setItemMeta(tpMeta);
        inv.setItem(14, tpCat);
        ItemStack adminCat = new ItemStack(Material.DIAMOND_SWORD);
        ItemMeta adminMeta = adminCat.getItemMeta();
        adminMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Admin Commands");
        adminMeta.setLore(Arrays.asList(String.valueOf(ChatColor.YELLOW) + "/setwarp <name> - Set warp", String.valueOf(ChatColor.YELLOW) + "/delwarp <name> - Delete warp", String.valueOf(ChatColor.YELLOW) + "/tpgui toggle - Toggle teleport request GUI"));
        adminCat.setItemMeta(adminMeta);
        inv.setItem(16, adminCat);
        player.openInventory(inv);
        return true;
    }

    private boolean toggleTpGui(Player player, String[] args) {
        if (!player.hasPermission("essentials999.tpgui")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1 || !args[0].equalsIgnoreCase("toggle")) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /tpgui toggle");
            return true;
        }
        UUID uuid = player.getUniqueId();
        if (this.tpGuiEnabledPlayers.contains(uuid)) {
            this.tpGuiEnabledPlayers.remove(uuid);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Teleport request GUI disabled.");
        } else {
            this.tpGuiEnabledPlayers.add(uuid);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleport request GUI enabled.");
        }
        return true;
    }

    private boolean isTpGuiEnabled(Player player) {
        return this.tpGuiEnabledPlayers.contains(player.getUniqueId());
    }

    private void openTeleportRequestGUI(Player target, Player requester, boolean requesterToTarget) {
        if (!this.isTpGuiEnabled(target)) {
            target.sendMessage(String.valueOf(ChatColor.YELLOW) + requester.getName() + " has requested to teleport " + (requesterToTarget ? "to you" : "you to them") + ". Use /tpaccept or /tpdeny.");
            return;
        }
        Inventory inv = Bukkit.createInventory(null, (int)9, (String)(String.valueOf(ChatColor.GOLD) + "Teleport Request"));
        ItemStack accept = new ItemStack(Material.GREEN_WOOL);
        ItemMeta acceptMeta = accept.getItemMeta();
        acceptMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Accept");
        accept.setItemMeta(acceptMeta);
        ItemStack deny = new ItemStack(Material.RED_WOOL);
        ItemMeta denyMeta = deny.getItemMeta();
        denyMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Deny");
        deny.setItemMeta(denyMeta);
        ItemStack filler = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(" ");
        filler.setItemMeta(fillerMeta);
        for (int i = 0; i < 9; ++i) {
            if (i == 3 || i == 5) continue;
            inv.setItem(i, filler);
        }
        inv.setItem(3, deny);
        inv.setItem(5, accept);
        target.openInventory(inv);
        BukkitTask task = this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
            if (target.getOpenInventory().getTopInventory().equals((Object)inv)) {
                target.closeInventory();
                target.sendMessage(String.valueOf(ChatColor.RED) + "Teleport request expired.");
                this.tpRequests.remove(target.getUniqueId());
            }
        }, 600L);
        this.teleportRequestExpireTasks.put(target.getUniqueId(), task);
    }

    private boolean rtpCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.rtp")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length > 0) {
            if (!player.hasPermission("essentials999.rtp.others")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to RTP other players.");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                return true;
            }
            this.performRTPForPlayer(target);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "RTPing " + target.getName() + "...");
            return true;
        }
        this.openRtpGui(player);
        return true;
    }

    private void performRTPForPlayer(Player player) {
        boolean enabled;
        String worldName = player.getWorld().getName();
        Map config = this.rtpWorldConfigs.getOrDefault(worldName, null);
        boolean bl = enabled = config != null ? config.getOrDefault("enabled", this.globalRtpEnabled) : this.globalRtpEnabled;
        if (!enabled) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "RTP is disabled in this world.");
            return;
        }
        int range = config != null ? config.getOrDefault("range", this.globalRtpRange) : this.globalRtpRange;
        int maxAttempts = config != null ? config.getOrDefault("max-attempts", this.globalRtpMaxAttempts) : this.globalRtpMaxAttempts;
        String biome = config != null ? config.getOrDefault("biome", this.globalRtpBiome) : this.globalRtpBiome;
        boolean checkWorldBorder = config != null ? config.getOrDefault("check-world-border", this.globalRtpCheckWorldBorder) : this.globalRtpCheckWorldBorder;
        this.performRTP(player, player.getWorld(), range, maxAttempts, biome, checkWorldBorder);
    }

    private void openRtpGui(Player player) {
        ItemMeta meta;
        boolean enabled;
        if (!player.hasPermission("essentials999.rtp")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return;
        }
        String worldName = player.getWorld().getName();
        Map config = this.rtpWorldConfigs.getOrDefault(worldName, null);
        boolean bl = enabled = config != null ? config.getOrDefault("enabled", this.globalRtpEnabled) : this.globalRtpEnabled;
        if (!enabled) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "RTP is disabled in this world.");
            return;
        }
        int cooldownSeconds = config != null ? config.getOrDefault("cooldown-seconds", this.globalRtpCooldownSeconds) : this.globalRtpCooldownSeconds;
        boolean allowNether = config != null ? config.getOrDefault("allow-nether", this.globalRtpAllowNether) : this.globalRtpAllowNether;
        boolean allowEnd = config != null ? config.getOrDefault("allow-end", this.globalRtpAllowEnd) : this.globalRtpAllowEnd;
        int size = 9;
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)(String.valueOf(ChatColor.DARK_PURPLE) + "Random Teleport"));
        if (player.getWorld().getEnvironment() == World.Environment.NORMAL) {
            ItemStack overworldBtn = new ItemStack(Material.GRASS_BLOCK);
            meta = overworldBtn.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "RTP in Overworld");
            meta.setLore(Collections.singletonList(String.valueOf(ChatColor.YELLOW) + "Click to teleport randomly in Overworld"));
            overworldBtn.setItemMeta(meta);
            inv.setItem(2, overworldBtn);
        }
        if (allowNether && player.getWorld().getEnvironment() != World.Environment.NETHER && this.getServer().getWorlds().stream().anyMatch(w -> w.getEnvironment() == World.Environment.NETHER)) {
            ItemStack netherBtn = new ItemStack(Material.NETHERRACK);
            meta = netherBtn.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.RED) + "RTP in Nether");
            meta.setLore(Collections.singletonList(String.valueOf(ChatColor.YELLOW) + "Click to teleport randomly in Nether"));
            netherBtn.setItemMeta(meta);
            inv.setItem(4, netherBtn);
        }
        if (allowEnd && player.getWorld().getEnvironment() != World.Environment.THE_END && this.getServer().getWorlds().stream().anyMatch(w -> w.getEnvironment() == World.Environment.THE_END)) {
            ItemStack endBtn = new ItemStack(Material.END_STONE);
            meta = endBtn.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.LIGHT_PURPLE) + "RTP in End");
            meta.setLore(Collections.singletonList(String.valueOf(ChatColor.YELLOW) + "Click to teleport randomly in End"));
            endBtn.setItemMeta(meta);
            inv.setItem(6, endBtn);
        }
        long now = System.currentTimeMillis();
        long lastRtp = this.rtpCooldowns.getOrDefault(player.getUniqueId(), 0L);
        long cooldownMillis = (long)cooldownSeconds * 1000L;
        long elapsed = now - lastRtp;
        long timeLeft = Math.max(0L, (cooldownMillis - elapsed) / 1000L);
        ItemStack cooldownItem = new ItemStack(Material.CLOCK);
        ItemMeta cooldownMeta = cooldownItem.getItemMeta();
        cooldownMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Cooldown");
        cooldownMeta.setLore(Collections.singletonList(String.valueOf(ChatColor.YELLOW) + (String)(timeLeft > 0L ? timeLeft + " seconds left" : "Ready")));
        cooldownItem.setItemMeta(cooldownMeta);
        inv.setItem(8, cooldownItem);
        player.openInventory(inv);
    }

    @EventHandler
    public void onInventoryClickAdditional(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inv = event.getInventory();
        String title = event.getView().getTitle();
        if (title.equals(String.valueOf(ChatColor.GOLD) + "Teleport Request")) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            Material clicked = event.getCurrentItem().getType();
            UUID playerId = player.getUniqueId();
            UUID requesterId = this.tpRequests.get(playerId);
            if (requesterId == null) {
                player.closeInventory();
                return;
            }
            Player requester = Bukkit.getPlayer((UUID)requesterId);
            if (clicked == Material.GREEN_WOOL) {
                if (requester != null && requester.isOnline()) {
                    requester.teleport(player.getLocation());
                    requester.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been teleported to " + player.getName() + "!");
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "You accepted the teleport request from " + requester.getName() + "!");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Requester is no longer online.");
                }
                this.tpRequests.remove(playerId);
                player.closeInventory();
            } else if (clicked == Material.RED_WOOL) {
                if (requester != null && requester.isOnline()) {
                    requester.sendMessage(String.valueOf(ChatColor.RED) + player.getName() + " denied your teleport request.");
                }
                this.tpRequests.remove(playerId);
                player.closeInventory();
            }
        } else if (title.equals(String.valueOf(ChatColor.DARK_PURPLE) + "Random Teleport")) {
            long cooldownMillis;
            long lastRtp;
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            Material clicked = event.getCurrentItem().getType();
            String worldName = player.getWorld().getName();
            Map config = this.rtpWorldConfigs.getOrDefault(worldName, null);
            int range = config != null ? config.getOrDefault("range", this.globalRtpRange) : this.globalRtpRange;
            int maxAttempts = config != null ? config.getOrDefault("max-attempts", this.globalRtpMaxAttempts) : this.globalRtpMaxAttempts;
            int cooldownSeconds = config != null ? config.getOrDefault("cooldown-seconds", this.globalRtpCooldownSeconds) : this.globalRtpCooldownSeconds;
            String biome = config != null ? config.getOrDefault("biome", this.globalRtpBiome) : this.globalRtpBiome;
            boolean checkWorldBorder = config != null ? config.getOrDefault("check-world-border", this.globalRtpCheckWorldBorder) : this.globalRtpCheckWorldBorder;
            long now = System.currentTimeMillis();
            long elapsed = now - (lastRtp = this.rtpCooldowns.getOrDefault(player.getUniqueId(), 0L).longValue());
            if (elapsed < (cooldownMillis = (long)cooldownSeconds * 1000L)) {
                long timeLeft = (cooldownMillis - elapsed) / 1000L;
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait " + timeLeft + " seconds before using RTP again.");
                player.closeInventory();
                return;
            }
            World targetWorld = null;
            if (clicked == Material.GRASS_BLOCK) {
                targetWorld = this.getServer().getWorlds().stream().filter(w -> w.getEnvironment() == World.Environment.NORMAL).findFirst().orElse(null);
            } else if (clicked == Material.NETHERRACK) {
                targetWorld = this.getServer().getWorlds().stream().filter(w -> w.getEnvironment() == World.Environment.NETHER).findFirst().orElse(null);
            } else if (clicked == Material.END_STONE) {
                targetWorld = this.getServer().getWorlds().stream().filter(w -> w.getEnvironment() == World.Environment.THE_END).findFirst().orElse(null);
            }
            if (targetWorld == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "This dimension is not available for RTP.");
                player.closeInventory();
                return;
            }
            player.closeInventory();
            this.rtpCooldowns.put(player.getUniqueId(), now);
            this.performRTP(player, targetWorld, range, maxAttempts, biome, checkWorldBorder);
        } else if (title.startsWith(String.valueOf(ChatColor.DARK_PURPLE) + "Kits")) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            if (event.getCurrentItem().getType() == Material.ARROW) {
                int currentPage = this.kitsGuiPage.getOrDefault(player.getUniqueId(), 0);
                if (event.getCurrentItem().getItemMeta().getDisplayName().contains("Next")) {
                    this.openKitsGUI(player, currentPage + 1);
                } else if (event.getCurrentItem().getItemMeta().getDisplayName().contains("Previous")) {
                    this.openKitsGUI(player, currentPage - 1);
                }
                return;
            }
            if (event.getClick().isLeftClick()) {
                String kitName = ChatColor.stripColor((String)event.getCurrentItem().getItemMeta().getDisplayName());
                player.closeInventory();
                this.kitCommand(player, new String[]{kitName});
            }
        }
    }

    private void performRTP(final Player player, final World world, final int range, final int maxAttempts, final String biome, final boolean checkWorldBorder) {
        new BukkitRunnable(){

            public void run() {
                Location loc = null;
                Biome targetBiome = null;
                if (biome != null && !biome.isEmpty()) {
                    try {
                        targetBiome = Biome.valueOf((String)biome.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid biome specified in the config: " + biome);
                        return;
                    }
                }
                for (int i = 0; i < maxAttempts; ++i) {
                    Location candidate;
                    int x = ThreadLocalRandom.current().nextInt(-range, range + 1);
                    int z = ThreadLocalRandom.current().nextInt(-range, range + 1);
                    if (checkWorldBorder) {
                        WorldBorder border = world.getWorldBorder();
                        double size = border.getSize() / 2.0;
                        Location center = border.getCenter();
                        if ((double)x > center.getX() + size || (double)x < center.getX() - size || (double)z > center.getZ() + size || (double)z < center.getZ() - size) continue;
                    }
                    int y = world.getHighestBlockYAt(x, z);
                    if (targetBiome != null && world.getBiome(x, y, z) != targetBiome || !Essentials999.this.isSafeLocation(candidate = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5))) continue;
                    loc = candidate;
                    break;
                }
                if (loc == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to find a safe location for RTP. Try again later.");
                    return;
                }
                final Location finalLoc = loc;
                new BukkitRunnable(){

                    public void run() {
                        Essentials999.this.startTeleportCountdown(player, finalLoc, "Random Teleport");
                    }
                }.runTask((Plugin)Essentials999.this);
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private boolean seenCommand(Player player, String[] args) {
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /seen <player>");
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
        if (target.isOnline()) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + target.getName() + " is currently online.");
        } else {
            long lastSeenTime = target.getLastPlayed();
            if (lastSeenTime == 0L) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player " + args[0] + " has never been seen on this server.");
            } else {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + " was last seen on " + String.valueOf(new Date(lastSeenTime)));
            }
        }
        return true;
    }

    private boolean whoisCommand(Player player, String[] args) {
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /whois <player>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "--- Whois: " + target.getName() + " ---");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "UUID: " + String.valueOf(target.getUniqueId()));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Health: " + String.format("%.2f/%.2f", target.getHealth(), target.getAttribute(Attribute.MAX_HEALTH).getValue()));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Food: " + target.getFoodLevel() + "/20");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Gamemode: " + String.valueOf(target.getGameMode()));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Kills: " + target.getStatistic(Statistic.PLAYER_KILLS));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Deaths: " + target.getStatistic(Statistic.DEATHS));
        return true;
    }

    private boolean healCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.heal")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        Player targetPlayer = player;
        if (args.length > 0) {
            Player specifiedTarget = Bukkit.getPlayer((String)args[0]);
            if (specifiedTarget == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                return true;
            }
            targetPlayer = specifiedTarget;
        }
        Player finalTarget = targetPlayer;
        finalTarget.setHealth(finalTarget.getAttribute(Attribute.MAX_HEALTH).getValue());
        finalTarget.setFoodLevel(20);
        finalTarget.setFireTicks(0);
        finalTarget.getActivePotionEffects().forEach(effect -> finalTarget.removePotionEffect(effect.getType()));
        if (finalTarget.equals((Object)player)) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been healed.");
        } else {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + finalTarget.getName() + " has been healed.");
            finalTarget.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been healed by " + player.getName() + ".");
        }
        return true;
    }

    private boolean feedCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.feed")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        Player target = player;
        if (args.length > 0 && (target = Bukkit.getPlayer((String)args[0])) == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        target.setFoodLevel(20);
        target.setSaturation(10.0f);
        if (target.equals((Object)player)) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been fed.");
        } else {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + target.getName() + " has been fed.");
            target.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been fed by " + player.getName() + ".");
        }
        return true;
    }

    private boolean jailCommand(Player player, String[] args) {
        int time;
        if (!player.hasPermission("essentials999.jail")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /jail <player> <time>");
            return true;
        }
        final Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        if (this.jailedPlayers.containsKey(target.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "That player is already jailed.");
            return true;
        }
        try {
            time = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid time specified.");
            return true;
        }
        Location jailLoc = target.getLocation().clone();
        this.jailedPlayers.put(target.getUniqueId(), target.getLocation());
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 2; ++y) {
                    if (x == 0 && z == 0 && y >= 0 && y <= 1) continue;
                    jailLoc.clone().add((double)x, (double)y, (double)z).getBlock().setType(Material.BEDROCK);
                }
            }
        }
        target.teleport(jailLoc.clone().add(0.5, 0.0, 0.5));
        target.sendMessage(String.valueOf(ChatColor.RED) + "You have been jailed for " + time + " seconds!");
        player.sendMessage(String.valueOf(ChatColor.GREEN) + target.getName() + " has been jailed for " + time + " seconds.");
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                Essentials999.this.unjailPlayer(target);
            }
        }.runTaskLater((Plugin)this, (long)time * 20L);
        this.jailTasks.put(target.getUniqueId(), task);
        return true;
    }

    private void unjailPlayer(Player player) {
        if (!this.jailedPlayers.containsKey(player.getUniqueId())) {
            return;
        }
        Location originalLoc = this.jailedPlayers.remove(player.getUniqueId());
        this.jailTasks.remove(player.getUniqueId());
        Location jailLoc = player.getLocation();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 2; ++y) {
                    if (x == 0 && z == 0 && y >= 0 && y <= 1) continue;
                    jailLoc.clone().add((double)x, (double)y, (double)z).getBlock().setType(Material.AIR);
                }
            }
        }
        player.teleport(originalLoc);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been unjailed.");
    }

    private boolean kitCommand(Player player, String[] args) {
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /kit <name> or /kit create <name>");
            return true;
        }
        if (args[0].equalsIgnoreCase("create")) {
            if (!player.hasPermission("essentials999.kit.create")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to create kits.");
                return true;
            }
            if (args.length < 2) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /kit create <name>");
                return true;
            }
            String kitName = args[1];
            if (this.kitManager.getKit(kitName) != null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Kit '" + kitName + "' already exists.");
                return true;
            }
            this.kitManager.createKit(kitName, player);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Kit '" + kitName + "' created successfully from your inventory!");
        } else {
            if (!player.hasPermission("essentials999.kit.use")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use kits.");
                return true;
            }
            String kitName = args[0];
            Kit kit = this.kitManager.getKit(kitName);
            if (kit == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Kit '" + kitName + "' not found.");
                return true;
            }
            long now = System.currentTimeMillis();
            long cooldownMillis = kit.getCooldown() * 1000L;
            Map playerKitCooldowns = this.kitCooldowns.computeIfAbsent(player.getUniqueId(), k -> new ConcurrentHashMap());
            long lastUsed = playerKitCooldowns.getOrDefault(kitName.toLowerCase(), 0L);
            long elapsed = now - lastUsed;
            if (elapsed < cooldownMillis) {
                long timeLeft = (cooldownMillis - elapsed) / 1000L;
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait " + timeLeft + " seconds before using kit '" + kitName + "' again.");
                return true;
            }
            for (ItemStack item : kit.getItems()) {
                player.getInventory().addItem(new ItemStack[]{item.clone()});
            }
            playerKitCooldowns.put(kitName.toLowerCase(), now);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You received kit '" + kitName + "'!");
        }
        return true;
    }

    private boolean kitsCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.kits")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        this.openKitsGUI(player, 0);
        return true;
    }

    private void openKitsGUI(Player player, int page) {
        if (!player.hasPermission("essentials999.kits")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return;
        }
        Map<String, Kit> kits = this.kitManager.getKits();
        if (kits.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No kits have been set.");
            return;
        }
        ArrayList<String> kitNames = new ArrayList<String>(kits.keySet());
        int itemsPerPage = 45;
        int startIndex = page * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, kitNames.size());
        int totalPages = (int)Math.ceil((double)kitNames.size() / (double)itemsPerPage);
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.DARK_PURPLE) + "Kits (Page " + (page + 1) + "/" + totalPages + ")"));
        for (int i = startIndex; i < endIndex; ++i) {
            String kitName = (String)kitNames.get(i);
            Kit kit = kits.get(kitName);
            if (kit == null) continue;
            ItemStack item = new ItemStack(Material.CHEST);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + kitName);
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Left-click to receive kit")));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Cooldown: " + kit.getCooldown() + " seconds")));
            meta.setLore(lore);
            item.setItemMeta(meta);
            inv.addItem(new ItemStack[]{item});
        }
        if (page > 0) {
            ItemStack prev = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prev.getItemMeta();
            prevMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Previous Page");
            prev.setItemMeta(prevMeta);
            inv.setItem(45, prev);
        }
        if (page < totalPages - 1) {
            ItemStack next = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = next.getItemMeta();
            nextMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + "Next Page");
            next.setItemMeta(nextMeta);
            inv.setItem(53, next);
        }
        this.kitsGuiPage.put(player.getUniqueId(), page);
        player.openInventory(inv);
    }
}

