/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.essentials999;

import com.yourname.essentials999.Essentials999;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class EssentialsCommands
implements Listener {
    private final Essentials999 plugin;
    private final Set<UUID> flyingPlayers;
    private final Set<UUID> godPlayers;
    private final Set<UUID> vanishedPlayers;
    private final Map<UUID, UUID> tpRequests;
    private final Map<UUID, Boolean> tpHereRequests;
    private final Map<UUID, UUID> tpDenied;
    private final Map<UUID, String> nicknames;
    private final Map<UUID, Long> mutedPlayers;

    public EssentialsCommands(Essentials999 plugin, Set<UUID> flyingPlayers, Set<UUID> godPlayers, Set<UUID> vanishedPlayers, Map<UUID, UUID> tpRequests, Map<UUID, Boolean> tpHereRequests, Map<UUID, UUID> tpDenied, Map<UUID, String> nicknames, Map<UUID, Long> mutedPlayers) {
        this.plugin = plugin;
        this.flyingPlayers = flyingPlayers;
        this.godPlayers = godPlayers;
        this.vanishedPlayers = vanishedPlayers;
        this.tpRequests = tpRequests;
        this.tpHereRequests = tpHereRequests;
        this.tpDenied = tpDenied;
        this.nicknames = nicknames;
        this.mutedPlayers = mutedPlayers;
    }

    public boolean flyCommand(Player player, String[] args) {
        if (args.length == 0) {
            if (!player.hasPermission("essentials999.fly")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            this.toggleFlight(player, player);
        } else if (args.length == 1) {
            if (!player.hasPermission("essentials999.fly.others")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to toggle flight for others.");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                return true;
            }
            this.toggleFlight(player, target);
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /fly [player]");
        }
        return true;
    }

    private void toggleFlight(Player sender, Player target) {
        if (this.flyingPlayers.contains(target.getUniqueId())) {
            target.setAllowFlight(false);
            target.setFlying(false);
            this.flyingPlayers.remove(target.getUniqueId());
            target.sendMessage(String.valueOf(ChatColor.YELLOW) + "Flight disabled.");
            if (!sender.equals((Object)target)) {
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Flight disabled for " + target.getName() + ".");
            }
        } else {
            target.setAllowFlight(true);
            target.setFlying(true);
            this.flyingPlayers.add(target.getUniqueId());
            target.sendMessage(String.valueOf(ChatColor.GREEN) + "Flight enabled.");
            if (!sender.equals((Object)target)) {
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Flight enabled for " + target.getName() + ".");
            }
        }
    }

    public boolean godCommand(Player player, String[] args) {
        if (args.length == 0) {
            if (!player.hasPermission("essentials999.god")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            this.toggleGodMode(player, player);
        } else if (args.length == 1) {
            if (!player.hasPermission("essentials999.god.others")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to toggle god mode for others.");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                return true;
            }
            this.toggleGodMode(player, target);
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /god [player]");
        }
        return true;
    }

    private void toggleGodMode(Player sender, Player target) {
        if (this.godPlayers.contains(target.getUniqueId())) {
            this.godPlayers.remove(target.getUniqueId());
            target.sendMessage(String.valueOf(ChatColor.YELLOW) + "God mode disabled.");
            if (!sender.equals((Object)target)) {
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "God mode disabled for " + target.getName() + ".");
            }
        } else {
            this.godPlayers.add(target.getUniqueId());
            target.sendMessage(String.valueOf(ChatColor.GREEN) + "God mode enabled.");
            if (!sender.equals((Object)target)) {
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "God mode enabled for " + target.getName() + ".");
            }
        }
    }

    public boolean vanishCommand(Player player, String[] args) {
        if (args.length == 0) {
            if (!player.hasPermission("essentials999.vanish")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            this.toggleVanish(player, player);
        } else if (args.length == 1) {
            if (!player.hasPermission("essentials999.vanish.others")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to toggle vanish for others.");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                return true;
            }
            this.toggleVanish(player, target);
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /vanish [player]");
        }
        return true;
    }

    private void toggleVanish(Player sender, Player target) {
        if (this.vanishedPlayers.contains(target.getUniqueId())) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                onlinePlayer.showPlayer((Plugin)this.plugin, target);
            }
            this.vanishedPlayers.remove(target.getUniqueId());
            target.sendMessage(String.valueOf(ChatColor.YELLOW) + "You are no longer vanished.");
            if (!sender.equals((Object)target)) {
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + target.getName() + " is no longer vanished.");
            }
        } else {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (onlinePlayer.hasPermission("essentials999.vanish.see")) continue;
                onlinePlayer.hidePlayer((Plugin)this.plugin, target);
            }
            this.vanishedPlayers.add(target.getUniqueId());
            target.sendMessage(String.valueOf(ChatColor.GREEN) + "You are now vanished.");
            if (!sender.equals((Object)target)) {
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + target.getName() + " is now vanished.");
            }
        }
    }

    public boolean tpaallCommand(Player player) {
        if (!player.hasPermission("essentials999.tpaall")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        int requestsSent = 0;
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (target.equals((Object)player)) continue;
            this.tpRequests.put(target.getUniqueId(), player.getUniqueId());
            this.tpHereRequests.put(target.getUniqueId(), true);
            this.tpDenied.remove(target.getUniqueId());
            target.sendMessage(String.valueOf(ChatColor.YELLOW) + player.getName() + " has requested you to teleport to them. Use /tpaccept to accept or /tpdeny to deny.");
            ++requestsSent;
        }
        if (requestsSent > 0) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleport request sent to " + requestsSent + " players.");
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No other players are online to send a request to.");
        }
        return true;
    }

    public boolean broadcastCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.broadcast")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /broadcast <message>");
            return true;
        }
        String message = String.join((CharSequence)" ", args);
        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GOLD) + "[Broadcast] " + String.valueOf(ChatColor.WHITE) + message));
        return true;
    }

    public boolean timeCommand(Player player, String timeType) {
        long time;
        if (!player.hasPermission("essentials999.time")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (timeType.equalsIgnoreCase("day")) {
            time = 0L;
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Time set to day.");
        } else if (timeType.equalsIgnoreCase("night")) {
            time = 14000L;
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Time set to night.");
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /day or /night");
            return true;
        }
        player.getWorld().setTime(time);
        return true;
    }

    public boolean weatherCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.weather")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /weather <clear|rain|thunder>");
            return true;
        }
        String weatherType = args[0].toLowerCase();
        World world = player.getWorld();
        switch (weatherType) {
            case "clear": {
                world.setStorm(false);
                world.setThundering(false);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Weather set to clear.");
                break;
            }
            case "rain": {
                world.setStorm(true);
                world.setThundering(false);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Weather set to rain.");
                break;
            }
            case "thunder": {
                world.setStorm(true);
                world.setThundering(true);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Weather set to thunder.");
                break;
            }
            default: {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /weather <clear|rain|thunder>");
                return true;
            }
        }
        return true;
    }

    public boolean nickCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.nick")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.nicknames.remove(player.getUniqueId());
            player.setDisplayName(player.getName());
            player.setPlayerListName(player.getName());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your nickname has been cleared.");
            return true;
        }
        String nickname = ChatColor.translateAlternateColorCodes((char)'&', (String)args[0]);
        this.nicknames.put(player.getUniqueId(), nickname);
        player.setDisplayName(nickname + String.valueOf(ChatColor.RESET));
        player.setPlayerListName(nickname + String.valueOf(ChatColor.RESET));
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your nickname has been set to " + nickname + String.valueOf(ChatColor.GREEN) + ".");
        return true;
    }

    public boolean muteCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.mute")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /mute <player> [time_in_seconds] [reason]");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        long muteDuration = -1L;
        if (args.length >= 2) {
            try {
                muteDuration = Long.parseLong(args[1]);
            }
            catch (NumberFormatException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid time specified. Usage: /mute <player> [time_in_seconds] [reason]");
                return true;
            }
        }
        String reason = args.length >= 3 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length)) : "No reason specified.";
        long muteUntil = muteDuration == -1L ? -1L : System.currentTimeMillis() + muteDuration * 1000L;
        this.mutedPlayers.put(target.getUniqueId(), muteUntil);
        target.sendMessage(String.valueOf(ChatColor.RED) + "You have been muted by " + player.getName() + " for: " + reason);
        if (muteDuration != -1L) {
            target.sendMessage(String.valueOf(ChatColor.RED) + "Mute will expire in " + muteDuration + " seconds.");
        } else {
            target.sendMessage(String.valueOf(ChatColor.RED) + "This mute is permanent.");
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + target.getName() + " has been muted.");
        return true;
    }

    public boolean unmuteCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.unmute")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /unmute <player>");
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
        if (!this.mutedPlayers.containsKey(target.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + target.getName() + " is not currently muted.");
            return true;
        }
        this.mutedPlayers.remove(target.getUniqueId());
        player.sendMessage(String.valueOf(ChatColor.GREEN) + target.getName() + " has been unmuted.");
        if (target.isOnline()) {
            target.getPlayer().sendMessage(String.valueOf(ChatColor.GREEN) + "You have been unmuted.");
        }
        return true;
    }

    @EventHandler
    public void onAsyncPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.mutedPlayers.containsKey(player.getUniqueId())) {
            long muteUntil = this.mutedPlayers.get(player.getUniqueId());
            if (muteUntil == -1L || System.currentTimeMillis() < muteUntil) {
                long timeLeft;
                event.setCancelled(true);
                long l = timeLeft = muteUntil == -1L ? -1L : (muteUntil - System.currentTimeMillis()) / 1000L;
                if (timeLeft == -1L) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are permanently muted.");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are muted for " + timeLeft + " more seconds.");
                }
            } else {
                this.mutedPlayers.remove(player.getUniqueId());
            }
        }
    }
}

