/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.essentials999;

import com.yourname.essentials999.Essentials999;
import com.yourname.essentials999.Kit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class KitManager {
    private final Essentials999 plugin;
    private final Map<String, Kit> kits = new HashMap<String, Kit>();
    private File kitsFile;
    private YamlConfiguration kitsConfig;

    public KitManager(Essentials999 plugin) {
        this.plugin = plugin;
        this.setup();
        this.loadKits();
    }

    private void setup() {
        this.kitsFile = new File(this.plugin.getDataFolder(), "kits.yml");
        if (!this.kitsFile.exists()) {
            try {
                this.kitsFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to create kits.yml: " + e.getMessage());
            }
        }
        this.kitsConfig = YamlConfiguration.loadConfiguration((File)this.kitsFile);
    }

    private void loadKits() {
        if (!this.kitsConfig.contains("kits")) {
            return;
        }
        ConfigurationSection kitsSection = this.kitsConfig.getConfigurationSection("kits");
        for (String kitName : kitsSection.getKeys(false)) {
            ConfigurationSection kitSection = kitsSection.getConfigurationSection(kitName);
            if (kitSection == null) continue;
            long cooldown = kitSection.getLong("cooldown");
            List items = kitSection.getList("items");
            if (items == null) continue;
            this.kits.put(kitName.toLowerCase(), new Kit(kitName, items, cooldown));
        }
    }

    public void saveKits() {
        ConfigurationSection kitsSection = this.kitsConfig.createSection("kits");
        for (Map.Entry<String, Kit> entry : this.kits.entrySet()) {
            String kitName = entry.getKey();
            Kit kit = entry.getValue();
            ConfigurationSection kitSection = kitsSection.createSection(kitName);
            kitSection.set("cooldown", (Object)kit.getCooldown());
            kitSection.set("items", kit.getItems());
        }
        try {
            this.kitsConfig.save(this.kitsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save kits.yml: " + e.getMessage());
        }
    }

    public void createKit(String name, Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null) continue;
            items.add(item.clone());
        }
        this.kits.put(name.toLowerCase(), new Kit(name, items, 0L));
        this.saveKits();
    }

    public Kit getKit(String name) {
        return this.kits.get(name.toLowerCase());
    }

    public Map<String, Kit> getKits() {
        return this.kits;
    }
}

