/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.essentials999;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Essentials999
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private final Map<UUID, PlayerHomes> playerHomes = new ConcurrentHashMap<UUID, PlayerHomes>();
    private final Map<UUID, Location> lastLocations = new ConcurrentHashMap<UUID, Location>();
    private final Map<UUID, Long> warpCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, UUID> tpRequests = new ConcurrentHashMap<UUID, UUID>();
    private final Map<UUID, UUID> tpDenied = new ConcurrentHashMap<UUID, UUID>();
    private final Map<String, Location> spawnPoints = new ConcurrentHashMap<String, Location>();
    private File homesFile;
    private YamlConfiguration homesConfig;
    private WarpsManager warpsManager;
    int maxHomes;
    private boolean teleportSafety;
    private int warpCooldownSeconds;
    private final Map<String, Map<String, Object>> rtpWorldConfigs = new HashMap<String, Map<String, Object>>();
    private boolean globalRtpEnabled;
    private int globalRtpRange;
    private int globalRtpMaxAttempts;
    private int globalRtpCooldownSeconds;
    private int globalRtpMinYLevel;
    private boolean globalRtpCheckCaves;
    private boolean globalRtpAllowNether;
    private boolean globalRtpAllowEnd;
    private final Set<Material> rtpUnsafeBlocks = new HashSet<Material>();
    private final Set<Material> rtpSolidBlocks = new HashSet<Material>();
    private final Map<UUID, Long> rtpCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, String> pendingDeleteHome = new HashMap<UUID, String>();
    private final Map<UUID, BukkitTask> teleportRequestExpireTasks = new HashMap<UUID, BukkitTask>();
    private final Set<UUID> tpGuiEnabledPlayers = new HashSet<UUID>();

    public void onEnable() {
        this.setupConfigs();
        this.loadConfigValues();
        this.loadHomes();
        this.warpsManager = new WarpsManager();
        this.warpsManager.loadWarps();
        this.loadRTPConfig();
        this.registerCommands();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info(String.valueOf(ChatColor.GREEN) + "Essentials999 v1.0.4 enabled!");
    }

    public void onDisable() {
        this.saveHomesAsync();
        this.warpsManager.saveWarpsAsync();
        this.getLogger().info(String.valueOf(ChatColor.RED) + "Essentials999 v1.0.4 disabled!");
    }

    private void setupConfigs() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.saveDefaultConfig();
        this.homesFile = new File(this.getDataFolder(), "homes.yml");
        if (!this.homesFile.exists()) {
            try {
                this.homesFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to create homes.yml: " + e.getMessage());
            }
        }
        this.homesConfig = YamlConfiguration.loadConfiguration((File)this.homesFile);
    }

    private void loadConfigValues() {
        this.maxHomes = this.getConfig().getInt("max-homes", 5);
        this.teleportSafety = this.getConfig().getBoolean("safe-teleport", true);
        this.warpCooldownSeconds = this.getConfig().getInt("warp-cooldown", 10);
        if (this.getConfig().isConfigurationSection("spawn")) {
            for (String worldName : this.getConfig().getConfigurationSection("spawn").getKeys(false)) {
                Location loc = this.getConfig().getLocation("spawn." + worldName);
                if (loc == null) continue;
                this.spawnPoints.put(worldName.toLowerCase(), loc);
            }
        }
    }

    private void loadHomes() {
        if (!this.homesConfig.contains("players")) {
            return;
        }
        for (String uuidStr : this.homesConfig.getConfigurationSection("players").getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(uuidStr);
                PlayerHomes homes = new PlayerHomes(uuid);
                homes.loadFromConfig(this.homesConfig);
                this.playerHomes.put(uuid, homes);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid UUID in homes.yml: " + uuidStr);
            }
        }
    }

    public void saveHomesAsync() {
        new BukkitRunnable(){

            public void run() {
                Essentials999.this.saveHomes();
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    private synchronized void saveHomes() {
        this.homesConfig.set("players", null);
        this.playerHomes.forEach((uuid, homes) -> homes.saveToConfig(this.homesConfig));
        try {
            this.homesConfig.save(this.homesFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save homes.yml: " + e.getMessage());
        }
    }

    private void loadRTPConfig() {
        FileConfiguration config = this.getConfig();
        this.globalRtpEnabled = config.getBoolean("rtp.enabled", true);
        this.globalRtpRange = config.getInt("rtp.range", 1000);
        this.globalRtpMaxAttempts = config.getInt("rtp.max-attempts", 15);
        this.globalRtpCooldownSeconds = config.getInt("rtp.cooldown-seconds", 60);
        this.globalRtpMinYLevel = config.getInt("rtp.min-y-level", 80);
        this.globalRtpCheckCaves = config.getBoolean("rtp.check-caves", true);
        this.globalRtpAllowNether = config.getBoolean("rtp.allow-nether", false);
        this.globalRtpAllowEnd = config.getBoolean("rtp.allow-end", false);
        this.rtpWorldConfigs.clear();
        ConfigurationSection worldsSec = config.getConfigurationSection("rtp.worlds");
        if (worldsSec != null) {
            for (String worldName : worldsSec.getKeys(false)) {
                ConfigurationSection w = worldsSec.getConfigurationSection(worldName);
                if (w == null) continue;
                HashMap<String, Comparable<Boolean>> worldConfig = new HashMap<String, Comparable<Boolean>>();
                worldConfig.put("enabled", Boolean.valueOf(w.getBoolean("enabled", true)));
                worldConfig.put("range", Integer.valueOf(w.getInt("range", this.globalRtpRange)));
                worldConfig.put("max-attempts", Integer.valueOf(w.getInt("max-attempts", this.globalRtpMaxAttempts)));
                worldConfig.put("cooldown-seconds", Integer.valueOf(w.getInt("cooldown-seconds", this.globalRtpCooldownSeconds)));
                worldConfig.put("min-y-level", Integer.valueOf(w.getInt("min-y-level", this.globalRtpMinYLevel)));
                worldConfig.put("check-caves", Boolean.valueOf(w.getBoolean("check-caves", this.globalRtpCheckCaves)));
                worldConfig.put("allow-nether", Boolean.valueOf(w.getBoolean("allow-nether", this.globalRtpAllowNether)));
                worldConfig.put("allow-end", Boolean.valueOf(w.getBoolean("allow-end", this.globalRtpAllowEnd)));
                this.rtpWorldConfigs.put(worldName, worldConfig);
            }
        }
        this.rtpUnsafeBlocks.clear();
        Collections.addAll(this.rtpUnsafeBlocks, Material.LAVA, Material.CACTUS, Material.FIRE, Material.SOUL_FIRE, Material.MAGMA_BLOCK, Material.SWEET_BERRY_BUSH, Material.COBWEB, Material.POWDER_SNOW, Material.WATER, Material.WHITE_CARPET, Material.OAK_LEAVES, Material.SPRUCE_LEAVES, Material.BIRCH_LEAVES, Material.JUNGLE_LEAVES, Material.ACACIA_LEAVES, Material.DARK_OAK_LEAVES);
        this.rtpSolidBlocks.clear();
        Collections.addAll(this.rtpSolidBlocks, Material.GRASS_BLOCK, Material.DIRT, Material.STONE, Material.SAND, Material.GRAVEL, Material.COBBLESTONE, Material.OAK_PLANKS, Material.BEDROCK, Material.NETHERRACK, Material.END_STONE, Material.TERRACOTTA, Material.CLAY, Material.DEEPSLATE, Material.SANDSTONE, Material.MYCELIUM, Material.PODZOL, Material.SOUL_SAND, Material.SOUL_SOIL, Material.BASALT, Material.BLACKSTONE, Material.POLISHED_BLACKSTONE, Material.QUARTZ_BLOCK, Material.OBSIDIAN, Material.COPPER_BLOCK, Material.ENCHANTING_TABLE, Material.BOOKSHELF);
    }

    private void registerCommands() {
        String[] commands;
        for (String cmd : commands = new String[]{"sethome", "rtp", "delhome", "home", "homes", "back", "setspawn", "spawn", "setwarp", "delwarp", "warp", "warps", "tpask", "tpahere", "tpaccept", "tpdeny", "tpgui", "essentials999"}) {
            Objects.requireNonNull(this.getCommand(cmd)).setExecutor((CommandExecutor)this);
            Objects.requireNonNull(this.getCommand(cmd)).setTabCompleter((TabCompleter)this);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String cmdName;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        switch (cmdName = cmd.getName().toLowerCase()) {
            case "sethome": {
                return this.setHomeCommand(player, args);
            }
            case "delhome": {
                return this.deleteHomeCommand(player, args);
            }
            case "home": {
                return this.homeCommand(player, args);
            }
            case "homes": {
                return this.openHomesGUI(player);
            }
            case "back": {
                return this.backCommand(player);
            }
            case "setspawn": {
                return this.setSpawnCommand(player);
            }
            case "spawn": {
                return this.spawnCommand(player);
            }
            case "setwarp": {
                return this.setWarpCommand(player, args);
            }
            case "delwarp": {
                return this.deleteWarpCommand(player, args);
            }
            case "warp": {
                return this.warpCommand(player, args);
            }
            case "warps": {
                return this.openWarpsGUI(player);
            }
            case "tpask": {
                return this.tpAskCommand(player, args);
            }
            case "tpahere": {
                return this.tpHereCommand(player, args);
            }
            case "tpaccept": {
                return this.tpAcceptCommand(player);
            }
            case "tpdeny": {
                return this.tpDenyCommand(player);
            }
            case "tpgui": {
                return this.toggleTpGui(player, args);
            }
            case "essentials999": {
                if (args.length > 0 && args[0].equalsIgnoreCase("help")) {
                    return this.openHelpGUI(player);
                }
                return false;
            }
            case "rtp": {
                return this.rtpCommand(player);
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        String cmdName;
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        switch (cmdName = cmd.getName().toLowerCase()) {
            case "home": 
            case "delhome": {
                PlayerHomes homes;
                if (args.length != 1 || (homes = this.playerHomes.get(player.getUniqueId())) == null) break;
                return this.filterStartingWith(homes.getHomeNames(), args[0]);
            }
            case "warp": 
            case "delwarp": {
                if (args.length != 1) break;
                return this.filterStartingWith(this.warpsManager.getWarpNames(), args[0]);
            }
            case "tpask": 
            case "tpahere": {
                if (args.length != 1) break;
                ArrayList<String> onlineNames = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (p.equals((Object)player)) continue;
                    onlineNames.add(p.getName());
                }
                return this.filterStartingWith(onlineNames, args[0]);
            }
            case "tpgui": {
                if (args.length != 1) break;
                return this.filterStartingWith(Collections.singletonList("toggle"), args[0]);
            }
        }
        return Collections.emptyList();
    }

    private List<String> filterStartingWith(Collection<String> options, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        String lowerPrefix = prefix.toLowerCase();
        for (String option : options) {
            if (!option.toLowerCase().startsWith(lowerPrefix)) continue;
            result.add(option);
        }
        return result;
    }

    private boolean setHomeCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.sethome")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /sethome <name>");
            return true;
        }
        String homeName = args[0];
        PlayerHomes homes = this.playerHomes.computeIfAbsent(player.getUniqueId(), k -> new PlayerHomes(player.getUniqueId()));
        if (!homes.setHome(homeName, player.getLocation())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You've reached your home limit (" + this.maxHomes + "). Delete another home first.");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Home '" + homeName + "' set successfully!");
        this.saveHomesAsync();
        return true;
    }

    private boolean deleteHomeCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.delhome")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /delhome <name>");
            return true;
        }
        String homeName = args[0];
        PlayerHomes homes = this.playerHomes.get(player.getUniqueId());
        if (homes == null || !homes.deleteHome(homeName)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Home '" + homeName + "' doesn't exist.");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Home '" + homeName + "' deleted successfully!");
        this.saveHomesAsync();
        return true;
    }

    private boolean homeCommand(Player player, String[] args) {
        Location homeLoc;
        if (!player.hasPermission("essentials999.home")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /home <name>");
            return true;
        }
        String homeName = args[0];
        PlayerHomes homes = this.playerHomes.get(player.getUniqueId());
        Location location = homeLoc = homes != null ? homes.getHome(homeName) : null;
        if (homeLoc == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Home '" + homeName + "' doesn't exist.");
            return true;
        }
        this.teleportPlayerSafe(player, homeLoc, "home '" + homeName + "'");
        return true;
    }

    private boolean backCommand(Player player) {
        if (!player.hasPermission("essentials999.back")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        Location lastLocation = this.lastLocations.get(player.getUniqueId());
        if (lastLocation == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No previous location found.");
            return true;
        }
        this.teleportPlayerSafe(player, lastLocation, "last location");
        return true;
    }

    private boolean setSpawnCommand(Player player) {
        if (!player.hasPermission("essentials999.setspawn")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        Location loc = player.getLocation();
        String worldName = loc.getWorld().getName().toLowerCase();
        this.spawnPoints.put(worldName, loc);
        this.getConfig().set("spawn." + worldName, (Object)loc);
        this.saveConfig();
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Spawn point set for world '" + worldName + "' successfully!");
        return true;
    }

    private boolean spawnCommand(Player player) {
        if (!player.hasPermission("essentials999.spawn")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        String worldName = player.getWorld().getName().toLowerCase();
        Location spawnLoc = this.spawnPoints.get(worldName);
        if (spawnLoc == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Spawn point has not been set for this world.");
            return true;
        }
        this.teleportPlayerSafe(player, spawnLoc, "spawn");
        return true;
    }

    private boolean setWarpCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.setwarp")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /setwarp <name>");
            return true;
        }
        String warpName = args[0];
        this.warpsManager.setWarp(warpName, player.getLocation());
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Warp '" + warpName + "' set successfully!");
        return true;
    }

    private boolean deleteWarpCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.delwarp")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /delwarp <name>");
            return true;
        }
        String warpName = args[0];
        if (!this.warpsManager.deleteWarp(warpName)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Warp '" + warpName + "' doesn't exist.");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Warp '" + warpName + "' deleted successfully!");
        return true;
    }

    private boolean warpCommand(Player player, String[] args) {
        long cooldownMillis;
        if (!player.hasPermission("essentials999.warp")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /warp <name>");
            return true;
        }
        String warpName = args[0];
        Location warpLoc = this.warpsManager.getWarp(warpName);
        if (warpLoc == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Warp '" + warpName + "' doesn't exist.");
            return true;
        }
        long lastWarpTime = this.warpCooldowns.getOrDefault(player.getUniqueId(), 0L);
        long now = System.currentTimeMillis();
        long elapsed = now - lastWarpTime;
        if (elapsed < (cooldownMillis = (long)this.warpCooldownSeconds * 1000L)) {
            long timeLeft = (cooldownMillis - elapsed) / 1000L;
            player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait " + timeLeft + " seconds before warping again.");
            return true;
        }
        this.warpCooldowns.put(player.getUniqueId(), now);
        this.teleportPlayerSafe(player, warpLoc, "warp '" + warpName + "'");
        return true;
    }

    private boolean openWarpsGUI(Player player) {
        if (!player.hasPermission("essentials999.warps")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        Set<String> warps = this.warpsManager.getWarpNames();
        if (warps.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No warps have been set.");
            return true;
        }
        int size = ((warps.size() - 1) / 9 + 1) * 9;
        Inventory inv = this.getServer().createInventory(null, size, String.valueOf(ChatColor.DARK_AQUA) + "Warps");
        long now = System.currentTimeMillis();
        long cooldownMillis = (long)this.warpCooldownSeconds * 1000L;
        long lastWarpTime = this.warpCooldowns.getOrDefault(player.getUniqueId(), 0L);
        long elapsed = now - lastWarpTime;
        long timeLeft = Math.max(0L, (cooldownMillis - elapsed) / 1000L);
        for (String warpName : warps) {
            Location loc = this.warpsManager.getWarp(warpName);
            if (loc == null) continue;
            ItemStack item = new ItemStack(Material.COMPASS);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + warpName);
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            if (timeLeft > 0L) {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "Cooldown: " + timeLeft + " seconds")));
            } else {
                lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Left-click to warp")));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            inv.addItem(new ItemStack[]{item});
        }
        player.openInventory(inv);
        return true;
    }

    private boolean tpAskCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.tpask")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /tpask <playername>");
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null || !target.isOnline()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        if (target.equals((Object)player)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot send a teleport request to yourself.");
            return true;
        }
        this.tpRequests.put(target.getUniqueId(), player.getUniqueId());
        this.tpDenied.remove(target.getUniqueId());
        target.sendMessage(String.valueOf(ChatColor.YELLOW) + player.getName() + " has requested to teleport to you. Use /tpaccept to accept or /tpdeny to deny.");
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleport request sent to " + target.getName() + ".");
        return true;
    }

    private boolean tpHereCommand(Player player, String[] args) {
        if (!player.hasPermission("essentials999.tpahere")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /tpahere <playername>");
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null || !target.isOnline()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        if (target.equals((Object)player)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot send a teleport request to yourself.");
            return true;
        }
        this.tpRequests.put(target.getUniqueId(), player.getUniqueId());
        this.tpDenied.remove(target.getUniqueId());
        target.sendMessage(String.valueOf(ChatColor.YELLOW) + player.getName() + " has requested you to teleport to them. Use /tpaccept to accept or /tpdeny to deny.");
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleport request sent to " + target.getName() + ".");
        return true;
    }

    private boolean tpAcceptCommand(Player player) {
        if (!player.hasPermission("essentials999.tpaccept")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        UUID requesterId = this.tpRequests.remove(player.getUniqueId());
        if (requesterId == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You have no pending teleport requests.");
            return true;
        }
        if (this.tpDenied.containsKey(player.getUniqueId()) && this.tpDenied.get(player.getUniqueId()).equals(requesterId)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You have denied this teleport request.");
            this.tpDenied.remove(player.getUniqueId());
            return true;
        }
        Player requester = Bukkit.getPlayer((UUID)requesterId);
        if (requester != null && requester.isOnline()) {
            requester.teleport(player.getLocation());
            requester.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been teleported to " + player.getName() + "!");
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have accepted the teleport request from " + requester.getName() + "!");
        } else {
            player.sendMessage(String.valueOf(ChatColor.RED) + "The player who requested to teleport is no longer online.");
        }
        return true;
    }

    private boolean tpDenyCommand(Player player) {
        if (!player.hasPermission("essentials999.tpdeny")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        UUID requesterId = this.tpRequests.remove(player.getUniqueId());
        if (requesterId == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You have no pending teleport requests.");
            return true;
        }
        this.tpDenied.put(player.getUniqueId(), requesterId);
        Player requester = Bukkit.getPlayer((UUID)requesterId);
        if (requester != null && requester.isOnline()) {
            requester.sendMessage(String.valueOf(ChatColor.RED) + player.getName() + " has denied your teleport request.");
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleport request denied.");
        return true;
    }

    private void teleportPlayerSafe(final Player player, final Location targetLoc, final String destinationName) {
        new BukkitRunnable(){

            public void run() {
                int chunkZ;
                World world = targetLoc.getWorld();
                if (world == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid world for teleport.");
                    return;
                }
                int chunkX = targetLoc.getBlockX() >> 4;
                if (!world.isChunkLoaded(chunkX, chunkZ = targetLoc.getBlockZ() >> 4)) {
                    world.loadChunk(chunkX, chunkZ);
                }
                Location safeLoc = targetLoc.clone().add(0.5, 0.0, 0.5);
                if (Essentials999.this.teleportSafety && !Essentials999.this.isSafeLocation(safeLoc)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Cannot teleport to " + destinationName + " because the location is unsafe.");
                    return;
                }
                Essentials999.this.lastLocations.put(player.getUniqueId(), player.getLocation());
                player.teleport(safeLoc);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleported to " + destinationName + "!");
            }
        }.runTask((Plugin)this);
    }

    private boolean isSafeLocation(Location loc) {
        if (loc == null) {
            return false;
        }
        World world = loc.getWorld();
        if (world == null) {
            return false;
        }
        Location feet = loc.clone();
        Location head = loc.clone().add(0.0, 1.0, 0.0);
        return !feet.getBlock().getType().isSolid() && !head.getBlock().getType().isSolid();
    }

    private boolean openHomesGUI(Player player) {
        if (!player.hasPermission("essentials999.homes")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        PlayerHomes homes = this.playerHomes.get(player.getUniqueId());
        if (homes == null || homes.getHomeNames().isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have any homes.");
            return true;
        }
        Set<String> homeNames = homes.getHomeNames();
        int size = ((homeNames.size() - 1) / 9 + 1) * 9;
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)(String.valueOf(ChatColor.DARK_GREEN) + "Your Homes"));
        for (String homeName : homeNames) {
            Location loc = homes.getHome(homeName);
            if (loc == null) continue;
            ItemStack item = new ItemStack(Material.RED_BED);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + homeName);
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Left-click to teleport")));
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.RED) + "Right-click to delete")));
            meta.setLore(lore);
            item.setItemMeta(meta);
            inv.addItem(new ItemStack[]{item});
        }
        player.openInventory(inv);
        return true;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inv = event.getInventory();
        String title = event.getView().getTitle();
        if (title.startsWith(String.valueOf(ChatColor.DARK_GREEN) + "Your Homes")) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            if (event.getClick().isLeftClick()) {
                String homeName = ChatColor.stripColor((String)event.getCurrentItem().getItemMeta().getDisplayName());
                PlayerHomes homes = this.playerHomes.get(player.getUniqueId());
                if (homes == null) {
                    return;
                }
                Location loc = homes.getHome(homeName);
                if (loc == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Home '" + homeName + "' no longer exists.");
                    player.closeInventory();
                    return;
                }
                player.closeInventory();
                this.teleportPlayerSafe(player, loc, "home '" + homeName + "'");
            } else if (event.getClick().isRightClick()) {
                String homeName = ChatColor.stripColor((String)event.getCurrentItem().getItemMeta().getDisplayName());
                player.closeInventory();
                this.openDeleteConfirmGUI(player, homeName);
            }
        } else if (title.startsWith(String.valueOf(ChatColor.RED) + "Delete home")) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            String homeName = this.pendingDeleteHome.get(player.getUniqueId());
            if (homeName == null) {
                player.closeInventory();
                return;
            }
            Material clicked = event.getCurrentItem().getType();
            if (clicked == Material.GREEN_STAINED_GLASS_PANE) {
                PlayerHomes homes = this.playerHomes.get(player.getUniqueId());
                if (homes != null && homes.deleteHome(homeName)) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Home '" + homeName + "' deleted successfully!");
                    this.saveHomesAsync();
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Home '" + homeName + "' no longer exists.");
                }
                this.pendingDeleteHome.remove(player.getUniqueId());
                player.closeInventory();
            } else if (clicked == Material.RED_STAINED_GLASS_PANE) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Home deletion cancelled.");
                this.pendingDeleteHome.remove(player.getUniqueId());
                player.closeInventory();
            }
        } else if (title.startsWith(String.valueOf(ChatColor.DARK_AQUA) + "Warps")) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            if (event.getClick().isLeftClick()) {
                String warpName = ChatColor.stripColor((String)event.getCurrentItem().getItemMeta().getDisplayName());
                player.closeInventory();
                this.warpCommand(player, new String[]{warpName});
            }
        }
    }

    private void openDeleteConfirmGUI(Player player, String homeName) {
        Inventory inv = Bukkit.createInventory(null, (int)9, (String)(String.valueOf(ChatColor.RED) + "Delete home '" + homeName + "'?"));
        ItemStack yes = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta yesMeta = yes.getItemMeta();
        yesMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Yes");
        yes.setItemMeta(yesMeta);
        ItemStack no = new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta noMeta = no.getItemMeta();
        noMeta.setDisplayName(String.valueOf(ChatColor.RED) + "No");
        no.setItemMeta(noMeta);
        ItemStack filler = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(" ");
        filler.setItemMeta(fillerMeta);
        for (int i = 0; i < 9; ++i) {
            if (i == 3 || i == 5) continue;
            inv.setItem(i, filler);
        }
        inv.setItem(3, no);
        inv.setItem(5, yes);
        this.pendingDeleteHome.put(player.getUniqueId(), homeName);
        player.openInventory(inv);
    }

    private boolean openHelpGUI(Player player) {
        if (!player.hasPermission("essentials999.help")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        int size = 27;
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)(String.valueOf(ChatColor.BLUE) + "Essentials999 Help"));
        ItemStack homesCat = new ItemStack(Material.RED_BED);
        ItemMeta homesMeta = homesCat.getItemMeta();
        homesMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Homes Commands");
        homesMeta.setLore(Arrays.asList(String.valueOf(ChatColor.YELLOW) + "/sethome <name> - Set a home", String.valueOf(ChatColor.YELLOW) + "/home <name> - Teleport home", String.valueOf(ChatColor.YELLOW) + "/delhome <name> - Delete home", String.valueOf(ChatColor.YELLOW) + "/homes - List homes (GUI)"));
        homesCat.setItemMeta(homesMeta);
        inv.setItem(10, homesCat);
        ItemStack warpsCat = new ItemStack(Material.COMPASS);
        ItemMeta warpsMeta = warpsCat.getItemMeta();
        warpsMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Warps Commands");
        warpsMeta.setLore(Arrays.asList(String.valueOf(ChatColor.YELLOW) + "/warp <name> - Warp to location", String.valueOf(ChatColor.YELLOW) + "/warps - List warps (GUI)"));
        warpsCat.setItemMeta(warpsMeta);
        inv.setItem(12, warpsCat);
        ItemStack tpCat = new ItemStack(Material.ENDER_PEARL);
        ItemMeta tpMeta = tpCat.getItemMeta();
        tpMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Teleport Commands");
        tpMeta.setLore(Arrays.asList(String.valueOf(ChatColor.YELLOW) + "/tpask <player> - Request teleport", String.valueOf(ChatColor.YELLOW) + "/tpahere <player> - Request player teleport", String.valueOf(ChatColor.YELLOW) + "/tpaccept - Accept teleport", String.valueOf(ChatColor.YELLOW) + "/tpdeny - Deny teleport", String.valueOf(ChatColor.YELLOW) + "/back - Return to last location", String.valueOf(ChatColor.YELLOW) + "/spawn - Teleport to spawn", String.valueOf(ChatColor.YELLOW) + "/setspawn - Set spawn"));
        tpCat.setItemMeta(tpMeta);
        inv.setItem(14, tpCat);
        ItemStack adminCat = new ItemStack(Material.DIAMOND_SWORD);
        ItemMeta adminMeta = adminCat.getItemMeta();
        adminMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Admin Commands");
        adminMeta.setLore(Arrays.asList(String.valueOf(ChatColor.YELLOW) + "/setwarp <name> - Set warp", String.valueOf(ChatColor.YELLOW) + "/delwarp <name> - Delete warp", String.valueOf(ChatColor.YELLOW) + "/tpgui toggle - Toggle teleport request GUI"));
        adminCat.setItemMeta(adminMeta);
        inv.setItem(16, adminCat);
        player.openInventory(inv);
        return true;
    }

    private boolean toggleTpGui(Player player, String[] args) {
        if (!player.hasPermission("essentials999.tpgui")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1 || !args[0].equalsIgnoreCase("toggle")) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /tpgui toggle");
            return true;
        }
        UUID uuid = player.getUniqueId();
        if (this.tpGuiEnabledPlayers.contains(uuid)) {
            this.tpGuiEnabledPlayers.remove(uuid);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Teleport request GUI disabled.");
        } else {
            this.tpGuiEnabledPlayers.add(uuid);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleport request GUI enabled.");
        }
        return true;
    }

    private boolean isTpGuiEnabled(Player player) {
        return this.tpGuiEnabledPlayers.contains(player.getUniqueId());
    }

    private void openTeleportRequestGUI(Player target, Player requester, boolean requesterToTarget) {
        if (!this.isTpGuiEnabled(target)) {
            target.sendMessage(String.valueOf(ChatColor.YELLOW) + requester.getName() + " has requested to teleport " + (requesterToTarget ? "to you" : "you to them") + ". Use /tpaccept or /tpdeny.");
            return;
        }
        Inventory inv = Bukkit.createInventory(null, (int)9, (String)(String.valueOf(ChatColor.GOLD) + "Teleport Request"));
        ItemStack accept = new ItemStack(Material.GREEN_WOOL);
        ItemMeta acceptMeta = accept.getItemMeta();
        acceptMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Accept");
        accept.setItemMeta(acceptMeta);
        ItemStack deny = new ItemStack(Material.RED_WOOL);
        ItemMeta denyMeta = deny.getItemMeta();
        denyMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Deny");
        deny.setItemMeta(denyMeta);
        ItemStack filler = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(" ");
        filler.setItemMeta(fillerMeta);
        for (int i = 0; i < 9; ++i) {
            if (i == 3 || i == 5) continue;
            inv.setItem(i, filler);
        }
        inv.setItem(3, deny);
        inv.setItem(5, accept);
        target.openInventory(inv);
        BukkitTask task = this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
            if (target.getOpenInventory().getTopInventory().equals((Object)inv)) {
                target.closeInventory();
                target.sendMessage(String.valueOf(ChatColor.RED) + "Teleport request expired.");
                this.tpRequests.remove(target.getUniqueId());
            }
        }, 600L);
        this.teleportRequestExpireTasks.put(target.getUniqueId(), task);
    }

    private boolean rtpCommand(Player player) {
        ItemMeta meta;
        boolean enabled;
        if (!player.hasPermission("essentials999.rtp")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        String worldName = player.getWorld().getName();
        Map config = this.rtpWorldConfigs.getOrDefault(worldName, null);
        boolean bl = enabled = config != null ? config.getOrDefault("enabled", this.globalRtpEnabled) : this.globalRtpEnabled;
        if (!enabled) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "RTP is disabled in this world.");
            return true;
        }
        int cooldownSeconds = config != null ? config.getOrDefault("cooldown-seconds", this.globalRtpCooldownSeconds) : this.globalRtpCooldownSeconds;
        boolean allowNether = config != null ? config.getOrDefault("allow-nether", this.globalRtpAllowNether) : this.globalRtpAllowNether;
        boolean allowEnd = config != null ? config.getOrDefault("allow-end", this.globalRtpAllowEnd) : this.globalRtpAllowEnd;
        int size = 9;
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)(String.valueOf(ChatColor.DARK_PURPLE) + "Random Teleport"));
        if (worldName.equalsIgnoreCase("world") || allowNether || allowEnd) {
            ItemStack overworldBtn = new ItemStack(Material.GRASS_BLOCK);
            meta = overworldBtn.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "RTP in Overworld");
            meta.setLore(Collections.singletonList(String.valueOf(ChatColor.YELLOW) + "Click to teleport randomly in Overworld"));
            overworldBtn.setItemMeta(meta);
            inv.setItem(2, overworldBtn);
        }
        if (allowNether && this.getServer().getWorld("world_nether") != null) {
            ItemStack netherBtn = new ItemStack(Material.NETHERRACK);
            meta = netherBtn.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.RED) + "RTP in Nether");
            meta.setLore(Collections.singletonList(String.valueOf(ChatColor.YELLOW) + "Click to teleport randomly in Nether"));
            netherBtn.setItemMeta(meta);
            inv.setItem(4, netherBtn);
        }
        if (allowEnd && this.getServer().getWorld("world_the_end") != null) {
            ItemStack endBtn = new ItemStack(Material.END_STONE);
            meta = endBtn.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.LIGHT_PURPLE) + "RTP in End");
            meta.setLore(Collections.singletonList(String.valueOf(ChatColor.YELLOW) + "Click to teleport randomly in End"));
            endBtn.setItemMeta(meta);
            inv.setItem(6, endBtn);
        }
        long now = System.currentTimeMillis();
        long lastRtp = this.rtpCooldowns.getOrDefault(player.getUniqueId(), 0L);
        long cooldownMillis = (long)cooldownSeconds * 1000L;
        long elapsed = now - lastRtp;
        long timeLeft = Math.max(0L, (cooldownMillis - elapsed) / 1000L);
        ItemStack cooldownItem = new ItemStack(Material.CLOCK);
        ItemMeta cooldownMeta = cooldownItem.getItemMeta();
        cooldownMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Cooldown");
        cooldownMeta.setLore(Collections.singletonList(String.valueOf(ChatColor.YELLOW) + (String)(timeLeft > 0L ? timeLeft + " seconds left" : "Ready")));
        cooldownItem.setItemMeta(cooldownMeta);
        inv.setItem(8, cooldownItem);
        player.openInventory(inv);
        return true;
    }

    @EventHandler
    public void onInventoryClickAdditional(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inv = event.getInventory();
        String title = event.getView().getTitle();
        if (title.equals(String.valueOf(ChatColor.GOLD) + "Teleport Request")) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            Material clicked = event.getCurrentItem().getType();
            UUID playerId = player.getUniqueId();
            UUID requesterId = this.tpRequests.get(playerId);
            if (requesterId == null) {
                player.closeInventory();
                return;
            }
            Player requester = Bukkit.getPlayer((UUID)requesterId);
            if (clicked == Material.GREEN_WOOL) {
                if (requester != null && requester.isOnline()) {
                    requester.teleport(player.getLocation());
                    requester.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been teleported to " + player.getName() + "!");
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "You accepted the teleport request from " + requester.getName() + "!");
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Requester is no longer online.");
                }
                this.tpRequests.remove(playerId);
                player.closeInventory();
            } else if (clicked == Material.RED_WOOL) {
                if (requester != null && requester.isOnline()) {
                    requester.sendMessage(String.valueOf(ChatColor.RED) + player.getName() + " denied your teleport request.");
                }
                this.tpRequests.remove(playerId);
                player.closeInventory();
            }
        } else if (title.equals(String.valueOf(ChatColor.DARK_PURPLE) + "Random Teleport")) {
            long cooldownMillis;
            long lastRtp;
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            Material clicked = event.getCurrentItem().getType();
            String worldName = player.getWorld().getName();
            Map config = this.rtpWorldConfigs.getOrDefault(worldName, null);
            int range = config != null ? config.getOrDefault("range", this.globalRtpRange) : this.globalRtpRange;
            int maxAttempts = config != null ? config.getOrDefault("max-attempts", this.globalRtpMaxAttempts) : this.globalRtpMaxAttempts;
            int cooldownSeconds = config != null ? config.getOrDefault("cooldown-seconds", this.globalRtpCooldownSeconds) : this.globalRtpCooldownSeconds;
            long now = System.currentTimeMillis();
            long elapsed = now - (lastRtp = this.rtpCooldowns.getOrDefault(player.getUniqueId(), 0L).longValue());
            if (elapsed < (cooldownMillis = (long)cooldownSeconds * 1000L)) {
                long timeLeft = (cooldownMillis - elapsed) / 1000L;
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait " + timeLeft + " seconds before using RTP again.");
                player.closeInventory();
                return;
            }
            World targetWorld = null;
            if (clicked == Material.GRASS_BLOCK) {
                targetWorld = this.getServer().getWorld("world");
            } else if (clicked == Material.NETHERRACK) {
                targetWorld = this.getServer().getWorld("world_nether");
            } else if (clicked == Material.END_STONE) {
                targetWorld = this.getServer().getWorld("world_the_end");
            }
            if (targetWorld == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "This dimension is not available for RTP.");
                player.closeInventory();
                return;
            }
            player.closeInventory();
            this.rtpCooldowns.put(player.getUniqueId(), now);
            this.performRTP(player, targetWorld, range, maxAttempts);
        }
    }

    private void performRTP(final Player player, final World world, final int range, final int maxAttempts) {
        new BukkitRunnable(){

            public void run() {
                Location loc = null;
                for (int i = 0; i < maxAttempts; ++i) {
                    int z;
                    int y;
                    int x = ThreadLocalRandom.current().nextInt(-range, range + 1);
                    Location candidate = new Location(world, (double)x + 0.5, (double)(y = world.getHighestBlockYAt(x, z = ThreadLocalRandom.current().nextInt(-range, range + 1))), (double)z + 0.5);
                    if (!Essentials999.this.isSafeLocation(candidate)) continue;
                    loc = candidate;
                    break;
                }
                if (loc == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Failed to find a safe location for RTP. Try again later.");
                    return;
                }
                final Location finalLoc = loc;
                new BukkitRunnable(){

                    public void run() {
                        Essentials999.this.teleportPlayerSafe(player, finalLoc, "Random Teleport");
                    }
                }.runTask((Plugin)Essentials999.this);
            }
        }.runTaskAsynchronously((Plugin)this);
    }

    public class WarpsManager {
        private final Map<String, Location> warps = new HashMap<String, Location>();
        private File warpsFile;
        private YamlConfiguration warpsConfig;

        public WarpsManager() {
            this.setup();
        }

        private void setup() {
            this.warpsFile = new File(Essentials999.this.getDataFolder(), "warps.yml");
            if (!this.warpsFile.exists()) {
                try {
                    this.warpsFile.createNewFile();
                }
                catch (IOException e) {
                    Essentials999.this.getLogger().severe("Failed to create warps.yml: " + e.getMessage());
                }
            }
            this.warpsConfig = YamlConfiguration.loadConfiguration((File)this.warpsFile);
        }

        public void loadWarps() {
            this.warps.clear();
            if (!this.warpsConfig.contains("warps")) {
                return;
            }
            ConfigurationSection sec = this.warpsConfig.getConfigurationSection("warps");
            if (sec == null) {
                return;
            }
            for (String warpName : sec.getKeys(false)) {
                Location loc = sec.getLocation(warpName);
                if (loc == null) continue;
                this.warps.put(warpName.toLowerCase(), loc);
            }
        }

        public void saveWarpsAsync() {
            new BukkitRunnable(){

                public void run() {
                    WarpsManager.this.saveWarps();
                }
            }.runTaskAsynchronously((Plugin)Essentials999.this);
        }

        private synchronized void saveWarps() {
            this.warpsConfig.set("warps", null);
            for (Map.Entry<String, Location> entry : this.warps.entrySet()) {
                this.warpsConfig.set("warps." + entry.getKey(), (Object)entry.getValue());
            }
            try {
                this.warpsConfig.save(this.warpsFile);
            }
            catch (IOException e) {
                Essentials999.this.getLogger().severe("Failed to save warps.yml: " + e.getMessage());
            }
        }

        public void setWarp(String name, Location loc) {
            this.warps.put(name.toLowerCase(), loc);
            this.saveWarpsAsync();
        }

        public boolean deleteWarp(String name) {
            if (this.warps.remove(name.toLowerCase()) != null) {
                this.saveWarpsAsync();
                return true;
            }
            return false;
        }

        public Location getWarp(String name) {
            return this.warps.get(name.toLowerCase());
        }

        public Set<String> getWarpNames() {
            return new HashSet<String>(this.warps.keySet());
        }
    }

    public class PlayerHomes {
        private final UUID playerUUID;
        private final Map<String, Location> homes = new HashMap<String, Location>();

        public PlayerHomes(UUID playerUUID) {
            this.playerUUID = playerUUID;
        }

        public boolean setHome(String name, Location loc) {
            if (this.homes.size() >= Essentials999.this.maxHomes && !this.homes.containsKey(name.toLowerCase())) {
                return false;
            }
            this.homes.put(name.toLowerCase(), loc);
            return true;
        }

        public boolean deleteHome(String name) {
            return this.homes.remove(name.toLowerCase()) != null;
        }

        public Location getHome(String name) {
            return this.homes.get(name.toLowerCase());
        }

        public Set<String> getHomeNames() {
            return new HashSet<String>(this.homes.keySet());
        }

        public void loadFromConfig(YamlConfiguration config) {
            String path = "players." + this.playerUUID.toString() + ".homes";
            if (!config.contains(path)) {
                return;
            }
            ConfigurationSection sec = config.getConfigurationSection(path);
            if (sec == null) {
                return;
            }
            for (String homeName : sec.getKeys(false)) {
                Location loc = sec.getLocation(homeName);
                if (loc == null) continue;
                this.homes.put(homeName.toLowerCase(), loc);
            }
        }

        public void saveToConfig(YamlConfiguration config) {
            String path = "players." + this.playerUUID.toString() + ".homes";
            config.set(path, null);
            for (Map.Entry<String, Location> entry : this.homes.entrySet()) {
                config.set(path + "." + entry.getKey(), (Object)entry.getValue());
            }
        }
    }
}

