/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import xaero.pac.client.gui.WidgetListElement;
import xaero.pac.client.gui.XPACScreen;

public abstract class WidgetListScreen
extends XPACScreen {
    private static final int ROW_HEIGHT = 24;
    private static final int PER_PAGE = 12;
    private int page;
    private final int pageCount;
    protected final List<WidgetListElement<?>> elements;
    private final List<class_342> tickableBoxes;
    private class_2561 displayedTitle;
    private class_4185 nextButton;
    private class_4185 prevButton;

    protected WidgetListScreen(List<WidgetListElement<?>> elements, List<class_342> tickableBoxes, class_437 escape, class_437 parent, class_2561 p_96550_) {
        super(escape, parent, p_96550_);
        this.elements = elements;
        this.tickableBoxes = tickableBoxes;
        this.pageCount = (elements.size() + 12 - 1) / 12;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int xAnchor = this.field_22789 / 2;
        int yAnchor = this.field_22790 / 7;
        int startIndex = this.getStartIndex();
        int endIndex = this.getEndIndex();
        this.tickableBoxes.clear();
        for (int index = startIndex; index < endIndex; ++index) {
            int indexOff = index - startIndex;
            int x = xAnchor - 205 + 210 * (indexOff / 6);
            int y = yAnchor + indexOff % 6 * 24;
            this.elements.get(index).screenInit(x, y, this, this.tickableBoxes);
        }
        this.method_37063(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.xaero_pac_back"), this::onBackButton).method_46434(xAnchor - 100, this.field_22790 / 6 + 168, 200, 20).method_46431());
        this.prevButton = class_4185.method_46430((class_2561)class_2561.method_43469((String)"gui.xaero_pac_previous", (Object[])new Object[0]), this::onPrevButton).method_46434(this.field_22789 / 2 - 205, yAnchor + 144, 75, 20).method_46431();
        this.nextButton = class_4185.method_46430((class_2561)class_2561.method_43469((String)"gui.xaero_pac_next", (Object[])new Object[0]), this::onNextButton).method_46434(this.field_22789 / 2 + 131, yAnchor + 144, 75, 20).method_46431();
        if (this.pageCount > 1) {
            this.method_37063(this.prevButton);
            this.method_37063(this.nextButton);
            this.prevButton.field_22763 = this.page > 0;
            this.nextButton.field_22763 = this.page < this.pageCount - 1;
        }
        this.displayedTitle = class_2561.method_43470((String)"");
        this.displayedTitle.method_10855().add(this.field_22785);
        this.displayedTitle.method_10855().add(class_2561.method_43470((String)(" (" + (this.page + 1) + "/" + this.pageCount + ")")));
    }

    private int getStartIndex() {
        return this.page * 12;
    }

    private int getEndIndex() {
        return Math.min((this.page + 1) * 12, this.elements.size());
    }

    protected <T extends class_364 & class_4068> T method_37063(T widget) {
        return (T)super.method_37063(widget);
    }

    protected <T extends class_4068> T method_37060(T widget) {
        return (T)super.method_37060(widget);
    }

    protected <T extends class_364 & class_6379> T method_25429(T p_96625_) {
        return (T)super.method_25429(p_96625_);
    }

    @Override
    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partial) {
        this.method_25420(poseStack);
        WidgetListScreen.method_27534((class_4587)poseStack, (class_327)this.field_22793, (class_2561)this.displayedTitle, (int)(this.field_22789 / 2), (int)16, (int)-1);
        super.method_25394(poseStack, mouseX, mouseY, partial);
    }

    @Override
    protected void renderPreDropdown(class_4587 poseStack, int mouseX, int mouseY, float partial) {
        List<class_5481> tooltip;
        super.renderPreDropdown(poseStack, mouseX, mouseY, partial);
        int startIndex = this.getStartIndex();
        int endIndex = this.getEndIndex();
        WidgetListElement<?> tooltipElement = null;
        for (int index = startIndex; index < endIndex; ++index) {
            WidgetListElement<?> e = this.elements.get(index);
            e.render(poseStack);
            if (!e.isOver(mouseX, mouseY)) continue;
            tooltipElement = e;
        }
        if (this.openDropdown == null && tooltipElement != null && (tooltip = tooltipElement.getTooltip()) != null) {
            this.method_25417(poseStack, tooltip, mouseX, mouseY + 24 + 10);
        }
    }

    public void method_25393() {
        super.method_25393();
        for (class_342 editBox : this.tickableBoxes) {
            editBox.method_1865();
        }
    }

    private void onPrevButton(class_4185 b) {
        --this.page;
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }

    private void onNextButton(class_4185 b) {
        ++this.page;
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }

    protected void onBackButton(class_4185 b) {
        this.goBack();
    }

    public void method_25395(class_364 l) {
        class_364 currentFocused = this.method_25399();
        if (currentFocused != null && currentFocused != l && currentFocused instanceof class_342) {
            ((class_342)currentFocused).method_1876(false);
        }
        super.method_25395(l);
    }
}

