/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.mods.prometheus;

import com.teamresourceful.resourcefullib.client.components.selection.ListEntry;
import com.teamresourceful.resourcefullib.client.components.selection.SelectionList;
import com.teamresourceful.resourcefullib.common.utils.TriState;
import earth.terrarium.prometheus.api.roles.client.OptionDisplay;
import earth.terrarium.prometheus.api.roles.options.RoleOption;
import earth.terrarium.prometheus.client.screens.roles.options.entries.NumberBoxListEntry;
import earth.terrarium.prometheus.client.screens.roles.options.entries.TextBoxListEntry;
import earth.terrarium.prometheus.client.screens.roles.options.entries.TextListEntry;
import earth.terrarium.prometheus.client.screens.roles.options.entries.TriStateListEntry;
import earth.terrarium.prometheus.common.handlers.role.Role;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import xaero.pac.client.mods.prometheus.BetterNumberBoxListEntry;
import xaero.pac.common.mods.prometheus.OPACOptions;
import xaero.pac.common.server.player.permission.api.IPermissionNodeAPI;
import xaero.pac.common.server.player.permission.api.UsedPermissionNodes;
import xaero.pac.common.util.json.XaeroJsonUtil;

public class OPACOptionsDisplay
implements OptionDisplay {
    protected final List<ListEntry> entries;
    protected final Map<IPermissionNodeAPI<?>, ListEntry> mappedEntries;
    private static final Component TITLE = Component.translatable((String)"option.openpartiesandclaims.permissions/v1");

    public OPACOptionsDisplay(List<ListEntry> entries, Map<IPermissionNodeAPI<?>, ListEntry> mappedEntries) {
        this.entries = entries;
        this.mappedEntries = mappedEntries;
    }

    public static OPACOptionsDisplay create(Role role, SelectionList<ListEntry> ignored) {
        ArrayList<ListEntry> entries = new ArrayList<ListEntry>();
        HashMap mappedEntries = new HashMap();
        OPACOptions options = (OPACOptions)role.getNonNullOption(OPACOptions.SERIALIZER);
        entries.add((ListEntry)new TextListEntry(TITLE));
        UsedPermissionNodes.ALL.forEach((name, node) -> {
            Object entry;
            if (Number.class.isAssignableFrom(node.getType())) {
                Number currentValue = (Number)options.getValueCast((IPermissionNodeAPI<?>)node);
                boolean withPartial = currentValue instanceof Float || currentValue instanceof Double;
                entry = new BetterNumberBoxListEntry(currentValue == null ? -1 : currentValue.intValue(), withPartial, node.getName(), node.getComment());
                if (currentValue == null) {
                    ((BetterNumberBoxListEntry)((Object)((Object)entry))).setText("");
                } else if (withPartial) {
                    ((BetterNumberBoxListEntry)((Object)((Object)entry))).setText(currentValue.toString());
                }
            } else if (node.getType() == String.class) {
                String currentValue = (String)options.getValueCast((IPermissionNodeAPI<?>)node);
                entry = new TextBoxListEntry(currentValue, 200, node.getName(), node.getComment(), s -> true);
            } else if (node.getType() == Component.class) {
                Component currentValue = (Component)options.getValueCast((IPermissionNodeAPI<?>)node);
                String text = XaeroJsonUtil.toJson(currentValue);
                entry = new TextBoxListEntry(text, 5000, node.getName(), node.getComment(), s -> true);
            } else {
                TriState state = TriState.UNDEFINED;
                Boolean value = (Boolean)options.getValueCast((IPermissionNodeAPI<?>)node);
                if (value != null) {
                    state = TriState.of((Boolean)value);
                }
                entry = new TriStateListEntry(node.getName(), state, e -> {});
            }
            entries.add((ListEntry)entry);
            mappedEntries.put((IPermissionNodeAPI<?>)node, (ListEntry)entry);
        });
        return new OPACOptionsDisplay(entries, mappedEntries);
    }

    public List<ListEntry> getDisplayEntries() {
        return this.entries;
    }

    public boolean save(Role role) {
        OPACOptions options = new OPACOptions();
        this.mappedEntries.forEach((node, entry) -> {
            TriStateListEntry triStateListEntry;
            if (entry instanceof NumberBoxListEntry) {
                NumberBoxListEntry numberBoxListEntry = (NumberBoxListEntry)entry;
                if (node.getType() == Float.class || node.getType() == Double.class) {
                    numberBoxListEntry.getDoubleValue().ifPresent(d -> {
                        Number castValue = node.getType() == Float.class ? (Number)Float.valueOf((float)d) : (Number)d;
                        options.setValueCast((IPermissionNodeAPI<?>)node, castValue);
                    });
                    return;
                }
                numberBoxListEntry.getIntValue().ifPresent(i -> {
                    Number castValue = node.getType() == Byte.class ? (Number)((byte)i) : (Number)(node.getType() == Short.class ? (Number)((short)i) : (Number)(node.getType() == Long.class ? (Number)Long.valueOf(i) : (Number)i));
                    options.setValueCast((IPermissionNodeAPI<?>)node, castValue);
                });
                return;
            }
            if ((node.getType() == String.class || node.getType() == Component.class) && entry instanceof TextBoxListEntry) {
                TextBoxListEntry textBoxListEntry = (TextBoxListEntry)entry;
                String value = textBoxListEntry.getText();
                if (node.getType() == Component.class) {
                    value = XaeroJsonUtil.fromJson(textBoxListEntry.getText());
                }
                options.setValueCast((IPermissionNodeAPI<?>)node, value);
                return;
            }
            if (node.getType() == Boolean.class && entry instanceof TriStateListEntry && (triStateListEntry = (TriStateListEntry)entry).state() != TriState.UNDEFINED) {
                options.setValueCast((IPermissionNodeAPI<?>)node, triStateListEntry.state() == TriState.TRUE);
            }
        });
        role.setData((RoleOption)options);
        return true;
    }
}

