/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundClaimLimitsPacket
extends LazyPacket<ClientboundClaimLimitsPacket> {
    public static final LazyPacket.Encoder<ClientboundClaimLimitsPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final int loadingClaimCount;
    private final int loadingForceloadCount;
    private final int claimLimit;
    private final int forceloadLimit;
    private final int maxClaimDistance;
    private final boolean alwaysUseLoadingValues;

    public ClientboundClaimLimitsPacket(int loadingClaimCount, int loadingForceloadCount, int claimLimit, int forceloadLimit, int maxClaimDistance, boolean alwaysUseLoadingValues) {
        this.loadingClaimCount = loadingClaimCount;
        this.loadingForceloadCount = loadingForceloadCount;
        this.claimLimit = claimLimit;
        this.forceloadLimit = forceloadLimit;
        this.maxClaimDistance = maxClaimDistance;
        this.alwaysUseLoadingValues = alwaysUseLoadingValues;
    }

    @Override
    protected void writeOnPrepare(FriendlyByteBuf u) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("cc", this.loadingClaimCount);
        tag.putInt("fc", this.loadingForceloadCount);
        tag.putInt("cl", this.claimLimit);
        tag.putInt("fl", this.forceloadLimit);
        tag.putInt("d", this.maxClaimDistance);
        tag.putBoolean("a", this.alwaysUseLoadingValues);
        u.writeNbt((Tag)tag);
    }

    @Override
    protected Function<FriendlyByteBuf, ClientboundClaimLimitsPacket> getDecoder() {
        return DECODER;
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundClaimLimitsPacket> {
        @Override
        public ClientboundClaimLimitsPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 2048) {
                    return null;
                }
                CompoundTag tag = (CompoundTag)input.readNbt(NbtAccounter.unlimitedHeap());
                if (tag == null) {
                    return null;
                }
                int loadingClaimCount = tag.getIntOr("cc", 0);
                int loadingForceloadCount = tag.getIntOr("fc", 0);
                int claimLimit = tag.getIntOr("cl", 0);
                int forceloadLimit = tag.getIntOr("fl", 0);
                int maxClaimDistance = tag.getIntOr("d", 0);
                boolean alwaysUseLoadingValues = tag.getBooleanOr("a", false);
                return new ClientboundClaimLimitsPacket(loadingClaimCount, loadingForceloadCount, claimLimit, forceloadLimit, maxClaimDistance, alwaysUseLoadingValues);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundClaimLimitsPacket> {
        @Override
        public void handle(ClientboundClaimLimitsPacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onClaimLimits(t.loadingClaimCount, t.loadingForceloadCount, t.claimLimit, t.forceloadLimit, t.maxClaimDistance, t.alwaysUseLoadingValues);
        }
    }
}

