/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.UUID;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;
import xaero.pac.common.util.nbt.XaeroNbtUtil;

public class ClientboundClaimsClaimUpdatePacket
extends LazyPacket<ClientboundClaimsClaimUpdatePacket> {
    public static final LazyPacket.Encoder<ClientboundClaimsClaimUpdatePacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final ResourceLocation dimension;
    private final int x;
    private final int z;
    private final UUID playerId;
    private final int subConfigIndex;
    private final boolean forceLoaded;
    private final int claimSyncIndex;

    public ClientboundClaimsClaimUpdatePacket(ResourceLocation dimension, int x, int z, UUID playerId, int subConfigIndex, boolean forceLoaded, int claimSyncIndex) {
        this.dimension = dimension;
        this.x = x;
        this.z = z;
        this.playerId = playerId;
        this.subConfigIndex = subConfigIndex;
        this.forceLoaded = forceLoaded;
        this.claimSyncIndex = claimSyncIndex;
    }

    @Override
    protected Function<FriendlyByteBuf, ClientboundClaimsClaimUpdatePacket> getDecoder() {
        return DECODER;
    }

    @Override
    protected void writeOnPrepare(FriendlyByteBuf u) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("d", this.dimension.toString());
        nbt.putInt("x", this.x);
        nbt.putInt("z", this.z);
        if (this.playerId != null) {
            nbt.putInt("i", this.claimSyncIndex);
            XaeroNbtUtil.putUUID(nbt, "p", this.playerId);
            nbt.putInt("s", this.subConfigIndex);
            nbt.putBoolean("f", this.forceLoaded);
        }
        u.writeNbt((Tag)nbt);
    }

    public String toString() {
        return String.format("[%s, %d, %d, %s, %s, %d, %d]", this.dimension, this.x, this.z, this.playerId, this.forceLoaded, this.subConfigIndex, this.claimSyncIndex);
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundClaimsClaimUpdatePacket> {
        @Override
        public ClientboundClaimsClaimUpdatePacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 10000) {
                    return null;
                }
                CompoundTag nbt = (CompoundTag)input.readNbt(NbtAccounter.unlimitedHeap());
                if (nbt == null) {
                    return null;
                }
                String dimensionString = nbt.getStringOr("d", null);
                if (dimensionString == null || dimensionString.length() > 2048) {
                    return null;
                }
                int x = nbt.getIntOr("x", 0);
                int z = nbt.getIntOr("z", 0);
                int claimStateIndex = -1;
                UUID playerId = null;
                int subConfigIndex = -1;
                boolean forceload = false;
                if (nbt.contains("p")) {
                    claimStateIndex = nbt.getIntOr("i", 0);
                    playerId = XaeroNbtUtil.getUUID(nbt, "p").orElse(null);
                    subConfigIndex = nbt.getIntOr("s", 0);
                    forceload = nbt.getBooleanOr("f", false);
                }
                return new ClientboundClaimsClaimUpdatePacket(ResourceLocation.parse((String)dimensionString), x, z, playerId, subConfigIndex, forceload, claimStateIndex);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundClaimsClaimUpdatePacket> {
        @Override
        public void handle(ClientboundClaimsClaimUpdatePacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onClaimUpdate(t.dimension, t.x, t.z, t.playerId, t.subConfigIndex, t.forceLoaded, t.claimSyncIndex);
        }
    }
}

