/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.parties;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import xaero.pac.common.parties.party.PartyPlayerInfo;
import xaero.pac.common.parties.party.member.PartyInvite;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.util.nbt.XaeroNbtUtil;

public class PartyPlayerInfoCodec {
    public PartyInvite fromPartyInviteTag(CompoundTag playerInfoTag) {
        if (playerInfoTag.isEmpty()) {
            return null;
        }
        try {
            UUID playerUUID = XaeroNbtUtil.getUUID(playerInfoTag, "i").orElse(null);
            String username = playerInfoTag.getStringOr("n", null);
            if (username == null || username.length() > 128) {
                return null;
            }
            PartyInvite result = new PartyInvite(playerUUID);
            result.setUsername(username);
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public PartyMember fromMemberTag(CompoundTag memberTag, boolean isOwner) {
        if (memberTag.isEmpty()) {
            return null;
        }
        try {
            UUID playerUUID = XaeroNbtUtil.getUUID(memberTag, "i").orElse(null);
            String username = memberTag.getStringOr("n", null);
            if (username == null || username.length() > 128) {
                return null;
            }
            String rank = memberTag.getStringOr("r", null);
            if (rank == null || rank.length() > 128) {
                return null;
            }
            PartyMember result = new PartyMember(playerUUID, isOwner);
            result.setUsername(username);
            result.setRank(PartyMemberRank.valueOf(rank));
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private CompoundTag toPlayerInfoTag(PartyPlayerInfo<?> playerInfo) {
        CompoundTag infoTag = new CompoundTag();
        XaeroNbtUtil.putUUID(infoTag, "i", playerInfo.getUUID());
        infoTag.putString("n", playerInfo.getUsername());
        return infoTag;
    }

    public CompoundTag toPartyInviteTag(PartyInvite playerInfo) {
        return this.toPlayerInfoTag(playerInfo);
    }

    public CompoundTag toMemberTag(PartyMember member) {
        CompoundTag memberTag = this.toPlayerInfoTag(member);
        memberTag.putString("r", member.getRank().toString());
        return memberTag;
    }
}

