/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.protection;

import com.google.common.collect.Iterators;
import com.mojang.datafixers.util.Either;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.function.TriFunction;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.api.IPlayerChunkClaimAPI;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.protection.ChunkProtectionEntityHelper;
import xaero.pac.common.server.claims.protection.ChunkProtectionExceptionSet;
import xaero.pac.common.server.claims.protection.ChunkProtectionExceptionType;
import xaero.pac.common.server.claims.protection.ExceptionElementType;
import xaero.pac.common.server.claims.protection.WildcardResolver;
import xaero.pac.common.server.claims.protection.api.IChunkProtectionAPI;
import xaero.pac.common.server.claims.protection.group.ChunkProtectionExceptionGroup;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.core.ServerCore;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.system.IPlayerPartySystemManager;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.api.IPlayerConfigAPI;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.data.api.ServerPlayerDataAPI;
import xaero.pac.common.server.world.ServerLevelHelper;

public class ChunkProtection<CM extends IServerClaimsManager<?, ?, ?>>
implements IChunkProtectionAPI {
    public static final UUID CREATE_DEPLOYER_UUID = UUID.fromString("9e2faded-cafe-4ec2-c314-dad129ae971d");
    public static final UUID CREATE_PLOUGH_UUID = UUID.fromString("9e2faded-eeee-4ec2-c314-dad129ae971d");
    public static final String TAG_PREFIX = "#";
    public static final String BREAK_PREFIX = "break$";
    public static final String HAND_PREFIX = "hand$";
    public static final String ANYTHING_PREFIX = "anything$";
    public static final String INTERACT_PREFIX = "interact$";
    public static final String FULL_PREFIX = "full$";
    private final TriFunction<IPlayerConfig, Entity, Entity, IPlayerConfigOptionSpecAPI<Integer>> usedDroppedItemProtectionOptionGetter = this::getUsedDroppedItemProtectionOption;
    private final TriFunction<IPlayerConfig, Entity, Entity, IPlayerConfigOptionSpecAPI<Integer>> usedExperienceOrbProtectionOptionGetter = (c, e, a) -> PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_XP_PICKUP;
    private final Component MAIN_HAND = Component.translatable((String)"gui.xaero_claims_protection_main_hand");
    private final Component OFF_HAND = Component.translatable((String)"gui.xaero_claims_protection_off_hand");
    private final Component CANT_INTERACT_BLOCK = Component.translatable((String)"gui.xaero_claims_protection_interact_block_any").withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component CANT_INTERACT_BLOCK_MAIN = Component.translatable((String)"gui.xaero_claims_protection_interact_block", (Object[])new Object[]{this.MAIN_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component BLOCK_TRY_EMPTY_MAIN = Component.translatable((String)"gui.xaero_claims_protection_interact_block_try_empty", (Object[])new Object[]{this.MAIN_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component BLOCK_DISABLED = Component.translatable((String)"gui.xaero_claims_protection_block_disabled").withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component PROJECTILE_HIT_BLOCK = Component.translatable((String)"gui.xaero_claims_protection_projectile_hit_block").withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component USE_ITEM_ANY = Component.translatable((String)"gui.xaero_claims_protection_use_item_any").withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component USE_ITEM_MAIN = Component.translatable((String)"gui.xaero_claims_protection_use_item", (Object[])new Object[]{this.MAIN_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component CANT_INTERACT_ENTITY = Component.translatable((String)"gui.xaero_claims_protection_interact_entity_any").withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component CANT_INTERACT_ENTITY_MAIN = Component.translatable((String)"gui.xaero_claims_protection_interact_entity", (Object[])new Object[]{this.MAIN_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component ENTITY_TRY_EMPTY_MAIN = Component.translatable((String)"gui.xaero_claims_protection_interact_entity_try_empty", (Object[])new Object[]{this.MAIN_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component ENTITY_DISABLED = Component.translatable((String)"gui.xaero_claims_protection_entity_disabled").withStyle(s -> s.withColor(ChatFormatting.RED));
    public final Component PROJECTILE_HIT_ENTITY = Component.translatable((String)"gui.xaero_claims_protection_projectile_hit_entity").withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component CANT_APPLY_ITEM_ANY = Component.translatable((String)"gui.xaero_claims_protection_interact_item_apply_any").withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component CANT_APPLY_ITEM_MAIN = Component.translatable((String)"gui.xaero_claims_protection_interact_item_apply", (Object[])new Object[]{this.MAIN_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component CANT_APPLY_ITEM_THIS_CLOSE_MAIN = Component.translatable((String)"gui.xaero_claims_protection_interact_item_apply_too_close", (Object[])new Object[]{this.MAIN_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component ITEM_DISABLED_ANY = Component.translatable((String)"gui.xaero_claims_protection_item_disabled_any").withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component ITEM_DISABLED_MAIN = Component.translatable((String)"gui.xaero_claims_protection_item_disabled", (Object[])new Object[]{this.MAIN_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component CANT_INTERACT_BLOCK_OFF = Component.translatable((String)"gui.xaero_claims_protection_interact_block", (Object[])new Object[]{this.OFF_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component BLOCK_TRY_EMPTY_OFF = Component.translatable((String)"gui.xaero_claims_protection_interact_block_try_empty", (Object[])new Object[]{this.OFF_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component USE_ITEM_OFF = Component.translatable((String)"gui.xaero_claims_protection_use_item", (Object[])new Object[]{this.OFF_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component CANT_APPLY_ITEM_OFF = Component.translatable((String)"gui.xaero_claims_protection_interact_item_apply", (Object[])new Object[]{this.OFF_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component CANT_APPLY_ITEM_THIS_CLOSE_OFF = Component.translatable((String)"gui.xaero_claims_protection_interact_item_apply_too_close", (Object[])new Object[]{this.OFF_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component ITEM_DISABLED_OFF = Component.translatable((String)"gui.xaero_claims_protection_item_disabled", (Object[])new Object[]{this.OFF_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component CANT_INTERACT_ENTITY_OFF = Component.translatable((String)"gui.xaero_claims_protection_interact_entity", (Object[])new Object[]{this.OFF_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component ENTITY_TRY_EMPTY_OFF = Component.translatable((String)"gui.xaero_claims_protection_interact_entity_try_empty", (Object[])new Object[]{this.OFF_HAND}).withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component CANT_CHORUS = Component.translatable((String)"gui.xaero_claims_protection_chorus").withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component CANT_USE_SUPER_GLUE = Component.translatable((String)"gui.xaero_claims_protection_create_cant_use_glue").withStyle(s -> s.withColor(ChatFormatting.RED));
    private final Component CANT_REMOVE_SUPER_GLUE = Component.translatable((String)"gui.xaero_claims_protection_create_cant_remove_glue").withStyle(s -> s.withColor(ChatFormatting.RED));
    private final ChunkProtectionEntityHelper entityHelper;
    private IServerData<CM, ?> serverData;
    private final CM claimsManager;
    private final IPlayerPartySystemManager playerPartySystemManager;
    private final ChunkProtectionExceptionSet<EntityType<?>> friendlyEntityList;
    private final ChunkProtectionExceptionSet<EntityType<?>> hostileEntityList;
    private final ChunkProtectionExceptionSet<Block> forcedInteractionExceptionBlocks;
    private final ChunkProtectionExceptionSet<Block> forcedBreakExceptionBlocks;
    private final ChunkProtectionExceptionSet<Block> requiresEmptyHandBlocks;
    private final ChunkProtectionExceptionSet<Block> forcedAllowAnyItemBlocks;
    private final ChunkProtectionExceptionSet<EntityType<?>> forcedInteractionExceptionEntities;
    private final ChunkProtectionExceptionSet<EntityType<?>> forcedKillExceptionEntities;
    private final ChunkProtectionExceptionSet<EntityType<?>> requiresEmptyHandEntities;
    private final ChunkProtectionExceptionSet<EntityType<?>> forcedAllowAnyItemEntities;
    private final ChunkProtectionExceptionSet<EntityType<?>> forcedEntityClaimBarrierList;
    private final ChunkProtectionExceptionSet<EntityType<?>> entitiesAllowedToBreakBlocks;
    private final ChunkProtectionExceptionSet<EntityType<?>> entitiesAllowedToInteractWithBlocks;
    private final ChunkProtectionExceptionSet<EntityType<?>> entitiesAllowedToKillEntities;
    private final ChunkProtectionExceptionSet<EntityType<?>> entitiesAllowedToInteractWithEntities;
    private final ChunkProtectionExceptionSet<EntityType<?>> entitiesAllowedToGriefDroppedItems;
    private final ChunkProtectionExceptionSet<EntityType<?>> nonBlockGriefingMobs;
    private final ChunkProtectionExceptionSet<EntityType<?>> entityGriefingMobs;
    private final ChunkProtectionExceptionSet<EntityType<?>> droppedItemGriefingMobs;
    private final Set<String> staticFakePlayerUsernames;
    private final Set<UUID> staticFakePlayerIds;
    private final Set<Class<?>> staticFakePlayerClassExceptions;
    private final ChunkProtectionExceptionSet<Item> additionalBannedItems;
    private final ChunkProtectionExceptionSet<Item> itemUseProtectionExceptions;
    private final ChunkProtectionExceptionSet<Item> completelyDisabledItems;
    private final ChunkProtectionExceptionSet<Block> completelyDisabledBlocks;
    private final ChunkProtectionExceptionSet<EntityType<?>> completelyDisabledEntities;
    private final Map<String, ChunkProtectionExceptionGroup<Block>> blockExceptionGroups;
    private final Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> entityExceptionGroups;
    private final Map<String, ChunkProtectionExceptionGroup<Item>> itemExceptionGroups;
    private final Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> entityBarrierGroups;
    private final Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> blockAccessEntityGroups;
    private final Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> entityAccessEntityGroups;
    private final Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> droppedItemAccessEntityGroups;
    private final BlockPos.MutableBlockPos reusableBlockPos;
    private boolean ignoreChunkEnter = false;
    private final Map<Entity, Set<ChunkPos>> cantPickupItemsInTickCache;
    private final Map<Entity, Set<ChunkPos>> cantPickupXPInTickCache;
    private final Set<UUID> fullPasses;
    private boolean fullPassesPaused;

    private ChunkProtection(CM claimsManager, IPlayerPartySystemManager playerPartySystemManager, ChunkProtectionEntityHelper entityHelper, ChunkProtectionExceptionSet<EntityType<?>> friendlyEntityList, ChunkProtectionExceptionSet<EntityType<?>> hostileEntityList, ChunkProtectionExceptionSet<Block> forcedInteractionExceptionBlocks, ChunkProtectionExceptionSet<Block> forcedBreakExceptionBlocks, ChunkProtectionExceptionSet<Block> requiresEmptyHandBlocks, ChunkProtectionExceptionSet<Block> forcedAllowAnyItemBlocks, ChunkProtectionExceptionSet<Block> completelyDisabledBlocks, ChunkProtectionExceptionSet<EntityType<?>> forcedInteractionExceptionEntities, ChunkProtectionExceptionSet<EntityType<?>> forcedKillExceptionEntities, ChunkProtectionExceptionSet<EntityType<?>> requiresEmptyHandEntities, ChunkProtectionExceptionSet<EntityType<?>> forcedAllowAnyItemEntities, ChunkProtectionExceptionSet<EntityType<?>> forcedEntityClaimBarrierList, ChunkProtectionExceptionSet<EntityType<?>> entitiesAllowedToBreakBlocks, ChunkProtectionExceptionSet<EntityType<?>> entitiesAllowedToInteractWithBlocks, ChunkProtectionExceptionSet<EntityType<?>> entitiesAllowedToKillEntities, ChunkProtectionExceptionSet<EntityType<?>> entitiesAllowedToInteractWithEntities, ChunkProtectionExceptionSet<EntityType<?>> entitiesAllowedToGriefDroppedItems, ChunkProtectionExceptionSet<EntityType<?>> nonBlockGriefingMobs, ChunkProtectionExceptionSet<EntityType<?>> entityGriefingMobs, ChunkProtectionExceptionSet<EntityType<?>> droppedItemGriefingMobs, Set<String> staticFakePlayerUsernames, Set<UUID> staticFakePlayerIds, Set<Class<?>> staticFakePlayerClassExceptions, ChunkProtectionExceptionSet<Item> additionalBannedItems, ChunkProtectionExceptionSet<Item> completelyBannedItems, ChunkProtectionExceptionSet<Item> itemUseProtectionExceptions, ChunkProtectionExceptionSet<EntityType<?>> completelyDisabledEntities, Map<String, ChunkProtectionExceptionGroup<Block>> blockExceptionGroups, Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> entityExceptionGroups, Map<String, ChunkProtectionExceptionGroup<Item>> itemExceptionGroups, Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> entityBarrierGroups, Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> blockAccessEntityGroups, Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> entityAccessEntityGroups, Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> droppedItemAccessEntityGroups, BlockPos.MutableBlockPos reusableBlockPos, Map<Entity, Set<ChunkPos>> cantPickItemsCache, Map<Entity, Set<ChunkPos>> cantPickupXPInTickCache, Set<UUID> fullPasses) {
        this.claimsManager = claimsManager;
        this.playerPartySystemManager = playerPartySystemManager;
        this.entityHelper = entityHelper;
        this.friendlyEntityList = friendlyEntityList;
        this.hostileEntityList = hostileEntityList;
        this.forcedInteractionExceptionBlocks = forcedInteractionExceptionBlocks;
        this.forcedBreakExceptionBlocks = forcedBreakExceptionBlocks;
        this.requiresEmptyHandBlocks = requiresEmptyHandBlocks;
        this.forcedAllowAnyItemBlocks = forcedAllowAnyItemBlocks;
        this.completelyDisabledBlocks = completelyDisabledBlocks;
        this.forcedInteractionExceptionEntities = forcedInteractionExceptionEntities;
        this.forcedKillExceptionEntities = forcedKillExceptionEntities;
        this.requiresEmptyHandEntities = requiresEmptyHandEntities;
        this.forcedAllowAnyItemEntities = forcedAllowAnyItemEntities;
        this.forcedEntityClaimBarrierList = forcedEntityClaimBarrierList;
        this.entitiesAllowedToBreakBlocks = entitiesAllowedToBreakBlocks;
        this.entitiesAllowedToInteractWithBlocks = entitiesAllowedToInteractWithBlocks;
        this.entitiesAllowedToKillEntities = entitiesAllowedToKillEntities;
        this.entitiesAllowedToInteractWithEntities = entitiesAllowedToInteractWithEntities;
        this.entitiesAllowedToGriefDroppedItems = entitiesAllowedToGriefDroppedItems;
        this.nonBlockGriefingMobs = nonBlockGriefingMobs;
        this.entityGriefingMobs = entityGriefingMobs;
        this.droppedItemGriefingMobs = droppedItemGriefingMobs;
        this.staticFakePlayerUsernames = staticFakePlayerUsernames;
        this.staticFakePlayerIds = staticFakePlayerIds;
        this.staticFakePlayerClassExceptions = staticFakePlayerClassExceptions;
        this.additionalBannedItems = additionalBannedItems;
        this.completelyDisabledItems = completelyBannedItems;
        this.itemUseProtectionExceptions = itemUseProtectionExceptions;
        this.completelyDisabledEntities = completelyDisabledEntities;
        this.blockExceptionGroups = blockExceptionGroups;
        this.entityExceptionGroups = entityExceptionGroups;
        this.itemExceptionGroups = itemExceptionGroups;
        this.entityBarrierGroups = entityBarrierGroups;
        this.blockAccessEntityGroups = blockAccessEntityGroups;
        this.entityAccessEntityGroups = entityAccessEntityGroups;
        this.droppedItemAccessEntityGroups = droppedItemAccessEntityGroups;
        this.reusableBlockPos = reusableBlockPos;
        this.cantPickupItemsInTickCache = cantPickItemsCache;
        this.cantPickupXPInTickCache = cantPickupXPInTickCache;
        this.fullPasses = fullPasses;
    }

    public void setServerData(IServerData<CM, ?> serverData) {
        this.serverData = serverData;
    }

    @Override
    public void giveFullPass(@Nonnull UUID entityId) {
        this.fullPasses.add(entityId);
    }

    @Override
    public void removeFullPass(@Nonnull UUID entityId) {
        this.fullPasses.remove(entityId);
    }

    private boolean hasActiveFullPass(Entity entity) {
        if (this.fullPassesPaused) {
            return false;
        }
        if (entity instanceof Player && (CREATE_DEPLOYER_UUID.equals(entity.getUUID()) || CREATE_PLOUGH_UUID.equals(entity.getUUID())) && !this.isStaticFakePlayerExceptionClass(entity)) {
            return true;
        }
        return this.fullPasses.contains(entity.getUUID());
    }

    private boolean isStaticFakePlayerExceptionClass(Entity entity) {
        for (Class<?> fakePlayerExceptionClass : this.staticFakePlayerClassExceptions) {
            if (!fakePlayerExceptionClass.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        return false;
    }

    private InteractionTargetResult entityAccessCheck(IPlayerConfigManager playerConfigs, IPlayerConfig claimConfig, Entity e, Entity from, Entity accessor, UUID accessorId, boolean attack, boolean emptyHand, boolean exceptions) {
        return this.entityAccessCheck(playerConfigs, claimConfig, e, from, accessor, accessorId, attack, emptyHand, exceptions, false);
    }

    private InteractionTargetResult entityAccessCheck(IPlayerConfigManager playerConfigs, IPlayerConfig claimConfig, Entity e, Entity from, Entity accessor, UUID accessorId, boolean attack, boolean emptyHand, boolean exceptions, boolean checkingInverted) {
        IPlayerConfigOptionSpecAPI<Integer> option;
        boolean optionProtects;
        boolean isProtectable;
        if (e instanceof Player && e != accessor) {
            boolean chunkProtected = claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS);
            InteractionTargetResult result = InteractionTargetResult.ALLOW;
            if (chunkProtected) {
                Entity usedOptionBase;
                Entity entity = usedOptionBase = claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYERS_REDIRECT) != false ? accessor : from;
                if (usedOptionBase == null) {
                    if (this.hasAnEnabledOption(claimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYERS_FROM_PLAYERS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYERS_FROM_MOBS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYERS_FROM_OTHER)) {
                        return InteractionTargetResult.PROTECT;
                    }
                } else {
                    IPlayerConfigOptionSpecAPI<Boolean> option2;
                    IPlayerConfigOptionSpecAPI<Boolean> iPlayerConfigOptionSpecAPI = usedOptionBase instanceof Player ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYERS_FROM_PLAYERS : (option2 = usedOptionBase instanceof LivingEntity ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYERS_FROM_MOBS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYERS_FROM_OTHER);
                    if (claimConfig.getEffective(option2).booleanValue()) {
                        return InteractionTargetResult.PROTECT;
                    }
                }
                result = InteractionTargetResult.PASS;
            }
            if (accessor instanceof Player && !checkingInverted) {
                return this.entityAccessCheck(playerConfigs, this.getClaimConfig(playerConfigs, this.claimsManager.get(accessor.level().dimension().location(), accessor.chunkPosition())), accessor, accessor == from ? e : from, e, null, attack, emptyHand, exceptions, true);
            }
            return result;
        }
        if (this.hasChunkAccess(claimConfig, accessor, accessorId)) {
            return InteractionTargetResult.ALLOW;
        }
        boolean bl = isProtectable = !exceptions || this.isProtectable(e);
        if (isProtectable) {
            Raider raider;
            if (accessor instanceof Raider && (raider = (Raider)accessor).canJoinRaid() && claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_RAIDS).booleanValue()) {
                return InteractionTargetResult.PROTECT;
            }
        } else if (attack || emptyHand) {
            return InteractionTargetResult.ALLOW;
        }
        if (!(optionProtects = this.checkProtectionLeveledOption(option = this.getUsedEntityProtectionOption(claimConfig, from, accessor), claimConfig, accessor, accessorId)) && (attack || emptyHand || !this.checkProtectionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_USE, claimConfig, accessor, accessorId))) {
            return InteractionTargetResult.ALLOW;
        }
        if (!exceptions) {
            return optionProtects ? InteractionTargetResult.PROTECT : InteractionTargetResult.PASS;
        }
        EntityType entityType = e.getType();
        if (attack && this.forcedKillExceptionEntities.contains(entityType)) {
            return InteractionTargetResult.ALLOW;
        }
        if (!attack && this.forcedAllowAnyItemEntities.contains(entityType)) {
            return InteractionTargetResult.ALLOW;
        }
        int exceptionAccessLevel = this.getExceptionAccessLevel(claimConfig, accessor, accessorId);
        boolean groupsAllowPass = false;
        for (ChunkProtectionExceptionGroup<EntityType<?>> group : this.entityExceptionGroups.values()) {
            if (group.getType() == ChunkProtectionExceptionType.BREAK != attack || !emptyHand && group.getType() == ChunkProtectionExceptionType.EMPTY_HAND_INTERACTION || !isProtectable && group.getType() != ChunkProtectionExceptionType.ANY_ITEM_INTERACTION || exceptionAccessLevel > claimConfig.getEffective(group.getPlayerConfigOption()) || !group.contains(entityType)) continue;
            if (attack || emptyHand || group.getType() == ChunkProtectionExceptionType.ANY_ITEM_INTERACTION) {
                return InteractionTargetResult.ALLOW;
            }
            groupsAllowPass = true;
        }
        if (groupsAllowPass || !optionProtects || !isProtectable) {
            return InteractionTargetResult.PASS;
        }
        if (this.entityHelper.isOwned(e, accessorId)) {
            return InteractionTargetResult.PASS;
        }
        if (!attack && this.forcedInteractionExceptionEntities.contains(entityType) && (emptyHand || !this.requiresEmptyHandEntities.contains(entityType))) {
            return InteractionTargetResult.PASS;
        }
        return InteractionTargetResult.PROTECT;
    }

    private IPlayerConfigOptionSpecAPI<Integer> getUsedEntityProtectionOption(IPlayerConfig claimConfig, Entity entity, Entity accessor) {
        Entity usedOptionBase;
        Entity entity2 = usedOptionBase = !(entity instanceof Player) && claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_REDIRECT) != false ? accessor : entity;
        if (usedOptionBase == null) {
            return this.getToughestProtectionLevelOption(claimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_PLAYERS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_MOBS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_OTHER);
        }
        return usedOptionBase instanceof Player ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_PLAYERS : (usedOptionBase instanceof LivingEntity ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_MOBS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_OTHER);
    }

    private IPlayerConfigOptionSpecAPI<Integer> getUsedBlockProtectionOption(IPlayerConfig claimConfig, Entity entity, Entity accessor) {
        Entity usedOptionBase;
        Entity entity2 = usedOptionBase = !(entity instanceof Player) && claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_REDIRECT) != false ? accessor : entity;
        if (usedOptionBase == null) {
            return this.getToughestProtectionLevelOption(claimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_PLAYERS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_MOBS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_OTHER);
        }
        return usedOptionBase instanceof Player ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_PLAYERS : (usedOptionBase instanceof LivingEntity ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_MOBS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_OTHER);
    }

    private boolean checkProtectionLeveledOption(IPlayerConfigOptionSpecAPI<Integer> option, IPlayerConfig claimConfig, Entity accessor, UUID accessorId) {
        int optionValue = claimConfig.getEffective(option);
        if (optionValue <= 0) {
            return false;
        }
        if (optionValue == 1) {
            return true;
        }
        int exceptionLevel = this.getExceptionAccessLevel(claimConfig, accessor, accessorId);
        return exceptionLevel >= optionValue;
    }

    private boolean checkExceptionLeveledOption(IPlayerConfigOptionSpecAPI<Integer> option, IPlayerConfig claimConfig, Entity accessor, UUID accessorId) {
        int optionValue = claimConfig.getEffective(option);
        if (optionValue >= 3) {
            return true;
        }
        if (optionValue == 0) {
            return false;
        }
        int exceptionLevel = this.getExceptionAccessLevel(claimConfig, accessor, accessorId);
        return exceptionLevel <= optionValue;
    }

    @Override
    public boolean checkProtectionLeveledOption(@Nonnull IPlayerConfigOptionSpecAPI<Integer> option, @Nonnull IPlayerConfigAPI claimConfig, @Nonnull Entity accessor) {
        return this.checkProtectionLeveledOption(option, (IPlayerConfig)claimConfig, accessor, null);
    }

    @Override
    public boolean checkExceptionLeveledOption(@Nonnull IPlayerConfigOptionSpecAPI<Integer> option, @Nonnull IPlayerConfigAPI claimConfig, @Nonnull Entity accessor) {
        return this.checkExceptionLeveledOption(option, (IPlayerConfig)claimConfig, accessor, null);
    }

    @Override
    public boolean checkProtectionLeveledOption(@Nonnull IPlayerConfigOptionSpecAPI<Integer> option, @Nonnull IPlayerConfigAPI claimConfig, @Nonnull UUID accessorId) {
        return this.checkProtectionLeveledOption(option, (IPlayerConfig)claimConfig, null, accessorId);
    }

    @Override
    public boolean checkExceptionLeveledOption(@Nonnull IPlayerConfigOptionSpecAPI<Integer> option, @Nonnull IPlayerConfigAPI claimConfig, @Nonnull UUID accessorId) {
        return this.checkExceptionLeveledOption(option, (IPlayerConfig)claimConfig, null, accessorId);
    }

    private boolean isIncludedByProtectedEntityLists(Entity e) {
        if (this.entityHelper.isHostile(e)) {
            return ServerConfig.CONFIG.hostileChunkProtectedEntityListType.get() == ServerConfig.ConfigListType.ALL_BUT && !this.hostileEntityList.contains(e.getType()) || ServerConfig.CONFIG.hostileChunkProtectedEntityListType.get() == ServerConfig.ConfigListType.ONLY && this.hostileEntityList.contains(e.getType());
        }
        return ServerConfig.CONFIG.friendlyChunkProtectedEntityListType.get() == ServerConfig.ConfigListType.ALL_BUT && !this.friendlyEntityList.contains(e.getType()) || ServerConfig.CONFIG.friendlyChunkProtectedEntityListType.get() == ServerConfig.ConfigListType.ONLY && this.friendlyEntityList.contains(e.getType());
    }

    private boolean isProtectable(Entity e) {
        return !(e instanceof Player) && this.isIncludedByProtectedEntityLists(e);
    }

    private boolean canGrief(Entity e, IPlayerConfig config, Entity accessor, UUID accessorId, boolean blocks, boolean entities, boolean items) {
        IPlayerConfigOptionSpecAPI<Integer> option;
        if (e == null) {
            return false;
        }
        if (blocks && !this.isAllowedToGrief(e, accessor, accessorId, config, true, this.entitiesAllowedToBreakBlocks, null, this.blockAccessEntityGroups) && this.checkProtectionLeveledOption(option = this.getUsedBlockProtectionOption(config, e, accessor), config, accessor, accessorId)) {
            return false;
        }
        if (entities && !this.isAllowedToGrief(e, accessor, accessorId, config, true, this.entitiesAllowedToKillEntities, null, this.entityAccessEntityGroups) && this.checkProtectionLeveledOption(option = this.getUsedEntityProtectionOption(config, e, accessor), config, accessor, accessorId)) {
            return false;
        }
        return !items || this.isAllowedToGrief(e, accessor, accessorId, config, true, this.entitiesAllowedToGriefDroppedItems, null, this.droppedItemAccessEntityGroups) || !this.checkProtectionLeveledOption(option = this.getUsedDroppedItemProtectionOption(config, e, accessor), config, accessor, accessorId);
    }

    private boolean isAllowedToGrief(Entity e, Entity accessor, UUID accessorId, IPlayerConfig config, boolean breaking, ChunkProtectionExceptionSet<EntityType<?>> breakingForcedSet, ChunkProtectionExceptionSet<EntityType<?>> interactForcedSet, Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> groups) {
        if (e == null) {
            return false;
        }
        EntityType entityType = e.getType();
        if (breaking && breakingForcedSet.contains(entityType)) {
            return true;
        }
        if (!breaking && interactForcedSet.contains(entityType)) {
            return true;
        }
        for (ChunkProtectionExceptionGroup<EntityType<?>> group : groups.values()) {
            if (group.getType() != ChunkProtectionExceptionType.FULL && breaking != (group.getType() == ChunkProtectionExceptionType.BREAK) || !group.contains(entityType) || !this.checkExceptionLeveledOption(group.getPlayerConfigOption(), config, accessor, accessorId)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasChunkAccess(IPlayerConfigAPI claimConfig, Entity accessor, UUID accessorId) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return true;
        }
        if (claimConfig == null) return true;
        if (!claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
            return true;
        }
        if (accessor != null) {
            boolean isAServerPlayer;
            if (accessorId == null) {
                accessorId = accessor.getUUID();
            }
            if ((isAServerPlayer = accessor instanceof ServerPlayer) && ServerPlayerDataAPI.from((ServerPlayer)accessor).isClaimsNonallyMode()) {
                return false;
            }
            if (accessorId.equals(claimConfig.getPlayerId())) {
                return true;
            }
            if (!isAServerPlayer) return false;
            ServerPlayerDataAPI playerData = ServerPlayerDataAPI.from((ServerPlayer)accessor);
            this.claimsManager.getPermissionHandler().ensureAdminModeStatusPermission((ServerPlayer)accessor, playerData);
            if (playerData.isClaimsAdminMode()) return true;
            if (playerData.isClaimsServerMode() && this.claimsManager.getPermissionHandler().playerHasServerClaimPermission((ServerPlayer)accessor) && claimConfig.getType() == PlayerConfigType.SERVER) {
                return true;
            }
        } else {
            if (accessorId == null) {
                return false;
            }
            if (accessorId.equals(claimConfig.getPlayerId())) {
                return true;
            }
        }
        if (claimConfig.getPlayerId() == null) {
            return false;
        }
        if (claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FROM_PARTY).booleanValue() && claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FROM_ALLY_PARTIES).booleanValue()) {
            return false;
        }
        if (!this.playerPartySystemManager.isInAParty(claimConfig.getPlayerId())) {
            return false;
        }
        if (!claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FROM_PARTY).booleanValue()) {
            if (this.playerPartySystemManager.areInSameParty(claimConfig.getPlayerId(), accessorId)) return true;
        }
        if (claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FROM_ALLY_PARTIES) != false) return false;
        if (!this.playerPartySystemManager.isPlayerAllying(claimConfig.getPlayerId(), accessorId)) return false;
        return true;
    }

    @Override
    public boolean hasChunkAccess(@Nonnull IPlayerConfigAPI claimConfig, @Nonnull UUID accessorId) {
        return this.hasChunkAccess(claimConfig, null, accessorId);
    }

    @Override
    public boolean hasChunkAccess(@Nonnull IPlayerConfigAPI claimConfig, @Nonnull Entity accessor) {
        return this.hasChunkAccess(claimConfig, accessor, accessor.getUUID());
    }

    private int getExceptionAccessLevel(IPlayerConfig claimConfig, Entity accessor, UUID accessorId) {
        ServerPlayer player;
        if (accessor instanceof ServerPlayer && ServerPlayerData.from(player = (ServerPlayer)accessor).isClaimsNonallyMode()) {
            return 3;
        }
        if (accessorId == null) {
            if (accessor == null) {
                return 3;
            }
            accessorId = accessor.getUUID();
        }
        if (accessorId.equals(claimConfig.getPlayerId())) {
            return 0;
        }
        if (!this.playerPartySystemManager.isInAParty(claimConfig.getPlayerId())) {
            return 3;
        }
        if (this.playerPartySystemManager.areInSameParty(claimConfig.getPlayerId(), accessorId)) {
            return 1;
        }
        if (this.playerPartySystemManager.isPlayerAllying(claimConfig.getPlayerId(), accessorId)) {
            return 2;
        }
        return 3;
    }

    private BlockPos getFakePlayerPos(Player player) {
        BlockPos playerPos = player.blockPosition();
        if (!BlockPos.ZERO.equals((Object)playerPos)) {
            return playerPos;
        }
        Vec3 position1 = player.getPosition(1.0f);
        if (!Vec3.ZERO.equals((Object)position1)) {
            return BlockPos.containing((Position)position1);
        }
        double specificallyX = player.getX();
        double specificallyY = player.getY();
        double specificallyZ = player.getZ();
        if (specificallyX == 0.0 && specificallyY == 0.0 && specificallyZ == 0.0) {
            return BlockPos.containing((Position)player.getPosition(0.0f));
        }
        return BlockPos.containing((double)specificallyX, (double)specificallyY, (double)specificallyZ);
    }

    private boolean isAllowedStaticFakePlayerAction(IServerData<CM, ?> serverData, Player player, BlockPos targetPos, BlockPos targetPos2) {
        if (player == null || !this.staticFakePlayerIds.contains(player.getUUID()) && !this.staticFakePlayerUsernames.contains(player.getGameProfile().getName())) {
            return false;
        }
        if (this.isStaticFakePlayerExceptionClass((Entity)player)) {
            return false;
        }
        BlockPos playerPos = this.getFakePlayerPos(player);
        BlockPos checkedPos = targetPos;
        BlockPos.MutableBlockPos possibleFakePlayerOrigin = new BlockPos.MutableBlockPos();
        boolean shouldCheckTargetPos2 = targetPos2 != null && (targetPos.getX() >> 4 != targetPos2.getX() >> 4 || targetPos.getZ() >> 4 != targetPos2.getZ() >> 4);
        while (true) {
            int minX = 0;
            int maxX = 0;
            int minZ = 0;
            int maxZ = 0;
            int localX = checkedPos.getX() & 0xF;
            int localZ = checkedPos.getZ() & 0xF;
            if (localX == 0) {
                minX = -1;
            } else if (localX == 15) {
                maxX = 1;
            }
            if (localZ == 0) {
                minZ = -1;
            } else if (localZ == 15) {
                maxZ = 1;
            }
            if (checkedPos == playerPos || minX != maxX || minZ != maxZ) {
                for (int i = minX; i <= maxX; ++i) {
                    for (int j = minZ; j <= maxZ; ++j) {
                        if (i == 0 && j == 0) {
                            possibleFakePlayerOrigin.set((Vec3i)checkedPos);
                        } else {
                            possibleFakePlayerOrigin.set(checkedPos.getX() + i, checkedPos.getY(), checkedPos.getZ() + j);
                        }
                        if (possibleFakePlayerOrigin.equals((Object)targetPos)) continue;
                        if (checkedPos == playerPos) {
                            int diffX = possibleFakePlayerOrigin.getX() - targetPos.getX();
                            int diffZ = possibleFakePlayerOrigin.getZ() - targetPos.getZ();
                            if (diffX * diffX <= 1 && diffZ * diffZ <= 1) continue;
                        }
                        if (this.hitsAnotherClaim(serverData, player.level(), (BlockPos)possibleFakePlayerOrigin, targetPos, null, true)) {
                            return false;
                        }
                        if (!shouldCheckTargetPos2 || !this.hitsAnotherClaim(serverData, player.level(), (BlockPos)possibleFakePlayerOrigin, targetPos2, null, true)) continue;
                        return false;
                    }
                }
            }
            if (checkedPos.equals((Object)playerPos)) break;
            checkedPos = playerPos;
        }
        return true;
    }

    private boolean isAllowedStaticFakePlayerAction(IServerData<CM, ?> serverData, Player player, BlockPos targetPos) {
        return this.isAllowedStaticFakePlayerAction(serverData, player, targetPos, null);
    }

    public boolean onEntityDestroyBlock(IServerData<CM, ?> serverData, BlockState blockState, Entity entity, ServerLevel world, BlockPos pos, boolean messages) {
        return this.onBlockInteraction(serverData, blockState, entity, InteractionHand.MAIN_HAND, null, world, pos, Direction.UP, true, messages);
    }

    public IPlayerConfig getClaimConfig(IPlayerConfigManager playerConfigs, IPlayerChunkClaim claim) {
        IPlayerConfig mainConfig = playerConfigs.getLoadedConfig(claim == null ? null : claim.getPlayerId());
        if (claim == null) {
            return mainConfig;
        }
        return mainConfig.getEffectiveSubConfig(claim.getSubConfigIndex());
    }

    @Override
    @Nonnull
    public IPlayerConfigAPI getClaimConfig(@Nullable IPlayerChunkClaimAPI claim) {
        return this.getClaimConfig(this.serverData.getPlayerConfigs(), (IPlayerChunkClaim)claim);
    }

    private InteractionTargetResult blockAccessCheck(Block block, IPlayerConfig config, Entity entity, Entity accessor, UUID accessorId, boolean emptyHand, boolean breaking) {
        boolean chunkAccess = this.hasChunkAccess(config, accessor, accessorId);
        if (chunkAccess) {
            return InteractionTargetResult.ALLOW;
        }
        boolean optionProtects = this.checkProtectionLeveledOption(this.getUsedBlockProtectionOption(config, entity, accessor), config, accessor, accessorId);
        if (optionProtects) {
            boolean bl = optionProtects = entity instanceof Player || !this.isAllowedToGrief(entity, accessor, accessorId, config, breaking, this.entitiesAllowedToBreakBlocks, this.entitiesAllowedToInteractWithBlocks, this.blockAccessEntityGroups);
        }
        if (!optionProtects && (breaking || emptyHand || !this.checkProtectionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_USE, config, accessor, accessorId))) {
            return InteractionTargetResult.ALLOW;
        }
        if (block == null) {
            return optionProtects ? InteractionTargetResult.PROTECT : InteractionTargetResult.PASS;
        }
        if (breaking && this.forcedBreakExceptionBlocks.contains(block)) {
            return InteractionTargetResult.ALLOW;
        }
        if (!breaking && this.forcedAllowAnyItemBlocks.contains(block)) {
            return InteractionTargetResult.ALLOW;
        }
        int exceptionAccessLevel = this.getExceptionAccessLevel(config, accessor, accessorId);
        boolean groupsAllowPass = false;
        for (ChunkProtectionExceptionGroup<Block> group : this.blockExceptionGroups.values()) {
            if (group.getType() == ChunkProtectionExceptionType.BREAK != breaking || !emptyHand && group.getType() == ChunkProtectionExceptionType.EMPTY_HAND_INTERACTION || exceptionAccessLevel > config.getEffective(group.getPlayerConfigOption()) || !group.contains(block)) continue;
            if (breaking || emptyHand || group.getType() == ChunkProtectionExceptionType.ANY_ITEM_INTERACTION) {
                return InteractionTargetResult.ALLOW;
            }
            groupsAllowPass = true;
        }
        if (!optionProtects) {
            return InteractionTargetResult.PASS;
        }
        if (groupsAllowPass) {
            return InteractionTargetResult.PASS;
        }
        if (!breaking && this.forcedInteractionExceptionBlocks.contains(block) && (emptyHand || !this.requiresEmptyHandBlocks.contains(block))) {
            return InteractionTargetResult.PASS;
        }
        return InteractionTargetResult.PROTECT;
    }

    private InteractionTargetResult onBlockAccess(IServerData<CM, ?> serverData, Block block, IPlayerConfig config, Entity entity, Entity accessor, UUID accessorId, InteractionHand hand, boolean emptyHand, boolean leftClick, Component message, Entity messageReceiver) {
        InteractionTargetResult result = this.blockAccessCheck(block, config, entity, accessor, accessorId, emptyHand, leftClick);
        if (result == InteractionTargetResult.PROTECT && messageReceiver instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)messageReceiver;
            player.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor(player, hand == null ? this.CANT_INTERACT_BLOCK : (hand == InteractionHand.MAIN_HAND ? this.CANT_INTERACT_BLOCK_MAIN : this.CANT_INTERACT_BLOCK_OFF)));
            if (message != null) {
                player.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor(player, message));
            }
        }
        return result;
    }

    public boolean onBlockInteraction(IServerData<CM, ?> serverData, BlockState blockState, Entity entity, InteractionHand hand, ItemStack heldItem, ServerLevel world, BlockPos pos, Direction direction, boolean breaking, boolean messages) {
        boolean emptyHand;
        boolean itemMatters;
        Entity messageReceiver;
        Block block;
        Entity accessor;
        UUID accessorId;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(world, accessorId);
        } else {
            accessor = (Entity)accessorInfo;
            accessorId = accessor == null ? null : accessor.getUUID();
        }
        Block block2 = block = blockState == null ? null : blockState.getBlock();
        Entity entity2 = !messages ? null : (messageReceiver = accessor == null ? entity : accessor);
        if (this.completelyDisabledBlocks.contains(block)) {
            if (messageReceiver instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)messageReceiver;
                player.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor((ServerPlayer)entity, this.BLOCK_DISABLED));
            }
            return true;
        }
        if (entity != null && this.hasActiveFullPass(entity)) {
            return false;
        }
        if (heldItem == null) {
            ItemStack itemStack;
            if (hand != null && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                itemStack = livingEntity.getItemInHand(hand);
            } else {
                itemStack = ItemStack.EMPTY;
            }
            heldItem = itemStack;
        }
        boolean bl = itemMatters = !(emptyHand = heldItem.isEmpty()) && !breaking;
        Component message = !itemMatters ? null : (hand == InteractionHand.MAIN_HAND ? this.BLOCK_TRY_EMPTY_MAIN : this.BLOCK_TRY_EMPTY_OFF);
        boolean itemUseAtTargetAllowed = false;
        boolean isPlayer = entity instanceof Player;
        ChunkPos chunkPos = new ChunkPos(pos);
        IPlayerChunkClaim claim = this.claimsManager.get(world.dimension().location(), chunkPos);
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        if (!isPlayer || !this.isAllowedStaticFakePlayerAction(serverData, (Player)entity, pos)) {
            IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
            InteractionTargetResult targetResult = this.onBlockAccess(serverData, block, config, entity, accessor, accessorId, hand, emptyHand, breaking, message, messageReceiver);
            if (targetResult == InteractionTargetResult.PROTECT) {
                return true;
            }
            if (isPlayer && !emptyHand && targetResult == InteractionTargetResult.ALLOW && !((Player)entity).isSecondaryUseActive()) {
                itemUseAtTargetAllowed = true;
            }
        }
        if (!itemMatters) {
            return false;
        }
        boolean itemUseAtOffsetAllowed = false;
        if (itemUseAtTargetAllowed) {
            if (this.isOnChunkEdge(pos)) {
                BlockPos offsetPos = pos.offset(direction.getUnitVec3i());
                ChunkPos offsetChunkPos = new ChunkPos(offsetPos);
                if (!chunkPos.equals((Object)offsetChunkPos)) {
                    IPlayerChunkClaim offsetClaim = this.claimsManager.get(world.dimension().location(), offsetChunkPos);
                    if (offsetClaim != null && claim != offsetClaim) {
                        UUID offsetClaimOwnerId;
                        UUID claimOwnerId = claim == null ? null : claim.getPlayerId();
                        if (Objects.equals(claimOwnerId, offsetClaimOwnerId = offsetClaim.getPlayerId())) {
                            IPlayerConfig config = this.getClaimConfig(playerConfigs, offsetClaim);
                            InteractionTargetResult offsetResult = this.onBlockAccess(serverData, block, config, entity, accessor, accessorId, hand, emptyHand, breaking, message, messageReceiver);
                            itemUseAtOffsetAllowed = offsetResult == InteractionTargetResult.ALLOW;
                        }
                    } else {
                        itemUseAtOffsetAllowed = true;
                    }
                } else {
                    itemUseAtOffsetAllowed = true;
                }
            } else {
                itemUseAtOffsetAllowed = true;
            }
        }
        return this.onUseItemAt(serverData, entity, world, pos, direction, heldItem, hand, itemUseAtTargetAllowed, itemUseAtOffsetAllowed, messages);
    }

    @Override
    public boolean onBlockInteraction(@Nullable Entity entity, @Nullable InteractionHand hand, @Nullable ItemStack heldItem, @Nonnull ServerLevel world, @Nonnull BlockPos pos, @Nonnull Direction direction, boolean breaking, boolean messages) {
        return this.onBlockInteraction(entity, hand, heldItem, world, pos, direction, breaking, messages, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onBlockInteraction(@Nullable Entity entity, @Nullable InteractionHand hand, @Nullable ItemStack heldItem, @Nonnull ServerLevel world, @Nonnull BlockPos pos, @Nonnull Direction direction, boolean breaking, boolean messages, boolean targetExceptions) {
        try {
            this.fullPassesPaused = true;
            boolean bl = this.onBlockInteraction(this.serverData, targetExceptions ? world.getBlockState(pos) : null, entity, hand, heldItem, world, pos, direction, breaking, messages);
            return bl;
        }
        finally {
            this.fullPassesPaused = false;
        }
    }

    public boolean onBlockSpecialInteraction(IServerData<CM, ?> serverData, Player player, ServerLevel world, BlockPos pos) {
        return this.onBlockInteraction(serverData, world.getBlockState(pos), (Entity)player, null, null, world, pos, Direction.UP, false, true);
    }

    public boolean onEntityPlaceBlock(IServerData<CM, ?> serverData, Entity entity, ServerLevel world, BlockPos pos, IPlayerConfigOptionSpecAPI<Integer> option) {
        Entity accessor;
        UUID accessorId;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        if (entity != null && this.hasActiveFullPass(entity)) {
            return false;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        IPlayerChunkClaim claim = this.claimsManager.get(world.dimension().location(), chunkPos);
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(world, accessorId);
        } else {
            accessor = (Entity)accessorInfo;
            UUID uUID = accessorId = accessor == null ? null : accessor.getUUID();
        }
        if (entity instanceof Player && this.isAllowedStaticFakePlayerAction(serverData, (Player)entity, pos)) {
            return false;
        }
        return !(option != null && !this.checkProtectionLeveledOption(option, config, accessor, accessorId) || !(entity instanceof Player) && this.canGrief(entity, config, accessor, accessorId, true, false, false) || this.blockAccessCheck(null, config, entity, accessor, accessorId, false, false) != InteractionTargetResult.PROTECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onEntityPlaceBlock(@Nullable Entity entity, @Nonnull ServerLevel world, @Nonnull BlockPos pos) {
        try {
            this.fullPassesPaused = true;
            boolean bl = this.onEntityPlaceBlock(this.serverData, entity, world, pos, null);
            return bl;
        }
        finally {
            this.fullPassesPaused = false;
        }
    }

    public boolean onEnchantmentEffectOnBlock(IServerData<CM, ?> serverData, Entity entity, ServerLevel world, BlockPos pos) {
        return this.onEntityPlaceBlock(serverData, entity, world, pos, PlayerConfigOptions.PROTECT_CLAIMED_BLOCKS_FROM_ENCHANTMENTS);
    }

    public boolean onEnchantmentEffectOnBlockDisk(IServerData<CM, ?> serverData, Entity entity, ServerLevel world, BlockPos pos, int radius) {
        int minBlockX = pos.getX() - radius;
        int minBlockZ = pos.getZ() - radius;
        int maxBlockX = pos.getX() + radius;
        int maxBlockZ = pos.getZ() + radius;
        int minChunkX = minBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                this.reusableBlockPos.set(chunkX << 4, pos.getY(), chunkZ << 4);
                if (!this.onEntityPlaceBlock(serverData, entity, world, (BlockPos)this.reusableBlockPos, PlayerConfigOptions.PROTECT_CLAIMED_BLOCKS_FROM_ENCHANTMENTS)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isItemUseRestricted(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (this.itemUseProtectionExceptions.contains(item)) {
            return false;
        }
        return item instanceof BlockItem || !itemStack.has(DataComponents.FOOD) && !(item instanceof PotionItem) && !(item instanceof ProjectileWeaponItem) && !(item instanceof TridentItem) && !(item instanceof ShieldItem) && !itemStack.has(DataComponents.WEAPON) && !(item instanceof AxeItem) && !(item instanceof HoeItem) && !(item instanceof BoatItem) && !itemStack.is(ItemTags.BOATS) && !itemStack.has(DataComponents.CONSUMABLE) && !itemStack.has(DataComponents.EQUIPPABLE) || this.additionalBannedItems.contains(item);
    }

    public boolean onItemRightClick(IServerData<CM, ?> serverData, InteractionHand hand, ItemStack itemStack, BlockPos pos, LivingEntity entity, boolean messages) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        boolean shouldProtect = false;
        Item item = itemStack.getItem();
        if (this.completelyDisabledItems.contains(item)) {
            if (messages && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor(serverPlayer, hand == null ? this.ITEM_DISABLED_ANY : (hand == InteractionHand.MAIN_HAND ? this.ITEM_DISABLED_MAIN : this.ITEM_DISABLED_OFF)));
            }
            return true;
        }
        if (this.hasActiveFullPass((Entity)entity)) {
            return false;
        }
        if (this.isItemUseRestricted(itemStack) && !(item instanceof BucketItem) && !(item instanceof SolidBucketItem)) {
            IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
            ChunkPos chunkPos = new ChunkPos(pos);
            boolean shouldCheckGroups = false;
            for (ChunkProtectionExceptionGroup<Item> group : this.itemExceptionGroups.values()) {
                if (!group.contains(itemStack.getItem())) continue;
                shouldCheckGroups = true;
                break;
            }
            block1: for (int i = -1; i < 2; ++i) {
                block2: for (int j = -1; j < 2; ++j) {
                    Player player;
                    IPlayerConfig config;
                    boolean isCurrentChunk;
                    ChunkPos offsetChunkPos = new ChunkPos(chunkPos.x + i, chunkPos.z + j);
                    IPlayerChunkClaim claim = this.claimsManager.get(entity.level().dimension().location(), offsetChunkPos);
                    boolean bl = isCurrentChunk = i == 0 && j == 0;
                    if (!isCurrentChunk && claim == null || !this.checkProtectionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_USE, config = this.getClaimConfig(playerConfigs, claim), (Entity)entity, null) || !isCurrentChunk && !config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NEIGHBOR_CHUNKS_ITEM_USE).booleanValue() || this.hasChunkAccess(config, (Entity)entity, null) || entity instanceof Player && this.isAllowedStaticFakePlayerAction(serverData, player = (Player)entity, offsetChunkPos.getMiddleBlockPosition(0))) continue;
                    if (shouldCheckGroups) {
                        int exceptionAccessLevel = this.getExceptionAccessLevel(config, (Entity)entity, null);
                        for (ChunkProtectionExceptionGroup<Item> group : this.itemExceptionGroups.values()) {
                            if (exceptionAccessLevel > config.getEffective(group.getPlayerConfigOption()) || !group.contains(itemStack.getItem())) continue;
                            continue block2;
                        }
                    }
                    shouldProtect = true;
                    continue block1;
                }
            }
        }
        if (messages && shouldProtect && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor(serverPlayer, hand == null ? this.USE_ITEM_ANY : (hand == InteractionHand.MAIN_HAND ? this.USE_ITEM_MAIN : this.USE_ITEM_OFF)));
        }
        return shouldProtect;
    }

    public boolean onMobGrief(IServerData<CM, ?> serverData, Entity entity) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        boolean blocks = !(entity instanceof Evoker) && !this.nonBlockGriefingMobs.contains(entity.getType());
        boolean entities = entity instanceof Evoker || this.entityGriefingMobs.contains(entity.getType());
        boolean items = this.droppedItemGriefingMobs.contains(entity.getType());
        return this.onMobGrief(serverData, entity, blocks, entities, items);
    }

    private boolean onMobGrief(IServerData<CM, ?> serverData, Entity entity, boolean blocks, boolean entities, boolean items) {
        Entity accessor;
        UUID accessorId;
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(ServerLevelHelper.getServerLevel(entity.level()), accessorId);
        } else {
            accessor = (Entity)accessorInfo;
            accessorId = accessor.getUUID();
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                IPlayerConfig config;
                ChunkPos chunkPos = new ChunkPos(entity.chunkPosition().x + i, entity.chunkPosition().z + j);
                IPlayerChunkClaim claim = this.claimsManager.get(entity.level().dimension().location(), chunkPos);
                if ((i != 0 || j != 0) && claim == null || !(config = this.getClaimConfig(playerConfigs, claim)).getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_MOB_GRIEFING_OVERRIDE).booleanValue() || this.canGrief(entity, config, accessor, accessorId, blocks, entities, items) || this.hasChunkAccess(config, accessor, accessorId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean onEntityInteraction(IServerData<CM, ?> serverData, Entity interactingEntityIndirect, Entity interactingEntity, Entity target, ItemStack heldItem, InteractionHand hand, boolean attack, boolean messages, boolean targetExceptions) {
        Entity accessor;
        UUID accessorId;
        Entity messageReceiver;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        Entity entity = !messages ? null : (messageReceiver = interactingEntityIndirect == null ? interactingEntity : interactingEntityIndirect);
        if (!attack && this.completelyDisabledEntities.contains(target.getType())) {
            if (hand != InteractionHand.OFF_HAND && messageReceiver instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)messageReceiver;
                player.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor(player, this.ENTITY_DISABLED));
            }
            return true;
        }
        if (interactingEntity != null && this.hasActiveFullPass(interactingEntity)) {
            return false;
        }
        if (interactingEntity instanceof Player && this.isAllowedStaticFakePlayerAction(serverData, (Player)interactingEntity, target.blockPosition())) {
            return false;
        }
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        Level targetLevel = target.level();
        ServerLevel targetServerLevel = ServerLevelHelper.getServerLevel(targetLevel);
        IPlayerChunkClaim claim = this.claimsManager.get(target.level().dimension().location(), target.chunkPosition());
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        if (heldItem == null) {
            ItemStack itemStack;
            if (hand != null && interactingEntity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)interactingEntity;
                itemStack = living.getItemInHand(hand);
            } else {
                itemStack = ItemStack.EMPTY;
            }
            heldItem = itemStack;
        }
        boolean emptyHand = heldItem.isEmpty();
        Object accessorInfo = this.getAccessorInfo(interactingEntityIndirect == null ? interactingEntity : interactingEntityIndirect);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(targetServerLevel, accessorId);
        } else {
            accessor = (Entity)accessorInfo;
            accessorId = accessor == null ? null : accessor.getUUID();
        }
        boolean needsItemCheck = !attack && !emptyHand;
        boolean itemUseAtTargetAllowed = false;
        if (!(targetExceptions && target == accessor || this.isAllowedToGrief(interactingEntity, accessor, accessorId, config, attack, this.entitiesAllowedToKillEntities, this.entitiesAllowedToInteractWithEntities, this.entityAccessEntityGroups))) {
            Player player;
            InteractionTargetResult targetResult = this.entityAccessCheck(playerConfigs, config, target, interactingEntity, accessor, accessorId, attack, emptyHand, targetExceptions);
            if (targetResult == InteractionTargetResult.PROTECT) {
                if (messageReceiver instanceof ServerPlayer) {
                    ServerPlayer player2 = (ServerPlayer)messageReceiver;
                    player2.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor(player2, hand == null ? this.CANT_INTERACT_ENTITY : (hand == InteractionHand.MAIN_HAND ? this.CANT_INTERACT_ENTITY_MAIN : this.CANT_INTERACT_ENTITY_OFF)));
                    if (needsItemCheck) {
                        Component message = hand == InteractionHand.MAIN_HAND ? this.ENTITY_TRY_EMPTY_MAIN : this.ENTITY_TRY_EMPTY_OFF;
                        player2.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor(player2, message));
                    }
                }
                return true;
            }
            if (needsItemCheck && targetResult == InteractionTargetResult.ALLOW && interactingEntity instanceof Player && !(player = (Player)interactingEntity).isSecondaryUseActive()) {
                itemUseAtTargetAllowed = true;
            }
        }
        if (!needsItemCheck) {
            return false;
        }
        return this.onUseItemAt(serverData, interactingEntity, targetServerLevel, target.blockPosition(), null, heldItem, hand, itemUseAtTargetAllowed, false, messages);
    }

    @Override
    public boolean onEntityInteraction(@Nullable Entity interactingEntityIndirect, @Nullable Entity interactingEntity, @Nonnull Entity target, @Nullable ItemStack heldItem, @Nullable InteractionHand hand, boolean attack, boolean messages) {
        return this.onEntityInteraction(interactingEntityIndirect, interactingEntity, target, heldItem, hand, attack, messages, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onEntityInteraction(@Nullable Entity interactingEntityIndirect, @Nullable Entity interactingEntity, @Nonnull Entity target, @Nullable ItemStack heldItem, @Nullable InteractionHand hand, boolean attack, boolean messages, boolean targetExceptions) {
        try {
            this.fullPassesPaused = true;
            boolean bl = this.onEntityInteraction(this.serverData, interactingEntityIndirect, interactingEntity, target, heldItem, hand, attack, messages, targetExceptions);
            return bl;
        }
        finally {
            this.fullPassesPaused = false;
        }
    }

    public boolean onFishingHookedEntity(IServerData<CM, ?> serverData, FishingHook hook, Entity entity) {
        return this.onEntityInteraction(serverData, hook.getOwner(), (Entity)hook, entity, ItemStack.EMPTY, InteractionHand.MAIN_HAND, true, false, true);
    }

    public boolean onEntityFire(IServerData<CM, ?> serverData, Entity target) {
        IPlayerChunkClaim claim;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim = this.claimsManager.get(target.level().dimension().location(), target.chunkPosition()));
        return config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS) != false && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_FIRE) != false && this.isProtectable(target);
    }

    private boolean blockedByBarrierGroups(IPlayerConfig config, Entity entity, Entity accessor, UUID accessorId) {
        int exceptionAccessLevel = this.getExceptionAccessLevel(config, accessor, accessorId);
        for (ChunkProtectionExceptionGroup<EntityType<?>> group : this.entityBarrierGroups.values()) {
            int configValue = config.getEffective(group.getPlayerConfigOption());
            if (configValue <= 0 || exceptionAccessLevel < configValue || !group.contains(entity.getType())) continue;
            return true;
        }
        return false;
    }

    private boolean shouldPreventEntityChunkEntry(IServerData<CM, ?> serverData, IPlayerConfigManager playerConfigs, IPlayerChunkClaim toClaim, IPlayerChunkClaim fromClaim, IPlayerConfig config, IPlayerConfig fromConfig, Entity entity, SectionPos newSection, SectionPos oldSection) {
        UUID lootOwnerId;
        Entity accessor;
        UUID accessorId;
        if (toClaim == null && newSection != null) {
            toClaim = this.claimsManager.get(entity.level().dimension().location(), newSection.x(), newSection.z());
        }
        if (config == null) {
            config = this.getClaimConfig(playerConfigs, toClaim);
        }
        ServerLevel entityServerLevel = ServerLevelHelper.getServerLevel(entity.level());
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(entityServerLevel, accessorId);
        } else {
            accessor = (Entity)accessorInfo;
            accessorId = accessor.getUUID();
        }
        if (fromClaim == null && oldSection != null) {
            fromClaim = this.claimsManager.get(entity.level().dimension().location(), oldSection.x(), oldSection.z());
        }
        boolean enteringProtectedChunk = toClaim != null && !this.hasChunkAccess(config, accessor, accessorId);
        boolean isBlockedEntity = enteringProtectedChunk && this.forcedEntityClaimBarrierList.contains(entity.getType());
        boolean madeAnException = false;
        if (enteringProtectedChunk) {
            ItemEntity itemEntity;
            UUID throwerId;
            if (!isBlockedEntity) {
                isBlockedEntity = this.blockedByBarrierGroups(config, entity, accessor, accessorId);
                if (isBlockedEntity && !this.hitsAnotherClaim(serverData, fromClaim, toClaim, null, false)) {
                    fromConfig = this.getClaimConfig(playerConfigs, fromClaim);
                    isBlockedEntity = !this.blockedByBarrierGroups(fromConfig, entity, accessor, accessorId);
                    madeAnException = true;
                }
            } else {
                isBlockedEntity = this.hitsAnotherClaim(serverData, fromClaim, toClaim, null, false);
                madeAnException = true;
            }
            if (!isBlockedEntity) {
                Raider raider;
                boolean bl = isBlockedEntity = accessor instanceof Raider && (raider = (Raider)accessor).canJoinRaid() && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_RAIDS) != false;
            }
            if (!isBlockedEntity && entity instanceof ItemEntity && (throwerId = ServerCore.getItemEntityThrower(itemEntity = (ItemEntity)entity)) != null) {
                if (fromConfig == null) {
                    fromConfig = this.getClaimConfig(playerConfigs, fromClaim);
                }
                Entity thrower = this.getEntityById(entityServerLevel, throwerId);
                boolean bl = isBlockedEntity = fromConfig != config && this.shouldPreventToss(config, itemEntity, thrower, throwerId, ServerCore.getThrowerAccessor(itemEntity)) != itemEntity;
            }
        }
        if (!isBlockedEntity && (lootOwnerId = ServerCore.getLootOwner(entity)) != null) {
            if (fromConfig == null) {
                fromConfig = this.getClaimConfig(playerConfigs, fromClaim);
            }
            if (fromConfig != config) {
                UUID deadPlayerId = ServerCore.getDeadPlayer(entity);
                if (deadPlayerId != null) {
                    Entity deadPlayer = this.getEntityById(entityServerLevel, deadPlayerId);
                    isBlockedEntity = this.checkExceptionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYER_DEATH_LOOT, fromConfig, deadPlayer, deadPlayerId);
                } else if (enteringProtectedChunk) {
                    isBlockedEntity = this.shouldStopMobLoot(config, this.getEntityById(entityServerLevel, lootOwnerId), lootOwnerId);
                }
            }
        }
        if (enteringProtectedChunk && !isBlockedEntity && madeAnException && accessor != entity && (isBlockedEntity = this.blockedByBarrierGroups(config, accessor, accessor, accessorId))) {
            if (fromConfig == null) {
                fromConfig = this.getClaimConfig(playerConfigs, fromClaim);
            }
            isBlockedEntity = !this.blockedByBarrierGroups(fromConfig, accessor, accessor, accessorId);
        }
        return isBlockedEntity;
    }

    public void onEntityEnterChunk(IServerData<CM, ?> serverData, Entity entity, double goodX, double goodZ, SectionPos newSection, SectionPos oldSection) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return;
        }
        if (this.ignoreChunkEnter) {
            return;
        }
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        boolean isBlockedEntity = this.shouldPreventEntityChunkEntry(serverData, playerConfigs, null, null, null, null, entity, newSection, oldSection);
        if (isBlockedEntity) {
            this.ignoreChunkEnter = true;
            int goodXInt = (int)Math.floor(goodX);
            int goodZInt = (int)Math.floor(goodZ);
            double fixedX = (double)goodXInt + 0.5;
            double fixedZ = (double)goodZInt + 0.5;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                MinecraftServer server = player.getServer();
                server.execute(() -> {
                    ServerPlayer upToDatePlayer = server.getPlayerList().getPlayer(player.getUUID());
                    if (upToDatePlayer != player) {
                        return;
                    }
                    player.stopRiding();
                    player.connection.teleport(fixedX, entity.getY(), fixedZ, entity.getYRot(), entity.getXRot());
                });
            } else {
                entity.stopRiding();
                entity.snapTo(fixedX, entity.getY(), fixedZ, entity.getYRot(), entity.getXRot());
            }
            this.ignoreChunkEnter = false;
        }
    }

    public void onExplosionDetonate(IServerData<CM, ?> serverData, ServerLevel world, ServerExplosion explosion, List<Entity> affectedEntities, List<BlockPos> affectedBlocks) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return;
        }
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        LivingEntity damager = explosion.getIndirectSourceEntity();
        if (damager != null && this.hasActiveFullPass((Entity)damager)) {
            return;
        }
        Iterator<BlockPos> positions = affectedBlocks.iterator();
        while (positions.hasNext()) {
            BlockPos blockPos = positions.next();
            ChunkPos chunkPos = new ChunkPos(blockPos);
            IPlayerChunkClaim claim = this.claimsManager.get(world.dimension().location(), chunkPos);
            IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
            if (config != null && (!config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue() || !config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_EXPLOSIONS).booleanValue()) || config == null) continue;
            positions.remove();
        }
        Iterator<Entity> entities = affectedEntities.iterator();
        Entity directDamager = explosion.getDirectSourceEntity();
        while (entities.hasNext()) {
            Entity entity = entities.next();
            IPlayerChunkClaim claim = this.claimsManager.get(world.dimension().location(), entity.chunkPosition());
            IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
            if (config != null && !config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
                config = null;
            }
            if (config == null || !config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_EXPLOSIONS).booleanValue() || (damager instanceof Player || !this.isProtectable(entity)) && this.entityAccessCheck(playerConfigs, config, entity, directDamager, (Entity)damager, null, true, true, true) != InteractionTargetResult.PROTECT) continue;
            entities.remove();
        }
    }

    public boolean onChorusFruitTeleport(IServerData<CM, ?> serverData, Vec3 pos, Entity entity) {
        Entity accessor;
        UUID accessorId;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        ChunkPos chunkPos = new ChunkPos(BlockPos.containing((Position)pos));
        IPlayerChunkClaim claim = this.claimsManager.get(entity.level().dimension().location(), chunkPos);
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig claimConfig = this.getClaimConfig(playerConfigs, claim);
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(ServerLevelHelper.getServerLevel(entity.level()), accessorId);
        } else {
            accessor = (Entity)accessorInfo;
            accessorId = accessor.getUUID();
        }
        if (this.checkProtectionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_CHORUS_FRUIT, claimConfig, accessor, accessorId) && !this.hasChunkAccess(claimConfig, accessor, accessorId)) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor(player, this.CANT_CHORUS));
            }
            return true;
        }
        return false;
    }

    public void onLightningBolt(IServerData<CM, ?> serverData, LightningBolt bolt) {
        OpenPartiesAndClaims.LOGGER.info("checking lightning 1 " + String.valueOf(bolt.getCause()));
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue() || bolt.getCause() == null) {
            return;
        }
        OpenPartiesAndClaims.LOGGER.info("checking lightning 2");
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        block0: for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                IPlayerConfig config;
                ChunkPos chunkPos = new ChunkPos(bolt.chunkPosition().x + i, bolt.chunkPosition().z + j);
                IPlayerChunkClaim claim = this.claimsManager.get(bolt.level().dimension().location(), chunkPos);
                if ((i != 0 || j != 0) && claim == null || !this.checkProtectionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYER_LIGHTNING, config = this.getClaimConfig(playerConfigs, claim), (Entity)bolt.getCause(), null) || this.hasChunkAccess(config, (Entity)bolt.getCause(), null) || this.isAllowedStaticFakePlayerAction(serverData, (Player)bolt.getCause(), chunkPos.getMiddleBlockPosition(0))) continue;
                bolt.setVisualOnly(true);
                OpenPartiesAndClaims.LOGGER.info("checking lightning 3");
                continue block0;
            }
        }
        OpenPartiesAndClaims.LOGGER.info("checking lightning 4");
    }

    public boolean onFireSpread(IServerData<CM, ?> serverData, ServerLevel world, BlockPos pos) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(world.dimension().location(), new ChunkPos(pos));
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig claimConfig = this.getClaimConfig(playerConfigs, claim);
        return claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS) != false && claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FROM_FIRE_SPREAD) != false;
    }

    public boolean onCropTrample(IServerData<CM, ?> serverData, Entity entity, BlockPos pos) {
        Entity accessor;
        UUID accessorId;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(entity.level().dimension().location(), new ChunkPos(pos));
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig claimConfig = this.getClaimConfig(playerConfigs, claim);
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(ServerLevelHelper.getServerLevel(entity.level()), accessorId);
        } else {
            accessor = (Entity)accessorInfo;
            accessorId = accessor == null ? null : accessor.getUUID();
        }
        return claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_CROP_TRAMPLE) != false && !this.hasChunkAccess(claimConfig, accessor, accessorId);
    }

    public boolean onBucketUse(IServerData<CM, ?> serverData, Entity entity, ServerLevel world, HitResult hitResult, ItemStack itemStack) {
        BlockPos pos;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        if (entity != null && this.hasActiveFullPass(entity)) {
            return false;
        }
        Direction direction = null;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            pos = blockHitResult.getBlockPos();
            direction = blockHitResult.getDirection();
        } else {
            pos = BlockPos.containing((Position)hitResult.getLocation());
        }
        return this.onUseItemAt(serverData, entity, world, pos, direction, itemStack, null, false, false, true);
    }

    public boolean onUseItemAt(IServerData<CM, ?> serverData, Entity entity, ServerLevel world, BlockPos pos, Direction direction, ItemStack itemStack, InteractionHand hand, boolean itemUseAtTargetAllowed, boolean itemUseAtOffsetAllowed, boolean messages) {
        ChunkPos chunkPos2;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        if (this.completelyDisabledItems.contains(itemStack.getItem())) {
            if (messages && entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor(player, hand == InteractionHand.MAIN_HAND ? this.ITEM_DISABLED_MAIN : this.ITEM_DISABLED_OFF));
            }
            return true;
        }
        if (entity != null && this.hasActiveFullPass(entity)) {
            return false;
        }
        if (!this.isItemUseRestricted(itemStack)) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (hand == null) {
                Object object = living.getItemInHand(InteractionHand.MAIN_HAND) == itemStack ? InteractionHand.MAIN_HAND : (hand = living.getItemInHand(InteractionHand.OFF_HAND) == itemStack ? InteractionHand.OFF_HAND : null);
            }
            if (this.additionalBannedItems.contains(itemStack.getItem()) && this.onItemRightClick(serverData, hand, itemStack, pos, living, false)) {
                if (messages && living instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)living;
                    player.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor(player, hand == null ? this.CANT_APPLY_ITEM_ANY : (hand == InteractionHand.MAIN_HAND ? this.CANT_APPLY_ITEM_THIS_CLOSE_MAIN : this.CANT_APPLY_ITEM_THIS_CLOSE_OFF)));
                }
                return true;
            }
        }
        BlockPos pos2 = null;
        if (direction != null) {
            pos2 = pos.offset(direction.getUnitVec3i());
        }
        if (itemUseAtTargetAllowed && pos2 == null) {
            return false;
        }
        if (entity instanceof Player && this.isAllowedStaticFakePlayerAction(serverData, (Player)entity, pos, pos2)) {
            return false;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        if (!itemUseAtTargetAllowed && this.applyItemAccessCheck(serverData, chunkPos, entity, world, itemStack) || !itemUseAtOffsetAllowed && pos2 != null && !(chunkPos2 = new ChunkPos(pos2)).equals((Object)chunkPos) && this.applyItemAccessCheck(serverData, chunkPos2, entity, world, itemStack)) {
            if (messages && entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor(player, hand == null ? this.CANT_APPLY_ITEM_ANY : (hand == InteractionHand.MAIN_HAND ? this.CANT_APPLY_ITEM_MAIN : this.CANT_APPLY_ITEM_OFF)));
            }
            return true;
        }
        return false;
    }

    private boolean applyItemAccessCheck(IServerData<CM, ?> serverData, ChunkPos chunkPos, Entity entity, ServerLevel world, ItemStack itemStack) {
        Entity accessor;
        UUID accessorId;
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerChunkClaim claim = this.claimsManager.get(world.dimension().location(), chunkPos);
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(world, accessorId);
        } else {
            accessor = (Entity)accessorInfo;
            accessorId = accessor.getUUID();
        }
        return this.checkProtectionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_USE, config, accessor, accessorId) && !this.hasChunkAccess(config, accessor, accessorId) && !this.isOptionalItemException(serverData, accessor, accessorId, itemStack, world, chunkPos);
    }

    private boolean isOptionalItemException(IServerData<CM, ?> serverData, Entity accessor, UUID accessorId, ItemStack itemStack, ServerLevel world, ChunkPos chunkPos) {
        IPlayerChunkClaim claim = this.claimsManager.get(world.dimension().location(), chunkPos);
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        int exceptionAccessLevel = this.getExceptionAccessLevel(config, accessor, accessorId);
        for (ChunkProtectionExceptionGroup<Item> group : this.itemExceptionGroups.values()) {
            if (exceptionAccessLevel > config.getEffective(group.getPlayerConfigOption()) || !group.contains(itemStack.getItem())) continue;
            return true;
        }
        return false;
    }

    private boolean isOnChunkEdge(BlockPos pos) {
        int chunkRelativeX = pos.getX() & 0xF;
        int chunkRelativeZ = pos.getZ() & 0xF;
        return this.isOnChunkEdge(chunkRelativeX, chunkRelativeZ);
    }

    private boolean isOnChunkEdge(int chunkRelativeX, int chunkRelativeZ) {
        return chunkRelativeX == 0 || chunkRelativeX == 15 || chunkRelativeZ == 0 || chunkRelativeZ == 15;
    }

    private boolean isProtectionEnabled(IPlayerConfig config, IPlayerConfigOptionSpecAPI<?> option) {
        Integer integ;
        Boolean bool;
        Object value = config.getEffective(option);
        return value instanceof Boolean && (bool = (Boolean)value) != false || value instanceof Integer && (integ = (Integer)value) > 0;
    }

    private int compareProtectionLevels(IPlayerConfig config1, IPlayerConfig config2, IPlayerConfigOptionSpecAPI<? extends Comparable<?>> option, boolean isExceptionOption) {
        Comparable<?> value1 = config1.getEffective(option);
        Comparable<?> value2 = config2.getEffective(option);
        if (value1 instanceof Boolean) {
            Boolean bool1 = (Boolean)value1;
            int result = bool1.compareTo((Boolean)value2);
            return isExceptionOption ? -result : result;
        }
        Integer int1 = (Integer)value1;
        Integer int2 = (Integer)value2;
        if (int1.equals(int2)) {
            return 0;
        }
        if (!isExceptionOption) {
            if (int1 > 0 && int2 <= 0) {
                return 1;
            }
            if (int2 > 0 && int1 <= 0) {
                return -1;
            }
        }
        return int2.compareTo(int1);
    }

    private boolean hitsAnotherClaim(IServerData<CM, ?> serverData, IPlayerChunkClaim fromClaim, IPlayerChunkClaim toClaim, IPlayerConfigOptionSpecAPI<? extends Comparable<?>> optionSpec, boolean withBuildCheck) {
        if (toClaim == null || fromClaim == toClaim || fromClaim != null && fromClaim.isSameClaimType(toClaim)) {
            return false;
        }
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig toClaimConfig = this.getClaimConfig(playerConfigs, toClaim);
        if (!toClaimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue() || optionSpec != null && !this.isProtectionEnabled(toClaimConfig, optionSpec)) {
            return false;
        }
        if (fromClaim != null && fromClaim.getPlayerId().equals(toClaim.getPlayerId())) {
            IPlayerConfig fromClaimConfig = this.getClaimConfig(playerConfigs, fromClaim);
            if (!fromClaimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue() || optionSpec != null && this.compareProtectionLevels(fromClaimConfig, toClaimConfig, optionSpec, false) < 0) {
                return true;
            }
            if (withBuildCheck) {
                int toClaimItemUseProt = toClaimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_USE);
                if (toClaimItemUseProt == 0 && toClaimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_PLAYERS) == 0) {
                    return false;
                }
                if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_PLAYERS, false) < 0) {
                    return true;
                }
                if (toClaimItemUseProt > 0) {
                    if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_USE, false) < 0) {
                        return true;
                    }
                    if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NEIGHBOR_CHUNKS_ITEM_USE, false) < 0) {
                        return true;
                    }
                }
                if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_MOBS, false) < 0) {
                    return true;
                }
                if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_OTHER, false) < 0) {
                    return true;
                }
                if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PISTON_BARRIER, false) < 0) {
                    return true;
                }
                for (ChunkProtectionExceptionGroup<Item> chunkProtectionExceptionGroup : this.itemExceptionGroups.values()) {
                    if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, chunkProtectionExceptionGroup.getPlayerConfigOption(), true) >= 0) continue;
                    return true;
                }
                for (ChunkProtectionExceptionGroup<Item> chunkProtectionExceptionGroup : this.entityBarrierGroups.values()) {
                    if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, chunkProtectionExceptionGroup.getPlayerConfigOption(), false) >= 0) continue;
                    return true;
                }
                for (ChunkProtectionExceptionGroup<Item> chunkProtectionExceptionGroup : this.blockExceptionGroups.values()) {
                    if (chunkProtectionExceptionGroup.getType() != ChunkProtectionExceptionType.INTERACTION && chunkProtectionExceptionGroup.getType() != ChunkProtectionExceptionType.ANY_ITEM_INTERACTION || this.compareProtectionLevels(fromClaimConfig, toClaimConfig, chunkProtectionExceptionGroup.getPlayerConfigOption(), true) >= 0) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean hitsAnotherClaim(IServerData<CM, ?> serverData, Level world, BlockPos from, BlockPos to, IPlayerConfigOptionSpecAPI<? extends Comparable<?>> optionSpec, boolean withBuildCheck) {
        int fromChunkX = from.getX() >> 4;
        int fromChunkZ = from.getZ() >> 4;
        int toChunkX = to.getX() >> 4;
        int toChunkZ = to.getZ() >> 4;
        if (fromChunkX == toChunkX && fromChunkZ == toChunkZ) {
            return false;
        }
        IPlayerChunkClaim toClaim = this.claimsManager.get(world.dimension().location(), toChunkX, toChunkZ);
        IPlayerChunkClaim fromClaim = this.claimsManager.get(world.dimension().location(), fromChunkX, fromChunkZ);
        return this.hitsAnotherClaim(serverData, fromClaim, toClaim, optionSpec, withBuildCheck);
    }

    public boolean onFluidSpread(IServerData<CM, ?> serverData, ServerLevel world, BlockPos from, BlockPos to) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        return this.isOnChunkEdge(from) && this.hitsAnotherClaim(serverData, (Level)world, from, to, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FLUID_BARRIER, true);
    }

    public boolean onDispenseFrom(IServerData<CM, ?> serverData, ServerLevel serverLevel, BlockPos from) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        if (!this.isOnChunkEdge(from)) {
            return false;
        }
        BlockState blockState = serverLevel.getBlockState(from);
        Direction direction = (Direction)blockState.getValue((Property)DirectionalBlock.FACING);
        BlockPos to = from.relative(direction);
        return this.isOnChunkEdge(from) && this.hitsAnotherClaim(serverData, (Level)serverLevel, from, to, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_DISPENSER_BARRIER, true);
    }

    private boolean shouldStopPistonPush(IServerData<CM, ?> serverData, ServerLevel world, BlockPos pushPos, int pistonChunkX, int pistonChunkZ, IPlayerChunkClaim pistonClaim) {
        int pushChunkX = pushPos.getX() >> 4;
        int pushChunkZ = pushPos.getZ() >> 4;
        if (pushChunkX == pistonChunkX && pushChunkZ == pistonChunkZ) {
            return false;
        }
        IPlayerChunkClaim pushClaim = this.claimsManager.get(world.dimension().location(), pushChunkX, pushChunkZ);
        return this.hitsAnotherClaim(serverData, pistonClaim, pushClaim, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PISTON_BARRIER, true);
    }

    public boolean onPistonPush(IServerData<CM, ?> serverData, ServerLevel world, List<BlockPos> toPush, List<BlockPos> toDestroy, BlockPos pistonPos, Direction direction, boolean extending) {
        Direction actualDirection;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerChunkClaim pistonClaim = this.claimsManager.get(world.dimension().location(), pistonPos);
        int pistonChunkX = pistonPos.getX() >> 4;
        int pistonChunkZ = pistonPos.getZ() >> 4;
        Direction direction2 = actualDirection = extending ? direction : direction.getOpposite();
        if (toPush.isEmpty() && toDestroy.isEmpty()) {
            BlockPos pushPos = pistonPos.relative(direction);
            if (this.shouldStopPistonPush(serverData, world, pushPos, pistonChunkX, pistonChunkZ, pistonClaim)) {
                return true;
            }
            return this.shouldStopPistonPush(serverData, world, pushPos.relative(actualDirection), pistonChunkX, pistonChunkZ, pistonClaim);
        }
        Iterator posIterator = Iterators.concat(toPush.iterator(), toDestroy.iterator());
        while (posIterator.hasNext()) {
            BlockPos pushPos = (BlockPos)posIterator.next();
            if (this.shouldStopPistonPush(serverData, world, pushPos, pistonChunkX, pistonChunkZ, pistonClaim)) {
                return true;
            }
            BlockPos pushedToPos = pushPos.relative(actualDirection);
            if (!this.shouldStopPistonPush(serverData, world, pushedToPos, pistonChunkX, pistonChunkZ, pistonClaim)) continue;
            return true;
        }
        return false;
    }

    private Object getAccessorInfo(Entity entity) {
        Object result = entity instanceof Projectile ? ((Projectile)entity).getOwner() : (entity instanceof Vex ? ((Vex)entity).getOwner() : (entity instanceof EvokerFangs ? ((EvokerFangs)entity).getOwner() : (entity instanceof AbstractBoat ? entity.getControllingPassenger() : this.entityHelper.getOwnerId(entity))));
        return result == null ? entity : result;
    }

    public void onEntitiesPushBlock(IServerData<CM, ?> serverData, ServerLevel world, BlockPos pos, Block block, List<? extends Entity> entities) {
        IPlayerConfigOptionSpecAPI<Integer> blockSpecificOption;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return;
        }
        Iterator<? extends Entity> iterator = entities.iterator();
        IPlayerChunkClaim claim = this.claimsManager.get(world.dimension().location(), new ChunkPos(pos));
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        if (!config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
            return;
        }
        IPlayerConfigOptionSpecAPI<Integer> iPlayerConfigOptionSpecAPI = block instanceof ButtonBlock ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BUTTONS_FROM_PROJECTILES : (blockSpecificOption = block instanceof TargetBlock ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_TARGETS_FROM_PROJECTILES : null);
        if (blockSpecificOption != null && config.getEffective(blockSpecificOption) <= 0) {
            return;
        }
        boolean everyoneExceptAccessHavers = blockSpecificOption != null && config.getEffective(blockSpecificOption) == 1;
        HashMap<UUID, HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>> cachedAccessorOptionResults = null;
        boolean isWeighted = block instanceof WeightedPressurePlateBlock;
        boolean isTripwire = block instanceof TripWireBlock;
        while (iterator.hasNext()) {
            boolean protect;
            Boolean cachedResult;
            HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean> resultsCachedForAccessor;
            Entity accessor;
            UUID accessorId;
            Entity e = iterator.next();
            if (blockSpecificOption == null && !isWeighted && e.isIgnoringBlockTriggers()) continue;
            Object accessorInfo = this.getAccessorInfo(e);
            if (accessorInfo instanceof UUID) {
                accessorId = (UUID)accessorInfo;
                accessor = this.getEntityById(world, accessorId);
            } else {
                accessor = (Entity)accessorInfo;
                accessorId = accessor.getUUID();
            }
            IPlayerConfigOptionSpecAPI<Integer> entitySpecificOption = blockSpecificOption;
            if (entitySpecificOption == null) {
                if (isTripwire) {
                    entitySpecificOption = e instanceof Player ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_TRIPWIRE_FROM_PLAYERS : (e instanceof LivingEntity ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_TRIPWIRE_FROM_MOBS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_TRIPWIRE_FROM_OTHER);
                } else {
                    IPlayerConfigOptionSpecAPI<Integer> iPlayerConfigOptionSpecAPI2 = e instanceof Player ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLATES_FROM_PLAYERS : (entitySpecificOption = e instanceof LivingEntity ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLATES_FROM_MOBS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLATES_FROM_OTHER);
                }
            }
            if (cachedAccessorOptionResults != null && (resultsCachedForAccessor = (HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>)cachedAccessorOptionResults.get(accessorId)) != null && (cachedResult = (Boolean)resultsCachedForAccessor.get(entitySpecificOption)) != null) {
                if (!cachedResult.booleanValue()) continue;
                iterator.remove();
                continue;
            }
            boolean bl = protect = (everyoneExceptAccessHavers || this.checkProtectionLeveledOption(entitySpecificOption, config, accessor, accessorId)) && !this.hasChunkAccess(config, accessor, accessorId);
            if (!protect && (blockSpecificOption == PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BUTTONS_FROM_PROJECTILES || blockSpecificOption == null && !isWeighted)) break;
            if (iterator.hasNext()) {
                if (cachedAccessorOptionResults == null) {
                    cachedAccessorOptionResults = new HashMap<UUID, HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>>();
                }
                if ((resultsCachedForAccessor = (Map)cachedAccessorOptionResults.get(accessorId)) == null) {
                    resultsCachedForAccessor = new HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>();
                    cachedAccessorOptionResults.put(accessorId, resultsCachedForAccessor);
                }
                resultsCachedForAccessor.put(entitySpecificOption, protect);
            }
            if (!protect) continue;
            iterator.remove();
        }
    }

    public void onEntitiesCollideWithEntity(IServerData<CM, ?> serverData, Entity entity, List<? extends Entity> collidingEntities) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return;
        }
        Level level = entity.level();
        ServerLevel serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(level.dimension().location(), entity.chunkPosition());
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        if (!config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
            return;
        }
        if (config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_PLAYERS) == 0 && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_MOBS) == 0 && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_OTHER) == 0) {
            return;
        }
        HashMap<UUID, HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>> cachedAccessorOptionResults = null;
        Iterator<? extends Entity> iterator = collidingEntities.iterator();
        boolean multipleCollisionsMatter = false;
        while (iterator.hasNext()) {
            boolean protect;
            Boolean cachedResult;
            HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean> accessorCache;
            Entity accessor;
            UUID accessorId;
            Entity collidingEntity = iterator.next();
            Object accessorInfo = this.getAccessorInfo(collidingEntity);
            if (accessorInfo instanceof UUID) {
                accessorId = (UUID)accessorInfo;
                accessor = this.getEntityById(serverLevel, accessorId);
            } else {
                accessor = (Entity)accessorInfo;
                accessorId = accessor.getUUID();
            }
            IPlayerConfigOptionSpecAPI<Integer> option = this.getUsedEntityProtectionOption(config, collidingEntity, accessor);
            if (cachedAccessorOptionResults != null && (accessorCache = (HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>)cachedAccessorOptionResults.get(accessorId)) != null && (cachedResult = (Boolean)accessorCache.get(option)) != null) {
                if (!cachedResult.booleanValue()) continue;
                iterator.remove();
                continue;
            }
            boolean bl = protect = this.checkProtectionLeveledOption(option, config, accessor, accessorId) && !this.hasChunkAccess(config, accessor, accessorId);
            if (!protect && !multipleCollisionsMatter) break;
            if (iterator.hasNext()) {
                if (cachedAccessorOptionResults == null) {
                    cachedAccessorOptionResults = new HashMap<UUID, HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>>();
                }
                if ((accessorCache = (Map)cachedAccessorOptionResults.get(accessorId)) == null) {
                    accessorCache = new HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>();
                    cachedAccessorOptionResults.put(accessorId, accessorCache);
                }
                accessorCache.put(option, protect);
            }
            if (!protect) continue;
            iterator.remove();
        }
    }

    public void onEntityAffectsEntities(IServerData<CM, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, Entity entity, List<Entity> targets) {
        double randomDrop;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return;
        }
        double d = randomDrop = entity instanceof AbstractBoat && (Boolean)ServerConfig.CONFIG.reducedBoatEntityCollisions.get() != false ? 0.9 : 0.0;
        if (randomDrop > 0.0 && Math.random() < randomDrop) {
            targets.clear();
            return;
        }
        Iterator<Entity> iterator = targets.iterator();
        while (iterator.hasNext()) {
            Entity target = iterator.next();
            if (!this.onEntityInteraction(serverData, null, entity, target, null, null, true, false, true)) continue;
            iterator.remove();
        }
    }

    public boolean onEntityPushed(IServerData<CM, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, Entity target, MoverType moverType) {
        if (moverType != MoverType.SHULKER) {
            return false;
        }
        return this.onEntityInteraction(serverData, null, null, target, null, null, true, false, true);
    }

    public boolean onNetherPortal(IServerData<CM, ?> serverData, Entity entity, ServerLevel world, BlockPos pos) {
        Entity accessor;
        UUID accessorId;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(world.dimension().location(), new ChunkPos(pos));
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        if (!config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
            return false;
        }
        if (config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NETHER_PORTALS_PLAYERS) == 0 && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NETHER_PORTALS_MOBS) == 0 && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NETHER_PORTALS_OTHER) == 0) {
            return false;
        }
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(world, accessorId);
        } else {
            accessor = (Entity)accessorInfo;
            accessorId = accessor.getUUID();
        }
        IPlayerConfigOptionSpecAPI<Integer> option = entity instanceof Player ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NETHER_PORTALS_PLAYERS : (entity instanceof LivingEntity ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NETHER_PORTALS_MOBS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NETHER_PORTALS_OTHER);
        return this.checkProtectionLeveledOption(option, config, accessor, accessorId) && !this.hasChunkAccess(config, accessor, accessorId);
    }

    public boolean onRaidSpawn(IServerData<CM, ?> serverData, ServerLevel world, BlockPos pos) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(world.dimension().location(), new ChunkPos(pos));
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        return config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS) != false && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_RAIDS) != false;
    }

    public boolean onMobSpawn(IServerData<CM, ?> serverData, Entity entity, double x, double y, double z, EntitySpawnReason spawnReason) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(entity.level().dimension().location(), new ChunkPos(BlockPos.containing((double)x, (double)y, (double)z)));
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        if (!config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
            return false;
        }
        boolean hostile = this.entityHelper.isHostile(entity);
        IPlayerConfigOptionSpecAPI<Boolean> option = spawnReason == EntitySpawnReason.SPAWNER ? (hostile ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_HOSTILE_SPAWNERS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FRIENDLY_SPAWNERS) : (hostile ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_HOSTILE_NATURAL_SPAWN : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FRIENDLY_NATURAL_SPAWN);
        return config.getEffective(option);
    }

    public boolean onProjectileHitSpawnedEntity(IServerData<CM, ?> serverData, Entity projectile, Entity entity) {
        Entity accessor;
        UUID accessorId;
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (this.hasActiveFullPass(projectile)) {
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(entity.level().dimension().location(), entity.chunkPosition());
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        Object accessorInfo = this.getAccessorInfo(projectile);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(ServerLevelHelper.getServerLevel(entity.level()), accessorId);
        } else {
            accessor = (Entity)accessorInfo;
            accessorId = accessor.getUUID();
        }
        if (this.hasChunkAccess(config, accessor, accessorId)) {
            return false;
        }
        IPlayerConfigOptionSpecAPI<Integer> option = this.entityHelper.isHostile(entity) ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PROJECTILE_HIT_HOSTILE_SPAWN : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PROJECTILE_HIT_FRIENDLY_SPAWN;
        return this.checkProtectionLeveledOption(option, config, accessor, accessorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onProjectileHitSpawnedEntity(@Nonnull Entity projectile, @Nonnull Entity entity) {
        this.fullPassesPaused = true;
        try {
            boolean bl = this.onProjectileHitSpawnedEntity(this.serverData, projectile, entity);
            return bl;
        }
        finally {
            this.fullPassesPaused = false;
        }
    }

    public boolean onItemAddedToWorld(IServerData<CM, ?> serverData, ItemEntity itemEntity) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        UUID throwerId = ServerCore.getItemEntityThrower(itemEntity);
        if (throwerId == null) {
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(itemEntity.level().dimension().location(), itemEntity.chunkPosition());
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        if (!config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
            return false;
        }
        Entity thrower = this.getEntityById(ServerLevelHelper.getServerLevel(itemEntity.level()), throwerId);
        Entity result = this.shouldPreventToss(config, itemEntity, thrower, throwerId, null);
        if (result != itemEntity) {
            ItemStack itemStack;
            Player player;
            if (result instanceof Player && !(player = (Player)result).isCreative() && !player.addItem(itemStack = itemEntity.getItem()) && thrower != player && !thrower.chunkPosition().equals((Object)player.chunkPosition())) {
                player.drop(itemStack, true);
            }
            return true;
        }
        return false;
    }

    private Entity shouldPreventToss(IPlayerConfig config, ItemEntity itemEntity, Entity thrower, UUID throwerId, UUID throwerAccessorId) {
        Entity usedOptionBase;
        UUID accessorId;
        if (throwerId == null) {
            return itemEntity;
        }
        Entity accessor = null;
        if (throwerAccessorId == null) {
            if (thrower != null) {
                Object accessorInfo = this.getAccessorInfo(thrower);
                if (accessorInfo instanceof UUID) {
                    accessorId = (UUID)accessorInfo;
                    accessor = this.getEntityById(ServerLevelHelper.getServerLevel(itemEntity.level()), accessorId);
                } else {
                    accessor = (Entity)accessorInfo;
                    accessorId = accessor.getUUID();
                }
            } else {
                accessorId = throwerId;
            }
        } else {
            accessorId = throwerAccessorId;
            accessor = this.getEntityById(ServerLevelHelper.getServerLevel(itemEntity.level()), accessorId);
        }
        Entity entity = usedOptionBase = config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_TOSS_REDIRECT) == false ? thrower : accessor;
        IPlayerConfigOptionSpecAPI<Integer> option = usedOptionBase != null ? (!(usedOptionBase instanceof LivingEntity) ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_TOSS_OTHER : (usedOptionBase instanceof Player ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_TOSS_PLAYERS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_TOSS_MOBS)) : this.getToughestProtectionLevelOption(config, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_TOSS_PLAYERS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_TOSS_MOBS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_TOSS_OTHER);
        if (this.checkProtectionLeveledOption(option, config, accessor, accessorId) && !this.hasChunkAccess(config, accessor, accessorId)) {
            return accessor;
        }
        return itemEntity;
    }

    private boolean hasAnEnabledOption(IPlayerConfig config, IPlayerConfigOptionSpecAPI<Boolean> option1, IPlayerConfigOptionSpecAPI<Boolean> option2, IPlayerConfigOptionSpecAPI<Boolean> option3) {
        return config.getEffective(option1) != false || config.getEffective(option2) != false || config.getEffective(option3) != false;
    }

    private IPlayerConfigOptionSpecAPI<Integer> getToughestProtectionLevelOption(IPlayerConfig config, IPlayerConfigOptionSpecAPI<Integer> option1, IPlayerConfigOptionSpecAPI<Integer> option2, IPlayerConfigOptionSpecAPI<Integer> option3) {
        int toughestProtectionLevel = config.getEffective(option1);
        IPlayerConfigOptionSpecAPI<Integer> toughestOption = option1;
        int protectionLevel = config.getEffective(option2);
        if (protectionLevel != 0 && (toughestProtectionLevel == 0 || protectionLevel < toughestProtectionLevel)) {
            toughestProtectionLevel = protectionLevel;
            toughestOption = option2;
        }
        if (option3 != null && (protectionLevel = config.getEffective(option3).intValue()) != 0 && (toughestProtectionLevel == 0 || protectionLevel < toughestProtectionLevel)) {
            return option3;
        }
        return toughestOption;
    }

    public boolean onLivingLootEntity(IServerData<CM, ?> serverData, LivingEntity livingEntity, Entity lootEntity, DamageSource source) {
        Player player;
        Entity accessor;
        UUID accessorId;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        boolean noKiller = source.getEntity() == null || source.getEntity() == livingEntity;
        Object accessorInfo = this.getAccessorInfo((Entity)(noKiller ? livingEntity : source.getEntity()));
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(ServerLevelHelper.getServerLevel(lootEntity.level()), accessorId);
        } else {
            accessor = (Entity)accessorInfo;
            accessorId = accessor.getUUID();
        }
        if (lootEntity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)lootEntity;
            itemEntity.setThrower((Entity)livingEntity);
        }
        ServerCore.setLootOwner(lootEntity, accessorId);
        if (livingEntity instanceof Player) {
            ServerCore.setDeadPlayer(lootEntity, livingEntity.getUUID());
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(lootEntity.level().dimension().location(), lootEntity.chunkPosition());
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        if (!config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
            return false;
        }
        return this.shouldStopMobLoot(config, accessor, accessorId) && (!(accessor instanceof Player) || !this.isAllowedStaticFakePlayerAction(serverData, player = (Player)accessor, lootEntity.blockPosition()));
    }

    private boolean shouldStopMobLoot(IPlayerConfig config, Entity accessor, UUID accessorId) {
        return !this.hasChunkAccess(config, accessor, accessorId) && this.checkProtectionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_MOB_LOOT, config, accessor, accessorId);
    }

    public boolean onEntityPickup(IServerData<CM, ?> serverData, Entity entity, Entity pickedEntity, UUID pickedEntityThrowerId, UUID pickedEntityOwnerId, Map<Entity, Set<ChunkPos>> cantPickupCache, TriFunction<IPlayerConfig, Entity, Entity, IPlayerConfigOptionSpecAPI<Integer>> protectionOptionGetter) {
        IPlayerChunkClaim entityPosClaim;
        IPlayerConfig entityPosConfig;
        ChunkPos entityChunkPos;
        Entity accessor;
        UUID accessorId;
        Entity deadPlayer;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        if (entity.getUUID().equals(pickedEntityThrowerId) || entity.getUUID().equals(pickedEntityOwnerId) || entity.getUUID().equals(ServerCore.getLootOwner(pickedEntity)) || this.hasActiveFullPass(entity)) {
            return false;
        }
        ChunkPos chunkPos = pickedEntity.chunkPosition();
        Set<ChunkPos> cantPickupCached = cantPickupCache.get(entity);
        if (cantPickupCached != null && cantPickupCached.contains(chunkPos)) {
            return true;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(pickedEntity.level().dimension().location(), chunkPos);
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        UUID deadPlayerId = ServerCore.getDeadPlayer(pickedEntity);
        if (deadPlayerId != null && this.checkExceptionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYER_DEATH_LOOT, config, deadPlayer = this.getEntityById(ServerLevelHelper.getServerLevel(pickedEntity.level()), deadPlayerId), deadPlayerId)) {
            return true;
        }
        boolean shouldPrevent = false;
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(ServerLevelHelper.getServerLevel(entity.level()), accessorId);
        } else {
            accessor = (Entity)accessorInfo;
            accessorId = accessor.getUUID();
        }
        if (this.isAllowedToGrief(entity, accessor, accessorId, config, true, this.entitiesAllowedToGriefDroppedItems, null, this.droppedItemAccessEntityGroups)) {
            return false;
        }
        if (config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue() && !this.hasChunkAccess(config, accessor, accessorId)) {
            IPlayerConfigOptionSpecAPI usedOption = (IPlayerConfigOptionSpecAPI)protectionOptionGetter.apply((Object)config, (Object)entity, (Object)accessor);
            shouldPrevent = this.checkProtectionLeveledOption(usedOption, config, accessor, accessorId);
        }
        if (!(shouldPrevent || entity instanceof Player || chunkPos.equals((Object)(entityChunkPos = entity.chunkPosition())) || (entityPosConfig = this.getClaimConfig(playerConfigs, entityPosClaim = this.claimsManager.get(pickedEntity.level().dimension().location(), entityChunkPos))) == config)) {
            shouldPrevent = this.shouldPreventEntityChunkEntry(serverData, playerConfigs, entityPosClaim, claim, entityPosConfig, config, pickedEntity, null, null);
        }
        if (shouldPrevent) {
            if (cantPickupCached == null) {
                cantPickupCached = new HashSet<ChunkPos>();
                cantPickupCache.put(entity, cantPickupCached);
            }
            cantPickupCached.add(chunkPos);
        }
        return shouldPrevent;
    }

    public boolean onItemPickup(IServerData<CM, ?> serverData, Entity entity, ItemEntity itemEntity) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        if (entity.getUUID().equals(ServerCore.getThrowerAccessor(itemEntity))) {
            return false;
        }
        return this.onEntityPickup(serverData, entity, (Entity)itemEntity, ServerCore.getItemEntityThrower(itemEntity), ServerCore.getItemEntityOwner(itemEntity), this.cantPickupItemsInTickCache, this.usedDroppedItemProtectionOptionGetter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onItemPickup(@Nonnull Entity entity, @Nonnull ItemEntity itemEntity) {
        try {
            this.fullPassesPaused = true;
            boolean bl = this.onItemPickup(this.serverData, entity, itemEntity);
            return bl;
        }
        finally {
            this.fullPassesPaused = false;
        }
    }

    private IPlayerConfigOptionSpecAPI<Integer> getUsedDroppedItemProtectionOption(IPlayerConfig config, Entity entity, Entity accessor) {
        Entity usedOptionBase;
        Entity entity2 = usedOptionBase = !(entity instanceof Player) && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_REDIRECT) != false ? accessor : entity;
        if (usedOptionBase == null) {
            return this.getToughestProtectionLevelOption(config, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_PLAYERS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_MOBS, null);
        }
        return usedOptionBase instanceof Player ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_PLAYERS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_MOBS;
    }

    public boolean onEntityMerge(IServerData<CM, ?> serverData, Entity first, UUID firstThrower, UUID firstOwner, Entity second, UUID secondThrower, UUID secondOwner, IPlayerConfigOptionSpecAPI<Integer> playerOption, IPlayerConfigOptionSpecAPI<Integer> mobOption, IPlayerConfigOptionSpecAPI<Boolean> redirectOption) {
        boolean secondItemProtectionRedirect;
        boolean firstItemProtectionRedirect;
        int secondItemMobsProtection;
        int secondItemPlayerProtection;
        ChunkPos secondChunkPos;
        int firstItemMobsProtection;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        ChunkPos firstChunkPos = first.chunkPosition();
        IPlayerChunkClaim firstClaim = this.claimsManager.get(first.level().dimension().location(), firstChunkPos);
        IPlayerConfig firstConfig = this.getClaimConfig(playerConfigs, firstClaim);
        boolean differentThrower = !Objects.equals(firstThrower, secondThrower);
        boolean differentOwner = !Objects.equals(firstOwner, secondOwner);
        boolean differentLootOwner = !Objects.equals(ServerCore.getLootOwner(first), ServerCore.getLootOwner(second));
        boolean firstProtected = firstConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS);
        int firstItemPlayerProtection = !firstProtected ? 0 : firstConfig.getEffective(playerOption);
        int n = firstItemMobsProtection = !firstProtected || mobOption == null ? 0 : firstConfig.getEffective(mobOption);
        if (differentThrower || differentOwner || differentLootOwner) {
            Entity secondDeadPlayer;
            Entity firstDeadPlayer;
            if (firstItemPlayerProtection > 0 || firstItemMobsProtection > 0) {
                return true;
            }
            UUID firstDeadPlayerId = ServerCore.getDeadPlayer(first);
            if (firstDeadPlayerId != null && this.checkExceptionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYER_DEATH_LOOT, firstConfig, firstDeadPlayer = this.getEntityById(ServerLevelHelper.getServerLevel(first.level()), firstDeadPlayerId), firstDeadPlayerId)) {
                return true;
            }
            UUID secondDeadPlayerId = ServerCore.getDeadPlayer(second);
            if (secondDeadPlayerId != null && this.checkExceptionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYER_DEATH_LOOT, firstConfig, secondDeadPlayer = this.getEntityById(ServerLevelHelper.getServerLevel(first.level()), secondDeadPlayerId), secondDeadPlayerId)) {
                return true;
            }
        }
        if ((secondChunkPos = second.chunkPosition()).equals((Object)firstChunkPos)) {
            return false;
        }
        IPlayerChunkClaim secondClaim = this.claimsManager.get(first.level().dimension().location(), secondChunkPos);
        if (firstClaim == secondClaim) {
            return false;
        }
        IPlayerConfig secondConfig = this.getClaimConfig(playerConfigs, secondClaim);
        if (firstConfig == secondConfig) {
            return false;
        }
        UUID firstClaimOwner = firstConfig.getPlayerId();
        UUID secondClaimOwner = secondConfig.getPlayerId();
        boolean sameClaimOwner = Objects.equals(firstClaimOwner, secondClaimOwner);
        boolean secondProtected = secondConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS);
        int n2 = secondItemPlayerProtection = !secondProtected ? 0 : secondConfig.getEffective(playerOption);
        if (firstItemPlayerProtection != secondItemPlayerProtection || !sameClaimOwner && secondItemPlayerProtection > 1) {
            return true;
        }
        int n3 = secondItemMobsProtection = !secondProtected || mobOption == null ? 0 : secondConfig.getEffective(mobOption);
        if (firstItemMobsProtection != secondItemMobsProtection || !sameClaimOwner && secondItemMobsProtection > 1) {
            return true;
        }
        if (firstItemPlayerProtection != firstItemMobsProtection && redirectOption != null && (firstItemProtectionRedirect = firstConfig.getEffective(redirectOption).booleanValue()) != (secondItemProtectionRedirect = secondConfig.getEffective(redirectOption).booleanValue())) {
            return true;
        }
        return this.shouldPreventEntityChunkEntry(serverData, playerConfigs, firstClaim, secondClaim, firstConfig, secondConfig, second, null, null);
    }

    public boolean onItemStackMerge(IServerData<CM, ?> serverData, ItemEntity first, ItemEntity second) {
        return this.onEntityMerge(serverData, (Entity)first, ServerCore.getItemEntityThrower(first), ServerCore.getItemEntityOwner(first), (Entity)second, ServerCore.getItemEntityThrower(second), ServerCore.getItemEntityOwner(second), PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_PLAYERS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_MOBS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_REDIRECT);
    }

    public boolean onExperiencePickup(IServerData<CM, ?> serverData, ExperienceOrb orb, Player player) {
        return this.onEntityPickup(serverData, (Entity)player, (Entity)orb, null, null, this.cantPickupXPInTickCache, this.usedExperienceOrbProtectionOptionGetter);
    }

    public boolean onExperienceMerge(IServerData<CM, ?> serverData, ExperienceOrb from, ExperienceOrb into) {
        return this.onEntityMerge(serverData, (Entity)into, null, null, (Entity)from, null, null, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_XP_PICKUP, null, null);
    }

    public boolean onProjectileEntityImpact(IServerData<CM, ?> serverData, Projectile projectile, EntityHitResult hitResult) {
        Entity entity;
        boolean shouldProtect = this.onEntityInteraction(serverData, projectile.getOwner(), (Entity)projectile, hitResult.getEntity(), null, null, false, false, false);
        if (shouldProtect && (entity = projectile.getOwner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor(player, ((ChunkProtection)serverData.getChunkProtection()).PROJECTILE_HIT_ENTITY));
        }
        return shouldProtect;
    }

    public boolean onProjectileBlockImpact(IServerData<CM, ?> serverData, Projectile projectile, BlockHitResult hitResult) {
        Entity entity;
        ServerLevel world = ServerLevelHelper.getServerLevel(projectile.level());
        if (world == null) {
            return false;
        }
        boolean shouldProtect = this.onBlockInteraction(serverData, null, (Entity)projectile, null, null, world, hitResult.getBlockPos(), null, false, false);
        if (!shouldProtect) {
            BlockPos offPos = hitResult.getBlockPos().offset(hitResult.getDirection().getUnitVec3i());
            shouldProtect = this.onBlockInteraction(serverData, null, (Entity)projectile, null, null, world, offPos, null, false, false);
        }
        if (shouldProtect && (entity = projectile.getOwner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor(player, this.PROJECTILE_HIT_BLOCK));
        }
        return shouldProtect;
    }

    public boolean onProjectileImpact(IServerData<CM, ?> serverData, Projectile projectile, HitResult hitResult) {
        boolean result = false;
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            result = this.onProjectileEntityImpact(serverData, projectile, entityHitResult);
        } else if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            result = this.onProjectileBlockImpact(serverData, projectile, blockHitResult);
        }
        if (result) {
            projectile.discard();
        }
        return result;
    }

    public void setThrowerAccessor(ItemEntity itemEntity) {
        Object accessorInfo;
        UUID throwerId = ServerCore.getItemEntityThrower(itemEntity);
        Entity thrower = this.getEntityById(ServerLevelHelper.getServerLevel(itemEntity.level()), throwerId);
        UUID accessorId = thrower != null ? ((accessorInfo = this.getAccessorInfo(thrower)) instanceof UUID ? (UUID)accessorInfo : ((Entity)accessorInfo).getUUID()) : throwerId;
        ServerCore.setThrowerAccessor(itemEntity, accessorId);
    }

    private Entity getEntityById(ServerLevel world, UUID id) {
        if (world == null) {
            return null;
        }
        ServerPlayer result = world.getServer().getPlayerList().getPlayer(id);
        return result != null ? result : world.getEntity(id);
    }

    private boolean onPosAffectedByAnotherPos(IServerData<CM, ?> serverData, IPlayerChunkClaim toClaim, IPlayerChunkClaim fromClaim, boolean affectsBlocks, boolean affectsEntities) {
        if (!this.hitsAnotherClaim(serverData, fromClaim, toClaim, null, true)) {
            return false;
        }
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig posClaimConfig = this.getClaimConfig(playerConfigs, toClaim);
        if (affectsBlocks && this.isProtectionEnabled(posClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_OTHER)) {
            return true;
        }
        return affectsEntities && this.isProtectionEnabled(posClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_OTHER);
    }

    private boolean onPosAffectedByAnotherPos(IServerData<CM, ?> serverData, ServerLevel world, IPlayerChunkClaim toClaim, int toChunkX, int toChunkZ, int fromChunkX, int fromChunkZ, boolean affectsBlocks, boolean affectsEntities) {
        if (toChunkX == fromChunkX && toChunkZ == fromChunkZ) {
            return false;
        }
        IPlayerChunkClaim anchorClaim = this.claimsManager.get(world.dimension().location(), fromChunkX, fromChunkZ);
        return this.onPosAffectedByAnotherPos(serverData, toClaim, anchorClaim, affectsBlocks, affectsEntities);
    }

    public boolean onPosAffectedByAnotherPos(IServerData<CM, ?> serverData, ServerLevel toWorld, int toChunkX, int toChunkZ, ServerLevel fromWorld, int fromChunkX, int fromChunkZ, boolean includeWilderness, boolean affectsBlocks, boolean affectsEntities) {
        if (toChunkX == fromChunkX && toChunkZ == fromChunkZ) {
            return false;
        }
        IPlayerChunkClaim toClaim = this.claimsManager.get(toWorld.dimension().location(), toChunkX, toChunkZ);
        if (!includeWilderness && toClaim == null) {
            return false;
        }
        IPlayerChunkClaim fromClaim = this.claimsManager.get(fromWorld.dimension().location(), fromChunkX, fromChunkZ);
        return this.onPosAffectedByAnotherPos(serverData, toClaim, fromClaim, affectsBlocks, affectsEntities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onPosAffectedByAnotherPos(@Nonnull ServerLevel toWorld, @Nonnull ChunkPos toChunk, @Nonnull ServerLevel fromWorld, @Nonnull ChunkPos fromChunk, boolean includeWilderness, boolean affectsBlocks, boolean affectsEntities) {
        try {
            this.fullPassesPaused = true;
            boolean bl = this.onPosAffectedByAnotherPos(this.serverData, toWorld, toChunk.x, toChunk.z, fromWorld, fromChunk.x, fromChunk.z, includeWilderness, affectsBlocks, affectsEntities);
            return bl;
        }
        finally {
            this.fullPassesPaused = false;
        }
    }

    private boolean onBlockBounds(IServerData<CM, ?> serverData, BlockPos from, BlockPos to, ServerPlayer player) {
        ServerLevel level = player.level();
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        int fromChunkX = from.getX() >> 4;
        int fromChunkZ = from.getZ() >> 4;
        int toChunkX = to.getX() >> 4;
        int toChunkZ = to.getZ() >> 4;
        int minChunkX = Math.min(fromChunkX, toChunkX);
        int minChunkZ = Math.min(fromChunkZ, toChunkZ);
        int maxChunkX = Math.max(fromChunkX, toChunkX);
        int maxChunkZ = Math.max(fromChunkZ, toChunkZ);
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                IPlayerChunkClaim claim = this.claimsManager.get(level.dimension().location(), chunkX, chunkZ);
                IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
                if (this.hasChunkAccess(config, (Entity)player, player.getUUID())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean onBlockBoundsFromAnchor(IServerData<CM, ?> serverData, ServerLevel level, BlockPos from, BlockPos to, BlockPos anchor) {
        IPlayerChunkClaim anchorClaim = this.claimsManager.get(level.dimension().location(), new ChunkPos(anchor));
        int fromChunkX = from.getX() >> 4;
        int fromChunkZ = from.getZ() >> 4;
        int toChunkX = to.getX() >> 4;
        int toChunkZ = to.getZ() >> 4;
        int minChunkX = Math.min(fromChunkX, toChunkX);
        int minChunkZ = Math.min(fromChunkZ, toChunkZ);
        int maxChunkX = Math.max(fromChunkX, toChunkX);
        int maxChunkZ = Math.max(fromChunkZ, toChunkZ);
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                IPlayerChunkClaim claim = this.claimsManager.get(level.dimension().location(), chunkX, chunkZ);
                if (!this.onPosAffectedByAnotherPos(serverData, claim, anchorClaim, true, true)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean onCreateMod(IServerData<CM, ?> serverData, ServerLevel world, int posChunkX, int posChunkZ, @Nullable BlockPos sourceOrAnchor, boolean checkNeighborBlocks, boolean affectsBlocks, boolean affectsEntities) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerChunkClaim posClaim = this.claimsManager.get(world.dimension().location(), posChunkX, posChunkZ);
        if (posClaim == null) {
            return false;
        }
        if (sourceOrAnchor == null) {
            return this.onPosAffectedByAnotherPos(serverData, posClaim, null, affectsBlocks, affectsEntities);
        }
        int anchorChunkRelativeX = sourceOrAnchor.getX() & 0xF;
        int anchorChunkRelativeZ = sourceOrAnchor.getZ() & 0xF;
        int anchorChunkX = sourceOrAnchor.getX() >> 4;
        int anchorChunkZ = sourceOrAnchor.getZ() >> 4;
        if (!checkNeighborBlocks || !this.isOnChunkEdge(sourceOrAnchor)) {
            return this.onPosAffectedByAnotherPos(serverData, world, posClaim, posChunkX, posChunkZ, anchorChunkX, anchorChunkZ, affectsBlocks, affectsEntities);
        }
        int fromChunkOffX = anchorChunkRelativeX == 0 ? -1 : 0;
        int toChunkOffX = anchorChunkRelativeX == 15 ? 1 : 0;
        int fromChunkOffZ = anchorChunkRelativeZ == 0 ? -1 : 0;
        int toChunkOffZ = anchorChunkRelativeZ == 15 ? 1 : 0;
        for (int offX = fromChunkOffX; offX <= toChunkOffX; ++offX) {
            for (int offZ = fromChunkOffZ; offZ <= toChunkOffZ; ++offZ) {
                int effectiveAnchorChunkX = anchorChunkX + offX;
                int effectiveAnchorChunkZ = anchorChunkZ + offZ;
                if (!this.onPosAffectedByAnotherPos(serverData, world, posClaim, posChunkX, posChunkZ, effectiveAnchorChunkX, effectiveAnchorChunkZ, affectsBlocks, affectsEntities)) continue;
                return true;
            }
        }
        return false;
    }

    public <E> boolean onCreateModAffectPositionedObjects(IServerData<CM, ?> serverData, ServerLevel world, List<E> objects, Function<E, ChunkPos> positionGetter, BlockPos contraptionAnchor, boolean checkNeighborBlocks, boolean removeInvalid, boolean affectsBlocks, boolean affectsEntities) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        Iterator<E> objectIterator = objects.iterator();
        if (!objectIterator.hasNext()) {
            return false;
        }
        HashMap<ChunkPos, Boolean> chunkCache = new HashMap<ChunkPos, Boolean>();
        boolean result = false;
        while (objectIterator.hasNext()) {
            E object = objectIterator.next();
            ChunkPos objectChunkPos = positionGetter.apply(object);
            Boolean cachedValue = (Boolean)chunkCache.get(objectChunkPos);
            if (cachedValue != null) {
                if (!cachedValue.booleanValue()) continue;
                objectIterator.remove();
                continue;
            }
            boolean shouldProtect = this.onCreateMod(serverData, world, objectChunkPos.x, objectChunkPos.z, contraptionAnchor, checkNeighborBlocks, affectsBlocks, affectsEntities);
            if (shouldProtect) {
                result = true;
                if (!removeInvalid) break;
                objectIterator.remove();
            }
            chunkCache.put(objectChunkPos, shouldProtect);
        }
        return result;
    }

    public boolean onCreateGlueSelection(IServerData<CM, ?> serverData, BlockPos from, BlockPos to, ServerPlayer player) {
        if (this.onBlockBounds(serverData, from, to, player)) {
            player.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor(player, this.CANT_USE_SUPER_GLUE));
            return true;
        }
        return false;
    }

    public boolean onCreateGlueRemoval(IServerData<CM, ?> serverData, int entityId, ServerPlayer player) {
        ServerLevel level = player.level();
        Entity superGlueEntity = level.getEntity(entityId);
        return superGlueEntity != null && this.onCreateGlueEntity(serverData, superGlueEntity, player);
    }

    public boolean onCreateGlueEntity(IServerData<CM, ?> serverData, Entity superGlueEntity, ServerPlayer player) {
        BlockPos maxPos;
        AABB boundingBox = superGlueEntity.getBoundingBox();
        BlockPos minPos = BlockPos.containing((double)boundingBox.minX, (double)boundingBox.minY, (double)boundingBox.minZ);
        if (this.onBlockBounds(serverData, minPos, maxPos = BlockPos.containing((double)(boundingBox.maxX - 1.0), (double)(boundingBox.maxY - 1.0), (double)(boundingBox.maxZ - 1.0)), player)) {
            player.sendSystemMessage(serverData.getAdaptiveLocalizer().getFor(player, this.CANT_REMOVE_SUPER_GLUE));
            return true;
        }
        return false;
    }

    public boolean onCreateGlueEntityFromAnchor(IServerData<CM, ?> serverData, Entity superGlueEntity, BlockPos anchor) {
        ServerLevel level = ServerLevelHelper.getServerLevel(superGlueEntity.level());
        AABB boundingBox = superGlueEntity.getBoundingBox();
        BlockPos minPos = BlockPos.containing((double)boundingBox.minX, (double)boundingBox.minY, (double)boundingBox.minZ);
        BlockPos maxPos = BlockPos.containing((double)(boundingBox.maxX - 1.0), (double)(boundingBox.maxY - 1.0), (double)(boundingBox.maxZ - 1.0));
        int fromChunkX = minPos.getX() >> 4;
        int fromChunkZ = minPos.getZ() >> 4;
        int toChunkX = maxPos.getX() >> 4;
        int toChunkZ = maxPos.getZ() >> 4;
        int minChunkX = Math.min(fromChunkX, toChunkX);
        int minChunkZ = Math.min(fromChunkZ, toChunkZ);
        int maxChunkX = Math.max(fromChunkX, toChunkX);
        int maxChunkZ = Math.max(fromChunkZ, toChunkZ);
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                if (!this.onCreateMod(serverData, level, chunkX, chunkZ, anchor, true, true, false)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateTagExceptions(MinecraftServer server) {
        this.friendlyEntityList.updateTagExceptions(server);
        this.hostileEntityList.updateTagExceptions(server);
        this.forcedInteractionExceptionBlocks.updateTagExceptions(server);
        this.forcedBreakExceptionBlocks.updateTagExceptions(server);
        this.requiresEmptyHandBlocks.updateTagExceptions(server);
        this.forcedAllowAnyItemBlocks.updateTagExceptions(server);
        this.forcedInteractionExceptionEntities.updateTagExceptions(server);
        this.forcedKillExceptionEntities.updateTagExceptions(server);
        this.requiresEmptyHandEntities.updateTagExceptions(server);
        this.forcedAllowAnyItemEntities.updateTagExceptions(server);
        this.forcedEntityClaimBarrierList.updateTagExceptions(server);
        this.entitiesAllowedToBreakBlocks.updateTagExceptions(server);
        this.entitiesAllowedToInteractWithBlocks.updateTagExceptions(server);
        this.entitiesAllowedToKillEntities.updateTagExceptions(server);
        this.entitiesAllowedToInteractWithEntities.updateTagExceptions(server);
        this.entitiesAllowedToGriefDroppedItems.updateTagExceptions(server);
        this.nonBlockGriefingMobs.updateTagExceptions(server);
        this.entityGriefingMobs.updateTagExceptions(server);
        this.droppedItemGriefingMobs.updateTagExceptions(server);
        this.additionalBannedItems.updateTagExceptions(server);
        this.itemUseProtectionExceptions.updateTagExceptions(server);
        this.completelyDisabledItems.updateTagExceptions(server);
        this.completelyDisabledBlocks.updateTagExceptions(server);
        this.completelyDisabledEntities.updateTagExceptions(server);
        this.blockExceptionGroups.values().forEach(g -> g.updateTagExceptions(server));
        this.entityExceptionGroups.values().forEach(g -> g.updateTagExceptions(server));
        this.itemExceptionGroups.values().forEach(g -> g.updateTagExceptions(server));
        this.entityBarrierGroups.values().forEach(g -> g.updateTagExceptions(server));
    }

    public void onServerTick() {
        this.cantPickupItemsInTickCache.clear();
        this.cantPickupXPInTickCache.clear();
    }

    public static enum InteractionTargetResult {
        PROTECT,
        ALLOW,
        PASS;

    }

    public static final class Builder<CM extends IServerClaimsManager<?, ?, ?>> {
        private MinecraftServer server;
        private CM claimsManager;
        private IPlayerPartySystemManager playerPartySystemManager;
        private Map<String, ChunkProtectionExceptionGroup<Block>> blockExceptionGroups;
        private Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> entityExceptionGroups;
        private Map<String, ChunkProtectionExceptionGroup<Item>> itemExceptionGroups;
        private Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> entityBarrierGroups;
        private Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> blockAccessEntityGroups;
        private Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> entityAccessEntityGroups;
        private Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> droppedItemAccessEntityGroups;

        private Builder() {
        }

        public Builder<CM> setDefault() {
            this.setServer(null);
            this.setClaimsManager(null);
            this.setPlayerPartySystemManager(null);
            return this;
        }

        public Builder<CM> setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public Builder<CM> setClaimsManager(CM claimsManager) {
            this.claimsManager = claimsManager;
            return this;
        }

        public Builder<CM> setPlayerPartySystemManager(IPlayerPartySystemManager playerPartySystemManager) {
            this.playerPartySystemManager = playerPartySystemManager;
            return this;
        }

        public Builder<CM> setBlockExceptionGroups(Map<String, ChunkProtectionExceptionGroup<Block>> blockExceptionGroups) {
            this.blockExceptionGroups = blockExceptionGroups;
            return this;
        }

        public Builder<CM> setEntityExceptionGroups(Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> entityExceptionGroups) {
            this.entityExceptionGroups = entityExceptionGroups;
            return this;
        }

        public Builder<CM> setItemExceptionGroups(Map<String, ChunkProtectionExceptionGroup<Item>> itemExceptionGroups) {
            this.itemExceptionGroups = itemExceptionGroups;
            return this;
        }

        public Builder<CM> setEntityBarrierGroups(Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> entityBarrierGroups) {
            this.entityBarrierGroups = entityBarrierGroups;
            return this;
        }

        public Builder<CM> setBlockAccessEntityGroups(Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> blockAccessEntityGroups) {
            this.blockAccessEntityGroups = blockAccessEntityGroups;
            return this;
        }

        public Builder<CM> setEntityAccessEntityGroups(Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> entityAccessEntityGroups) {
            this.entityAccessEntityGroups = entityAccessEntityGroups;
            return this;
        }

        public Builder<CM> setDroppedItemAccessEntityGroups(Map<String, ChunkProtectionExceptionGroup<EntityType<?>>> droppedItemAccessEntityGroups) {
            this.droppedItemAccessEntityGroups = droppedItemAccessEntityGroups;
            return this;
        }

        public ChunkProtection<CM> build() {
            if (this.server == null || this.claimsManager == null || this.playerPartySystemManager == null || this.blockExceptionGroups == null || this.entityExceptionGroups == null || this.itemExceptionGroups == null || this.entityBarrierGroups == null || this.blockAccessEntityGroups == null || this.entityAccessEntityGroups == null || this.droppedItemAccessEntityGroups == null) {
                throw new IllegalStateException();
            }
            ChunkProtectionExceptionSet.Builder<EntityType<?>> friendlyEntityList = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<EntityType<?>> hostileEntityList = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<Block> forcedInteractionExceptionBlocksBuilder = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.BLOCK);
            ChunkProtectionExceptionSet.Builder<Block> forcedBreakExceptionBlocksBuilder = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.BLOCK);
            ChunkProtectionExceptionSet.Builder<Block> requiresEmptyHandBlocksBuilder = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.BLOCK);
            ChunkProtectionExceptionSet.Builder<Block> forcedAllowAnyItemBlocksBuilder = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.BLOCK);
            ChunkProtectionExceptionSet.Builder<EntityType<?>> forcedInteractionExceptionEntities = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<EntityType<?>> forcedKillExceptionEntities = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<EntityType<?>> requiresEmptyHandEntitiesBuilder = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<EntityType<?>> forcedAllowAnyItemEntitiesBuilder = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<EntityType<?>> forcedEntityClaimBarrierList = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<EntityType<?>> entitiesAllowedToBreakBlocks = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<EntityType<?>> entitiesAllowedToInteractWithBlocks = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<EntityType<?>> entitiesAllowedToKillEntities = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<EntityType<?>> entitiesAllowedToInteractWithEntities = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<EntityType<?>> entitiesAllowedToGriefDroppedItems = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<EntityType<?>> nonBlockGriefingMobs = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<EntityType<?>> entityGriefingMobs = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<EntityType<?>> droppedItemGriefingMobs = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<Item> additionalBannedItems = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ITEM);
            ChunkProtectionExceptionSet.Builder<Item> itemUseProtectionExceptions = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ITEM);
            ChunkProtectionExceptionSet.Builder<Item> completelyDisabledItems = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ITEM);
            ChunkProtectionExceptionSet.Builder<Block> completelyDisabledBlocks = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.BLOCK);
            ChunkProtectionExceptionSet.Builder<EntityType<?>> completelyDisabledEntities = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            WildcardResolver wildcardResolver = new WildcardResolver();
            this.onExceptionList(this.server, ServerConfig.CONFIG.friendlyChunkProtectedEntityList, friendlyEntityList::addEither, null, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.hostileChunkProtectedEntityList, hostileEntityList::addEither, null, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.forcedBlockProtectionExceptionList, null, forcedInteractionExceptionBlocksBuilder::addEither, forcedBreakExceptionBlocksBuilder::addEither, o -> {
                forcedInteractionExceptionBlocksBuilder.addEither((Either<Block, TagKey<Block>>)o);
                requiresEmptyHandBlocksBuilder.addEither((Either<Block, TagKey<Block>>)o);
            }, forcedAllowAnyItemBlocksBuilder::addEither, ExceptionElementType.BLOCK, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.forcedEntityProtectionExceptionList, null, forcedInteractionExceptionEntities::addEither, forcedKillExceptionEntities::addEither, o -> {
                forcedInteractionExceptionEntities.addEither((Either<EntityType<?>, TagKey<EntityType<?>>>)o);
                requiresEmptyHandEntitiesBuilder.addEither((Either<EntityType<?>, TagKey<EntityType<?>>>)o);
            }, forcedAllowAnyItemEntitiesBuilder::addEither, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.forcedEntityClaimBarrierList, forcedEntityClaimBarrierList::addEither, null, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.entitiesAllowedToGrief, e -> {
                entitiesAllowedToBreakBlocks.addEither((Either<EntityType<?>, TagKey<EntityType<?>>>)e);
                entitiesAllowedToInteractWithBlocks.addEither((Either<EntityType<?>, TagKey<EntityType<?>>>)e);
            }, entitiesAllowedToInteractWithBlocks::addEither, entitiesAllowedToBreakBlocks::addEither, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.entitiesAllowedToGriefEntities, e -> {
                entitiesAllowedToKillEntities.addEither((Either<EntityType<?>, TagKey<EntityType<?>>>)e);
                entitiesAllowedToInteractWithEntities.addEither((Either<EntityType<?>, TagKey<EntityType<?>>>)e);
            }, entitiesAllowedToInteractWithEntities::addEither, entitiesAllowedToKillEntities::addEither, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.entitiesAllowedToGriefDroppedItems, entitiesAllowedToGriefDroppedItems::addEither, null, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.nonBlockGriefingMobs, nonBlockGriefingMobs::addEither, null, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.entityGriefingMobs, entityGriefingMobs::addEither, null, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.droppedItemGriefingMobs, droppedItemGriefingMobs::addEither, null, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.additionalBannedItemsList, additionalBannedItems::addEither, null, null, null, null, ExceptionElementType.ITEM, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.itemUseProtectionExceptionList, null, itemUseProtectionExceptions::addEither, null, null, null, ExceptionElementType.ITEM, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.completelyDisabledItemInteractions, null, completelyDisabledItems::addEither, null, null, null, ExceptionElementType.ITEM, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.completelyDisabledBlockInteractions, null, completelyDisabledBlocks::addEither, null, null, null, ExceptionElementType.BLOCK, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.completelyDisabledEntityInteractions, null, completelyDisabledEntities::addEither, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            HashSet<String> staticFakePlayerUsernames = new HashSet<String>();
            HashSet<UUID> staticFakePlayerIds = new HashSet<UUID>();
            ((List)ServerConfig.CONFIG.staticFakePlayers.get()).forEach(e -> {
                try {
                    staticFakePlayerIds.add(UUID.fromString(e));
                }
                catch (IllegalArgumentException iae) {
                    staticFakePlayerUsernames.add((String)e);
                }
            });
            HashSet staticFakePlayerClassExceptions = new HashSet();
            ((List)ServerConfig.CONFIG.staticFakePlayerClassExceptions.get()).forEach(e -> {
                try {
                    staticFakePlayerClassExceptions.add(Class.forName(e));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            });
            HashSet<UUID> fullPasses = new HashSet<UUID>();
            return new ChunkProtection<CM>(this.claimsManager, this.playerPartySystemManager, new ChunkProtectionEntityHelper(), friendlyEntityList.build(), hostileEntityList.build(), forcedInteractionExceptionBlocksBuilder.build(), forcedBreakExceptionBlocksBuilder.build(), requiresEmptyHandBlocksBuilder.build(), forcedAllowAnyItemBlocksBuilder.build(), completelyDisabledBlocks.build(), forcedInteractionExceptionEntities.build(), forcedKillExceptionEntities.build(), requiresEmptyHandEntitiesBuilder.build(), forcedAllowAnyItemEntitiesBuilder.build(), forcedEntityClaimBarrierList.build(), entitiesAllowedToBreakBlocks.build(), entitiesAllowedToInteractWithBlocks.build(), entitiesAllowedToKillEntities.build(), entitiesAllowedToInteractWithEntities.build(), entitiesAllowedToGriefDroppedItems.build(), nonBlockGriefingMobs.build(), entityGriefingMobs.build(), droppedItemGriefingMobs.build(), staticFakePlayerUsernames, staticFakePlayerIds, staticFakePlayerClassExceptions, additionalBannedItems.build(), completelyDisabledItems.build(), itemUseProtectionExceptions.build(), completelyDisabledEntities.build(), this.blockExceptionGroups, this.entityExceptionGroups, this.itemExceptionGroups, this.entityBarrierGroups, this.blockAccessEntityGroups, this.entityAccessEntityGroups, this.droppedItemAccessEntityGroups, new BlockPos.MutableBlockPos(), new HashMap<Entity, Set<ChunkPos>>(), new HashMap<Entity, Set<ChunkPos>>(), fullPasses);
        }

        private <T> void onExceptionList(MinecraftServer server, ModConfigSpec.ConfigValue<List<? extends String>> list, Consumer<Either<T, TagKey<T>>> defaultException, Consumer<Either<T, TagKey<T>>> interactException, Consumer<Either<T, TagKey<T>>> breakException, Consumer<Either<T, TagKey<T>>> handException, Consumer<Either<T, TagKey<T>>> anythingException, ExceptionElementType<T> elementType, WildcardResolver wildcardResolver) {
            Registry elementRegistry = elementType.getRegistry(server);
            Function<ResourceLocation, Object> objectGetter = key -> elementRegistry.getOptional(key).orElse(null);
            Iterable iterable = elementType.getIterable();
            Function<Object, ResourceLocation> keyGetter = arg_0 -> elementRegistry.getKey(arg_0);
            Function<ResourceLocation, TagKey> objectTagGetter = rl -> TagKey.create((ResourceKey)elementRegistry.key(), (ResourceLocation)rl);
            Iterable tagIterable = elementType.getTagIterable();
            Function<TagKey, ResourceLocation> tagKeyGetter = TagKey::location;
            ((List)list.get()).forEach(s -> this.onExceptionListElement((String)s, defaultException, interactException, breakException, handException, anythingException, (Function)objectGetter, iterable, (Function)keyGetter, (Function)objectTagGetter, tagIterable, (Function)tagKeyGetter, wildcardResolver));
        }

        private <T> void onExceptionListElement(String element, Consumer<Either<T, TagKey<T>>> defaultException, Consumer<Either<T, TagKey<T>>> interactException, Consumer<Either<T, TagKey<T>>> breakException, Consumer<Either<T, TagKey<T>>> handException, Consumer<Either<T, TagKey<T>>> anythingException, Function<ResourceLocation, T> objectGetter, Iterable<T> iterable, Function<T, ResourceLocation> keyGetter, Function<ResourceLocation, TagKey<T>> objectTagGetter, Iterable<TagKey<T>> tagIterable, Function<TagKey<T>, ResourceLocation> tagKeyGetter, WildcardResolver wildcardResolver) {
            block5: {
                Consumer<Object> destination;
                String id;
                block6: {
                    id = element;
                    if (defaultException == null) {
                        defaultException = interactException;
                    }
                    destination = defaultException;
                    if (element.startsWith(ChunkProtection.BREAK_PREFIX) || element.startsWith(ChunkProtection.HAND_PREFIX) || element.startsWith(ChunkProtection.ANYTHING_PREFIX) || element.startsWith(ChunkProtection.INTERACT_PREFIX)) {
                        id = element.substring(element.indexOf("$") + 1);
                        destination = element.startsWith(ChunkProtection.BREAK_PREFIX) ? breakException : (element.startsWith(ChunkProtection.ANYTHING_PREFIX) ? anythingException : (element.startsWith(ChunkProtection.INTERACT_PREFIX) ? interactException : handException));
                    }
                    if (destination == null) break block5;
                    if (id.startsWith(ChunkProtection.TAG_PREFIX)) break block6;
                    List<T> objects = wildcardResolver.resolveResourceLocations(objectGetter, iterable, keyGetter, id);
                    if (objects == null) break block5;
                    for (T object : objects) {
                        destination.accept(Either.left(object));
                    }
                    break block5;
                }
                List<TagKey<T>> objectTags = wildcardResolver.resolveResourceLocations(objectTagGetter, tagIterable, tagKeyGetter, id = id.substring(ChunkProtection.TAG_PREFIX.length()));
                if (objectTags != null) {
                    for (TagKey<T> objectTag : objectTags) {
                        destination.accept(Either.right(objectTag));
                    }
                }
            }
        }

        public static <CM extends IServerClaimsManager<?, ?, ?>> Builder<CM> begin() {
            return new Builder<CM>().setDefault();
        }
    }
}

