/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.protection;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.projectile.Projectile;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.reflect.Reflection;
import xaero.pac.common.server.core.ServerCore;

public class ChunkProtectionEntityHelper {
    private static EntityDataAccessor<Optional<EntityReference<LivingEntity>>> FOX_TRUSTED_UUID_SECONDARY;
    private static EntityDataAccessor<Optional<EntityReference<LivingEntity>>> FOX_TRUSTED_UUID_MAIN;

    boolean hostileException(Entity e) {
        if (e instanceof Piglin) {
            return ((Piglin)e).isBaby();
        }
        return false;
    }

    boolean isHostile(Entity e) {
        return e.level().getDifficulty() != Difficulty.PEACEFUL && !this.hostileException(e) && (e instanceof Enemy || e.getSoundSource() == SoundSource.HOSTILE);
    }

    boolean isOwned(Entity e, UUID potentialOwnerId) {
        if (potentialOwnerId == null) {
            return false;
        }
        UUID owner = this.getOwnerId(e);
        if (potentialOwnerId.equals(owner)) {
            return true;
        }
        if (e instanceof Fox) {
            Fox fox = (Fox)e;
            EntityReference ownerReference = FOX_TRUSTED_UUID_MAIN != null ? (EntityReference)((Optional)fox.getEntityData().get(FOX_TRUSTED_UUID_MAIN)).orElse(null) : null;
            return ownerReference != null && potentialOwnerId.equals(ownerReference.getUUID());
        }
        return false;
    }

    UUID getOwnerId(Entity e) {
        OwnableEntity ownable;
        EntityReference ownerReference;
        if (e instanceof ItemEntity) {
            UUID ownerId = ServerCore.getItemEntityOwner((ItemEntity)e);
            return ownerId == null ? ServerCore.getItemEntityThrower((ItemEntity)e) : ownerId;
        }
        if (e instanceof OwnableEntity && (ownerReference = (ownable = (OwnableEntity)e).getOwnerReference()) != null) {
            return ownerReference.getUUID();
        }
        if (e instanceof Fox) {
            Fox fox = (Fox)e;
            ownerReference = FOX_TRUSTED_UUID_SECONDARY != null ? (EntityReference)((Optional)fox.getEntityData().get(FOX_TRUSTED_UUID_SECONDARY)).orElse(null) : null;
            return ownerReference != null ? ownerReference.getUUID() : null;
        }
        Entity ownerEntity = null;
        if (e instanceof Projectile) {
            ownerEntity = ((Projectile)e).getOwner();
        } else if (e instanceof Vex) {
            ownerEntity = ((Vex)e).getOwner();
        } else if (e instanceof EvokerFangs) {
            ownerEntity = ((EvokerFangs)e).getOwner();
        }
        return ownerEntity == null ? null : ownerEntity.getUUID();
    }

    static {
        Field foxTrustSecondaryField = null;
        Field foxTrustMainField = null;
        try {
            foxTrustSecondaryField = Reflection.getFieldReflection(Fox.class, "DATA_TRUSTED_ID_0", "f_28439_", "field_17951", "Lnet/minecraft/class_2940;");
        }
        catch (Exception e) {
            OpenPartiesAndClaims.LOGGER.error("suppressed exception", (Throwable)e);
        }
        try {
            foxTrustMainField = Reflection.getFieldReflection(Fox.class, "DATA_TRUSTED_ID_1", "f_28440_", "field_17952", "Lnet/minecraft/class_2940;");
        }
        catch (Exception e) {
            OpenPartiesAndClaims.LOGGER.error("suppressed exception", (Throwable)e);
        }
        if (foxTrustSecondaryField != null) {
            try {
                foxTrustSecondaryField.setAccessible(true);
                FOX_TRUSTED_UUID_SECONDARY = (EntityDataAccessor)foxTrustSecondaryField.get(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (foxTrustMainField != null) {
            try {
                foxTrustMainField.setAccessible(true);
                FOX_TRUSTED_UUID_MAIN = (EntityDataAccessor)foxTrustMainField.get(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

