/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import xaero.pac.client.gui.SimpleValueWidgetListElement;
import xaero.pac.client.gui.WidgetListScreen;

public final class PickerWidgetListElement<T>
extends SimpleValueWidgetListElement<T, PickerWidgetListElement<T>> {
    private int currentIndex;
    private final List<T> options;
    private final T defaultValue;
    private class_4185 prevButton;
    private class_4185 nextButton;
    private class_4185 defaultButton;
    private final BiConsumer<T, class_4185> valueChangeConsumer;

    private PickerWidgetListElement(int w, int h, boolean mutable, BiFunction<PickerWidgetListElement<T>, class_2382, class_339> widgetSupplier, List<class_5481> tooltip, T startValue, int startIndex, List<T> options, T defaultValue, BiConsumer<T, class_4185> valueChangeConsumer) {
        super(startValue, w, h, mutable, widgetSupplier, tooltip);
        this.options = options;
        this.currentIndex = startIndex;
        this.defaultValue = defaultValue;
        this.valueChangeConsumer = valueChangeConsumer;
    }

    @Override
    public class_339 screenInit(int x, int y, WidgetListScreen screen, List<class_342> tickableBoxes) {
        this.prevButton = (class_4185)super.screenInit(x, y, screen, tickableBoxes);
        this.defaultButton = new class_4185(x + this.w - 20, y, 20, 20, (class_2561)class_2561.method_43470((String)"-"), this::onDefaultButton);
        screen.method_37063(this.defaultButton);
        this.updateDefaultButton();
        this.nextButton = new class_4185(x + this.w - 40, y, 20, 20, (class_2561)class_2561.method_43470((String)">"), this::onNextButton);
        screen.method_37063(this.nextButton);
        return this.prevButton;
    }

    private void updateDefaultButton() {
        this.defaultButton.field_22763 = !Objects.equals(this.draftValue, this.defaultValue);
    }

    private void updateValue(class_4185 b) {
        this.draftValue = this.options.get(this.currentIndex);
        this.valueChangeConsumer.accept(this.draftValue, b);
        this.updateDefaultButton();
    }

    private void onDefaultButton(class_4185 b) {
        this.currentIndex = this.options.indexOf(this.defaultValue);
        if (this.currentIndex == -1) {
            this.currentIndex = 0;
        }
        this.updateValue(b);
    }

    private void onPrevButton(class_4185 b) {
        --this.currentIndex;
        if (this.currentIndex < 0) {
            this.currentIndex = this.options.size() - 1;
        }
        this.updateValue(b);
    }

    private void onNextButton(class_4185 b) {
        this.currentIndex = (this.currentIndex + 1) % this.options.size();
        this.updateValue(b);
    }

    @Override
    public void render(class_4587 poseStack) {
        super.render(poseStack);
        String subName = Objects.toString(this.draftValue);
        int subNameW = class_310.method_1551().field_1772.method_1727(subName);
        class_310.method_1551().field_1772.method_1720(poseStack, subName, (float)(this.x + 90 - subNameW / 2), (float)(this.y + 6), this.mutable ? -1 : 0xE0E0E0);
    }

    public static final class Builder<T>
    extends SimpleValueWidgetListElement.Builder<T, PickerWidgetListElement<T>, Builder<T>> {
        private int startIndex;
        private List<T> options;
        private T defaultValue;
        private BiConsumer<T, class_4185> valueChangeConsumer;

        @Override
        public Builder<T> setDefault() {
            super.setDefault();
            this.setStartIndex(-1);
            this.setOptions(null);
            this.setDefaultValue(null);
            this.setValueChangeConsumer((v, b) -> {});
            return (Builder)this.self;
        }

        @Override
        public Builder<T> setStartValue(T startValue) {
            if (startValue != null) {
                throw new IllegalArgumentException();
            }
            return (Builder)super.setStartValue(startValue);
        }

        public Builder<T> setStartIndex(int startIndex) {
            this.startIndex = startIndex;
            return (Builder)this.self;
        }

        public Builder<T> setOptions(List<T> options) {
            this.options = options;
            return (Builder)this.self;
        }

        public Builder<T> setDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return (Builder)this.self;
        }

        public Builder<T> setValueChangeConsumer(BiConsumer<T, class_4185> valueChangeConsumer) {
            this.valueChangeConsumer = valueChangeConsumer;
            return (Builder)this.self;
        }

        @Override
        public PickerWidgetListElement<T> build() {
            if (this.startIndex == -1 || this.options == null || this.valueChangeConsumer == null) {
                throw new IllegalStateException();
            }
            this.startValue = this.options.get(this.startIndex);
            if (this.defaultValue == null) {
                this.defaultValue = this.startValue;
            }
            return (PickerWidgetListElement)super.build();
        }

        @Override
        protected PickerWidgetListElement<T> buildInternal() {
            BiFunction widgetSupplier = (el, xy) -> new class_4185(xy.method_10263(), xy.method_10264(), 20, 20, (class_2561)class_2561.method_43470((String)"<"), el::onPrevButton);
            return new PickerWidgetListElement<Object>(this.w, this.h, this.mutable, widgetSupplier, this.tooltip, this.startValue, this.startIndex, this.options, this.defaultValue, this.valueChangeConsumer);
        }

        public static <T> Builder<T> begin() {
            return new Builder<T>().setDefault();
        }
    }
}

