/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import java.util.Iterator;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.api.IPartyMemberAPI;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class PartyOnCommandUpdater {
    private void onOnlineMember(UUID commandCasterId, MinecraftServer server, IPartyMember mi, class_3222 onlineMember, Predicate<IPartyMember> shouldUpdateCommandsForMember, class_2561 massMessage) {
        if (shouldUpdateCommandsForMember.test(mi)) {
            server.method_3734().method_9241(onlineMember);
        }
        if (massMessage != null) {
            onlineMember.method_9203(massMessage, commandCasterId);
        }
    }

    public <M extends IPartyMember, I extends IPartyPlayerInfo, A extends IPartyAlly> void update(UUID commandCasterId, IServerData<?, ?> serverData, IServerParty<M, I, A> party, IPlayerConfigManager configs, Predicate<IPartyMember> shouldUpdateCommandsForMember, class_2561 massMessageContent) {
        String partyName = party.getDefaultName();
        String partyCustomName = configs.getLoadedConfig(party.getOwner().getUUID()).getEffective(PlayerConfigOptions.PARTY_NAME);
        if (!partyCustomName.isEmpty()) {
            partyName = partyCustomName;
        }
        class_5250 partyNameComponent = new class_2585("[" + partyName + "] ").method_27694(s -> s.method_10977(class_124.field_1065).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(party.getDefaultName()))));
        class_2585 massMessage = new class_2585("");
        massMessage.method_10855().add(partyNameComponent);
        MinecraftServer server = serverData.getServer();
        AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
        class_3324 playerList = server.method_3760();
        if (playerList.method_14574() > party.getMemberCount()) {
            Iterator iterator = party.getTypedMemberInfoStream().iterator();
            while (iterator.hasNext()) {
                IPartyMember memberInfo = (IPartyMember)iterator.next();
                class_3222 onlinePlayer = playerList.method_14602(memberInfo.getUUID());
                if (onlinePlayer == null) continue;
                massMessage.method_10855().clear();
                massMessage.method_10855().add(partyNameComponent);
                massMessage.method_10855().add(adaptiveLocalizer.getFor(onlinePlayer, massMessageContent));
                this.onOnlineMember(commandCasterId, server, memberInfo, onlinePlayer, shouldUpdateCommandsForMember, (class_2561)massMessage);
            }
        } else {
            for (class_3222 onlinePlayer : playerList.method_14571()) {
                IPartyMemberAPI memberInfo = party.getMemberInfo(onlinePlayer.method_5667());
                if (memberInfo == null) continue;
                massMessage.method_10855().clear();
                massMessage.method_10855().add(partyNameComponent);
                massMessage.method_10855().add(adaptiveLocalizer.getFor(onlinePlayer, massMessageContent));
                this.onOnlineMember(commandCasterId, server, (IPartyMember)memberInfo, onlinePlayer, shouldUpdateCommandsForMember, (class_2561)massMessage);
            }
        }
    }
}

