/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.party.sync;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.parties.party.IPartyMemberDynamicInfoSyncable;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.PartyMemberDynamicInfoSyncable;
import xaero.pac.common.parties.party.ally.PartyAlly;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.server.parties.party.PartyManager;
import xaero.pac.common.server.parties.party.ServerParty;
import xaero.pac.common.server.parties.party.sync.AbstractPartySynchronizer;
import xaero.pac.common.server.parties.party.sync.IPartyMemberDynamicInfoSynchronizer;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.data.api.ServerPlayerDataAPI;

public class PartyMemberDynamicInfoSynchronizer
extends AbstractPartySynchronizer
implements IPartyMemberDynamicInfoSynchronizer<ServerParty> {
    private PartyManager partyManager;

    public PartyMemberDynamicInfoSynchronizer(MinecraftServer server) {
        super(server);
    }

    public void setPartyManager(PartyManager partyManager) {
        this.partyManager = partyManager;
    }

    @Override
    public void syncToPartyDynamicInfo(ServerParty party, IPartyMemberDynamicInfoSyncable syncedInfo, ServerParty fromParty) {
        IPlayerConfigManager configManager = this.partyManager.getPlayerConfigs();
        if (syncedInfo.isActive() && party == fromParty && !configManager.getLoadedConfig(syncedInfo.getPlayerId()).getEffective(PlayerConfigOptions.SHARE_LOCATION_WITH_PARTY).booleanValue()) {
            return;
        }
        if (syncedInfo.isActive() && syncedInfo.getPartyId() == null) {
            return;
        }
        PartyMember exceptionMemberInfo = party != fromParty ? null : party.getMemberInfo(syncedInfo.getPlayerId());
        PlayerConfigOptionSpec receiveConfigOption = (PlayerConfigOptionSpec)(party == fromParty ? PlayerConfigOptions.RECEIVE_LOCATIONS_FROM_PARTY : PlayerConfigOptions.RECEIVE_LOCATIONS_FROM_PARTY_MUTUAL_ALLIES);
        Predicate<IPartyPlayerInfo> exception = mi -> mi == exceptionMemberInfo || (Boolean)configManager.getLoadedConfig(mi.getUUID()).getEffective(receiveConfigOption) == false;
        this.syncToParty(party, exception, syncedInfo, true);
    }

    @Override
    public void syncToPartyMutualAlliesDynamicInfo(ServerParty party, IPartyMemberDynamicInfoSyncable syncedInfo) {
        IPlayerConfigManager configManager = this.partyManager.getPlayerConfigs();
        if (syncedInfo.isActive() && !configManager.getLoadedConfig(syncedInfo.getPlayerId()).getEffective(PlayerConfigOptions.SHARE_LOCATION_WITH_PARTY_MUTUAL_ALLIES).booleanValue()) {
            return;
        }
        if (syncedInfo.isActive() && syncedInfo.getPartyId() == null) {
            return;
        }
        Iterator allyIterator = party.getTypedAllyPartiesStream().iterator();
        while (allyIterator.hasNext()) {
            ServerParty allyParty = this.partyManager.getPartyById(((PartyAlly)allyIterator.next()).getPartyId());
            if (allyParty == null || !allyParty.isAlly(party.getId())) continue;
            this.syncToPartyDynamicInfo(allyParty, syncedInfo, party);
        }
    }

    @Override
    public void syncToPartiesDynamicInfo(ServerParty party, IPartyMemberDynamicInfoSyncable syncedInfo) {
        this.syncToPartyDynamicInfo(party, syncedInfo, party);
        this.syncToPartyMutualAlliesDynamicInfo(party, syncedInfo);
    }

    private void syncToClientAllDynamicInfo(IPlayerConfigManager configManager, class_3222 player, ServerParty party, ServerParty toParty, boolean removers) {
        if (!removers && !configManager.getLoadedConfig(player.method_5667()).getEffective(party == toParty ? PlayerConfigOptions.RECEIVE_LOCATIONS_FROM_PARTY : PlayerConfigOptions.RECEIVE_LOCATIONS_FROM_PARTY_MUTUAL_ALLIES).booleanValue()) {
            return;
        }
        PlayerConfigOptionSpec shareConfigOption = (PlayerConfigOptionSpec)(party == toParty ? PlayerConfigOptions.SHARE_LOCATION_WITH_PARTY : PlayerConfigOptions.SHARE_LOCATION_WITH_PARTY_MUTUAL_ALLIES);
        Consumer<class_3222> onlineMemberConsumer = onlineMember -> {
            if (onlineMember != player && ((Boolean)configManager.getLoadedConfig(onlineMember.method_5667()).getEffective(shareConfigOption)).booleanValue()) {
                PartyMemberDynamicInfoSyncable syncedInfo;
                ServerPlayerData partyMemberMainCap = (ServerPlayerData)ServerPlayerDataAPI.from(onlineMember);
                PartyMemberDynamicInfoSyncable partyMemberDynamicInfoSyncable = syncedInfo = removers ? partyMemberMainCap.getPartyMemberDynamicInfo().getRemover() : partyMemberMainCap.getPartyMemberDynamicInfo();
                if (removers || syncedInfo.getPartyId() != null) {
                    this.sendToClient(player, syncedInfo, true);
                }
            }
        };
        party.getOnlineMemberStream().forEach(onlineMemberConsumer);
    }

    @Override
    public void syncToClientAllDynamicInfo(class_3222 player, ServerParty party, boolean removers) {
        this.syncToClientAllDynamicInfo(this.partyManager.getPlayerConfigs(), player, party, party, removers);
    }

    @Override
    public void syncToClientMutualAlliesDynamicInfo(class_3222 player, ServerParty party, boolean removers) {
        IPlayerConfigManager configManager = this.partyManager.getPlayerConfigs();
        party.getTypedAllyPartiesStream().forEach(ally -> {
            ServerParty allyParty = this.partyManager.getPartyById(ally.getPartyId());
            if (allyParty != null && allyParty.isAlly(party.getId())) {
                this.syncToClientAllDynamicInfo(configManager, player, allyParty, party, removers);
            }
        });
    }

    public void syncToClientAllDynamicInfoIncludingMutualAllies(class_3222 player, ServerParty party) {
        this.syncToClientAllDynamicInfo(player, party, false);
        this.syncToClientMutualAlliesDynamicInfo(player, party, false);
    }

    public void syncToPartyAnotherPartyDynamicInfo(ServerParty party, ServerParty anotherParty, boolean removers) {
        if (party == anotherParty) {
            throw new IllegalArgumentException();
        }
        IPlayerConfigManager configManager = this.partyManager.getPlayerConfigs();
        Consumer<class_3222> onlineAllyMemberConsumer = anotherPartyMember -> {
            if (configManager.getLoadedConfig(anotherPartyMember.method_5667()).getEffective(PlayerConfigOptions.SHARE_LOCATION_WITH_PARTY_MUTUAL_ALLIES).booleanValue()) {
                ServerPlayerData anotherPartyMemberMainCap = (ServerPlayerData)ServerPlayerDataAPI.from(anotherPartyMember);
                PartyMemberDynamicInfoSyncable syncedInfo = removers ? anotherPartyMemberMainCap.getPartyMemberDynamicInfo().getRemover() : anotherPartyMemberMainCap.getPartyMemberDynamicInfo();
                this.syncToPartyDynamicInfo(party, (IPartyMemberDynamicInfoSyncable)syncedInfo, anotherParty);
            }
        };
        anotherParty.getOnlineMemberStream().forEach(onlineAllyMemberConsumer);
    }

    @Override
    public void handlePlayerLeave(ServerParty playerParty, class_3222 player) {
        if (playerParty != null) {
            ServerPlayerData playerMainCap = (ServerPlayerData)ServerPlayerDataAPI.from(player);
            PartyMemberDynamicInfoSyncable remover = playerMainCap.getPartyMemberDynamicInfo().getRemover();
            IPlayerConfigManager configManager = this.partyManager.getPlayerConfigs();
            if (configManager.getLoadedConfig(player.method_5667()).getEffective(PlayerConfigOptions.SHARE_LOCATION_WITH_PARTY).booleanValue()) {
                this.syncToPartyDynamicInfo(playerParty, (IPartyMemberDynamicInfoSyncable)remover, playerParty);
            }
            if (configManager.getLoadedConfig(player.method_5667()).getEffective(PlayerConfigOptions.SHARE_LOCATION_WITH_PARTY_MUTUAL_ALLIES).booleanValue()) {
                this.syncToPartyMutualAlliesDynamicInfo(playerParty, (IPartyMemberDynamicInfoSyncable)remover);
            }
        }
    }

    @Override
    public void onPlayerTick(ServerPlayerData mainCap, class_3222 player) {
        ServerParty playerParty = this.partyManager.getPartyByMember(player.method_5667());
        if (playerParty != null) {
            mainCap.getPartyMemberDynamicInfo().setPartyId(playerParty.getId());
            mainCap.getPartyMemberDynamicInfo().update(player.method_14220().method_27983().method_29177(), player.method_23317(), player.method_23318(), player.method_23321());
            if (mainCap.getPartyMemberDynamicInfo().isDirty()) {
                this.syncToPartiesDynamicInfo(playerParty, (IPartyMemberDynamicInfoSyncable)mainCap.getPartyMemberDynamicInfo());
            }
        } else {
            mainCap.getPartyMemberDynamicInfo().setPartyId(null);
        }
    }
}

