/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.permission.impl;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import javax.annotation.Nonnull;
import me.lucko.fabric.api.permissions.v0.Options;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import xaero.pac.common.server.player.permission.api.IPermissionNodeAPI;
import xaero.pac.common.server.player.permission.api.IPlayerPermissionSystemAPI;

public class FabricPermissionsSystem
implements IPlayerPermissionSystemAPI {
    private static final Map<Class<?>, Function<String, ?>> PARSERS = Map.of(Integer.class, Integer::valueOf, Double.class, Double::valueOf, Float.class, Float::valueOf, Long.class, Long::valueOf, Short.class, Short::valueOf, Byte.class, Byte::valueOf, String.class, Function.identity(), class_2561.class, class_2585::new);

    @Override
    @Nonnull
    public OptionalInt getIntPermission(@Nonnull class_3222 player, @Nonnull IPermissionNodeAPI<Integer> node) {
        Integer parsedInteger = Options.get((class_1297)player, (String)node.getNodeString(), Integer::parseInt).orElse(null);
        if (parsedInteger == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(parsedInteger);
    }

    @Override
    public boolean getPermission(@Nonnull class_3222 player, @Nonnull IPermissionNodeAPI<Boolean> node) {
        return Permissions.check((class_1297)player, (String)node.getNodeString());
    }

    @Override
    @Nonnull
    public <T> Optional<T> getPermissionTyped(@Nonnull class_3222 player, @Nonnull IPermissionNodeAPI<T> node) {
        if (node.getType() == Boolean.class) {
            Optional<Boolean> booleanValue = Optional.of(this.getPermission(player, node));
            return booleanValue;
        }
        Function<String, ?> parser = PARSERS.get(node.getType());
        if (parser == null) {
            return Optional.empty();
        }
        Object parsedValue = Options.get((class_1297)player, (String)node.getNodeString(), parser).orElse(null);
        return Optional.ofNullable(parsedValue);
    }
}

