/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.lazypacket;

import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.packet.LazyPacketsConfirmationPacket;
import xaero.pac.common.server.lazypacket.LazyPacket;
import xaero.pac.common.server.lazypacket.LazyPacketManager;
import xaero.pac.common.server.lazypacket.PlayerLazyPacketManager;

public class LazyPacketSender {
    private static final LazyPacketsConfirmationPacket CONFIRMATION_PACKET = new LazyPacketsConfirmationPacket();
    private final MinecraftServer server;
    private final LazyPacketManager manager;
    private final int bytesPerTickLimit;
    private final float speedUpAtOccupancy;
    private final int capacity;
    private final int bytesPerConfirmation;

    private LazyPacketSender(MinecraftServer server, LazyPacketManager manager, int bytesPerTickLimit, float speedUpAtOccupancy, int capacity, int bytesPerConfirmation) {
        this.server = server;
        this.manager = manager;
        this.bytesPerTickLimit = bytesPerTickLimit;
        this.speedUpAtOccupancy = speedUpAtOccupancy;
        this.capacity = capacity;
        this.bytesPerConfirmation = bytesPerConfirmation;
    }

    public void clearForPlayer(ServerPlayer player) {
        this.clearForPlayer(player, player.getUUID());
    }

    public void clearForPlayer(ServerPlayer player, UUID playerId) {
        this.manager.clearForPlayer(player, playerId);
    }

    public void enqueue(ServerPlayer player, LazyPacket<?> packet) {
        this.manager.enqueue(player, packet);
    }

    public void onConfirmation(ServerPlayer player) {
        this.manager.onConfirmation(player);
    }

    public void onServerTick() {
        PlayerLazyPacketManager playerPackets;
        boolean overCapacity;
        int bytesSent = 0;
        int bytesToSend = this.bytesPerTickLimit;
        float occupancy = (float)this.manager.getTotalBytesEnqueued() / (float)this.capacity;
        if (occupancy > this.speedUpAtOccupancy) {
            bytesToSend = (int)((float)bytesToSend * (occupancy / this.speedUpAtOccupancy));
        }
        while (((overCapacity = this.manager.getTotalBytesEnqueued() > this.capacity) || bytesSent < bytesToSend) && (playerPackets = this.manager.getNext(this.bytesPerConfirmation, overCapacity)) != null) {
            LazyPacket<?> packet = playerPackets.getNext();
            bytesSent += packet.getPreparedSize();
            ServerPlayer player = this.server.getPlayerList().getPlayer(playerPackets.getPlayerId());
            if (player == null) {
                this.clearForPlayer(null, playerPackets.getPlayerId());
                continue;
            }
            OpenPartiesAndClaims.INSTANCE.getPacketHandler().sendToPlayer(player, packet);
            this.manager.countSentBytes(packet);
            playerPackets.onSend(packet);
            if (playerPackets.isWaitingForConfirmation() || !playerPackets.needsConfirmation(this.bytesPerConfirmation)) continue;
            playerPackets.startWaitingForConfirmation();
            OpenPartiesAndClaims.INSTANCE.getPacketHandler().sendToPlayer(player, CONFIRMATION_PACKET);
        }
    }

    public boolean isClogged(ServerPlayer player) {
        return this.manager.isClogged(player);
    }

    public static final class Builder {
        private MinecraftServer server;
        private int bytesPerTickLimit;
        private float speedUpAtOccupancy;
        private int capacity;
        private int bytesPerConfirmation;

        public Builder setDefault() {
            this.setServer(null);
            this.setBytesPerTickLimit(0);
            this.setSpeedUpAtOccupancy(0.125f);
            this.setCapacity(0);
            this.setBytesPerConfirmation(0);
            return this;
        }

        public Builder setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public Builder setBytesPerTickLimit(int bytesPerTickLimit) {
            this.bytesPerTickLimit = bytesPerTickLimit;
            return this;
        }

        public Builder setSpeedUpAtOccupancy(float speedUpAtOccupancy) {
            this.speedUpAtOccupancy = speedUpAtOccupancy;
            return this;
        }

        public Builder setCapacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder setBytesPerConfirmation(int bytesPerConfirmation) {
            this.bytesPerConfirmation = bytesPerConfirmation;
            return this;
        }

        public LazyPacketSender build() {
            if (this.server == null || this.bytesPerTickLimit == 0 || this.capacity == 0 || this.bytesPerConfirmation == 0) {
                throw new IllegalStateException();
            }
            return new LazyPacketSender(this.server, LazyPacketManager.Builder.begin().setServer(this.server).build(), this.bytesPerTickLimit, this.speedUpAtOccupancy, this.capacity, this.bytesPerConfirmation);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

