/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.party.sync;

import java.util.List;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import xaero.pac.client.parties.party.ClientPartyAllyInfo;
import xaero.pac.common.packet.ClientboundLoadingPacket;
import xaero.pac.common.packet.parties.ClientboundPartyAllyPacket;
import xaero.pac.common.packet.parties.ClientboundPartyNamePacket;
import xaero.pac.common.packet.parties.ClientboundPartyPacket;
import xaero.pac.common.packet.parties.ClientboundPartyPlayerPacket;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.PartyAlly;
import xaero.pac.common.parties.party.member.PartyInvite;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.lazypacket.task.schedule.LazyPacketScheduleTaskHandler;
import xaero.pac.common.server.parties.party.PartyManager;
import xaero.pac.common.server.parties.party.ServerParty;
import xaero.pac.common.server.parties.party.sync.AbstractPartySynchronizer;
import xaero.pac.common.server.parties.party.sync.IPartySynchronizer;
import xaero.pac.common.server.parties.party.sync.PartyMemberDynamicInfoSynchronizer;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.data.ServerPlayerData;

public class PartySynchronizer
extends AbstractPartySynchronizer
implements IPartySynchronizer<ServerParty> {
    public static final int PARTY_ELEMENTS_PER_TICK = 8192;
    public static final int PARTY_ELEMENTS_PER_TICK_PER_PLAYER = 512;
    private PartyManager partyManager;
    private final PartyMemberDynamicInfoSynchronizer dynamicInfoSync;
    private final List<LazyPacketScheduleTaskHandler> schedulers;

    private PartySynchronizer(MinecraftServer server, PartyMemberDynamicInfoSynchronizer dynamicInfoSync, List<LazyPacketScheduleTaskHandler> schedulers) {
        super(server);
        this.dynamicInfoSync = dynamicInfoSync;
        this.schedulers = schedulers;
    }

    public void setPartyManager(PartyManager partyManager) {
        if (this.partyManager != null) {
            throw new IllegalAccessError();
        }
        this.partyManager = partyManager;
        this.dynamicInfoSync.setPartyManager(partyManager);
    }

    private void syncToPartyPlayerInfo(ServerParty party, ClientboundPartyPlayerPacket.Type type, ClientboundPartyPlayerPacket.Action action, IPartyPlayerInfo playerInfo) {
        ClientboundPartyPlayerPacket packet = new ClientboundPartyPlayerPacket(type, action, playerInfo);
        this.syncToParty(party, action == ClientboundPartyPlayerPacket.Action.ADD ? mi -> mi == playerInfo : mi -> false, packet, false);
    }

    public void syncToClientPlayerInfo(ServerPlayer player, ClientboundPartyPlayerPacket.Type type, ClientboundPartyPlayerPacket.Action action, IPartyPlayerInfo playerInfo) {
        ClientboundPartyPlayerPacket packet = new ClientboundPartyPlayerPacket(type, action, playerInfo);
        this.sendToClient(player, packet, false);
    }

    private void syncToPartyAlly(ServerParty party, ClientboundPartyAllyPacket.Action action, ServerParty ally) {
        this.syncToPartyAlly(party, action, ally, this.fetchConfiguredPartyName(ally));
    }

    private void syncToPartyAlly(ServerParty party, ClientboundPartyAllyPacket.Action action, ServerParty ally, String fetchedName) {
        if (ally == null) {
            return;
        }
        ClientboundPartyAllyPacket packet = new ClientboundPartyAllyPacket(action, new ClientPartyAllyInfo(ally.getId(), fetchedName, ally.getDefaultName()));
        this.syncToParty(party, mi -> false, packet, false);
    }

    public void syncToClientAlly(ServerPlayer player, ClientboundPartyAllyPacket.Action action, ServerParty ally) {
        this.syncToClientAlly(player, action, ally, this.fetchConfiguredPartyName(ally));
    }

    private void syncToClientAlly(ServerPlayer player, ClientboundPartyAllyPacket.Action action, ServerParty ally, String fetchedName) {
        if (ally == null) {
            return;
        }
        ClientboundPartyAllyPacket packet = new ClientboundPartyAllyPacket(action, new ClientPartyAllyInfo(ally.getId(), fetchedName, ally.getDefaultName()));
        this.sendToClient(player, packet, false);
    }

    public void syncToPartyUpdateOwner(ServerParty party) {
        this.syncToPartyPlayerInfo(party, ClientboundPartyPlayerPacket.Type.OWNER, ClientboundPartyPlayerPacket.Action.UPDATE, party.getOwner());
    }

    public void syncToPartyAddMember(ServerParty party, PartyMember addedMember) {
        this.syncToPartyPlayerInfo(party, ClientboundPartyPlayerPacket.Type.MEMBER, ClientboundPartyPlayerPacket.Action.ADD, addedMember);
    }

    public void syncToPartyRemoveMember(ServerParty party, PartyMember removedMember) {
        this.syncToPartyPlayerInfo(party, ClientboundPartyPlayerPacket.Type.MEMBER, ClientboundPartyPlayerPacket.Action.REMOVE, removedMember);
        PlayerList playerList = this.server.getPlayerList();
        ServerPlayer onlinePlayer = playerList.getPlayer(removedMember.getUUID());
        if (onlinePlayer != null) {
            this.dynamicInfoSync.handlePlayerLeave(party, onlinePlayer);
        }
    }

    public void syncToPartyUpdateMember(ServerParty party, PartyMember member) {
        this.syncToPartyPlayerInfo(party, ClientboundPartyPlayerPacket.Type.MEMBER, ClientboundPartyPlayerPacket.Action.UPDATE, member);
    }

    public void syncToPartyAddInvite(ServerParty party, PartyInvite invite) {
        this.syncToPartyPlayerInfo(party, ClientboundPartyPlayerPacket.Type.INVITE, ClientboundPartyPlayerPacket.Action.ADD, invite);
    }

    public void syncToPartyRemoveInvite(ServerParty party, PartyInvite invite) {
        this.syncToPartyPlayerInfo(party, ClientboundPartyPlayerPacket.Type.INVITE, ClientboundPartyPlayerPacket.Action.REMOVE, invite);
    }

    public void syncToClientUpdateName(ServerPlayer player, String name) {
        this.sendToClient(player, new ClientboundPartyNamePacket(name), false);
    }

    @Override
    public void syncToPartyAndAlliersUpdateName(ServerParty party, String name) {
        this.syncToParty(party, mi -> false, new ClientboundPartyNamePacket(name), false);
        this.partyManager.getTypedPartiesThatAlly(party.getId()).forEach(allier -> this.syncToPartyAllyUpdate((ServerParty)allier, party, name));
    }

    public void syncToPartyAllyAdd(ServerParty party, ServerParty ally) {
        this.syncToPartyAlly(party, ClientboundPartyAllyPacket.Action.ADD, ally);
        if (ally.isAlly(party.getId())) {
            this.dynamicInfoSync.syncToPartyAnotherPartyDynamicInfo(party, ally, false);
            this.dynamicInfoSync.syncToPartyAnotherPartyDynamicInfo(ally, party, false);
        }
    }

    private void syncToPartyAllyUpdate(ServerParty party, ServerParty ally, String fetchedName) {
        this.syncToPartyAlly(party, ClientboundPartyAllyPacket.Action.UPDATE, ally, fetchedName);
    }

    public void syncToPartyAllyRemove(ServerParty party, UUID allyId, boolean onPartyRemoval) {
        ServerParty ally;
        if (!onPartyRemoval) {
            ClientboundPartyAllyPacket packet = new ClientboundPartyAllyPacket(ClientboundPartyAllyPacket.Action.REMOVE, new ClientPartyAllyInfo(allyId, "", ""));
            this.syncToParty(party, mi -> false, packet, false);
        }
        if ((ally = this.partyManager.getPartyById(allyId)) != null && ally.isAlly(party.getId())) {
            if (!onPartyRemoval) {
                this.dynamicInfoSync.syncToPartyAnotherPartyDynamicInfo(party, ally, true);
            }
            this.dynamicInfoSync.syncToPartyAnotherPartyDynamicInfo(ally, party, true);
        }
    }

    public void sendSyncStart(ServerPlayer player) {
        this.sendToClient(player, ClientboundLoadingPacket.START_PARTY, false);
    }

    public void sendBasePartyPackets(ServerPlayer player, ServerParty party) {
        IPlayerConfigManager playerConfigs = this.serverData.getPlayerConfigs();
        this.sendToClient(player, party == null ? new ClientboundPartyPacket(null, null, 0, 0, 0, 0, 0, 0) : new ClientboundPartyPacket(party.getId(), party.getOwner(), party.getMemberCount(), party.getInviteCount(), party.getAllyCount(), (Integer)ServerConfig.CONFIG.maxPartyMembers.get(), (Integer)ServerConfig.CONFIG.maxPartyInvites.get(), (Integer)ServerConfig.CONFIG.maxPartyAllies.get()), false);
        this.syncToClientUpdateName(player, this.fetchConfiguredPartyName(playerConfigs, party));
    }

    public void sendToClientAllyAdd(ServerPlayer player, PartyAlly ally) {
        this.syncToClientAlly(player, ClientboundPartyAllyPacket.Action.ADD, this.partyManager.getPartyById(ally.getPartyId()));
    }

    public void sendSyncEnd(ServerPlayer player) {
        this.sendToClient(player, ClientboundLoadingPacket.END_PARTY, false);
    }

    @Override
    public void syncToClient(ServerPlayer player, ServerParty party) {
        if (party != null) {
            this.dynamicInfoSync.syncToClientAllDynamicInfoIncludingMutualAllies(player, party);
        }
        ServerPlayerData playerData = (ServerPlayerData)ServerPlayerData.from(player);
        playerData.getFullPartyPlayerSync().startPartySync(player, party);
    }

    public void syncToMember(PartyMember member, ServerParty party) {
        PlayerList playerList = this.server.getPlayerList();
        ServerPlayer player = playerList.getPlayer(member.getUUID());
        if (player == null) {
            return;
        }
        this.syncToClient(player, party);
    }

    private String fetchConfiguredPartyName(ServerParty party) {
        return this.fetchConfiguredPartyName(this.serverData.getPlayerConfigs(), party);
    }

    private String fetchConfiguredPartyName(IPlayerConfigManager playerConfigs, ServerParty party) {
        IPlayerConfig ownerConfig = party == null ? null : playerConfigs.getLoadedConfig(party.getOwner().getUUID());
        String configuredName = ownerConfig == null ? null : ownerConfig.getEffective(PlayerConfigOptions.PARTY_NAME);
        return configuredName;
    }

    @Override
    public void onLazyPacketsDropped(ServerPlayer player) {
        this.schedulers.forEach(s -> s.onLazyPacketsDropped(player));
    }

    @Override
    public void onServerTick() {
        this.schedulers.forEach(s -> s.onTick(this.serverData));
    }

    public PartyMemberDynamicInfoSynchronizer getOftenSyncedInfoSync() {
        return this.dynamicInfoSync;
    }

    public static final class Builder {
        private MinecraftServer server;

        public Builder setDefault() {
            this.setServer(null);
            return this;
        }

        public Builder setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public PartySynchronizer build() {
            if (this.server == null) {
                throw new IllegalStateException();
            }
            LazyPacketScheduleTaskHandler fullPartySyncScheduler = ((LazyPacketScheduleTaskHandler.Builder)((LazyPacketScheduleTaskHandler.Builder)((LazyPacketScheduleTaskHandler.Builder)LazyPacketScheduleTaskHandler.Builder.begin().setPlayerTaskGetter(ServerPlayerData::getFullPartyPlayerSync)).setPerTickLimit(8192)).setPerTickPerTaskLimit(512)).build();
            List<LazyPacketScheduleTaskHandler> schedulers = List.of(fullPartySyncScheduler);
            return new PartySynchronizer(this.server, new PartyMemberDynamicInfoSynchronizer(this.server), schedulers);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

