/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class SortedValueList<T extends Comparable<T>>
implements Iterable<T> {
    private final List<T> storage;
    private final boolean mutable;

    private SortedValueList(List<T> storage, boolean mutable) {
        this.storage = mutable ? storage : Collections.unmodifiableList(storage);
        this.mutable = mutable;
    }

    private int binarySearch(T value) {
        return Collections.binarySearch(this.storage, value);
    }

    private int fixIndex(int binarySearchResult) {
        return binarySearchResult >= 0 ? binarySearchResult : -binarySearchResult - 1;
    }

    public int size() {
        return this.storage.size();
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public boolean contains(T value) {
        return this.binarySearch(value) >= 0;
    }

    public int indexOf(T value) {
        return this.binarySearch(value);
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.storage.iterator();
    }

    public Stream<T> stream() {
        return this.storage.stream();
    }

    public List<T> copyStorage() {
        return new ArrayList<T>(this.storage);
    }

    public boolean add(T t) {
        if (!this.mutable) {
            throw new IllegalStateException("not a mutable list!");
        }
        int index = this.binarySearch(t);
        if (index >= 0) {
            return false;
        }
        this.storage.add(this.fixIndex(index), t);
        return true;
    }

    public boolean remove(T t) {
        if (!this.mutable) {
            throw new IllegalStateException("not a mutable list!");
        }
        int index = this.binarySearch(t);
        if (index < 0) {
            return false;
        }
        return this.storage.remove(index) == t;
    }

    public void clear() {
        if (!this.mutable) {
            throw new IllegalStateException("not a mutable list!");
        }
        this.storage.clear();
    }

    public T get(int index) {
        return (T)((Comparable)this.storage.get(index));
    }

    public T remove(int index) {
        if (!this.mutable) {
            throw new IllegalStateException("not a mutable list!");
        }
        return (T)((Comparable)this.storage.remove(index));
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public static final class Builder<T extends Comparable<T>> {
        private List<T> content;
        private boolean mutable;

        private Builder() {
        }

        public Builder<T> setDefault() {
            this.setContent(null);
            this.setMutable(true);
            return this;
        }

        public Builder<T> setContent(List<T> content) {
            this.content = content;
            return this;
        }

        public Builder<T> setMutable(boolean mutable) {
            this.mutable = mutable;
            return this;
        }

        public SortedValueList<T> build() {
            if (this.content == null) {
                this.content = new ArrayList<T>();
            } else {
                Collections.sort(this.content);
            }
            return new SortedValueList<T>(this.content, this.mutable);
        }

        public static <T extends Comparable<T>> Builder<T> begin() {
            return new Builder<T>().setDefault();
        }
    }
}

