/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.protection.group;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.common.ModConfigSpec;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.claims.protection.ChunkProtectionExceptionType;
import xaero.pac.common.server.claims.protection.ExceptionElementType;
import xaero.pac.common.server.claims.protection.WildcardResolver;
import xaero.pac.common.server.claims.protection.group.ChunkProtectionExceptionGroup;
import xaero.pac.common.server.player.config.PlayerConfigOptionCategory;

public class ChunkProtectionExceptionGroupLoader {
    public <T> void load(MinecraftServer server, ModConfigSpec.ConfigValue<List<? extends String>> configOption, ExceptionElementType<T> elementType, Class<?> subjectType, boolean ofSubjects, WildcardResolver wildcardResolver, Map<String, ChunkProtectionExceptionGroup<T>> destination, ChunkProtectionExceptionType defaultType, Predicate<ChunkProtectionExceptionType> typeFilter, PlayerConfigOptionCategory optionCategory) {
        Registry elementRegistry = elementType.getRegistry(server);
        Function<ResourceLocation, Object> objectGetter = key -> elementRegistry.getOptional(key).orElse(null);
        Iterable iterable = elementType.getIterable();
        Function<Object, ResourceLocation> keyGetter = arg_0 -> elementRegistry.getKey(arg_0);
        Function<ResourceLocation, TagKey> tagGetter = rl -> TagKey.create((ResourceKey)elementRegistry.key(), (ResourceLocation)rl);
        Iterable tagIterable = elementType.getTagIterable();
        Function<TagKey, ResourceLocation> tagKeyGetter = TagKey::location;
        ((List)configOption.get()).forEach(stringEntry -> {
            String[] groupContentSplit;
            String prefixedName;
            int listEndIndex;
            int listStartIndex = stringEntry.indexOf(123);
            if (listStartIndex < 0 || (listEndIndex = stringEntry.indexOf(125)) < listStartIndex) {
                OpenPartiesAndClaims.LOGGER.error("Exception group must contain { and }, in that order: " + stringEntry);
                return;
            }
            String name = prefixedName = stringEntry.substring(0, listStartIndex);
            ChunkProtectionExceptionType type = defaultType;
            if (prefixedName.contains("$")) {
                type = null;
                for (int i = 0; i < ChunkProtectionExceptionType.values().length; ++i) {
                    ChunkProtectionExceptionType t = ChunkProtectionExceptionType.values()[i];
                    if (!typeFilter.test(t) || !t.is(prefixedName)) continue;
                    type = t;
                    name = prefixedName.substring(type.getPrefix().length());
                    break;
                }
            }
            if (type == null) {
                OpenPartiesAndClaims.LOGGER.error("Unknown exception group type prefix: " + prefixedName);
                return;
            }
            if (destination.containsKey(prefixedName)) {
                OpenPartiesAndClaims.LOGGER.error("Exception group name must be unique: " + prefixedName);
                return;
            }
            ChunkProtectionExceptionGroup.Builder builder = ChunkProtectionExceptionGroup.Builder.begin(elementType).setName(name).setSubjectType(subjectType).setOfSubjects(ofSubjects).setType(type);
            String groupContent = stringEntry.substring(listStartIndex + 1, listEndIndex).trim();
            String[] stringArray = groupContentSplit = groupContent.split("\\s*,\\s*");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                boolean invalidWildcard;
                String element;
                boolean tag = (element = stringArray[i]).startsWith("#");
                String id = element.substring(tag ? "#".length() : 0);
                if (tag) {
                    List objectTags = wildcardResolver.resolveResourceLocations(tagGetter, tagIterable, tagKeyGetter, id);
                    boolean bl = invalidWildcard = objectTags == null;
                    if (!invalidWildcard) {
                        for (TagKey objectTag : objectTags) {
                            builder.addException(Either.right((Object)objectTag));
                        }
                    }
                } else {
                    List objects = wildcardResolver.resolveResourceLocations(objectGetter, iterable, keyGetter, id);
                    boolean bl = invalidWildcard = objects == null;
                    if (!invalidWildcard) {
                        for (Object object : objects) {
                            builder.addException(Either.left(object));
                        }
                    }
                }
                if (!invalidWildcard) continue;
                OpenPartiesAndClaims.LOGGER.error("Invalid resource location in an exception group: " + element);
            }
            builder.setContentString(groupContent);
            builder.setOptionCategory(optionCategory);
            ChunkProtectionExceptionGroup group = builder.build();
            destination.put(prefixedName, group);
        });
    }
}

