/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.io.serialization.nbt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import xaero.pac.common.server.io.serialization.SerializedDataFileIO;
import xaero.pac.common.server.io.serialization.nbt.NBTConverter;

public class NBTSerializedDataFileIO<S, I>
implements SerializedDataFileIO<S, I> {
    private final NBTConverter<S, I> converter;

    public NBTSerializedDataFileIO(NBTConverter<S, I> converter) {
        this.converter = converter;
    }

    @Override
    public S read(I id, BufferedInputStream fileInput) throws IOException {
        try (BufferedInputStream bufferedStream = new BufferedInputStream(fileInput);){
            S s;
            try (DataInputStream dataInput = new DataInputStream(bufferedStream);){
                s = this.converter.convert(id, NbtIo.read((DataInput)dataInput));
            }
            return s;
        }
    }

    @Override
    public void write(BufferedOutputStream fileOutput, S serializedData) throws IOException {
        try (BufferedOutputStream bufferedOutput = new BufferedOutputStream(fileOutput);
             DataOutputStream dataOutput = new DataOutputStream(bufferedOutput);){
            NbtIo.write((CompoundTag)this.converter.convert(serializedData), (DataOutput)dataOutput);
        }
    }
}

