/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.forceload;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.platform.Services;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.forceload.ClaimTicket;
import xaero.pac.common.server.claims.forceload.player.PlayerForceloadTicketManager;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;

public final class ForceLoadTicketManager {
    public static final class_3230<class_1923> OPAC_TICKET = class_3230.method_14291((String)"openpartiesandclaims:forced", Comparator.comparingLong(class_1923::method_8324));
    private IServerClaimsManager<?, ?, ?> claimsManager;
    private final MinecraftServer server;
    private final Map<UUID, PlayerForceloadTicketManager> claimTickets;
    private Map<class_2960, DimensionInfo> dimensionInfoMap;

    private ForceLoadTicketManager(MinecraftServer server, Map<UUID, PlayerForceloadTicketManager> claimTickets, Map<class_2960, DimensionInfo> dimensionInfoMap) {
        this.server = server;
        this.claimTickets = claimTickets;
        this.dimensionInfoMap = dimensionInfoMap;
    }

    public void setClaimsManager(IServerClaimsManager<?, ?, ?> claimsManager) {
        if (this.claimsManager != null) {
            throw new IllegalStateException();
        }
        this.claimsManager = claimsManager;
    }

    private PlayerForceloadTicketManager getPlayerTickets(UUID id) {
        return this.claimTickets.computeIfAbsent(id, i -> PlayerForceloadTicketManager.Builder.begin().build());
    }

    private DimensionInfo getDimensionInfo(class_2960 dimension) {
        DimensionInfo dimInfo = this.dimensionInfoMap.get(dimension);
        if (dimInfo == null) {
            dimInfo = new DimensionInfo();
            this.dimensionInfoMap.put(dimension, dimInfo);
        }
        return dimInfo;
    }

    private boolean enableTicket(ClaimTicket ticket) {
        boolean isServer = Objects.equals(ticket.getPlayerId(), PlayerConfig.SERVER_CLAIM_UUID);
        if (!(isServer || ((Boolean)ServerConfig.CONFIG.allowExistingClaimsInUnclaimableDimensions.get()).booleanValue() && ((Boolean)ServerConfig.CONFIG.allowExistingForceloadsInUnclaimableDimensions.get()).booleanValue() || this.claimsManager.isClaimable(ticket.getDimension()))) {
            return false;
        }
        class_1923 pos = new class_1923(ticket.getX(), ticket.getZ());
        class_5321 levelKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)ticket.getDimension());
        class_3218 world = this.server.method_3847(levelKey);
        if (world == null) {
            return false;
        }
        Services.PLATFORM.getServerChunkCacheAccess().addRegionTicket(world.method_14178(), OPAC_TICKET, pos, 2, pos, true);
        ticket.setEnabled(true);
        this.countEnabled(ticket.getDimension(), 1);
        return true;
    }

    private void disableTicket(ClaimTicket ticket) {
        class_1923 pos = new class_1923(ticket.getX(), ticket.getZ());
        class_5321 levelKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)ticket.getDimension());
        class_3218 world = this.server.method_3847(levelKey);
        if (world != null) {
            Services.PLATFORM.getServerChunkCacheAccess().removeRegionTicket(world.method_14178(), OPAC_TICKET, pos, 2, pos, true);
        }
        ticket.setEnabled(false);
        this.countEnabled(ticket.getDimension(), -1);
    }

    private void countEnabled(class_2960 dimension, int change) {
        DimensionInfo dimInfo = this.getDimensionInfo(dimension);
        dimInfo.enabledTicketCount += change;
    }

    private boolean updateTicket(boolean shouldBeEnabled, ClaimTicket ticket) {
        if (shouldBeEnabled) {
            if (!ticket.isEnabled()) {
                return this.enableTicket(ticket);
            }
        } else if (ticket.isEnabled()) {
            this.disableTicket(ticket);
        }
        return true;
    }

    private boolean ticketsShouldBeEnabled(IPlayerConfig ownerConfig, boolean loggedOut) {
        return ownerConfig.getEffective(PlayerConfigOptions.FORCELOAD) != false && (Objects.equals(PlayerConfig.SERVER_CLAIM_UUID, ownerConfig.getPlayerId()) || Objects.equals(PlayerConfig.EXPIRED_CLAIM_UUID, ownerConfig.getPlayerId()) || ownerConfig.getEffective(PlayerConfigOptions.OFFLINE_FORCELOAD) != false || !loggedOut && this.server.method_3760().method_14602(ownerConfig.getPlayerId()) != null);
    }

    public void updateTicketsFor(IPlayerConfigManager playerConfigManager, UUID id, boolean loggedOut) {
        IPlayerConfig ownerConfig = playerConfigManager.getLoadedConfig(id);
        PlayerForceloadTicketManager playerTickets = this.getPlayerTickets(id);
        boolean isServer = PlayerConfig.SERVER_CLAIM_UUID.equals(id);
        boolean shouldBeEnabled = this.ticketsShouldBeEnabled(ownerConfig, loggedOut);
        OpenPartiesAndClaims.LOGGER.info("Updating all forceload tickets for " + String.valueOf(id));
        int forceloadLimit = this.claimsManager.getPlayerBaseForceloadLimit(id) + playerConfigManager.getLoadedConfig(id).getEffective(PlayerConfigOptions.BONUS_CHUNK_FORCELOADS);
        int enableSuccessCount = 0;
        boolean withinLimit = true;
        for (ClaimTicket ticket : playerTickets.values()) {
            boolean shouldEnableTicket;
            if (shouldBeEnabled && !isServer) {
                withinLimit = withinLimit && enableSuccessCount < forceloadLimit;
            }
            if (!this.updateTicket(shouldEnableTicket = shouldBeEnabled && withinLimit, ticket) || !shouldEnableTicket) continue;
            ++enableSuccessCount;
        }
        playerTickets.setFailedToEnableSome(!withinLimit);
    }

    public void addTicket(IPlayerConfigManager playerConfigManager, class_2960 dimension, UUID id, int x, int z) {
        ClaimTicket ticket = new ClaimTicket(id, dimension, x, z);
        PlayerForceloadTicketManager playerTickets = this.getPlayerTickets(id);
        playerTickets.add(ticket);
        IPlayerConfig ownerConfig = playerConfigManager.getLoadedConfig(id);
        boolean shouldBeEnabled = this.ticketsShouldBeEnabled(ownerConfig, false);
        if (shouldBeEnabled) {
            int forceloadLimit;
            boolean isServer = PlayerConfig.SERVER_CLAIM_UUID.equals(id);
            int n = forceloadLimit = isServer ? 0 : this.claimsManager.getPlayerBaseForceloadLimit(id) + playerConfigManager.getLoadedConfig(id).getEffective(PlayerConfigOptions.BONUS_CHUNK_FORCELOADS);
            if (isServer || playerTickets.getCount() <= forceloadLimit) {
                this.updateTicket(true, ticket);
            }
        }
    }

    public void removeTicket(IPlayerConfigManager playerConfigManager, class_2960 dimension, UUID id, int x, int z) {
        PlayerForceloadTicketManager playerTickets = this.getPlayerTickets(id);
        ClaimTicket ticket = playerTickets.remove(new ClaimTicket(id, dimension, x, z));
        if (ticket.isEnabled()) {
            this.updateTicket(false, ticket);
            if (playerTickets.failedToEnableSome()) {
                this.updateTicketsFor(playerConfigManager, id, false);
            }
        }
    }

    public boolean hasEnabledTickets(class_3218 level) {
        DimensionInfo dimensionInfo = this.dimensionInfoMap.get(level.method_27983().method_29177());
        return dimensionInfo != null && dimensionInfo.enabledTicketCount > 0;
    }

    public static final class DimensionInfo {
        private int enabledTicketCount;
    }

    public static final class Builder {
        private MinecraftServer server;

        private Builder() {
        }

        private Builder setDefault() {
            this.setServer(null);
            return this;
        }

        public Builder setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public ForceLoadTicketManager build() {
            if (this.server == null) {
                throw new IllegalStateException();
            }
            return new ForceLoadTicketManager(this.server, new HashMap<UUID, PlayerForceloadTicketManager>(), new HashMap<class_2960, DimensionInfo>());
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

