/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import xaero.pac.client.gui.SimpleValueWidgetListElement;
import xaero.pac.client.gui.widget.dropdown.DropDownWidget;
import xaero.pac.client.gui.widget.dropdown.IDropDownContainer;
import xaero.pac.client.gui.widget.dropdown.IDropDownWidgetCallback;

public final class DropdownWidgetListElement<T>
extends SimpleValueWidgetListElement<T, DropdownWidgetListElement<T>>
implements IDropDownWidgetCallback {
    private final Consumer<T> valueChangeConsumer;
    private final List<T> options;
    private int currentIndex;
    private final class_2561 title;

    private DropdownWidgetListElement(int w, int h, boolean mutable, BiFunction<DropdownWidgetListElement<T>, class_2382, class_339> widgetSupplier, List<class_5684> tooltip, T startValue, int startIndex, List<T> options, Consumer<T> valueChangeConsumer, class_2561 title) {
        super(startValue, w, h, mutable, widgetSupplier, tooltip);
        this.options = options;
        this.currentIndex = startIndex;
        this.valueChangeConsumer = valueChangeConsumer;
        this.title = title;
    }

    @Override
    public void render(class_332 guiGraphics) {
        super.render(guiGraphics);
        guiGraphics.method_27535(class_310.method_1551().field_1772, this.title, this.x, this.y + 6, this.mutable ? -1 : 0xE0E0E0);
    }

    @Override
    public boolean onSelected(DropDownWidget menu, int selected) {
        this.currentIndex = selected;
        this.draftValue = this.options.get(this.currentIndex);
        this.valueChangeConsumer.accept(this.draftValue);
        return true;
    }

    public static final class Builder<T>
    extends SimpleValueWidgetListElement.Builder<T, DropdownWidgetListElement<T>, Builder<T>> {
        private int startIndex;
        private List<T> options;
        private Consumer<T> valueChangeConsumer;
        private class_2561 title;

        @Override
        public Builder<T> setDefault() {
            super.setDefault();
            this.setStartIndex(-1);
            this.setOptions(null);
            this.setValueChangeConsumer(v -> {});
            this.setTitle(null);
            return (Builder)this.self;
        }

        @Override
        public Builder<T> setStartValue(T startValue) {
            if (startValue != null) {
                throw new IllegalArgumentException();
            }
            return (Builder)super.setStartValue(startValue);
        }

        public Builder<T> setStartIndex(int startIndex) {
            this.startIndex = startIndex;
            return (Builder)this.self;
        }

        public Builder<T> setOptions(List<T> options) {
            this.options = options;
            return (Builder)this.self;
        }

        public Builder<T> setValueChangeConsumer(Consumer<T> valueChangeConsumer) {
            this.valueChangeConsumer = valueChangeConsumer;
            return (Builder)this.self;
        }

        public Builder<T> setTitle(class_2561 title) {
            this.title = title;
            return (Builder)this.self;
        }

        @Override
        public DropdownWidgetListElement<T> build() {
            if (this.startIndex == -1 || this.options == null || this.valueChangeConsumer == null || this.title == null) {
                throw new IllegalStateException();
            }
            this.startValue = this.options.get(this.startIndex);
            return (DropdownWidgetListElement)super.build();
        }

        @Override
        protected DropdownWidgetListElement<T> buildInternal(List<class_5684> clientTooltip) {
            String[] stringOptions = new String[this.options.size()];
            for (int i = 0; i < this.options.size(); ++i) {
                stringOptions[i] = Objects.toString(this.options.get(i));
            }
            int titleWidth = class_310.method_1551().field_1772.method_27525((class_5348)this.title);
            int margin = 4;
            BiFunction widgetSupplier = (el, xy) -> DropDownWidget.Builder.begin().setX(xy.method_10263() + titleWidth + margin).setY(xy.method_10264() + 4).setW(this.w - titleWidth - margin - 1).setOptions(stringOptions).setNarrationTitle(this.title).setCallback((IDropDownWidgetCallback)el).setContainer((IDropDownContainer)class_310.method_1551().field_1755).setSelected(el.currentIndex).build();
            return new DropdownWidgetListElement<Object>(this.w, this.h, this.mutable, widgetSupplier, clientTooltip, this.startValue, this.startIndex, List.copyOf(this.options), this.valueChangeConsumer, this.title);
        }

        public static <T> Builder<T> begin() {
            return new Builder<T>().setDefault();
        }
    }
}

