/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.class_11907;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5684;
import xaero.pac.client.gui.SimpleValueWidgetListElement;
import xaero.pac.client.gui.WidgetListScreen;
import xaero.pac.client.gui.widget.TextWidgetEditBox;

public final class TextWidgetListElement
extends SimpleValueWidgetListElement<String, TextWidgetListElement> {
    private final class_2561 title;
    private class_342 editBox;
    private class_4185 confirmButton;
    private class_4185 cancelButton;
    private String confirmedText;
    private final BiConsumer<TextWidgetListElement, String> valueConfirmResponder;
    private final Predicate<String> validator;

    private TextWidgetListElement(int w, int h, boolean mutable, class_2561 title, BiFunction<TextWidgetListElement, class_2382, class_339> widgetSupplier, List<class_5684> tooltip, BiConsumer<TextWidgetListElement, String> valueConfirmResponder, Predicate<String> validator, String startValue) {
        super(startValue, w, h, mutable, widgetSupplier, tooltip);
        this.confirmedText = startValue;
        this.title = title;
        this.valueConfirmResponder = valueConfirmResponder;
        this.validator = validator;
    }

    @Override
    public class_339 screenInit(int x, int y, WidgetListScreen screen, List<class_342> tickableBoxes) {
        this.editBox = (class_342)super.screenInit(x, y, screen, tickableBoxes);
        this.confirmButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2714"), this::onConfirmButton).method_46434(x + this.w - 40, y, 20, 20).method_46431();
        screen.method_37063(this.confirmButton);
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u274c"), this::onCancelButton).method_46434(x + this.w - 20, y, 20, 20).method_46431();
        screen.method_37063(this.cancelButton);
        this.confirmButton.field_22763 = !this.confirmedText.equals(this.draftValue);
        this.cancelButton.field_22763 = !this.confirmedText.equals(this.draftValue);
        return this.editBox;
    }

    public boolean onEnterPressed() {
        if (this.confirmButton.field_22763) {
            this.confirmButton.method_25306((class_11907)new class_11909(0.0, 0.0, new class_11910(0, 0)));
            return true;
        }
        return false;
    }

    private boolean updateBoxColor() {
        boolean validInput = this.validator.test((String)this.draftValue);
        this.editBox.method_1868(validInput ? -2039584 : -43691);
        return validInput;
    }

    private void onTextTyped(String value) {
        if (!((String)this.draftValue).equals(value)) {
            this.draftValue = value;
            this.confirmButton.field_22763 = this.updateBoxColor();
            this.cancelButton.field_22763 = true;
        }
    }

    private void onConfirmButton(class_4185 b) {
        if (this.validator.test((String)this.draftValue)) {
            this.valueConfirmResponder.accept(this, (String)this.draftValue);
            this.confirmedText = (String)this.draftValue;
            this.confirmButton.field_22763 = false;
            this.cancelButton.field_22763 = false;
        }
    }

    public void clearBox() {
        this.editBox.method_1852("");
    }

    private void onCancelButton(class_4185 b) {
        this.draftValue = this.confirmedText;
        this.editBox.method_1852((String)this.draftValue);
        this.confirmButton.field_22763 = false;
        this.cancelButton.field_22763 = false;
        this.updateBoxColor();
    }

    @Override
    public final void render(class_332 guiGraphics) {
        super.render(guiGraphics);
        guiGraphics.method_27535(class_310.method_1551().field_1772, this.title, this.x + 2, this.y + 6, this.mutable ? -1 : -2039584);
    }

    public static final class Builder
    extends SimpleValueWidgetListElement.Builder<String, TextWidgetListElement, Builder> {
        private class_2561 title;
        private BiConsumer<TextWidgetListElement, String> responder;
        private Predicate<String> filter;
        private Predicate<String> validator;
        private int boxWidth;
        private int maxLength;

        @Override
        public Builder setDefault() {
            super.setDefault();
            this.setBoxWidth(50);
            this.setTitle(null);
            this.setResponder(null);
            this.setFilter(Objects::nonNull);
            this.setValidator(Objects::nonNull);
            this.setMaxLength(32);
            return this;
        }

        public Builder setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder setBoxWidth(int boxWidth) {
            this.boxWidth = boxWidth;
            return this;
        }

        public Builder setTitle(class_2561 title) {
            this.title = title;
            return this;
        }

        public Builder setResponder(BiConsumer<TextWidgetListElement, String> responder) {
            this.responder = responder;
            return this;
        }

        public Builder setFilter(Predicate<String> filter) {
            this.filter = filter;
            return this;
        }

        public Builder setValidator(Predicate<String> validator) {
            this.validator = validator;
            return this;
        }

        @Override
        public TextWidgetListElement build() {
            if (this.title == null || this.filter == null) {
                throw new IllegalStateException();
            }
            return (TextWidgetListElement)super.build();
        }

        @Override
        protected TextWidgetListElement buildInternal(List<class_5684> clientTooltip) {
            BiFunction<TextWidgetListElement, class_2382, class_339> widgetSupplier = (el, xy) -> {
                TextWidgetEditBox box = new TextWidgetEditBox((TextWidgetListElement)el, class_310.method_1551().field_1772, xy.method_10263() + this.w - this.boxWidth - 42, xy.method_10264(), this.boxWidth, this.h, this.title);
                box.method_1880(this.maxLength);
                box.method_1852((String)el.getDraftValue());
                box.method_1863(s -> el.onTextTyped((String)s));
                box.method_1890(this.filter);
                return box;
            };
            return new TextWidgetListElement(this.w, this.h, this.mutable, this.title, widgetSupplier, clientTooltip, this.responder, this.validator, (String)this.startValue);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

