/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.claims.player;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import xaero.pac.common.claims.player.PlayerClaimInfo;
import xaero.pac.common.claims.player.PlayerDimensionClaims;
import xaero.pac.common.util.linked.LinkedChain;

public abstract class PlayerClaimInfoManager<PCI extends PlayerClaimInfo<PCI, M>, M extends PlayerClaimInfoManager<PCI, M>> {
    protected final M self;
    private Map<UUID, PCI> storage;
    private LinkedChain<PCI> linkedPlayerInfo;

    public PlayerClaimInfoManager(Map<UUID, PCI> storage, LinkedChain<PCI> linkedPlayerInfo) {
        this.linkedPlayerInfo = linkedPlayerInfo;
        this.self = this;
        this.storage = storage;
    }

    protected abstract PCI create(String var1, UUID var2, Map<class_2960, PlayerDimensionClaims> var3);

    public boolean hasInfo(UUID playerId) {
        return this.storage.containsKey(playerId);
    }

    public PCI getInfo(UUID playerId) {
        PlayerClaimInfo result = (PlayerClaimInfo)this.storage.get(playerId);
        if (result == null) {
            result = this.create(playerId == null ? null : playerId.toString(), playerId, new HashMap<class_2960, PlayerDimensionClaims>());
            this.storage.put(playerId, result);
            this.onAdd(result);
        }
        return (PCI)result;
    }

    public Stream<PCI> getInfoStream() {
        return this.linkedPlayerInfo.stream();
    }

    public Iterator<PCI> iterator() {
        return this.linkedPlayerInfo.iterator();
    }

    public void clear() {
        this.linkedPlayerInfo.destroy();
        this.linkedPlayerInfo = new LinkedChain();
        this.storage = new HashMap<UUID, PCI>();
    }

    public void tryRemove(UUID playerId) {
        PlayerClaimInfo info = (PlayerClaimInfo)this.storage.get(playerId);
        if (info != null && info.getClaimCount() == 0) {
            this.storage.remove(playerId);
            this.onRemove(info);
        }
    }

    protected void onAdd(PCI playerInfo) {
        this.linkedPlayerInfo.add(playerInfo);
    }

    protected void onRemove(PCI playerInfo) {
        this.linkedPlayerInfo.remove(playerInfo);
    }
}

